/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway.acme;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Iterator;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.asn1.ASN1IA5String;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.TXTRecord;
import org.xbill.DNS.TextParseException;
import org.xipki.ca.gateway.acme.AcmeChallenge;
import org.xipki.ca.gateway.acme.AcmeChallenge2;
import org.xipki.ca.gateway.acme.AcmeIdentifier;
import org.xipki.ca.gateway.acme.AcmeRepo;
import org.xipki.ca.gateway.acme.AcmeSystemException;
import org.xipki.ca.gateway.acme.CertEnroller;
import org.xipki.ca.gateway.acme.ChallId;
import org.xipki.ca.gateway.acme.type.ChallengeStatus;
import org.xipki.util.Args;
import org.xipki.util.Base64Url;
import org.xipki.util.LogUtil;
import org.xipki.util.http.HttpRespContent;
import org.xipki.util.http.XiHttpClient;

public class ChallengeValidator
implements Runnable {
    private static final TrustManager trustAll = new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    };
    private static final Logger LOG = LoggerFactory.getLogger(CertEnroller.class);
    private final AcmeRepo repo;
    private boolean stopMe;

    public ChallengeValidator(AcmeRepo repo) {
        this.repo = (AcmeRepo)Args.notNull((Object)repo, (String)"repo");
    }

    @Override
    public void run() {
        while (!this.stopMe) {
            try {
                this.singleRun();
            }
            catch (Throwable t) {
                LogUtil.error((Logger)LOG, (Throwable)t, (String)"expected error");
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void singleRun() throws AcmeSystemException {
        Iterator<ChallId> challIds = this.repo.getChallengesToValidate();
        while (challIds.hasNext()) {
            ChallId challId = challIds.next();
            if (challId == null) continue;
            LOG.info("validate challenge {}", (Object)challId);
            AcmeChallenge2 chall2 = this.repo.getChallenge(challId);
            if (chall2 == null) continue;
            AcmeChallenge chall = chall2.getChallenge();
            String type = chall.getType();
            String receivedAuthorization = null;
            AcmeIdentifier identifier = chall2.getIdentifier();
            if (LOG.isDebugEnabled()) {
                String host = identifier.getValue();
                if (host.startsWith("*.")) {
                    host = host.substring(2);
                }
                try {
                    InetAddress inetAddr = InetAddress.getByName(host);
                    LOG.debug("type={}, host={}, InetAddress={}", new Object[]{type, host, inetAddr});
                }
                catch (UnknownHostException e) {
                    LOG.debug("type={}, host={}, UnknownHostException", (Object)type, (Object)host);
                }
            }
            switch (type) {
                case "http-01": {
                    String message;
                    String host = identifier.getValue();
                    String url = "http://" + host + "/.well-known/acme-challenge/" + chall.getToken();
                    try {
                        XiHttpClient client = new XiHttpClient();
                        HttpRespContent authzResp = client.httpGet(url);
                        receivedAuthorization = new String(authzResp.getContent(), StandardCharsets.UTF_8);
                    }
                    catch (IOException ex) {
                        message = "error while validating challenge " + challId + " for identifier " + identifier;
                        LogUtil.error((Logger)LOG, (Throwable)ex, (String)message);
                    }
                    break;
                }
                case "tls-alpn-01": {
                    byte[] octets;
                    byte[] extnValue;
                    X509Certificate cert;
                    boolean match;
                    Certificate[] certs = null;
                    try {
                        SSLContext sslContext = SSLContext.getInstance("TLS");
                        sslContext.init(null, new TrustManager[]{trustAll}, null);
                        SSLSocketFactory factory = sslContext.getSocketFactory();
                        try (SSLSocket socket = (SSLSocket)factory.createSocket(identifier.getValue(), 443);){
                            SSLParameters params = socket.getSSLParameters();
                            params.setApplicationProtocols(new String[]{"acme-tls/1.0"});
                            params.setProtocols(new String[]{"TLSv1.2", "TLSv1.3"});
                            socket.setSSLParameters(params);
                            SSLSession session = socket.getSession();
                            certs = session.getPeerCertificates();
                        }
                    }
                    catch (IOException | KeyManagementException | NoSuchAlgorithmException ex) {
                        String message = "error while validating challenge " + challId + " for identifier " + identifier;
                        LogUtil.error((Logger)LOG, (Throwable)ex, (String)message);
                    }
                    boolean bl = match = certs != null && certs.length > 0 && certs[0] instanceof X509Certificate;
                    if (match) {
                        cert = (X509Certificate)certs[0];
                        extnValue = cert.getExtensionValue(Extension.subjectAlternativeName.getId());
                        octets = ASN1OctetString.getInstance((Object)extnValue).getOctets();
                        GeneralNames generalNames = GeneralNames.getInstance((Object)octets);
                        GeneralName[] names = generalNames.getNames();
                        boolean bl2 = match = names != null && names.length == 1 && names[0].getTagNo() == 2;
                        if (match) {
                            String sanValue = ASN1IA5String.getInstance((Object)names[0].getName()).getString();
                            match = identifier.getValue().equals(sanValue);
                        }
                    }
                    if (!match || !(match = (cert = (X509Certificate)certs[0]).getCriticalExtensionOIDs().contains("1.3.6.1.5.5.7.1.31"))) break;
                    extnValue = cert.getExtensionValue("1.3.6.1.5.5.7.1.31");
                    octets = ASN1OctetString.getInstance((Object)extnValue).getOctets();
                    byte[] value = ASN1OctetString.getInstance((Object)octets).getOctets();
                    receivedAuthorization = Base64Url.encodeToStringNoPadding((byte[])value);
                    break;
                }
                case "dns-01": {
                    String message;
                    String host = identifier.getValue();
                    if (host.startsWith("*.")) {
                        host = host.substring(2);
                    }
                    LOG.debug("dns-01: host='{}'", (Object)identifier.getValue());
                    Record[] records = null;
                    try {
                        records = new Lookup(host, 16).run();
                    }
                    catch (TextParseException ex) {
                        message = "error while validating challenge " + challId + " for identifier " + identifier;
                        LogUtil.error((Logger)LOG, (Throwable)ex, (String)message);
                    }
                    String expectedName = "_acme-challenge." + host + ".";
                    if (records == null) break;
                    for (Record record : records) {
                        TXTRecord txt = (TXTRecord)record;
                        String name = txt.getName().toString();
                        if (!expectedName.equals(name)) continue;
                        receivedAuthorization = (String)txt.getStrings().get(0);
                    }
                    break;
                }
                default: {
                    throw new RuntimeException("should not reach here, unknown challenge type '" + type + "'");
                }
            }
            boolean authorizationValid = false;
            if (receivedAuthorization != null) {
                authorizationValid = chall.getExpectedAuthorization().equals(receivedAuthorization.trim());
            }
            if (authorizationValid) {
                LOG.info("validated challenge {}/{} for identifier {}/{}", new Object[]{chall.getType(), challId, identifier.getType(), identifier.getValue()});
                chall.validated(Instant.now().truncatedTo(ChronoUnit.SECONDS));
                chall.status(ChallengeStatus.valid);
            } else {
                LOG.warn("validation failed for challenge {}/{} for identifier {}/{}: received='{}', expected='{}'", new Object[]{chall.getType(), challId, identifier.getType(), identifier.getValue(), receivedAuthorization, chall.getExpectedAuthorization()});
                chall.status(ChallengeStatus.invalid);
            }
            if (chall.authz() == null || chall.authz().order() == null) continue;
            this.repo.flushOrderIfNotCached(chall.authz().order());
        }
    }

    public void close() {
        this.stopMe = true;
    }
}

