/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway.acme;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import org.xipki.ca.gateway.acme.AcmeAuthz;
import org.xipki.ca.gateway.acme.AcmeUtils;
import org.xipki.ca.gateway.acme.ChallId;
import org.xipki.ca.gateway.acme.msg.ChallengeResponse;
import org.xipki.ca.gateway.acme.type.ChallengeStatus;
import org.xipki.util.Args;
import org.xipki.util.CompareUtil;

public class AcmeChallenge {
    private final int subId;
    private final String expectedAuthorization;
    private final String type;
    private final String token;
    private Instant validated;
    private ChallengeStatus status;
    private AcmeAuthz authz;

    public AcmeChallenge(String type, int subId, String token, String expectedAuthorization, ChallengeStatus status) {
        this.subId = subId;
        this.expectedAuthorization = Args.notBlank((String)expectedAuthorization, (String)"expectedAuthorization");
        this.type = Args.notBlank((String)type, (String)"type");
        this.token = Args.notBlank((String)token, (String)"token");
        this.status = (ChallengeStatus)((Object)Args.notNull((Object)((Object)status), (String)"status"));
    }

    public Map<String, Object> encode() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("subId", this.subId);
        map.put("type", this.type);
        map.put("token", this.token);
        map.put("expectedAuthorization", this.expectedAuthorization);
        map.put("status", this.status.name());
        if (this.validated != null) {
            map.put("validated", this.validated.getEpochSecond());
        }
        return map;
    }

    public static AcmeChallenge decode(Map<String, Object> encoded) {
        int subId = AcmeUtils.getInt(encoded, "subId");
        String type = (String)encoded.get("type");
        String token = (String)encoded.get("token");
        String expectedAuthorization = (String)encoded.get("expectedAuthorization");
        ChallengeStatus status = ChallengeStatus.valueOf((String)encoded.get("status"));
        AcmeChallenge chall = new AcmeChallenge(type, subId, token, expectedAuthorization, status);
        Long l = AcmeUtils.getLong(encoded, "validated");
        if (l != null) {
            chall.validated = Instant.ofEpochSecond(l);
        }
        return chall;
    }

    public AcmeAuthz getAuthz() {
        return this.authz;
    }

    public void setAuthz(AcmeAuthz authz) {
        this.authz = authz;
    }

    public int getSubId() {
        return this.subId;
    }

    public Instant getValidated() {
        return this.validated;
    }

    public void setValidated(Instant validated) {
        this.markOrder();
        this.validated = validated;
    }

    public String getType() {
        return this.type;
    }

    public String getToken() {
        return this.token;
    }

    public ChallengeStatus getStatus() {
        return this.status;
    }

    public void setStatus(ChallengeStatus status) {
        this.markOrder();
        this.status = status;
    }

    public String getExpectedAuthorization() {
        return this.expectedAuthorization;
    }

    private void markOrder() {
        if (this.authz != null) {
            this.authz.markOrder();
        }
    }

    public ChallengeResponse toChallengeResponse(String baseUrl, long orderId, int authzId) {
        ChallengeResponse resp = new ChallengeResponse();
        if (this.validated != null) {
            resp.setValidated(this.validated.truncatedTo(ChronoUnit.SECONDS).toString());
        }
        ChallId challId = new ChallId(orderId, authzId, this.subId);
        resp.setUrl(baseUrl + "chall/" + challId.toIdText());
        resp.setStatus(this.status);
        resp.setType(this.type);
        resp.setToken(this.token);
        return resp;
    }

    public AcmeChallenge copy() {
        AcmeChallenge copy = new AcmeChallenge(this.type, this.subId, this.token, this.expectedAuthorization, this.status);
        copy.validated = this.validated;
        return copy;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AcmeChallenge)) {
            return false;
        }
        AcmeChallenge b = (AcmeChallenge)obj;
        return this.subId == b.subId && this.status == b.status && CompareUtil.equalsObject((Object)this.type, (Object)b.type) && CompareUtil.equalsObject((Object)this.token, (Object)b.token) && CompareUtil.equalsObject((Object)this.validated, (Object)b.validated) && CompareUtil.equalsObject((Object)this.expectedAuthorization, (Object)b.expectedAuthorization);
    }
}

