/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway.acme;

import java.security.SecureRandom;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.gateway.acme.AcmeAccount;
import org.xipki.ca.gateway.acme.AcmeAuthz;
import org.xipki.ca.gateway.acme.AcmeChallenge;
import org.xipki.ca.gateway.acme.AcmeOrder;
import org.xipki.ca.gateway.acme.AcmeSystemException;
import org.xipki.ca.gateway.acme.AcmeUtils;
import org.xipki.ca.gateway.acme.AuthzId;
import org.xipki.ca.gateway.acme.ChallId;
import org.xipki.ca.gateway.acme.type.AccountStatus;
import org.xipki.ca.gateway.acme.type.AuthzStatus;
import org.xipki.ca.gateway.acme.type.CertReqMeta;
import org.xipki.ca.gateway.acme.type.ChallengeStatus;
import org.xipki.ca.gateway.acme.type.OrderStatus;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.Base64Url;
import org.xipki.util.CompareUtil;

public class AcmeDataSource {
    private static final String SQL_ADD_ACCOUNT = "INSERT INTO ACCOUNT (ID,LUPDATE,STATUS,JWK_SHA256,DATA) VALUES (?,?,?,?,?)";
    private static final String SQL_ADD_ORDER = "INSERT INTO ORDER2 (ID,LUPDATE,ACCOUNT_ID,STATUS,EXPIRES,CERT_NAFTER,CERT_SHA256,CERTREQ_META,CSR,CERT,AUTHZS) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
    private static final String SQL_DELETE_ORDER_CERT_EXPIRED = "DELETE FROM ORDER2 WHERE CERT_NAFTER<?";
    private static final String SQL_DELETE_NOT_FINISHED_ORDER = "DELETE FROM ORDER2 WHERE STATUS != " + OrderStatus.valid.getCode() + " AND EXPIRES<?";
    private static final String SQL_SELECT_ORDER_ID = "SELECT ID FROM ORDER2 WHERE ACCOUNT=?";
    private static final Logger LOG = LoggerFactory.getLogger(AcmeDataSource.class);
    private final String sqlGetAccount;
    private final String sqlGetAccountFowJwkSha256;
    private final String sqlGetOrderById;
    private final String sqlGetOrderByCertSha256;
    private final DataSourceWrapper dataSource;
    private final SecureRandom rnd = new SecureRandom();
    private IdChecker idChecker;

    public AcmeDataSource(DataSourceWrapper dataSource) {
        this.dataSource = (DataSourceWrapper)Args.notNull((Object)dataSource, (String)"dataSource");
        this.sqlGetAccount = dataSource.buildSelectFirstSql(1, "ID,STATUS,JWK_SHA256,DATA FROM ACCOUNT WHERE ID=?");
        this.sqlGetAccountFowJwkSha256 = dataSource.buildSelectFirstSql(1, "ID,STATUS,JWK_SHA256,DATA FROM ACCOUNT WHERE JWK_SHA256=?");
        this.sqlGetOrderById = dataSource.buildSelectFirstSql(1, "ACCOUNT_ID,STATUS,EXPIRES,CERTREQ_META,AUTHZS,CERT_SHA256 FROM ORDER2 WHERE ID=?");
        this.sqlGetOrderByCertSha256 = dataSource.buildSelectFirstSql(1, "ID,ACCOUNT_ID,STATUS,EXPIRES,CERTREQ_META,AUTHZS FROM ORDER2 WHERE CERT_SHA256=?");
    }

    public void setIdChecker(IdChecker idChecker) {
        this.idChecker = idChecker;
    }

    private PreparedStatement prepareStatement(String sql) throws AcmeSystemException {
        try {
            return this.dataSource.prepareStatement(sql);
        }
        catch (DataAccessException ex) {
            throw new AcmeSystemException(ex);
        }
    }

    public void addNewAccount(AcmeAccount account) throws AcmeSystemException {
        if (account.getId() == 0L) {
            throw new AcmeSystemException("account.id not set");
        }
        String sql = SQL_ADD_ACCOUNT;
        PreparedStatement ps = this.prepareStatement(SQL_ADD_ACCOUNT);
        try {
            int index = 1;
            ps.setLong(index++, account.getId());
            ps.setLong(index++, Instant.now().getEpochSecond());
            ps.setInt(index++, account.getStatus().getCode());
            ps.setString(index++, account.getJwkSha256());
            ps.setString(index, account.getData().encode());
            ps.executeUpdate();
            LOG.info("Database: added account " + account.getId());
        }
        catch (SQLException ex) {
            throw new AcmeSystemException(this.dataSource.translate(SQL_ADD_ACCOUNT, ex));
        }
        finally {
            this.dataSource.releaseResources((Statement)ps, null);
        }
    }

    public byte[] getCert(long orderId) throws AcmeSystemException {
        try {
            String str = this.dataSource.getFirstStringValue(null, "ORDER2", "CERT", "ID=" + orderId);
            return str == null ? null : Base64Url.decodeFast((String)str);
        }
        catch (DataAccessException e) {
            throw new AcmeSystemException(e);
        }
    }

    public byte[] getCsr(long orderId) throws AcmeSystemException {
        try {
            String str = this.dataSource.getFirstStringValue(null, "ORDER2", "CSR", "ID=" + orderId);
            return str == null ? null : Base64Url.decodeFast((String)str);
        }
        catch (DataAccessException e) {
            throw new AcmeSystemException(e);
        }
    }

    public AcmeAccount getAccount(long accountId) throws AcmeSystemException {
        PreparedStatement ps = this.prepareStatement(this.sqlGetAccount);
        try {
            ps.setLong(1, accountId);
            AcmeAccount acmeAccount = this.getAccount(ps, this.sqlGetAccount);
            return acmeAccount;
        }
        catch (SQLException ex) {
            throw new AcmeSystemException(this.dataSource.translate(this.sqlGetAccount, ex));
        }
        finally {
            this.dataSource.releaseResources((Statement)ps, null);
        }
    }

    public void updateAccount(AcmeAccount oldAccount, AcmeAccount newAccount) throws AcmeSystemException {
        boolean updateData;
        if (oldAccount.getId() != newAccount.getId()) {
            throw new IllegalArgumentException("oldAccount and newAccount does not have the same id");
        }
        boolean updateJwkFp = oldAccount.getJwkSha256().equals(newAccount.getJwkSha256());
        boolean updateStatus = oldAccount.getStatus() != newAccount.getStatus();
        String oldData = oldAccount.getData().encode();
        String newData = newAccount.getData().encode();
        boolean bl = updateData = !oldData.equals(newData);
        if (!(updateJwkFp || updateStatus || updateData)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE ACCOUNT SET LUPDATE=?,");
        if (updateStatus) {
            sb.append("STATUS=?,");
        }
        if (updateJwkFp) {
            sb.append("JWK_SHA256=?,");
        }
        if (updateData) {
            sb.append("DATA=?,");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" WHERE ID=").append(oldAccount.getId());
        String sql = sb.toString();
        PreparedStatement ps = this.prepareStatement(sql);
        try {
            int index = 1;
            ps.setLong(index++, Instant.now().getEpochSecond());
            if (updateStatus) {
                ps.setInt(index++, newAccount.getStatus().getCode());
            }
            if (updateJwkFp) {
                ps.setString(index++, newAccount.getJwkSha256());
            }
            if (updateData) {
                ps.setString(index, newData);
            }
            ps.executeUpdate();
            LOG.info("Database: added account " + oldAccount.getId());
        }
        catch (SQLException ex) {
            throw new AcmeSystemException(this.dataSource.translate(sql, ex));
        }
        finally {
            this.dataSource.releaseResources((Statement)ps, null);
        }
    }

    public AcmeAccount getAccountForJwk(Map<String, String> jwk) throws AcmeSystemException {
        String sha256 = AcmeUtils.jwkSha256(jwk);
        String sql = this.sqlGetAccountFowJwkSha256;
        PreparedStatement ps = this.prepareStatement(sql);
        try {
            ps.setString(1, sha256);
            AcmeAccount acmeAccount = this.getAccount(ps, sql);
            return acmeAccount;
        }
        catch (SQLException ex) {
            throw new AcmeSystemException(this.dataSource.translate(sql, ex));
        }
        finally {
            this.dataSource.releaseResources((Statement)ps, null);
        }
    }

    private AcmeAccount getAccount(PreparedStatement ps, String sql) throws AcmeSystemException {
        ResultSet rs = null;
        try {
            rs = ps.executeQuery();
            if (!rs.next()) {
                AcmeAccount acmeAccount = null;
                return acmeAccount;
            }
            AccountStatus status = AccountStatus.ofCode(rs.getInt("STATUS"));
            AcmeAccount.Data data = AcmeAccount.Data.decode(rs.getString("DATA"));
            long id = rs.getLong("ID");
            AcmeAccount ret = new AcmeAccount(id, this);
            ret.setData(data);
            ret.setStatus(status);
            ret.setJwkSha256(rs.getString("JWK_SHA256"));
            ret.setInDb(true);
            ret.mark();
            AcmeAccount acmeAccount = ret;
            return acmeAccount;
        }
        catch (SQLException ex) {
            throw new AcmeSystemException(this.dataSource.translate(sql, ex));
        }
        finally {
            this.dataSource.releaseResources(null, rs);
        }
    }

    public void addNewOrder(AcmeOrder order) throws AcmeSystemException {
        String sql = SQL_ADD_ORDER;
        PreparedStatement ps = this.prepareStatement(sql);
        try {
            order.updateStatus();
            int index = 1;
            ps.setLong(index++, order.getId());
            ps.setLong(index++, Instant.now().getEpochSecond());
            ps.setLong(index++, order.getAccountId());
            ps.setInt(index++, order.getStatus().getCode());
            ps.setLong(index++, order.getExpires().getEpochSecond());
            byte[] certBytes = order.getCert();
            if (certBytes == null) {
                ps.setNull(index++, -5);
            } else {
                ps.setLong(index++, X509Util.extractCertNotAfter((byte[])certBytes));
            }
            ps.setString(index++, order.getCertSha256());
            if (order.getCertReqMeta() == null) {
                ps.setNull(index, 12);
            } else {
                ps.setString(index, order.getCertReqMeta().encode());
            }
            ++index;
            if (order.getCsr() == null) {
                ps.setNull(index, 12);
            } else {
                ps.setString(index, Base64Url.encodeToStringNoPadding((byte[])order.getCsr()));
            }
            ++index;
            if (certBytes == null) {
                ps.setNull(index, 12);
            } else {
                ps.setString(index, Base64Url.encodeToStringNoPadding((byte[])certBytes));
            }
            ps.setString(++index, order.getEncodedAuthzs());
            ps.executeUpdate();
            LOG.info("Database: added order " + order.getId());
        }
        catch (SQLException ex) {
            throw new AcmeSystemException(this.dataSource.translate(sql, ex));
        }
        finally {
            this.dataSource.releaseResources((Statement)ps, null);
        }
    }

    public void updateOrder(AcmeOrder oldOrder, AcmeOrder newOrder) throws AcmeSystemException {
        boolean updateCert;
        if (oldOrder.getId() != newOrder.getId()) {
            throw new IllegalArgumentException("oldOrder and newOrder does not have the same id");
        }
        if (oldOrder.getAccountId() != newOrder.getAccountId()) {
            throw new IllegalArgumentException("oldOrder and newOrder does not have the same account");
        }
        newOrder.updateStatus();
        boolean updateStatus = oldOrder.getStatus() != newOrder.getStatus();
        boolean updateExpires = !CompareUtil.equalsObject((Object)oldOrder.getExpires(), (Object)newOrder.getExpires());
        boolean updateAuthzs = !CompareUtil.equalsObject(oldOrder.getAuthzs(), newOrder.getAuthzs());
        boolean updateCertReqMeta = !CompareUtil.equalsObject((Object)oldOrder.getCertReqMeta(), (Object)newOrder.getCertReqMeta());
        boolean updateCsr = newOrder.getCsr() != null;
        boolean bl = updateCert = newOrder.getCert() != null;
        if (!(updateStatus || updateExpires || updateAuthzs || updateCertReqMeta || updateCsr || updateCert)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE ORDER2 SET LUPDATE=?,");
        if (updateStatus) {
            sb.append("STATUS=?,");
        }
        if (updateExpires) {
            sb.append("EXPIRES=?,");
        }
        if (updateAuthzs) {
            sb.append("AUTHZS=?,");
        }
        if (updateCertReqMeta) {
            sb.append("CERTREQ_META=?,");
        }
        if (updateCsr) {
            sb.append("CSR=?,");
        }
        if (updateCert) {
            sb.append("CERT_NAFTER=?,CERT_SHA256=?,CERT=?,");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" WHERE ID=").append(oldOrder.getId());
        String sql = sb.toString();
        PreparedStatement ps = this.prepareStatement(sql);
        try {
            int index = 1;
            ps.setLong(index++, Instant.now().getEpochSecond());
            if (updateStatus) {
                ps.setInt(index++, newOrder.getStatus().getCode());
            }
            if (updateExpires) {
                ps.setLong(index++, newOrder.getExpires().getEpochSecond());
            }
            if (updateAuthzs) {
                if (newOrder.getAuthzs() == null) {
                    ps.setNull(index, 12);
                } else {
                    ps.setString(index, newOrder.getEncodedAuthzs());
                }
                ++index;
            }
            if (updateCertReqMeta) {
                if (newOrder.getCertReqMeta() == null) {
                    ps.setNull(index, 12);
                } else {
                    ps.setString(index, newOrder.getCertReqMeta().encode());
                }
                ++index;
            }
            if (updateCsr) {
                ps.setString(index++, Base64Url.encodeToStringNoPadding((byte[])newOrder.getCsr()));
            }
            if (updateCert) {
                byte[] certBytes = newOrder.getCert();
                ps.setLong(index++, X509Util.extractCertNotAfter((byte[])certBytes));
                ps.setString(index++, newOrder.getCertSha256());
                ps.setString(index, Base64Url.encodeToStringNoPadding((byte[])certBytes));
            }
            ps.executeUpdate();
            LOG.info("Database: updated order " + oldOrder.getId());
        }
        catch (SQLException ex) {
            throw new AcmeSystemException(this.dataSource.translate(sql, ex));
        }
        finally {
            this.dataSource.releaseResources((Statement)ps, null);
        }
    }

    public AcmeOrder getOrder(long orderId) throws AcmeSystemException {
        PreparedStatement ps = this.prepareStatement(this.sqlGetOrderById);
        ResultSet rs = null;
        try {
            ps.setLong(1, orderId);
            rs = ps.executeQuery();
            if (!rs.next()) {
                AcmeOrder acmeOrder = null;
                return acmeOrder;
            }
            AcmeOrder order = this.buildOrder(rs, orderId);
            order.setCertSha256(rs.getString("CERT_SHA256"));
            order.mark();
            AcmeOrder acmeOrder = order;
            return acmeOrder;
        }
        catch (SQLException ex) {
            throw new AcmeSystemException(this.dataSource.translate(this.sqlGetOrderById, ex));
        }
        finally {
            this.dataSource.releaseResources((Statement)ps, rs);
        }
    }

    public AcmeOrder getOrderForCertSha256(String certSha256) throws AcmeSystemException {
        PreparedStatement ps = this.prepareStatement(this.sqlGetOrderByCertSha256);
        ResultSet rs = null;
        try {
            ps.setString(1, certSha256);
            rs = ps.executeQuery();
            if (!rs.next()) {
                AcmeOrder acmeOrder = null;
                return acmeOrder;
            }
            AcmeOrder order = this.buildOrder(rs, null);
            order.setCertSha256(certSha256);
            AcmeOrder acmeOrder = order;
            return acmeOrder;
        }
        catch (SQLException ex) {
            throw new AcmeSystemException(this.dataSource.translate(this.sqlGetOrderByCertSha256, ex));
        }
        finally {
            this.dataSource.releaseResources((Statement)ps, rs);
        }
    }

    private AcmeOrder buildOrder(ResultSet rs, Long id) throws SQLException {
        long accountId = rs.getLong("ACCOUNT_ID");
        if (id == null) {
            id = rs.getLong("ID");
        }
        AcmeOrder order = new AcmeOrder(accountId, id, this);
        order.setInDb(true);
        order.setStatus(OrderStatus.ofCode(rs.getInt("STATUS")));
        order.setExpires(Instant.ofEpochSecond(rs.getLong("EXPIRES")));
        String str = rs.getString("CERTREQ_META");
        if (str != null) {
            order.setCertReqMeta(CertReqMeta.decode(str));
        }
        String authzsStr = rs.getString("AUTHZS");
        order.setAuthzs(AcmeAuthz.decodeAuthzs(authzsStr));
        return order;
    }

    public AcmeAuthz getAuthz(byte[] authzId) throws AcmeSystemException {
        AuthzId id = new AuthzId(authzId);
        AcmeOrder order = this.getOrder(id.getOrderId());
        if (order == null) {
            return null;
        }
        return order.getAuthz(id.getSubId());
    }

    public List<Long> getOrderIds(long accountId) throws AcmeSystemException {
        LinkedList<Long> orderIds = new LinkedList<Long>();
        String sql = SQL_SELECT_ORDER_ID;
        PreparedStatement ps = this.prepareStatement(SQL_SELECT_ORDER_ID);
        ResultSet rs = null;
        try {
            ps.setLong(1, accountId);
            rs = ps.executeQuery();
            while (rs.next()) {
                long id = rs.getLong("ID");
                if (orderIds.contains(id)) continue;
                orderIds.add(id);
            }
        }
        catch (SQLException ex) {
            throw new AcmeSystemException(this.dataSource.translate(SQL_SELECT_ORDER_ID, ex));
        }
        finally {
            this.dataSource.releaseResources((Statement)ps, rs);
        }
        return orderIds;
    }

    public List<ChallId> getChallengesToValidate() throws AcmeSystemException {
        LinkedList<ChallId> linkedList;
        String sql = this.dataSource.buildSelectFirstSql(1000, "ID,AUTHZS FROM ORDER2 WHERE STATUS=?");
        PreparedStatement ps = this.prepareStatement(sql);
        ResultSet rs = null;
        try {
            ps.setInt(1, OrderStatus.pending.getCode());
            rs = ps.executeQuery();
            LinkedList<ChallId> ids = new LinkedList<ChallId>();
            while (rs.next()) {
                List<AcmeAuthz> authzs = AcmeAuthz.decodeAuthzs(rs.getString("AUTHZS"));
                AcmeDataSource.addChallengesToValidate(ids, rs.getLong("ID"), authzs);
            }
            linkedList = ids;
        }
        catch (SQLException ex) {
            try {
                throw new AcmeSystemException(this.dataSource.translate(sql, ex));
            }
            catch (Throwable throwable) {
                this.dataSource.releaseResources((Statement)ps, rs);
                throw throwable;
            }
        }
        this.dataSource.releaseResources((Statement)ps, rs);
        return linkedList;
    }

    public List<Long> getOrdersToEnroll() throws AcmeSystemException {
        LinkedList<Long> linkedList;
        String sql = this.dataSource.buildSelectFirstSql(1000, "ID FROM ORDER2 WHERE STATUS=?");
        PreparedStatement ps = this.prepareStatement(sql);
        ResultSet rs = null;
        try {
            ps.setInt(1, OrderStatus.processing.getCode());
            rs = ps.executeQuery();
            LinkedList<Long> ids = new LinkedList<Long>();
            while (rs.next()) {
                ids.add(rs.getLong("ID"));
            }
            linkedList = ids;
        }
        catch (SQLException ex) {
            try {
                throw new AcmeSystemException(this.dataSource.translate(sql, ex));
            }
            catch (Throwable throwable) {
                this.dataSource.releaseResources((Statement)ps, rs);
                throw throwable;
            }
        }
        this.dataSource.releaseResources((Statement)ps, rs);
        return linkedList;
    }

    public int cleanOrders(Instant certNotAfter, Instant notFinishedOrderExpires) throws AcmeSystemException {
        Instant dateLimit = Instant.now().minus(10L, ChronoUnit.DAYS);
        if (certNotAfter.isAfter(dateLimit)) {
            throw new IllegalArgumentException("certNotAfter " + certNotAfter + " is not allowed");
        }
        if (notFinishedOrderExpires.isAfter(dateLimit)) {
            throw new IllegalArgumentException("notFinishedOrderExpires " + notFinishedOrderExpires + " is not allowed");
        }
        int sum = 0;
        String sql = SQL_DELETE_ORDER_CERT_EXPIRED;
        PreparedStatement ps = this.prepareStatement(sql);
        try {
            ps.setLong(1, certNotAfter.getEpochSecond());
            sum += ps.executeUpdate();
            LOG.info("Database: deleted orders with certificates expired before {}", (Object)certNotAfter);
        }
        catch (SQLException ex) {
            throw new AcmeSystemException(this.dataSource.translate(sql, ex));
        }
        finally {
            this.dataSource.releaseResources((Statement)ps, null);
        }
        sql = SQL_DELETE_NOT_FINISHED_ORDER;
        ps = this.prepareStatement(sql);
        try {
            ps.setLong(1, notFinishedOrderExpires.getEpochSecond());
            LOG.info("Database: deleted orders expired before {}", (Object)certNotAfter);
        }
        catch (SQLException ex) {
            throw new AcmeSystemException(this.dataSource.translate(sql, ex));
        }
        finally {
            this.dataSource.releaseResources((Statement)ps, null);
        }
        return sum += ps.executeUpdate();
    }

    private static void addChallengesToValidate(List<ChallId> res, long orderId, List<AcmeAuthz> authzs) {
        block0: for (AcmeAuthz authz : authzs) {
            if (authz.getStatus() != AuthzStatus.pending) continue;
            for (AcmeChallenge challenge : authz.getChallenges()) {
                if (challenge.getStatus() != ChallengeStatus.processing) continue;
                res.add(new ChallId(orderId, authz.getSubId(), challenge.getSubId()));
                continue block0;
            }
        }
    }

    public long nextAccountId() throws DataAccessException {
        long id;
        while (this.idChecker.accountIdExists(id = this.rnd.nextLong()) || this.dataSource.columnExists(null, "ACCOUNT", "ID", (Object)id)) {
        }
        return id;
    }

    public long nextOrderId() throws DataAccessException {
        long id;
        while (this.idChecker.orderIdExists(id = this.rnd.nextLong()) || this.dataSource.columnExists(null, "ORDER2", "ID", (Object)id)) {
        }
        return id;
    }

    public int[] nextAuthzIds(int numAuthzs) {
        return this.nextIntIds(numAuthzs);
    }

    public int[] nextChallIds(int numChalls) {
        return this.nextIntIds(numChalls);
    }

    private int[] nextIntIds(int num) {
        if (num == 1) {
            return new int[]{this.rnd.nextInt() & 0xFFFF};
        }
        ArrayList<Integer> ids = new ArrayList<Integer>(num);
        for (int i = 0; i < num; ++i) {
            int id = this.rnd.nextInt() & 0xFFFF;
            while (ids.contains(id)) {
                id = this.rnd.nextInt() & 0xFFFF;
            }
            ids.add(id);
        }
        int[] ret = new int[num];
        for (int i = 0; i < num; ++i) {
            ret[i] = (Integer)ids.get(i);
        }
        return ret;
    }

    public static interface IdChecker {
        public boolean accountIdExists(long var1);

        public boolean orderIdExists(long var1);
    }
}

