/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway.acme;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.xipki.ca.gateway.acme.AcmeAuthz;
import org.xipki.ca.gateway.acme.AcmeChallenge;
import org.xipki.ca.gateway.acme.AcmeDataSource;
import org.xipki.ca.gateway.acme.AcmeSystemException;
import org.xipki.ca.gateway.acme.AcmeUtils;
import org.xipki.ca.gateway.acme.AuthzId;
import org.xipki.ca.gateway.acme.msg.OrderResponse;
import org.xipki.ca.gateway.acme.type.AuthzStatus;
import org.xipki.ca.gateway.acme.type.CertReqMeta;
import org.xipki.ca.gateway.acme.type.ChallengeStatus;
import org.xipki.ca.gateway.acme.type.Identifier;
import org.xipki.ca.gateway.acme.type.OrderStatus;
import org.xipki.security.HashAlgo;
import org.xipki.util.Args;
import org.xipki.util.Base64Url;

public class AcmeOrder {
    private boolean inDb;
    private boolean marked;
    private AcmeOrder mark;
    private OrderStatus status = OrderStatus.pending;
    private final long accountId;
    private final long id;
    private final String idStr;
    private List<AcmeAuthz> authzs;
    private Instant expires;
    private CertReqMeta certReqMeta;
    private byte[] csr;
    private String certSha256;
    private byte[] cert;
    private final AcmeDataSource dataSource;

    public AcmeOrder(long accountId, long id, AcmeDataSource dataSource) {
        this.accountId = accountId;
        this.id = id;
        this.idStr = AcmeUtils.toBase64(id);
        this.dataSource = (AcmeDataSource)Args.notNull((Object)dataSource, (String)"dataSource");
    }

    public long getAccountId() {
        return this.accountId;
    }

    public OrderStatus getStatus() {
        return this.status;
    }

    public void setStatus(OrderStatus status) {
        this.markMe();
        this.status = status;
    }

    public void setInDb(boolean inDb) {
        this.inDb = inDb;
    }

    public CertReqMeta getCertReqMeta() {
        return this.certReqMeta;
    }

    public void setCertReqMeta(CertReqMeta certReqMeta) {
        this.markMe();
        this.certReqMeta = certReqMeta;
    }

    public byte[] getCert() {
        return this.cert;
    }

    public String getCertSha256() {
        if (this.certSha256 != null) {
            return this.certSha256;
        }
        if (this.cert == null) {
            return null;
        }
        this.certSha256 = Base64Url.encodeToStringNoPadding((byte[])HashAlgo.SHA256.hash((byte[][])new byte[][]{this.cert}));
        return this.certSha256;
    }

    public void setCertSha256(String certSha256) {
        this.certSha256 = certSha256;
    }

    public void setCert(byte[] cert) {
        this.markMe();
        this.cert = cert;
        this.certSha256 = cert == null ? null : Base64Url.encodeToStringNoPadding((byte[])HashAlgo.SHA256.hash((byte[][])new byte[][]{cert}));
    }

    public long getId() {
        return this.id;
    }

    public String idText() {
        return this.idStr + " (" + this.id + ")";
    }

    public Instant getExpires() {
        return this.expires;
    }

    public void setExpires(Instant expires) {
        this.markMe();
        this.expires = expires;
    }

    public byte[] getCsr() {
        return this.csr;
    }

    public void setCsr(byte[] csr) {
        this.markMe();
        this.csr = csr;
    }

    public List<AcmeAuthz> getAuthzs() {
        return this.authzs;
    }

    public String getEncodedAuthzs() {
        return AcmeAuthz.encodeAuthzs(this.authzs);
    }

    public void setAuthzs(List<AcmeAuthz> authzs) {
        this.markMe();
        this.authzs = authzs;
        if (authzs != null) {
            for (AcmeAuthz authz : authzs) {
                authz.setOrder(this);
            }
        }
    }

    public String getLocation(String baseUrl) {
        return baseUrl + "order/" + this.idStr;
    }

    public OrderResponse toResponse(String baseUrl) {
        OrderResponse resp = new OrderResponse();
        resp.setStatus(this.status);
        resp.setExpires(this.expires.toString());
        resp.setFinalize(baseUrl + "finalize/" + this.idStr);
        ArrayList<String> authzUrls = new ArrayList<String>(this.authzs.size());
        ArrayList<Identifier> identifiers = new ArrayList<Identifier>(this.authzs.size());
        for (AcmeAuthz authz : this.authzs) {
            AuthzId authzId = new AuthzId(this.id, authz.getSubId());
            authzUrls.add(baseUrl + "authz/" + authzId.toIdText());
            identifiers.add(authz.getIdentifier().toIdentifier());
        }
        resp.setAuthorizations(authzUrls);
        resp.setIdentifiers(identifiers);
        if (this.status == OrderStatus.valid) {
            resp.setCertificate(baseUrl + "cert/" + this.idStr);
        }
        return resp;
    }

    public AcmeAuthz getAuthz(int authzId) {
        for (AcmeAuthz authz : this.authzs) {
            if (authz.getSubId() != authzId) continue;
            return authz;
        }
        return null;
    }

    public void updateStatus() {
        if (this.status == OrderStatus.valid || this.status == OrderStatus.invalid) {
            return;
        }
        block0: for (AcmeAuthz authz : this.authzs) {
            for (AcmeChallenge chall : authz.getChallenges()) {
                if (chall.getStatus() == ChallengeStatus.valid) {
                    authz.setStatus(AuthzStatus.valid);
                    continue block0;
                }
                if (chall.getStatus() != ChallengeStatus.invalid) continue;
                authz.setStatus(AuthzStatus.invalid);
                this.status = OrderStatus.invalid;
                return;
            }
        }
        if (this.status == OrderStatus.ready || this.status == OrderStatus.processing) {
            return;
        }
        boolean allAuthzsValidated = true;
        for (AcmeAuthz authz : this.authzs) {
            if (authz.getStatus() == AuthzStatus.valid) continue;
            allAuthzsValidated = false;
            break;
        }
        if (allAuthzsValidated) {
            this.status = OrderStatus.ready;
        }
    }

    public void mark() {
        this.marked = true;
    }

    public synchronized void flush() throws AcmeSystemException {
        this.updateStatus();
        if (this.inDb) {
            if (this.mark != null) {
                this.dataSource.updateOrder(this.mark, this);
            }
        } else {
            this.dataSource.addNewOrder(this);
            this.inDb = true;
        }
        this.mark = null;
    }

    synchronized void markMe() {
        if (!this.inDb || this.mark != null) {
            return;
        }
        AcmeOrder copy = new AcmeOrder(this.accountId, this.id, this.dataSource);
        if (this.authzs != null) {
            copy.authzs = new ArrayList<AcmeAuthz>(this.authzs.size());
            for (AcmeAuthz authz : this.authzs) {
                copy.authzs.add(authz.copy());
            }
        }
        if (this.cert != null) {
            copy.cert = this.cert;
        }
        if (this.csr != null) {
            copy.csr = this.csr;
        }
        copy.expires = this.expires;
        if (this.certReqMeta != null) {
            copy.certReqMeta = this.certReqMeta.copy();
        }
        copy.inDb = this.inDb;
        copy.status = this.status;
        copy.marked = this.marked;
        this.mark = copy;
    }
}

