/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway.acme;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.sec.SECObjectIdentifiers;
import org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.util.Pack;
import org.xipki.ca.gateway.acme.AcmeProtocolException;
import org.xipki.ca.gateway.acme.type.AcmeError;
import org.xipki.security.HashAlgo;
import org.xipki.security.util.AlgorithmUtil;
import org.xipki.security.util.KeyUtil;
import org.xipki.util.Base64Url;
import org.xipki.util.DateUtil;

final class AcmeUtils {
    private AcmeUtils() {
    }

    public static Instant parseTimestamp(String timestamp) throws AcmeProtocolException {
        try {
            return DateUtil.parseRFC3339Timestamp((String)timestamp);
        }
        catch (DateTimeParseException ex) {
            throw new AcmeProtocolException(400, AcmeError.malformed, "invalid timestamp " + timestamp);
        }
    }

    public static PublicKey jwkPublicKey(Map<String, String> jwk) throws InvalidKeySpecException {
        String kty = jwk.get("kty");
        if ("RSA".equalsIgnoreCase(kty)) {
            return KeyUtil.generateRSAPublicKey((RSAPublicKeySpec)new RSAPublicKeySpec(new BigInteger(1, Base64Url.decodeFast((String)jwk.get("n"))), new BigInteger(1, Base64Url.decodeFast((String)jwk.get("e")))));
        }
        if ("EC".equalsIgnoreCase(kty)) {
            String curveName = jwk.get("crv");
            ASN1ObjectIdentifier curveOid = AlgorithmUtil.getCurveOidForCurveNameOrOid((String)curveName);
            byte[] encodedPoint = AcmeUtils.buildECPublicKeyData(curveOid, Base64Url.decodeFast((String)jwk.get("x")), Base64Url.decodeFast((String)jwk.get("y")));
            return KeyUtil.createECPublicKey((ASN1ObjectIdentifier)curveOid, (byte[])encodedPoint);
        }
        throw new InvalidKeySpecException("unsupported kty " + kty);
    }

    public static boolean matchKey(Map<String, String> jwk, SubjectPublicKeyInfo pkInfo) throws InvalidKeySpecException {
        AlgorithmIdentifier pkInfoAlgo = pkInfo.getAlgorithm();
        ASN1ObjectIdentifier pkKeyAlgo = pkInfoAlgo.getAlgorithm();
        String kty = jwk.get("kty");
        if ("RSA".equalsIgnoreCase(kty)) {
            if (!(pkKeyAlgo.equals((ASN1Primitive)PKCSObjectIdentifiers.rsaEncryption) || pkKeyAlgo.equals((ASN1Primitive)PKCSObjectIdentifiers.id_RSASSA_PSS) || pkKeyAlgo.equals((ASN1Primitive)PKCSObjectIdentifiers.sha1WithRSAEncryption) || pkKeyAlgo.equals((ASN1Primitive)PKCSObjectIdentifiers.sha224WithRSAEncryption) || pkKeyAlgo.equals((ASN1Primitive)PKCSObjectIdentifiers.sha256WithRSAEncryption) || pkKeyAlgo.equals((ASN1Primitive)PKCSObjectIdentifiers.sha384WithRSAEncryption) || pkKeyAlgo.equals((ASN1Primitive)PKCSObjectIdentifiers.sha512WithRSAEncryption))) {
                return false;
            }
            BigInteger n = new BigInteger(1, Base64Url.decodeFast((String)jwk.get("n")));
            BigInteger e = new BigInteger(1, Base64Url.decodeFast((String)jwk.get("e")));
            ASN1Sequence seq = ASN1Sequence.getInstance((Object)pkInfo.getPublicKeyData().getOctets());
            BigInteger n2 = ASN1Integer.getInstance((Object)seq.getObjectAt(0)).getPositiveValue();
            BigInteger e2 = ASN1Integer.getInstance((Object)seq.getObjectAt(1)).getPositiveValue();
            return n.equals(n2) && e.equals(e2);
        }
        if ("EC".equalsIgnoreCase(kty)) {
            ASN1ObjectIdentifier curveOid2;
            if (!X9ObjectIdentifiers.id_ecPublicKey.equals((ASN1Primitive)pkKeyAlgo)) {
                return false;
            }
            try {
                curveOid2 = ASN1ObjectIdentifier.getInstance((Object)pkInfoAlgo.getParameters());
            }
            catch (IllegalArgumentException ex) {
                return false;
            }
            String curveName = jwk.get("crv");
            ASN1ObjectIdentifier curveOid = AlgorithmUtil.getCurveOidForCurveNameOrOid((String)curveName);
            if (!curveOid2.equals((ASN1Primitive)curveOid)) {
                return false;
            }
            byte[] encodedPoint = AcmeUtils.buildECPublicKeyData(curveOid, Base64Url.decodeFast((String)jwk.get("x")), Base64Url.decodeFast((String)jwk.get("y")));
            return Arrays.equals(pkInfo.getPublicKeyData().getBytes(), encodedPoint);
        }
        throw new RuntimeException("unsupported kty " + kty);
    }

    private static byte[] buildECPublicKeyData(ASN1ObjectIdentifier curveOid, byte[] x, byte[] y) throws InvalidKeySpecException {
        int i;
        int fieldSize = SECObjectIdentifiers.secp192r1.equals((ASN1Primitive)curveOid) || TeleTrusTObjectIdentifiers.brainpoolP192r1.equals((ASN1Primitive)curveOid) ? 24 : (SECObjectIdentifiers.secp224r1.equals((ASN1Primitive)curveOid) || TeleTrusTObjectIdentifiers.brainpoolP224r1.equals((ASN1Primitive)curveOid) ? 28 : (SECObjectIdentifiers.secp256r1.equals((ASN1Primitive)curveOid) || TeleTrusTObjectIdentifiers.brainpoolP256r1.equals((ASN1Primitive)curveOid) || GMObjectIdentifiers.sm2p256v1.equals((ASN1Primitive)curveOid) ? 32 : (SECObjectIdentifiers.secp384r1.equals((ASN1Primitive)curveOid) || TeleTrusTObjectIdentifiers.brainpoolP384r1.equals((ASN1Primitive)curveOid) ? 48 : (TeleTrusTObjectIdentifiers.brainpoolP256r1.equals((ASN1Primitive)curveOid) ? 64 : (SECObjectIdentifiers.secp521r1.equals((ASN1Primitive)curveOid) ? 66 : Math.max(x.length, y.length))))));
        byte[] res = new byte[1 + 2 * fieldSize];
        res[0] = 4;
        int off = 1;
        if (x.length > fieldSize) {
            for (i = 0; i < x.length - fieldSize; ++i) {
                if (x[i] == 0) continue;
                throw new InvalidKeySpecException("x too large");
            }
            System.arraycopy(x, x.length - fieldSize, res, off, fieldSize);
        } else {
            System.arraycopy(x, 0, res, off + fieldSize - x.length, x.length);
        }
        off = 1 + fieldSize;
        if (y.length > fieldSize) {
            for (i = 0; i < y.length - fieldSize; ++i) {
                if (y[i] == 0) continue;
                throw new InvalidKeySpecException("y too large");
            }
            System.arraycopy(y, y.length - fieldSize, res, off, fieldSize);
        } else {
            System.arraycopy(y, 0, res, off + fieldSize - y.length, x.length);
        }
        return res;
    }

    public static String toBase64(long label) {
        return Base64Url.encodeToStringNoPadding((byte[])Pack.longToLittleEndian((long)label));
    }

    public static String jwkSha256(Map<String, String> jwk) {
        ArrayList<String> jwkNames = new ArrayList<String>(jwk.keySet());
        Collections.sort(jwkNames);
        StringBuilder canonJwk = new StringBuilder();
        canonJwk.append("{");
        for (String jwkName : jwkNames) {
            canonJwk.append("\"").append(jwkName).append("\":\"").append(jwk.get(jwkName)).append("\",");
        }
        canonJwk.deleteCharAt(canonJwk.length() - 1);
        canonJwk.append("}");
        return Base64Url.encodeToStringNoPadding((byte[])HashAlgo.SHA256.hash((byte[][])new byte[][]{canonJwk.toString().getBytes(StandardCharsets.UTF_8)}));
    }

    public static Long getLong(Map<String, Object> map, String name) {
        Object obj = map.get(name);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Integer) {
            return (long)((Integer)obj);
        }
        return (Long)obj;
    }

    public static Integer getInt(Map<String, Object> map, String name) {
        Object obj = map.get(name);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Long) {
            long l = (Long)obj;
            if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
                throw new IllegalStateException("value of " + name + " is outside the integer range");
            }
            return (int)l;
        }
        return (Integer)obj;
    }
}

