/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway.acme.servlet;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.gateway.GatewayUtil;
import org.xipki.ca.gateway.ProtocolProxyConfWrapper;
import org.xipki.ca.gateway.acme.AcmeProxyConf;
import org.xipki.ca.gateway.acme.AcmeResponder;
import org.xipki.ca.gateway.acme.servlet.AcmeHttpServlet;
import org.xipki.ca.gateway.conf.ProtocolProxyConf;
import org.xipki.util.IoUtil;
import org.xipki.util.XipkiBaseDir;
import org.xipki.util.exception.InvalidConfException;
import org.xipki.util.http.XiHttpFilter;
import org.xipki.util.http.XiHttpRequest;
import org.xipki.util.http.XiHttpResponse;

public class AcmeHttpFilter
implements XiHttpFilter {
    private static final Logger LOG = LoggerFactory.getLogger(AcmeHttpFilter.class);
    private static final String DFLT_CFG = "etc/acme-gateway.json";
    private final AcmeHttpServlet servlet;
    private ProtocolProxyConfWrapper conf;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AcmeHttpFilter() throws Exception {
        boolean succ = false;
        try {
            AcmeProxyConf conf0;
            XipkiBaseDir.init();
            try {
                conf0 = AcmeProxyConf.readConfFromFile(IoUtil.expandFilepath((String)DFLT_CFG, (boolean)true));
            }
            catch (IOException ex) {
                throw new IOException("could not parse configuration file etc/acme-gateway.json", ex);
            }
            catch (InvalidConfException ex) {
                throw new InvalidConfException("could not parse configuration file etc/acme-gateway.json", (Throwable)ex);
            }
            this.conf = new ProtocolProxyConfWrapper((ProtocolProxyConf)conf0);
            AcmeResponder responder = new AcmeResponder(this.conf.getSdkClient(), this.conf.getSecurities().getSecurityFactory(), this.conf.getPopControl(), conf0.getAcme());
            responder.start();
            this.servlet = new AcmeHttpServlet(this.conf.isLogReqResp(), responder);
            succ = true;
        }
        finally {
            GatewayUtil.auditLogPciEvent((Logger)LOG, (String)"ACME-Gateway", (boolean)succ, (String)"START");
        }
    }

    public void destroy() {
        try {
            this.servlet.getResponder().close();
            if (this.conf != null) {
                this.conf.destroy();
                this.conf = null;
            }
            GatewayUtil.auditLogPciEvent((Logger)LOG, (String)"ACME-Gateway", (boolean)true, (String)"SHUTDOWN");
            GatewayUtil.closeAudits((Logger)LOG);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doFilter(XiHttpRequest req, XiHttpResponse resp) throws IOException {
        this.servlet.service(req, resp);
    }
}

