/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway.acme.servlet;

import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.audit.AuditEvent;
import org.xipki.audit.AuditLevel;
import org.xipki.audit.AuditService;
import org.xipki.audit.AuditStatus;
import org.xipki.audit.Audits;
import org.xipki.ca.gateway.GatewayUtil;
import org.xipki.ca.gateway.acme.AcmeResponder;
import org.xipki.util.Args;
import org.xipki.util.IoUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.http.HttpResponse;
import org.xipki.util.http.XiHttpRequest;
import org.xipki.util.http.XiHttpResponse;

class AcmeHttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(AcmeHttpServlet.class);
    private final boolean logReqResp;
    private final AcmeResponder responder;

    public AcmeHttpServlet(boolean logReqResp, AcmeResponder responder) {
        this.logReqResp = logReqResp;
        this.responder = (AcmeResponder)Args.notNull((Object)responder, (String)"responder");
    }

    AcmeResponder getResponder() {
        return this.responder;
    }

    public void service(XiHttpRequest req, XiHttpResponse resp) throws IOException {
        String method = req.getMethod();
        if (!"GET".equalsIgnoreCase(method) && !"POST".equalsIgnoreCase(method)) {
            resp.setStatus(405);
        }
        this.service0(req, "POST".equalsIgnoreCase(method)).fillResponse(resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse service0(XiHttpRequest req, boolean viaPost) throws IOException {
        HttpResponse httpResponse;
        AuditService auditService = Audits.getAuditService();
        AuditEvent event = new AuditEvent();
        event.setApplicationName("acme-gw");
        byte[] requestBytes = null;
        HttpResponse httpResp = null;
        try {
            requestBytes = viaPost ? IoUtil.readAllBytes((InputStream)req.getInputStream()) : null;
            httpResp = this.responder.service(req, requestBytes, event);
            if (event.getStatus() == null) {
                event.setStatus(AuditStatus.SUCCESSFUL);
            }
            httpResponse = httpResp;
        }
        catch (RuntimeException ex) {
            HttpResponse httpResponse2;
            try {
                event.setStatus(AuditStatus.FAILED);
                event.setLevel(AuditLevel.ERROR);
                LOG.error("RuntimeException thrown, this should not happen!", (Throwable)ex);
                httpResponse2 = new HttpResponse(500);
            }
            catch (Throwable throwable) {
                LogUtil.logTextReqResp((String)"ACME Gateway", (Logger)LOG, (boolean)this.logReqResp, (boolean)viaPost, (String)req.getRequestURI(), (byte[])requestBytes, (byte[])(httpResp == null ? null : httpResp.getBody()));
                event.finish();
                auditService.logEvent(event);
                GatewayUtil.logAuditEvent((Logger)LOG, (AuditEvent)event);
                throw throwable;
            }
            LogUtil.logTextReqResp((String)"ACME Gateway", (Logger)LOG, (boolean)this.logReqResp, (boolean)viaPost, (String)req.getRequestURI(), (byte[])requestBytes, (byte[])(httpResp == null ? null : httpResp.getBody()));
            event.finish();
            auditService.logEvent(event);
            GatewayUtil.logAuditEvent((Logger)LOG, (AuditEvent)event);
            return httpResponse2;
        }
        LogUtil.logTextReqResp((String)"ACME Gateway", (Logger)LOG, (boolean)this.logReqResp, (boolean)viaPost, (String)req.getRequestURI(), (byte[])requestBytes, (byte[])(httpResp == null ? null : httpResp.getBody()));
        event.finish();
        auditService.logEvent(event);
        GatewayUtil.logAuditEvent((Logger)LOG, (AuditEvent)event);
        return httpResponse;
    }
}

