/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.cmp.client;

import java.math.BigInteger;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.asn1.x500.X500Name;
import org.xipki.cmp.client.UnrevokeCertRequest;
import org.xipki.util.Args;

public class RevokeCertRequest {
    private final List<Entry> requestEntries = new LinkedList<Entry>();

    public boolean addRequestEntry(Entry requestEntry) {
        Args.notNull((Object)requestEntry, (String)"requestEntry");
        for (Entry re : this.requestEntries) {
            if (!re.getId().equals(requestEntry.getId())) continue;
            return false;
        }
        this.requestEntries.add(requestEntry);
        return true;
    }

    public List<Entry> getRequestEntries() {
        return Collections.unmodifiableList(this.requestEntries);
    }

    public static class Entry
    extends UnrevokeCertRequest.Entry {
        private final int reason;
        private final Date invalidityDate;
        private byte[] authorityKeyIdentifier;

        public Entry(String id, X500Name issuer, BigInteger serialNumber, int reason, Date invalidityDate) {
            super(id, issuer, serialNumber);
            if (reason < 0 || reason > 10 || reason == 7) {
                throw new IllegalArgumentException("invalid reason: " + reason);
            }
            this.reason = reason;
            this.invalidityDate = invalidityDate;
        }

        public int getReason() {
            return this.reason;
        }

        public Date getInvalidityDate() {
            return this.invalidityDate;
        }

        @Override
        public byte[] getAuthorityKeyIdentifier() {
            return this.authorityKeyIdentifier;
        }

        @Override
        public void setAuthorityKeyIdentifier(byte[] authorityKeyIdentifier) {
            this.authorityKeyIdentifier = authorityKeyIdentifier;
        }
    }
}

