/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.cmp.client;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.crmf.CertRequest;
import org.bouncycastle.asn1.crmf.ProofOfPossession;
import org.xipki.cmp.client.IdentifiedObject;
import org.xipki.util.Args;

public class EnrollCertRequest {
    private final EnrollType type;
    private final List<Entry> requestEntries = new LinkedList<Entry>();

    public EnrollCertRequest(EnrollType type) {
        this.type = (EnrollType)((Object)Args.notNull((Object)((Object)type), (String)"type"));
    }

    public EnrollType getType() {
        return this.type;
    }

    public boolean addRequestEntry(Entry requestEntry) {
        String id = ((Entry)Args.notNull((Object)requestEntry, (String)"requestEntry")).getId();
        ASN1Integer certReqId = requestEntry.getCertReq().getCertReqId();
        for (Entry re : this.requestEntries) {
            if (re.getId().equals(id)) {
                return false;
            }
            if (!re.getCertReq().getCertReqId().equals((ASN1Primitive)certReqId)) continue;
            return false;
        }
        this.requestEntries.add(requestEntry);
        return true;
    }

    public List<Entry> getRequestEntries() {
        return Collections.unmodifiableList(this.requestEntries);
    }

    public static class Entry
    extends IdentifiedObject {
        private final String certprofile;
        private final CertRequest certReq;
        private final ProofOfPossession pop;

        public Entry(String id, String certprofile, CertRequest certReq, ProofOfPossession pop) {
            super(id);
            this.certprofile = Args.notBlank((String)certprofile, (String)"certprofile");
            this.certReq = (CertRequest)Args.notNull((Object)certReq, (String)"certReq");
            this.pop = (ProofOfPossession)Args.notNull((Object)pop, (String)"pop");
        }

        public Entry(String id, String certprofile, CertRequest certReq, ProofOfPossession pop, boolean serverkeygen, boolean reenroll) {
            super(id);
            this.certprofile = reenroll ? certprofile : Args.notBlank((String)certprofile, (String)"certprofile");
            this.certReq = (CertRequest)Args.notNull((Object)certReq, (String)"certReq");
            if (!serverkeygen) {
                Args.notNull((Object)pop, (String)"pop");
            }
            this.pop = pop;
        }

        public String getCertprofile() {
            return this.certprofile;
        }

        public CertRequest getCertReq() {
            return this.certReq;
        }

        public ProofOfPossession getPop() {
            return this.pop;
        }
    }

    public static enum EnrollType {
        CERT_REQ,
        INIT_REQ,
        KEY_UPDATE,
        CROSS_CERT_REQ;

    }
}

