/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.cmp.client;

import java.util.LinkedList;
import java.util.List;
import org.xipki.util.FileOrBinary;
import org.xipki.util.ValidableConf;
import org.xipki.util.exception.InvalidConfException;
import org.xipki.util.http.SslConf;

public class CmpClientConf
extends ValidableConf {
    private boolean sendRequestorCert = true;
    private Responder responder;
    private SslConf ssl;

    public boolean isSendRequestorCert() {
        return this.sendRequestorCert;
    }

    public void setSendRequestorCert(boolean sendRequestorCert) {
        this.sendRequestorCert = sendRequestorCert;
    }

    public Responder getResponder() {
        return this.responder;
    }

    public void setResponder(Responder responder) {
        this.responder = responder;
    }

    public SslConf getSsl() {
        return this.ssl;
    }

    public void setSsl(SslConf ssl) {
        this.ssl = ssl;
    }

    public void validate() throws InvalidConfException {
        CmpClientConf.validate((ValidableConf)this.responder, (ValidableConf[])new ValidableConf[]{this.ssl});
    }

    public static class Responder
    extends ValidableConf {
        private String url;
        private PbmMac pbmMac;
        private Signature signature;
        private FileOrBinary dhPopCerts;

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public PbmMac getPbmMac() {
            return this.pbmMac;
        }

        public void setPbmMac(PbmMac value) {
            this.pbmMac = value;
        }

        public Signature getSignature() {
            return this.signature;
        }

        public void setSignature(Signature value) {
            this.signature = value;
        }

        public FileOrBinary getDhPopCerts() {
            return this.dhPopCerts;
        }

        public void setDhPopCerts(FileOrBinary dhPopCerts) {
            this.dhPopCerts = dhPopCerts;
        }

        public void validate() throws InvalidConfException {
            if (this.pbmMac == null && this.signature == null) {
                throw new InvalidConfException("at least one of pbmMac and signature must be specified");
            }
            Responder.validate((ValidableConf)this.pbmMac, (ValidableConf[])new ValidableConf[]{this.signature});
        }

        public static class Signature
        extends ValidableConf {
            private FileOrBinary cert;
            private List<String> signatureAlgos;

            public FileOrBinary getCert() {
                return this.cert;
            }

            public void setCert(FileOrBinary cert) {
                this.cert = cert;
            }

            public List<String> getSignatureAlgos() {
                if (this.signatureAlgos == null) {
                    this.signatureAlgos = new LinkedList<String>();
                }
                return this.signatureAlgos;
            }

            public void setSignatureAlgos(List<String> signatureAlgos) {
                this.signatureAlgos = signatureAlgos;
            }

            public void validate() throws InvalidConfException {
                Signature.notEmpty(this.signatureAlgos, (String)"signatureAlgos");
            }
        }

        public static class PbmMac
        extends ValidableConf {
            private List<String> owfAlgos;
            private List<String> macAlgos;

            public List<String> getOwfAlgos() {
                if (this.owfAlgos == null) {
                    this.owfAlgos = new LinkedList<String>();
                }
                return this.owfAlgos;
            }

            public void setOwfAlgos(List<String> owfAlgos) {
                this.owfAlgos = owfAlgos;
            }

            public List<String> getMacAlgos() {
                if (this.macAlgos == null) {
                    this.macAlgos = new LinkedList<String>();
                }
                return this.macAlgos;
            }

            public void setMacAlgos(List<String> macAlgos) {
                this.macAlgos = macAlgos;
            }

            public void validate() throws InvalidConfException {
                PbmMac.notEmpty(this.owfAlgos, (String)"owfAlgos");
                PbmMac.notEmpty(this.macAlgos, (String)"macAlgos");
            }
        }
    }
}

