/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.cmp.client.internal;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import org.bouncycastle.asn1.cmp.CMPCertificate;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.cert.X509CRLHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.cmp.client.CertIdOrError;
import org.xipki.cmp.client.CmpClient;
import org.xipki.cmp.client.CmpClientConf;
import org.xipki.cmp.client.CmpClientException;
import org.xipki.cmp.client.EnrollCertRequest;
import org.xipki.cmp.client.EnrollCertResult;
import org.xipki.cmp.client.PkiErrorException;
import org.xipki.cmp.client.Requestor;
import org.xipki.cmp.client.RevokeCertRequest;
import org.xipki.cmp.client.UnrevokeCertRequest;
import org.xipki.cmp.client.internal.CmpAgent;
import org.xipki.cmp.client.internal.CsrEnrollCertRequest;
import org.xipki.cmp.client.internal.EnrollCertResponse;
import org.xipki.cmp.client.internal.Responder;
import org.xipki.cmp.client.internal.ResultEntry;
import org.xipki.cmp.client.internal.RevokeCertResponse;
import org.xipki.security.AlgorithmValidator;
import org.xipki.security.CollectionAlgorithmValidator;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignAlgo;
import org.xipki.security.X509Cert;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.IoUtil;
import org.xipki.util.JSON;
import org.xipki.util.ReqRespDebug;
import org.xipki.util.exception.InvalidConfException;
import org.xipki.util.http.SslConf;
import org.xipki.util.http.SslContextConf;

public final class CmpClientImpl
implements CmpClient {
    private static final Logger LOG = LoggerFactory.getLogger(CmpClientImpl.class);
    private SecurityFactory securityFactory;
    private CmpAgent agent;
    private List<X509Cert> dhpopCerts;
    private String confFile;
    private final AtomicBoolean initialized = new AtomicBoolean(false);

    public void setSecurityFactory(SecurityFactory securityFactory) {
        this.securityFactory = securityFactory;
    }

    public void setConfFile(String confFile) {
        this.confFile = confFile;
    }

    public void init() throws Exception {
        if (this.initialized.get()) {
            return;
        }
        if (this.confFile == null) {
            throw new IllegalStateException("confFile is not set");
        }
        if (this.securityFactory == null) {
            throw new IllegalStateException("securityFactory is not set");
        }
        this.initialized.set(false);
        LOG.info("initializing ...");
        File configFile = new File(IoUtil.expandFilepath((String)this.confFile));
        if (!configFile.exists()) {
            throw new IllegalStateException("could not find configuration file " + this.confFile);
        }
        CmpClientConf conf = CmpClientImpl.parse(configFile);
        SslContextConf sslCc = SslContextConf.ofSslConf((SslConf)conf.getSsl());
        SSLSocketFactory sslSocketFactory = sslCc.getSslSocketFactory();
        HostnameVerifier hostnameVerifier = sslCc.getHostnameVerifier();
        CmpClientConf.Responder responderConf = conf.getResponder();
        String serverUrl = responderConf.getUrl();
        Responder.SignatureCmpResponder signatureResponder = null;
        CmpClientConf.Responder.Signature sigResponderConf = responderConf.getSignature();
        if (sigResponderConf != null) {
            X509Cert cert = X509Util.parseCert((byte[])sigResponderConf.getCert().readContent());
            HashSet<String> algoNames = new HashSet<String>(sigResponderConf.getSignatureAlgos());
            HashSet<SignAlgo> algos = new HashSet<SignAlgo>();
            for (String algoName : algoNames) {
                SignAlgo sa = SignAlgo.getInstance((String)algoName);
                algos.add(sa);
            }
            if (algos.isEmpty()) {
                throw new NoSuchAlgorithmException("none of the signature algorithms " + algoNames + " are supported");
            }
            signatureResponder = new Responder.SignatureCmpResponder(cert, (AlgorithmValidator)new CollectionAlgorithmValidator(algos));
        }
        Responder.PbmMacCmpResponder pbmMacResponder = null;
        CmpClientConf.Responder.PbmMac pbmMacResponderConf = responderConf.getPbmMac();
        if (pbmMacResponderConf != null) {
            pbmMacResponder = new Responder.PbmMacCmpResponder(pbmMacResponderConf.getOwfAlgos(), pbmMacResponderConf.getMacAlgos());
        }
        if (responderConf.getDhPopCerts() != null) {
            this.dhpopCerts = X509Util.parseCerts((byte[])responderConf.getDhPopCerts().readContent());
        }
        this.agent = new CmpAgent(signatureResponder, pbmMacResponder, serverUrl, this.securityFactory, sslSocketFactory, hostnameVerifier, conf.isSendRequestorCert());
        this.initialized.set(true);
        LOG.info("initialized");
    }

    private static CmpClientConf parse(File configFile) throws CmpClientException {
        CmpClientConf conf;
        try {
            conf = (CmpClientConf)((Object)JSON.parseConf((File)configFile, CmpClientConf.class));
            conf.validate();
        }
        catch (IOException | RuntimeException | InvalidConfException ex) {
            throw new CmpClientException("parsing profile failed, message: " + ex.getMessage(), ex);
        }
        return conf;
    }

    @Override
    public void close() {
    }

    @Override
    public EnrollCertResult enrollCert(String caName, Requestor requestor, CertificationRequest csr, String profile, Instant notBefore, Instant notAfter, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        Args.notNull((Object)csr, (String)"csr");
        caName = Args.notBlank((String)caName, (String)"caName").toLowerCase(Locale.ROOT);
        String id = "cert-1";
        CsrEnrollCertRequest request = new CsrEnrollCertRequest("cert-1", profile, csr);
        EnrollCertResponse result = this.agent.requestCertificate(caName, requestor, request, notBefore, notAfter, debug);
        return this.parseEnrollCertResult(result);
    }

    @Override
    public EnrollCertResult enrollCerts(String caName, Requestor requestor, EnrollCertRequest request, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        caName = Args.notBlank((String)caName, (String)"caName").toLowerCase(Locale.ROOT);
        List<EnrollCertRequest.Entry> requestEntries = ((EnrollCertRequest)Args.notNull((Object)request, (String)"request")).getRequestEntries();
        return CollectionUtil.isEmpty(requestEntries) ? null : this.parseEnrollCertResult(this.agent.requestCertificate(caName, requestor, request, debug));
    }

    @Override
    public CertIdOrError revokeCert(String caName, Requestor requestor, X509Cert issuerCert, X509Cert cert, int reason, Instant invalidityDate, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        Args.notNull((Object)cert, (String)"cert");
        CmpClientImpl.assertIssuedByCa(cert, issuerCert);
        return this.revokeCert(caName, requestor, issuerCert, cert.getSerialNumber(), reason, invalidityDate, debug);
    }

    @Override
    public CertIdOrError revokeCert(String caName, Requestor requestor, X509Cert issuerCert, BigInteger serial, int reason, Instant invalidityDate, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        Args.notNull((Object)caName, (String)"caName");
        Args.notNull((Object)serial, (String)"serial");
        String id = "cert-1";
        RevokeCertRequest.Entry entry = new RevokeCertRequest.Entry("cert-1", issuerCert.getSubject(), serial, reason, invalidityDate);
        entry.setAuthorityKeyIdentifier(issuerCert.getSubjectKeyId());
        RevokeCertRequest request = new RevokeCertRequest();
        request.addRequestEntry(entry);
        Map<String, CertIdOrError> result = this.revokeCerts(caName, requestor, request, debug);
        return result == null ? null : result.get("cert-1");
    }

    @Override
    public Map<String, CertIdOrError> revokeCerts(String caName, Requestor requestor, RevokeCertRequest request, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        List<RevokeCertRequest.Entry> requestEntries = ((RevokeCertRequest)Args.notNull((Object)request, (String)"request")).getRequestEntries();
        if (CollectionUtil.isEmpty(requestEntries)) {
            return Collections.emptyMap();
        }
        X500Name issuer = requestEntries.get(0).getIssuer();
        for (int i = 1; i < requestEntries.size(); ++i) {
            if (issuer.equals((Object)requestEntries.get(i).getIssuer())) continue;
            throw new PkiErrorException(2, 32, "revoking certificates issued by more than one CA is not allowed");
        }
        return this.parseRevokeCertResult(this.agent.revokeCertificate(caName, requestor, request, debug));
    }

    private Map<String, CertIdOrError> parseRevokeCertResult(RevokeCertResponse result) throws CmpClientException {
        HashMap<String, CertIdOrError> ret = new HashMap<String, CertIdOrError>();
        for (ResultEntry re : result.getResultEntries()) {
            CertIdOrError certIdOrError;
            if (re instanceof ResultEntry.RevokeCert) {
                certIdOrError = new CertIdOrError(((ResultEntry.RevokeCert)re).getCertId());
            } else if (re instanceof ResultEntry.Error) {
                certIdOrError = new CertIdOrError(((ResultEntry.Error)re).getStatusInfo());
            } else {
                throw new CmpClientException("unknown type " + re.getClass().getName());
            }
            ret.put(re.getId(), certIdOrError);
        }
        return ret;
    }

    @Override
    public X509CRLHolder downloadCrl(String caName, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        return this.agent.downloadCurrentCrl(Args.toNonBlankLower((String)caName, (String)"caName"), debug);
    }

    private static X509Cert getCertificate(CMPCertificate cmpCert) {
        Certificate bcCert = cmpCert.getX509v3PKCert();
        return bcCert == null ? null : new X509Cert(bcCert);
    }

    private static boolean verify(X509Cert caCert, X509Cert cert) {
        if (!cert.getIssuer().equals((Object)caCert.getSubject())) {
            return false;
        }
        boolean inBenchmark = Boolean.getBoolean("org.xipki.benchmark");
        if (inBenchmark) {
            return true;
        }
        PublicKey caPublicKey = caCert.getPublicKey();
        try {
            cert.verify(caPublicKey);
            return true;
        }
        catch (GeneralSecurityException ex) {
            LOG.debug("{} while verifying signature: {}", (Object)ex.getClass().getName(), (Object)ex.getMessage());
            return false;
        }
    }

    @Override
    public CertIdOrError unsuspendCert(String caName, Requestor requestor, X509Cert issuerCert, X509Cert cert, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        CmpClientImpl.assertIssuedByCa((X509Cert)Args.notNull((Object)cert, (String)"cert"), issuerCert);
        return this.unsuspendCert(caName, requestor, issuerCert, cert.getSerialNumber(), debug);
    }

    @Override
    public CertIdOrError unsuspendCert(String caName, Requestor requestor, X509Cert issuerCert, BigInteger serial, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        String id = "cert-1";
        ResultEntry.UnrevokeOrRemoveCert entry = new ResultEntry.UnrevokeOrRemoveCert("cert-1", ((X509Cert)Args.notNull((Object)issuerCert, (String)"issuerCert")).getSubject(), (BigInteger)Args.notNull((Object)serial, (String)"serial"));
        entry.setAuthorityKeyIdentifier(issuerCert.getSubjectKeyId());
        UnrevokeCertRequest request = new UnrevokeCertRequest();
        UnrevokeCertRequest.Entry entry2 = new UnrevokeCertRequest.Entry(entry.getId(), entry.getIssuer(), entry.getSerialNumber());
        entry2.setAuthorityKeyIdentifier(entry.getAuthorityKeyIdentifier());
        request.addRequestEntry(entry2);
        Map<String, CertIdOrError> result = this.unsuspendCerts(caName, requestor, request, debug);
        return result == null ? null : result.get("cert-1");
    }

    @Override
    public Map<String, CertIdOrError> unsuspendCerts(String caName, Requestor requestor, UnrevokeCertRequest request, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        List<UnrevokeCertRequest.Entry> requestEntries = ((UnrevokeCertRequest)Args.notNull((Object)request, (String)"request")).getRequestEntries();
        if (CollectionUtil.isEmpty(requestEntries)) {
            return Collections.emptyMap();
        }
        X500Name issuer = requestEntries.get(0).getIssuer();
        for (int i = 1; i < requestEntries.size(); ++i) {
            if (issuer.equals((Object)requestEntries.get(i).getIssuer())) continue;
            throw new PkiErrorException(2, 32, "unsuspending certificates issued by more than one CA is not allowed");
        }
        return this.parseRevokeCertResult(this.agent.unrevokeCertificate(caName, requestor, request, debug));
    }

    private EnrollCertResult parseEnrollCertResult(EnrollCertResponse result) {
        X509Cert[] x509CertArray;
        X509Cert cert;
        HashMap<String, EnrollCertResult.CertifiedKeyPairOrError> certOrErrors = new HashMap<String, EnrollCertResult.CertifiedKeyPairOrError>();
        for (ResultEntry resultEntry : result.getResultEntries()) {
            Object certOrError;
            if (resultEntry instanceof ResultEntry.EnrollCert) {
                ResultEntry.EnrollCert enrollCert = (ResultEntry.EnrollCert)resultEntry;
                X509Cert cert2 = CmpClientImpl.getCertificate(enrollCert.getCert());
                certOrError = new EnrollCertResult.CertifiedKeyPairOrError(cert2, enrollCert.getPrivateKeyInfo());
            } else {
                certOrError = resultEntry instanceof ResultEntry.Error ? new EnrollCertResult.CertifiedKeyPairOrError(((ResultEntry.Error)resultEntry).getStatusInfo()) : null;
            }
            certOrErrors.put(resultEntry.getId(), (EnrollCertResult.CertifiedKeyPairOrError)certOrError);
        }
        List<CMPCertificate> cmpCaPubs = result.getCaCertificates();
        if (CollectionUtil.isEmpty(cmpCaPubs)) {
            return new EnrollCertResult(null, certOrErrors);
        }
        ArrayList<X509Cert> caPubs = new ArrayList<X509Cert>(cmpCaPubs.size());
        for (CMPCertificate cMPCertificate : cmpCaPubs) {
            caPubs.add(CmpClientImpl.getCertificate(cMPCertificate));
        }
        X509Cert caCert = null;
        for (EnrollCertResult.CertifiedKeyPairOrError certOrError : certOrErrors.values()) {
            cert = certOrError.getCertificate();
            if (cert == null) continue;
            for (X509Cert caPub : caPubs) {
                if (!CmpClientImpl.verify(caPub, cert)) continue;
                caCert = caPub;
                break;
            }
            if (caCert == null) continue;
            break;
        }
        if (caCert == null) {
            return new EnrollCertResult(null, certOrErrors);
        }
        for (EnrollCertResult.CertifiedKeyPairOrError certOrError : certOrErrors.values()) {
            cert = certOrError.getCertificate();
            if (cert == null || CmpClientImpl.verify(caCert, cert)) continue;
            LOG.warn("not all certificates are issued by CA embedded in caPubs, ignore the caPubs");
            return new EnrollCertResult(null, certOrErrors);
        }
        caPubs.remove(caCert);
        if (caPubs.isEmpty()) {
            X509Cert[] x509CertArray2 = new X509Cert[1];
            x509CertArray = x509CertArray2;
            x509CertArray2[0] = caCert;
        } else {
            x509CertArray = X509Util.buildCertPath(caCert, caPubs, (boolean)true);
        }
        X509Cert[] x509CertArray3 = x509CertArray;
        return new EnrollCertResult(x509CertArray3, certOrErrors);
    }

    private static void assertIssuedByCa(X509Cert cert, X509Cert ca) throws CmpClientException {
        boolean issued = X509Util.issues((X509Cert)ca, (X509Cert)cert);
        if (!issued) {
            throw new CmpClientException("the given certificate is not issued by the CA");
        }
    }

    @Override
    public X509Cert caCert(String caName, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        return this.agent.caCerts(caName, 1, debug).get(0);
    }

    @Override
    public List<X509Cert> caCerts(String caName, ReqRespDebug debug) throws CmpClientException, PkiErrorException {
        return this.agent.caCerts(caName, 99, debug);
    }

    @Override
    public List<X509Cert> getDhPopPeerCertificates() {
        return this.dhpopCerts == null ? Collections.emptyList() : Collections.unmodifiableList(this.dhpopCerts);
    }
}

