/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway.cmp;

import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.xipki.ca.gateway.cmp.CmpControlConf;
import org.xipki.ca.sdk.CertsMode;
import org.xipki.security.AlgorithmValidator;
import org.xipki.security.CollectionAlgorithmValidator;
import org.xipki.security.HashAlgo;
import org.xipki.security.SignAlgo;
import org.xipki.util.CollectionUtil;
import org.xipki.util.exception.InvalidConfException;

/*
 * Exception performing whole class analysis ignored.
 */
public class CmpControl {
    private static final int DFLT_MESSAGE_TIME_BIAS = 300;
    private static final int DFLT_CONFIRM_WAIT_TIME = 300;
    private static final int DFLT_PBM_ITERATIONCOUNT = 10240;
    private final boolean confirmCert;
    private final boolean sendCaCert;
    private final boolean sendCertChain;
    private final boolean messageTimeRequired;
    private final boolean sendResponderCert;
    private final int messageTimeBias;
    private final int confirmWaitTime;
    private final int confirmWaitTimeMs;
    private HashAlgo responsePbmOwf;
    private List<HashAlgo> requestPbmOwfs;
    private SignAlgo responsePbmMac;
    private List<SignAlgo> requestPbmMacs;
    private int responsePbmIterationCount;
    private final CollectionAlgorithmValidator sigAlgoValidator;

    public CmpControl(CmpControlConf conf) throws InvalidConfException {
        String algo;
        int i;
        this.confirmCert = CmpControl.getBoolean((Boolean)conf.getConfirmCert(), (boolean)false);
        this.sendCaCert = CmpControl.getBoolean((Boolean)conf.getSendCaCert(), (boolean)false);
        this.sendCertChain = CmpControl.getBoolean((Boolean)conf.getSendCertChain(), (boolean)false);
        this.sendResponderCert = CmpControl.getBoolean((Boolean)conf.getSendResponderCert(), (boolean)true);
        this.messageTimeRequired = CmpControl.getBoolean((Boolean)conf.getMessageTimeRequired(), (boolean)true);
        this.messageTimeBias = CmpControl.getInt((Integer)conf.getMessageTimeBias(), (int)300);
        this.confirmWaitTime = CmpControl.getInt((Integer)conf.getConfirmWaitTime(), (int)300);
        if (this.confirmWaitTime < 0) {
            throw new InvalidConfException("invalid confirmWaitTime " + this.confirmWaitTime);
        }
        this.confirmWaitTimeMs = this.confirmWaitTime * 1000;
        List requestSigAlgos = conf.getRequestSigAlgos();
        if (CollectionUtil.isEmpty((Collection)requestSigAlgos)) {
            throw new InvalidConfException("requestSigAlgos is not set");
        }
        try {
            this.sigAlgoValidator = CollectionAlgorithmValidator.buildAlgorithmValidator((Collection)requestSigAlgos);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new InvalidConfException("invalid signature algorithm", (Throwable)ex);
        }
        try {
            if (conf.getResponsePbmMac() != null) {
                this.responsePbmMac = SignAlgo.getInstance((String)conf.getResponsePbmMac());
            }
            if (conf.getResponsePbmOwf() != null) {
                this.responsePbmOwf = HashAlgo.getInstance((String)conf.getResponsePbmOwf());
            }
        }
        catch (NoSuchAlgorithmException ex) {
            throw new InvalidConfException((Throwable)ex);
        }
        List<String> pbmOwfs = conf.getRequestPbmOwfs();
        List<String> pbmMacs = conf.getRequestPbmMacs();
        Integer pbmIterationCount = conf.getResponsePbmIterationCount();
        if (pbmIterationCount == null) {
            pbmIterationCount = 10240;
        }
        if (pbmIterationCount <= 0) {
            throw new InvalidConfException("invalid pbmIterationCount " + pbmIterationCount);
        }
        this.responsePbmIterationCount = pbmIterationCount;
        if (CollectionUtil.isEmpty((Collection)pbmOwfs)) {
            pbmOwfs = Collections.singletonList("SHA256");
        }
        if (CollectionUtil.isEmpty((Collection)pbmMacs)) {
            pbmMacs = Collections.singletonList("HMACSHA256");
        }
        this.requestPbmOwfs = new ArrayList(pbmOwfs.size());
        ArrayList<String> canonicalizedAlgos = new ArrayList<String>(pbmOwfs.size());
        for (i = 0; i < pbmOwfs.size(); ++i) {
            HashAlgo ha;
            algo = pbmOwfs.get(i);
            try {
                ha = HashAlgo.getInstance((String)algo);
            }
            catch (Exception ex) {
                throw new InvalidConfException("invalid pbmPwf " + algo, (Throwable)ex);
            }
            canonicalizedAlgos.add(ha.getJceName());
            this.requestPbmOwfs.add(ha);
            if (i != 0 || this.responsePbmOwf != null) continue;
            this.responsePbmOwf = ha;
        }
        canonicalizedAlgos.clear();
        this.requestPbmMacs = new ArrayList(pbmMacs.size());
        for (i = 0; i < pbmMacs.size(); ++i) {
            SignAlgo signAlgo;
            algo = pbmMacs.get(i);
            try {
                signAlgo = SignAlgo.getInstance((String)algo);
            }
            catch (NoSuchAlgorithmException ex) {
                throw new InvalidConfException("invalid pbmMac " + algo, (Throwable)ex);
            }
            canonicalizedAlgos.add(signAlgo.getJceName());
            this.requestPbmMacs.add(signAlgo);
            if (i != 0 || this.responsePbmMac != null) continue;
            this.responsePbmMac = signAlgo;
        }
    }

    public CertsMode getCaCertsMode() {
        if (!this.sendCaCert) {
            return CertsMode.NONE;
        }
        return this.sendCertChain ? CertsMode.CHAIN : CertsMode.CERT;
    }

    public boolean isMessageTimeRequired() {
        return this.messageTimeRequired;
    }

    public boolean isConfirmCert() {
        return this.confirmCert;
    }

    public int getMessageTimeBias() {
        return this.messageTimeBias;
    }

    public int getConfirmWaitTime() {
        return this.confirmWaitTime;
    }

    public int getConfirmWaitTimeMs() {
        return this.confirmWaitTimeMs;
    }

    public boolean isSendResponderCert() {
        return this.sendResponderCert;
    }

    public AlgorithmValidator getSigAlgoValidator() {
        return this.sigAlgoValidator;
    }

    public HashAlgo getResponsePbmOwf() {
        return this.responsePbmOwf;
    }

    public SignAlgo getResponsePbmMac() {
        return this.responsePbmMac;
    }

    public int getResponsePbmIterationCount() {
        return this.responsePbmIterationCount;
    }

    public boolean isRequestPbmOwfPermitted(HashAlgo pbmOwf) {
        return this.requestPbmOwfs.contains(pbmOwf);
    }

    public boolean isRequestPbmMacPermitted(SignAlgo pbmMac) {
        return this.requestPbmMacs.contains(pbmMac);
    }

    private static boolean getBoolean(Boolean b, boolean defaultValue) {
        return b == null ? defaultValue : b;
    }

    private static int getInt(Integer i, int defaultValue) {
        return i == null ? defaultValue : i;
    }
}

