/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway.cmp.servlet;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bouncycastle.asn1.cmp.PKIMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.audit.AuditEvent;
import org.xipki.audit.AuditLevel;
import org.xipki.audit.AuditService;
import org.xipki.audit.AuditStatus;
import org.xipki.audit.Audits;
import org.xipki.ca.gateway.GatewayUtil;
import org.xipki.ca.gateway.cmp.CmpResponder;
import org.xipki.ca.gateway.servlet.HttpRespAuditException;
import org.xipki.ca.gateway.servlet.ServletHelper;
import org.xipki.security.X509Cert;
import org.xipki.util.Args;
import org.xipki.util.IoUtil;
import org.xipki.util.LogUtil;

public class HttpCmpServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(HttpCmpServlet.class);
    private static final String CT_REQUEST = "application/pkixcmp";
    private static final String CT_RESPONSE = "application/pkixcmp";
    private boolean logReqResp;
    private CmpResponder responder;

    public void setLogReqResp(boolean logReqResp) {
        this.logReqResp = logReqResp;
    }

    public void setResponder(CmpResponder responder) {
        this.responder = (CmpResponder)Args.notNull((Object)responder, (String)"responder");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        X509Cert clientCert = ServletHelper.getTlsClientCert((HttpServletRequest)req);
        AuditService auditService = Audits.getAuditService();
        AuditEvent event = new AuditEvent(new Date());
        event.setApplicationName("cmp-gw");
        try {
            PKIMessage pkiReq;
            String reqContentType = req.getHeader("Content-Type");
            if (!"application/pkixcmp".equalsIgnoreCase(reqContentType)) {
                String message = "unsupported media type " + reqContentType;
                throw new HttpRespAuditException(415, message, AuditLevel.INFO, AuditStatus.FAILED);
            }
            String caName = null;
            String path = req.getServletPath();
            if (path.length() > 1) {
                caName = path.substring(1).toLowerCase();
            }
            if (caName == null) {
                String message = "no CA is specified";
                LOG.warn(message);
                throw new HttpRespAuditException(404, message, AuditLevel.INFO, AuditStatus.FAILED);
            }
            event.addEventData("ca", (Object)caName);
            byte[] requestBytes = IoUtil.read((InputStream)req.getInputStream());
            try {
                pkiReq = PKIMessage.getInstance((Object)requestBytes);
            }
            catch (Exception ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)"could not parse the request (PKIMessage)");
                throw new HttpRespAuditException(400, "bad request", AuditLevel.INFO, AuditStatus.FAILED);
            }
            Map map = req.getParameterMap();
            HashMap parameters = new HashMap();
            for (Map.Entry entry : map.entrySet()) {
                parameters.put(entry.getKey(), ((String[])entry.getValue())[0]);
            }
            PKIMessage pkiResp = this.responder.processPkiMessage(caName, pkiReq, clientCert, parameters, event);
            byte[] encodedPkiResp = pkiResp.getEncoded();
            ServletHelper.logReqResp((String)"CMP Gateway", (Logger)LOG, (boolean)this.logReqResp, (boolean)true, (HttpServletRequest)req, (byte[])requestBytes, (byte[])encodedPkiResp);
            resp.setContentType("application/pkixcmp");
            resp.setContentLength(encodedPkiResp.length);
            resp.getOutputStream().write(encodedPkiResp);
        }
        catch (Throwable th) {
            String auditMessage;
            AuditLevel auditLevel;
            AuditStatus auditStatus;
            int httpStatus = 500;
            if (th instanceof HttpRespAuditException) {
                HttpRespAuditException hae = (HttpRespAuditException)th;
                httpStatus = hae.getHttpStatus();
                auditStatus = hae.getAuditStatus();
                auditLevel = hae.getAuditLevel();
                auditMessage = hae.getAuditMessage();
            } else {
                auditLevel = AuditLevel.ERROR;
                auditStatus = AuditStatus.FAILED;
                auditMessage = "internal error";
                if (th instanceof EOFException) {
                    LogUtil.warn((Logger)LOG, (Throwable)th, (String)"connection reset by peer");
                } else {
                    LOG.error("Throwable thrown, this should not happen!", th);
                }
            }
            event.setStatus(auditStatus);
            event.setLevel(auditLevel);
            if (auditMessage != null) {
                event.addEventData("message", (Object)auditMessage);
            }
            resp.sendError(httpStatus);
        }
        finally {
            resp.flushBuffer();
            event.finish();
            auditService.logEvent(event);
            GatewayUtil.logAuditEvent((Logger)LOG, (AuditEvent)event);
        }
    }
}

