/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway.cmp.servlet;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.gateway.ProtocolProxyConfWrapper;
import org.xipki.ca.gateway.cmp.CmpControl;
import org.xipki.ca.gateway.cmp.CmpProxyConf;
import org.xipki.ca.gateway.cmp.CmpResponder;
import org.xipki.ca.gateway.cmp.servlet.HttpCmpServlet;
import org.xipki.ca.gateway.conf.ProtocolProxyConf;
import org.xipki.util.IoUtil;
import org.xipki.util.StringUtil;
import org.xipki.util.XipkiBaseDir;
import org.xipki.util.exception.InvalidConfException;
import org.xipki.util.exception.ObjectCreationException;

public class ProtocolServletFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(ProtocolServletFilter.class);
    private static final String DFLT_CFG = "etc/cmp-gateway.json";
    private HttpCmpServlet servlet;
    private ProtocolProxyConfWrapper conf;

    public void init(FilterConfig filterConfig) throws ServletException {
        CmpProxyConf conf0;
        LOG.info("XiPKI CMP Gateway version {}", (Object)StringUtil.getVersion(this.getClass()));
        XipkiBaseDir.init();
        try {
            conf0 = CmpProxyConf.readConfFromFile((String)IoUtil.expandFilepath((String)DFLT_CFG, (boolean)true));
        }
        catch (IOException | InvalidConfException ex) {
            throw new IllegalArgumentException("could not parse configuration file etc/cmp-gateway.json", ex);
        }
        try {
            CmpControl cmpControl = new CmpControl(conf0.getCmp());
            this.conf = new ProtocolProxyConfWrapper((ProtocolProxyConf)conf0);
            CmpResponder responder = new CmpResponder(cmpControl, this.conf.getSdkClient(), this.conf.getSecurities().getSecurityFactory(), this.conf.getSigners(), this.conf.getAuthenticator(), this.conf.getPopControl());
            this.servlet = new HttpCmpServlet();
            this.servlet.setLogReqResp(this.conf.isLogReqResp());
            this.servlet.setResponder(responder);
        }
        catch (NoSuchAlgorithmException | InvalidConfException | ObjectCreationException e) {
            String msg = "error initializing ServletFilter";
            LOG.error(msg, e);
            throw new ServletException(msg);
        }
    }

    public void destroy() {
        if (this.conf != null) {
            this.conf.destroy();
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest & response instanceof HttpServletResponse)) {
            throw new ServletException("Only HTTP request is supported");
        }
        this.servlet.service(request, response);
    }
}

