/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway.cmp;

import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.cmp.CMPCertificate;
import org.bouncycastle.asn1.cmp.CMPObjectIdentifiers;
import org.bouncycastle.asn1.cmp.CertConfirmContent;
import org.bouncycastle.asn1.cmp.CertRepMessage;
import org.bouncycastle.asn1.cmp.CertResponse;
import org.bouncycastle.asn1.cmp.CertStatus;
import org.bouncycastle.asn1.cmp.ErrorMsgContent;
import org.bouncycastle.asn1.cmp.InfoTypeAndValue;
import org.bouncycastle.asn1.cmp.PKIBody;
import org.bouncycastle.asn1.cmp.PKIFailureInfo;
import org.bouncycastle.asn1.cmp.PKIFreeText;
import org.bouncycastle.asn1.cmp.PKIHeader;
import org.bouncycastle.asn1.cmp.PKIHeaderBuilder;
import org.bouncycastle.asn1.cmp.PKIMessage;
import org.bouncycastle.asn1.cmp.PKIStatus;
import org.bouncycastle.asn1.cmp.PKIStatusInfo;
import org.bouncycastle.asn1.cmp.RevDetails;
import org.bouncycastle.asn1.cmp.RevRepContentBuilder;
import org.bouncycastle.asn1.cmp.RevReqContent;
import org.bouncycastle.asn1.crmf.AttributeTypeAndValue;
import org.bouncycastle.asn1.crmf.CertId;
import org.bouncycastle.asn1.crmf.CertReqMessages;
import org.bouncycastle.asn1.crmf.CertReqMsg;
import org.bouncycastle.asn1.crmf.CertTemplate;
import org.bouncycastle.asn1.crmf.Controls;
import org.bouncycastle.asn1.crmf.OptionalValidity;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.crmf.CertificateRequestMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.audit.AuditEvent;
import org.xipki.audit.AuditStatus;
import org.xipki.ca.gateway.CaNameSigners;
import org.xipki.ca.gateway.GatewayUtil;
import org.xipki.ca.gateway.PopControl;
import org.xipki.ca.gateway.Requestor;
import org.xipki.ca.gateway.RequestorAuthenticator;
import org.xipki.ca.gateway.cmp.BaseCmpResponder;
import org.xipki.ca.gateway.cmp.CmpControl;
import org.xipki.ca.sdk.ConfirmCertRequestEntry;
import org.xipki.ca.sdk.ConfirmCertsRequest;
import org.xipki.ca.sdk.EnrollCertRequestEntry;
import org.xipki.ca.sdk.EnrollCertsRequest;
import org.xipki.ca.sdk.EnrollOrPollCertsResponse;
import org.xipki.ca.sdk.EnrollOrPullCertResponseEntry;
import org.xipki.ca.sdk.ErrorEntry;
import org.xipki.ca.sdk.OldCertInfoByIssuerAndSerial;
import org.xipki.ca.sdk.RevokeCertRequestEntry;
import org.xipki.ca.sdk.RevokeCertsRequest;
import org.xipki.ca.sdk.RevokeCertsResponse;
import org.xipki.ca.sdk.SdkClient;
import org.xipki.ca.sdk.SdkErrorResponseException;
import org.xipki.ca.sdk.SingleCertSerialEntry;
import org.xipki.ca.sdk.UnsuspendOrRemoveRequest;
import org.xipki.ca.sdk.X500NameType;
import org.xipki.cmp.CmpUtf8Pairs;
import org.xipki.cmp.CmpUtil;
import org.xipki.security.CrlReason;
import org.xipki.security.SecurityFactory;
import org.xipki.security.util.X509Util;
import org.xipki.util.CollectionUtil;
import org.xipki.util.DateUtil;
import org.xipki.util.Hex;
import org.xipki.util.LogUtil;
import org.xipki.util.exception.InsufficientPermissionException;

/*
 * Exception performing whole class analysis ignored.
 */
public class CmpResponder
extends BaseCmpResponder {
    private static final Logger LOG = LoggerFactory.getLogger(BaseCmpResponder.class);

    public CmpResponder(CmpControl cmpControl, SdkClient sdk, SecurityFactory securityFactory, CaNameSigners signers, RequestorAuthenticator authenticator, PopControl popControl) throws NoSuchAlgorithmException {
        super(cmpControl, sdk, securityFactory, signers, authenticator, popControl);
    }

    private CertRepMessage processCertReqMessages(String caName, String dfltCertprofileName, boolean groupEnroll, PKIMessage request, Requestor requestor, ASN1OctetString tid, CertReqMessages cr, AuditEvent event) throws InsufficientPermissionException, IOException, SdkErrorResponseException {
        int numCertprofileNames;
        CertReqMsg[] certReqMsgs = cr.toCertReqMsgArray();
        int n = certReqMsgs.length;
        String[] certprofileNames = CmpUtil.extractCertProfile((InfoTypeAndValue[])request.getHeader().getGeneralInfo());
        if (certprofileNames == null && dfltCertprofileName != null) {
            certprofileNames = new String[n];
            for (int i = 0; i < n; ++i) {
                certprofileNames[i] = dfltCertprofileName;
            }
        }
        boolean reenroll = request.getBody().getType() == 7;
        int n2 = numCertprofileNames = certprofileNames == null ? 0 : certprofileNames.length;
        if (!(numCertprofileNames == n || reenroll && numCertprofileNames == 0)) {
            CertResponse[] certResps = new CertResponse[n];
            for (int i = 0; i < n; ++i) {
                ASN1Integer certReqId = certReqMsgs[i].getCertReq().getCertReqId();
                String msg = "expected " + n + ", but " + numCertprofileNames + " CertProfile names are specified";
                certResps[i] = new CertResponse(certReqId, CmpResponder.generateRejectionStatus((Integer)0x100000, (String)msg));
            }
            event.setStatus(AuditStatus.FAILED);
            return new CertRepMessage(null, certResps);
        }
        ArrayList<EnrollCertRequestEntry> certTemplateDatas = new ArrayList<EnrollCertRequestEntry>(n);
        HashMap failureResps = new HashMap();
        for (int i = 0; i < n; ++i) {
            CertReqMsg reqMsg = certReqMsgs[i];
            ASN1Integer certReqId = reqMsg.getCertReq().getCertReqId();
            CertificateRequestMessage req = new CertificateRequestMessage(reqMsg);
            CertTemplate certTemp = req.getCertTemplate();
            SubjectPublicKeyInfo publicKey = certTemp.getPublicKey();
            X500Name subject = certTemp.getSubject();
            String certprofileName = certprofileNames == null ? null : certprofileNames[i];
            OptionalValidity validity = certTemp.getValidity();
            Long notBefore = null;
            Long notAfter = null;
            if (validity != null) {
                if (validity.getNotBefore() != null) {
                    notBefore = DateUtil.toEpochSecond((Date)validity.getNotBefore().getDate());
                }
                if (validity.getNotAfter() != null) {
                    notAfter = DateUtil.toEpochSecond((Date)validity.getNotAfter().getDate());
                }
            }
            OldCertInfoByIssuerAndSerial oldCertInfo = null;
            if (reenroll) {
                Controls controls = reqMsg.getCertReq().getControls();
                AttributeTypeAndValue oldCertIdAtv = null;
                if (controls != null) {
                    ASN1Sequence seq;
                    try {
                        seq = ASN1Sequence.getInstance((Object)controls.getEncoded());
                    }
                    catch (IOException ex) {
                        CmpResponder.addErrCertResp(failureResps, (int)i, (ASN1Integer)certReqId, (int)0x40000000, (String)"could not parse the controls");
                        continue;
                    }
                    int seqSize = seq.size();
                    for (int j = 0; j < seqSize; ++j) {
                        AttributeTypeAndValue atv = AttributeTypeAndValue.getInstance((Object)seq.getObjectAt(j));
                        if (!atv.getType().equals((ASN1Primitive)CMPObjectIdentifiers.regCtrl_oldCertID)) continue;
                        oldCertIdAtv = atv;
                        break;
                    }
                }
                if (oldCertIdAtv == null) {
                    CmpResponder.addErrCertResp(failureResps, (int)i, (ASN1Integer)certReqId, (int)0x100000, (String)"no getCtrl oldCertID is specified");
                    continue;
                }
                CertId oldCertId = CertId.getInstance((Object)oldCertIdAtv.getValue());
                if (4 != oldCertId.getIssuer().getTagNo()) {
                    CmpResponder.addErrCertResp(failureResps, (int)i, (ASN1Integer)certReqId, (int)8, (String)"invalid regCtrl oldCertID");
                    continue;
                }
                if (!requestor.isCertprofilePermitted(certprofileName)) {
                    CmpResponder.addErrCertResp(failureResps, (int)i, (ASN1Integer)certReqId, (int)65536, (String)("certprofile " + certprofileName + " is not allowed"));
                    continue;
                }
                if (publicKey != null) {
                    if (!req.hasProofOfPossession()) {
                        CmpResponder.addErrCertResp(failureResps, (int)i, (ASN1Integer)certReqId, (int)16384, (String)"no POP");
                        continue;
                    }
                    if (!this.verifyPop(req, publicKey)) {
                        LOG.warn("could not validate POP for request {}", (Object)certReqId.getValue());
                        CmpResponder.addErrCertResp(failureResps, (int)i, (ASN1Integer)certReqId, (int)16384, (String)"invalid POP");
                        continue;
                    }
                } else {
                    this.checkPermission(requestor, 256);
                }
                oldCertInfo = new OldCertInfoByIssuerAndSerial();
                oldCertInfo.setIssuer(new X500NameType(X500Name.getInstance((Object)oldCertId.getIssuer().getName())));
                oldCertInfo.setSerialNumber(oldCertId.getSerialNumber().getValue());
                oldCertInfo.setReusePublicKey(false);
            }
            EnrollCertRequestEntry template = new EnrollCertRequestEntry();
            template.setNotBefore(notBefore);
            template.setNotAfter(notAfter);
            template.setCertReqId(certReqId.getValue());
            template.setCertprofile(certprofileName);
            try {
                template.extensions(certTemp.getExtensions());
            }
            catch (IOException e) {
                LogUtil.warn((Logger)LOG, (Throwable)e, (String)("could not encode extensions " + certReqId.getValue()));
                CmpResponder.addErrCertResp(failureResps, (int)i, (ASN1Integer)certReqId, (int)0x100000, (String)"invalid extensions");
                continue;
            }
            if (publicKey != null) {
                try {
                    template.setSubjectPublicKey(publicKey.getEncoded());
                }
                catch (IOException e) {
                    LogUtil.warn((Logger)LOG, (Throwable)e, (String)("could not encode extensions " + certReqId.getValue()));
                    CmpResponder.addErrCertResp(failureResps, (int)i, (ASN1Integer)certReqId, (int)0x100000, (String)"invalid public key");
                    continue;
                }
            }
            template.setSubject(new X500NameType(subject));
            if (oldCertInfo != null) {
                template.setOldCertIsn(oldCertInfo);
            }
            certTemplateDatas.add(template);
        }
        if (certTemplateDatas.size() != n) {
            event.setStatus(AuditStatus.FAILED);
            CertResponse[] certResps = new CertResponse[n];
            for (int i = 0; i < n; ++i) {
                certResps[i] = (CertResponse)failureResps.get(i);
                if (certResps[i] != null) continue;
                certResps[i] = new CertResponse(certReqMsgs[i].getCertReq().getCertReqId(), CmpResponder.generateRejectionStatus((Integer)32, (String)"failure in the parallel entries in the same request"));
            }
            return new CertRepMessage(null, certResps);
        }
        boolean cross = request.getBody().getType() == 13;
        return this.enrollCerts(caName, groupEnroll, reenroll, cross, requestor, tid, certTemplateDatas, event);
    }

    private PKIBody processP10cr(String caName, String dfltCertprofileName, Requestor requestor, ASN1OctetString tid, PKIHeader reqHeader, CertificationRequest p10cr, AuditEvent event) throws SdkErrorResponseException {
        PKIStatusInfo statusObj;
        int status;
        CertRepMessage certResp;
        ASN1Integer certReqId = new ASN1Integer(-1L);
        if (!GatewayUtil.verifyCsr((CertificationRequest)p10cr, (SecurityFactory)this.securityFactory, (PopControl)this.popControl)) {
            LOG.warn("could not validate POP for the pkcs#10 requst");
            certResp = CmpResponder.buildErrCertResp((ASN1Integer)certReqId, (int)16384, (String)"invalid POP");
        } else {
            InfoTypeAndValue[] generalInfo = reqHeader.getGeneralInfo();
            CmpUtf8Pairs keyvalues = CmpUtil.extractUtf8Pairs((InfoTypeAndValue[])generalInfo);
            String certprofileName = null;
            String[] list = CmpUtil.extractCertProfile((InfoTypeAndValue[])generalInfo);
            if (list != null && list.length > 0) {
                certprofileName = list[0];
            }
            Long notBefore = null;
            Long notAfter = null;
            if (keyvalues != null) {
                String str = keyvalues.value("notbefore");
                if (str != null) {
                    notBefore = DateUtil.parseUtcTimeyyyyMMddhhmmss((String)str).getEpochSecond();
                }
                if ((str = keyvalues.value("notafter")) != null) {
                    notAfter = DateUtil.parseUtcTimeyyyyMMddhhmmss((String)str).getEpochSecond();
                }
            }
            if (certprofileName == null) {
                certprofileName = dfltCertprofileName;
            }
            if (certprofileName == null) {
                LOG.warn("no certprofile is specified");
                certResp = CmpResponder.buildErrCertResp((ASN1Integer)certReqId, (int)0x100000, (String)"badCertTemplate");
            } else if (!requestor.isCertprofilePermitted(certprofileName = certprofileName.toLowerCase())) {
                String msg = "certprofile " + certprofileName + " is not allowed";
                certResp = CmpResponder.buildErrCertResp((ASN1Integer)certReqId, (int)65536, (String)msg);
            } else {
                EnrollCertRequestEntry certTemplate = new EnrollCertRequestEntry();
                certTemplate.setCertprofile(certprofileName);
                certTemplate.setCertReqId(BigInteger.valueOf(-1L));
                certTemplate.setNotBefore(notBefore);
                certTemplate.setNotAfter(notAfter);
                try {
                    certTemplate.setP10req(p10cr.getEncoded());
                }
                catch (IOException e) {
                    LogUtil.error((Logger)LOG, (Throwable)e);
                    return CmpResponder.buildErrorMsgPkiBody((PKIStatus)PKIStatus.rejection, (int)32, (String)"invalid PKCS#10 request");
                }
                try {
                    certResp = this.enrollCerts(caName, false, false, false, requestor, tid, Collections.singletonList(certTemplate), event);
                }
                catch (IOException e) {
                    LogUtil.error((Logger)LOG, (Throwable)e);
                    return CmpResponder.buildErrorMsgPkiBody((PKIStatus)PKIStatus.rejection, (int)0x40000000, null);
                }
            }
        }
        if ((event.getStatus() == null || event.getStatus() != AuditStatus.FAILED) && (status = (statusObj = certResp.getResponse()[0].getStatus()).getStatus().intValue()) != 0 && status != 1 && status != 3) {
            event.setStatus(AuditStatus.FAILED);
            PKIFreeText statusStr = statusObj.getStatusString();
            if (statusStr != null) {
                event.addEventData("message", (Object)statusStr.getStringAtUTF8(0).getString());
            }
        }
        return new PKIBody(3, (ASN1Encodable)certResp);
    }

    private CertRepMessage enrollCerts(String caName, boolean groupEnroll, boolean reenroll, boolean cross, Requestor requestor, ASN1OctetString tid, List<EnrollCertRequestEntry> templates, AuditEvent event) throws IOException, SdkErrorResponseException {
        EnrollCertsRequest sdkReq = new EnrollCertsRequest();
        sdkReq.setExplicitConfirm(Boolean.valueOf(this.cmpControl.isConfirmCert()));
        sdkReq.setGroupEnroll(Boolean.valueOf(groupEnroll));
        sdkReq.setConfirmWaitTimeMs(Integer.valueOf((int)this.cmpControl.getConfirmWaitTime().toMillis()));
        sdkReq.setCaCertMode(this.cmpControl.getCaCertsMode());
        sdkReq.setTransactionId(Hex.encode((byte[])tid.getOctets()));
        sdkReq.setEntries(templates);
        for (EnrollCertRequestEntry m : templates) {
            X500Name subject;
            event.addEventData("certprofile", (Object)m.getCertprofile());
            if (m.getSubject() != null) {
                subject = m.getSubject().toX500Name();
            } else {
                CertificationRequest csr = CertificationRequest.getInstance((Object)m.getP10req());
                subject = csr.getCertificationRequestInfo().getSubject();
            }
            event.addEventData("req_subject", (Object)("\"" + X509Util.x500NameText((X500Name)subject) + "\""));
        }
        EnrollOrPollCertsResponse resp = cross ? this.sdk.enrollCrossCerts(caName, sdkReq) : (reenroll ? this.sdk.reenrollCerts(caName, sdkReq) : this.sdk.enrollCerts(caName, sdkReq));
        List rentries = resp.getEntries();
        CertResponse[] certResponses = new CertResponse[rentries.size()];
        for (int i = 0; i < rentries.size(); ++i) {
            EnrollOrPullCertResponseEntry respEntry = (EnrollOrPullCertResponseEntry)rentries.get(i);
            ErrorEntry error = respEntry.getError();
            certResponses[i] = error != null ? new CertResponse(new ASN1Integer(respEntry.getId()), CmpResponder.buildPKIStatusInfo((int)error.getCode(), (String)error.getMessage())) : this.postProcessCertInfo(new ASN1Integer(respEntry.getId()), requestor, respEntry.getCert(), respEntry.getPrivateKey());
        }
        CMPCertificate[] caPubs = null;
        List extraCerts = resp.getExtraCerts();
        if (CollectionUtil.isNotEmpty((Collection)extraCerts)) {
            ArrayList<CMPCertificate> certchain = new ArrayList<CMPCertificate>(extraCerts.size());
            for (byte[] m : extraCerts) {
                certchain.add(new CMPCertificate(Certificate.getInstance((Object)m)));
            }
            caPubs = certchain.toArray(new CMPCertificate[0]);
        }
        return new CertRepMessage(caPubs, certResponses);
    }

    private PKIBody unRevokeCertificates(String caName, RevReqContent rr, boolean revoke, AuditEvent event) throws IOException, SdkErrorResponseException {
        List respEntries;
        RevokeCertsResponse resp;
        RevokeCertsRequest req;
        RevDetails[] revContent = rr.toRevDetailsArray();
        ArrayList<RevokeCertRequestEntry> revokeEntries = revoke ? new ArrayList<RevokeCertRequestEntry>(revContent.length) : null;
        ArrayList<BigInteger> unrevokeEntries = revoke ? null : new ArrayList<BigInteger>(revContent.length);
        X500Name issuer = null;
        byte[] aki = null;
        for (RevDetails revDetails : revContent) {
            CertTemplate certDetails = revDetails.getCertDetails();
            X500Name tIssuer = certDetails.getIssuer();
            if (tIssuer == null) {
                return CmpResponder.buildErrorMsgPkiBody((PKIStatus)PKIStatus.rejection, (int)0x100000, (String)"issuer is not present");
            }
            if (issuer == null) {
                issuer = tIssuer;
            } else if (issuer.equals((Object)tIssuer)) {
                return CmpResponder.buildErrorMsgPkiBody((PKIStatus)PKIStatus.rejection, (int)0x100000, (String)"not all issuers are of the same");
            }
            if (certDetails.getSerialNumber() == null) {
                return CmpResponder.buildErrorMsgPkiBody((PKIStatus)PKIStatus.rejection, (int)0x100000, (String)"serialNumber is not present");
            }
            BigInteger serialNumber = certDetails.getSerialNumber().getValue();
            if (certDetails.getSigningAlg() != null || certDetails.getValidity() != null || certDetails.getSubject() != null || certDetails.getPublicKey() != null || certDetails.getIssuerUID() != null || certDetails.getSubjectUID() != null) {
                return CmpResponder.buildErrorMsgPkiBody((PKIStatus)PKIStatus.rejection, (int)0x100000, (String)"only version, issuer and serialNumber in RevDetails.certDetails are allowed, but more is specified");
            }
            if (certDetails.getExtensions() != null) {
                Extension ext;
                Extensions exts = certDetails.getExtensions();
                ASN1ObjectIdentifier[] oids = exts.getCriticalExtensionOIDs();
                if (oids != null) {
                    for (ASN1ObjectIdentifier oid : oids) {
                        if (Extension.authorityKeyIdentifier.equals((ASN1Primitive)oid)) continue;
                        return CmpResponder.buildErrorMsgPkiBody((PKIStatus)PKIStatus.rejection, (int)0x100000, (String)("unknown critical extension " + oid.getId()));
                    }
                }
                if ((ext = exts.getExtension(Extension.authorityKeyIdentifier)) != null) {
                    AuthorityKeyIdentifier tAki = AuthorityKeyIdentifier.getInstance((Object)ext.getParsedValue());
                    if (tAki.getKeyIdentifier() == null) {
                        return CmpResponder.buildErrorMsgPkiBody((PKIStatus)PKIStatus.rejection, (int)0x100000, (String)"issuer's AKI not present");
                    }
                    if (aki == null) {
                        aki = tAki.getKeyIdentifier();
                    } else if (!Arrays.equals(aki, tAki.getKeyIdentifier())) {
                        return CmpResponder.buildErrorMsgPkiBody((PKIStatus)PKIStatus.rejection, (int)0x100000, (String)"not all AKIs are of the same");
                    }
                }
            }
            if (revoke) {
                Instant invalidityDate = null;
                CrlReason reason = null;
                Extensions crlDetails = revDetails.getCrlEntryDetails();
                if (crlDetails != null) {
                    ASN1ObjectIdentifier extId = Extension.reasonCode;
                    ASN1Encodable extValue = crlDetails.getExtensionParsedValue(extId);
                    if (extValue != null) {
                        int reasonCode = ASN1Enumerated.getInstance((Object)extValue).getValue().intValue();
                        reason = CrlReason.forReasonCode((int)reasonCode);
                    }
                    if ((extValue = crlDetails.getExtensionParsedValue(extId = Extension.invalidityDate)) != null) {
                        try {
                            invalidityDate = ASN1GeneralizedTime.getInstance((Object)extValue).getDate().toInstant();
                        }
                        catch (ParseException ex) {
                            return CmpResponder.buildErrorMsgPkiBody((PKIStatus)PKIStatus.rejection, (int)0x100000, (String)"invalid extension InvalidityDate");
                        }
                    }
                }
                if (reason == null) {
                    reason = CrlReason.UNSPECIFIED;
                }
                event.addEventData("reason", (Object)reason);
                RevokeCertRequestEntry entry = new RevokeCertRequestEntry();
                entry.setSerialNumber(serialNumber);
                entry.setReason(reason);
                if (invalidityDate != null) {
                    entry.setInvalidityTime(Long.valueOf(invalidityDate.getEpochSecond()));
                }
                revokeEntries.add(entry);
            } else {
                unrevokeEntries.add(serialNumber);
            }
            event.addEventData("serial", (Object)LogUtil.formatCsn((BigInteger)serialNumber));
        }
        if (revoke) {
            req = new RevokeCertsRequest();
            req.setEntries(revokeEntries);
            req.setIssuer(new X500NameType(issuer));
            req.setAuthorityKeyIdentifier(aki);
            resp = this.sdk.revokeCerts(caName, req);
            respEntries = resp.getEntries();
        } else {
            req = new UnsuspendOrRemoveRequest();
            req.setEntries(unrevokeEntries);
            req.setIssuer(new X500NameType(issuer));
            req.setAuthorityKeyIdentifier(aki);
            resp = this.sdk.unsuspendCerts(caName, (UnsuspendOrRemoveRequest)req);
            respEntries = resp.getEntries();
        }
        GeneralName caGn = new GeneralName(issuer);
        RevRepContentBuilder repContentBuilder = new RevRepContentBuilder();
        for (SingleCertSerialEntry m : respEntries) {
            ErrorEntry error = m.getError();
            PKIStatusInfo status = error == null ? new PKIStatusInfo(PKIStatus.granted) : CmpResponder.buildPKIStatusInfo((int)error.getCode(), (String)error.getMessage());
            repContentBuilder.add(status, new CertId(caGn, m.getSerialNumber()));
        }
        return new PKIBody(12, (ASN1Encodable)repContentBuilder.build());
    }

    protected PKIBody confirmCertificates(String caName, ASN1OctetString transactionId, CertConfirmContent certConf) throws SdkErrorResponseException {
        CertStatus[] certStatuses = certConf.toCertStatusArray();
        LinkedList<ConfirmCertRequestEntry> entries = new LinkedList<ConfirmCertRequestEntry>();
        for (CertStatus certStatus : certStatuses) {
            int status;
            ConfirmCertRequestEntry entry = new ConfirmCertRequestEntry();
            entry.setCertReqId(certStatus.getCertReqId().getValue());
            entry.setCerthash(certStatus.getCertHash().getOctets());
            PKIStatusInfo statusInfo = certStatus.getStatusInfo();
            boolean accept = true;
            if (statusInfo != null && 0 != (status = statusInfo.getStatus().intValue()) && 1 != status) {
                accept = false;
            }
            entry.setAccept(accept);
            entries.add(entry);
        }
        ConfirmCertsRequest sdkReq = new ConfirmCertsRequest();
        sdkReq.setTransactionId(Hex.encode((byte[])transactionId.getOctets()));
        sdkReq.setEntries(entries);
        try {
            this.sdk.confirmCerts(caName, sdkReq);
            return new PKIBody(19, (ASN1Encodable)DERNull.INSTANCE);
        }
        catch (IOException e) {
            return new PKIBody(23, (ASN1Encodable)new ErrorMsgContent(new PKIStatusInfo(PKIStatus.rejection, null, new PKIFailureInfo(0x40000000))));
        }
    }

    protected PKIBody revokePendingCertificates(String caName, ASN1OctetString transactionId) throws SdkErrorResponseException {
        try {
            this.sdk.revokePendingCerts(caName, Hex.encode((byte[])transactionId.getOctets()));
            return new PKIBody(19, (ASN1Encodable)DERNull.INSTANCE);
        }
        catch (IOException e) {
            return new PKIBody(23, (ASN1Encodable)new ErrorMsgContent(new PKIStatusInfo(PKIStatus.rejection, null, new PKIFailureInfo(0x40000000))));
        }
    }

    protected PKIBody cmpEnrollCert(String caName, String dfltCertprofileName, boolean groupEnroll, PKIMessage request, PKIHeaderBuilder respHeader, PKIHeader reqHeader, PKIBody reqBody, Requestor requestor, ASN1OctetString tid, AuditEvent event) throws InsufficientPermissionException, SdkErrorResponseException {
        InfoTypeAndValue tv;
        PKIBody respBody;
        Duration confirmWaitTime;
        block10: {
            if (dfltCertprofileName != null) {
                dfltCertprofileName = dfltCertprofileName.toLowerCase(Locale.ROOT);
            }
            confirmWaitTime = this.cmpControl.getConfirmWaitTime();
            int type = reqBody.getType();
            try {
                CertRepMessage repMessage;
                CertReqMessages cr;
                if (type == 0) {
                    this.checkPermission(requestor, 1);
                    cr = CertReqMessages.getInstance((Object)reqBody.getContent());
                    repMessage = this.processCertReqMessages(caName, dfltCertprofileName, groupEnroll, request, requestor, tid, cr, event);
                    respBody = new PKIBody(1, (ASN1Encodable)repMessage);
                    break block10;
                }
                if (type == 2) {
                    this.checkPermission(requestor, 1);
                    cr = CertReqMessages.getInstance((Object)reqBody.getContent());
                    repMessage = this.processCertReqMessages(caName, dfltCertprofileName, groupEnroll, request, requestor, tid, cr, event);
                    respBody = new PKIBody(3, (ASN1Encodable)repMessage);
                    break block10;
                }
                if (type == 7) {
                    this.checkPermission(requestor, 16);
                    CertReqMessages kur = CertReqMessages.getInstance((Object)reqBody.getContent());
                    repMessage = this.processCertReqMessages(caName, dfltCertprofileName, groupEnroll, request, requestor, tid, kur, event);
                    respBody = new PKIBody(8, (ASN1Encodable)repMessage);
                    break block10;
                }
                if (type == 4) {
                    this.checkPermission(requestor, 1);
                    respBody = this.processP10cr(caName, dfltCertprofileName, requestor, tid, reqHeader, CertificationRequest.getInstance((Object)reqBody.getContent()), event);
                    break block10;
                }
                if (type == 13) {
                    this.checkPermission(requestor, 128);
                    cr = CertReqMessages.getInstance((Object)reqBody.getContent());
                    repMessage = this.processCertReqMessages(caName, dfltCertprofileName, groupEnroll, request, requestor, tid, cr, event);
                    respBody = new PKIBody(14, (ASN1Encodable)repMessage);
                    break block10;
                }
                throw new IllegalStateException("should not reach here");
            }
            catch (IOException e) {
                LogUtil.error((Logger)LOG, (Throwable)e);
                return CmpResponder.buildErrorMsgPkiBody((PKIStatus)PKIStatus.rejection, (int)0x40000000, null);
            }
        }
        if (!this.cmpControl.isConfirmCert() && CmpUtil.isImplicitConfirm((PKIHeader)reqHeader)) {
            tv = CmpUtil.getImplicitConfirmGeneralInfo();
        } else {
            Instant now = Instant.now();
            respHeader.setMessageTime(new ASN1GeneralizedTime(Date.from(now)));
            tv = new InfoTypeAndValue(CMPObjectIdentifiers.it_confirmWaitTime, (ASN1Encodable)new ASN1GeneralizedTime(Date.from((Instant)confirmWaitTime.addTo(now))));
        }
        respHeader.setGeneralInfo(tv);
        return respBody;
    }

    protected PKIBody cmpUnRevokeCertificates(String caName, PKIMessage request, PKIHeaderBuilder respHeader, PKIHeader reqHeader, PKIBody reqBody, Requestor requestor, AuditEvent event) throws SdkErrorResponseException {
        RevDetails[] revContent;
        Integer requiredPermission = null;
        boolean allRevdetailsOfSameType = true;
        RevReqContent rr = RevReqContent.getInstance((Object)reqBody.getContent());
        for (RevDetails revDetails : revContent = rr.toRevDetailsArray()) {
            ASN1ObjectIdentifier extId;
            ASN1Encodable extValue;
            Extensions crlDetails = revDetails.getCrlEntryDetails();
            int reasonCode = CrlReason.UNSPECIFIED.getCode();
            if (crlDetails != null && (extValue = crlDetails.getExtensionParsedValue(extId = Extension.reasonCode)) != null) {
                reasonCode = ASN1Enumerated.getInstance((Object)extValue).getValue().intValue();
            }
            if (reasonCode < 0 || reasonCode > 10 || reasonCode == 7) {
                return CmpResponder.buildErrorMsgPkiBody((PKIStatus)PKIStatus.rejection, (int)32, (String)("invalid CRLReason " + reasonCode));
            }
            if (reasonCode == CrlReason.REMOVE_FROM_CRL.getCode()) {
                if (requiredPermission == null) {
                    event.addEventType("rr_unrevoke");
                    requiredPermission = 4;
                    continue;
                }
                if (requiredPermission == 4) continue;
                allRevdetailsOfSameType = false;
                break;
            }
            if (requiredPermission == null) {
                event.addEventType("rr_revoke");
                requiredPermission = 2;
                continue;
            }
            if (requiredPermission == 2) continue;
            allRevdetailsOfSameType = false;
            break;
        }
        if (!allRevdetailsOfSameType) {
            ErrorMsgContent emc = new ErrorMsgContent(new PKIStatusInfo(PKIStatus.rejection, new PKIFreeText("not all revDetails are of the same type"), new PKIFailureInfo(32)));
            return new PKIBody(23, (ASN1Encodable)emc);
        }
        try {
            this.checkPermission(requestor, requiredPermission.intValue());
        }
        catch (InsufficientPermissionException ex) {
            event.setStatus(AuditStatus.FAILED);
            event.addEventData("message", (Object)"NOT_PERMITTED");
            return CmpResponder.buildErrorMsgPkiBody((PKIStatus)PKIStatus.rejection, (int)65536, null);
        }
        boolean revoke = requiredPermission == 2;
        try {
            return this.unRevokeCertificates(caName, rr, revoke, event);
        }
        catch (IOException e) {
            LogUtil.error((Logger)LOG, (Throwable)e);
            return CmpResponder.buildErrorMsgPkiBody((PKIStatus)PKIStatus.rejection, (int)0x40000000, null);
        }
    }
}

