/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway.cmp;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.KeySpec;
import java.text.ParseException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.cmp.CMPCertificate;
import org.bouncycastle.asn1.cmp.CMPObjectIdentifiers;
import org.bouncycastle.asn1.cmp.CertConfirmContent;
import org.bouncycastle.asn1.cmp.CertOrEncCert;
import org.bouncycastle.asn1.cmp.CertRepMessage;
import org.bouncycastle.asn1.cmp.CertResponse;
import org.bouncycastle.asn1.cmp.CertifiedKeyPair;
import org.bouncycastle.asn1.cmp.ErrorMsgContent;
import org.bouncycastle.asn1.cmp.GenMsgContent;
import org.bouncycastle.asn1.cmp.GenRepContent;
import org.bouncycastle.asn1.cmp.InfoTypeAndValue;
import org.bouncycastle.asn1.cmp.PBMParameter;
import org.bouncycastle.asn1.cmp.PKIBody;
import org.bouncycastle.asn1.cmp.PKIFailureInfo;
import org.bouncycastle.asn1.cmp.PKIFreeText;
import org.bouncycastle.asn1.cmp.PKIHeader;
import org.bouncycastle.asn1.cmp.PKIHeaderBuilder;
import org.bouncycastle.asn1.cmp.PKIMessage;
import org.bouncycastle.asn1.cmp.PKIStatus;
import org.bouncycastle.asn1.cmp.PKIStatusInfo;
import org.bouncycastle.asn1.cms.GCMParameters;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.crmf.DhSigStatic;
import org.bouncycastle.asn1.crmf.EncryptedValue;
import org.bouncycastle.asn1.crmf.POPOSigningKey;
import org.bouncycastle.asn1.crmf.ProofOfPossession;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.EncryptionScheme;
import org.bouncycastle.asn1.pkcs.KeyDerivationFunc;
import org.bouncycastle.asn1.pkcs.PBES2Parameters;
import org.bouncycastle.asn1.pkcs.PBKDF2Params;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.cmp.CMPException;
import org.bouncycastle.cert.cmp.GeneralPKIMessage;
import org.bouncycastle.cert.cmp.ProtectedPKIMessage;
import org.bouncycastle.cert.crmf.CRMFException;
import org.bouncycastle.cert.crmf.CertificateRequestMessage;
import org.bouncycastle.cert.crmf.PKMACBuilder;
import org.bouncycastle.cert.crmf.PKMACValuesCalculator;
import org.bouncycastle.cert.crmf.jcajce.JcePKMACValuesCalculator;
import org.bouncycastle.jcajce.spec.PBKDF2KeySpec;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.PBEMacCalculatorProvider;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.audit.AuditEvent;
import org.xipki.audit.AuditLevel;
import org.xipki.audit.AuditStatus;
import org.xipki.ca.gateway.CaNameSigners;
import org.xipki.ca.gateway.PopControl;
import org.xipki.ca.gateway.Requestor;
import org.xipki.ca.gateway.RequestorAuthenticator;
import org.xipki.ca.gateway.cmp.CmpControl;
import org.xipki.ca.gateway.cmp.CrmfKeyWrapper;
import org.xipki.ca.sdk.ErrorResponse;
import org.xipki.ca.sdk.SdkClient;
import org.xipki.ca.sdk.SdkErrorResponseException;
import org.xipki.cmp.CmpUtil;
import org.xipki.cmp.PkiStatusInfo;
import org.xipki.cmp.ProtectionResult;
import org.xipki.cmp.ProtectionVerificationResult;
import org.xipki.security.AlgorithmValidator;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.DHSigStaticKeyCertPair;
import org.xipki.security.EdECConstants;
import org.xipki.security.HashAlgo;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignAlgo;
import org.xipki.security.X509Cert;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.LogUtil;
import org.xipki.util.PermissionConstants;
import org.xipki.util.StringUtil;
import org.xipki.util.concurrent.ConcurrentBag;
import org.xipki.util.concurrent.ConcurrentBagEntry;
import org.xipki.util.exception.ErrorCode;
import org.xipki.util.exception.InsufficientPermissionException;
import org.xipki.util.exception.OperationException;

public abstract class BaseCmpResponder {
    public static final String HTTP_HEADER_certprofile = "certprofile";
    public static final String HTTP_HEADER_groupenroll = "groupenroll";
    public static final String TYPE_ccr = "ccr";
    public static final String TYPE_certConf = "cert_conf";
    public static final String TYPE_ir = "ir";
    public static final String TYPE_cr = "cr";
    public static final String TYPE_error = "error";
    public static final String TYPE_genm_cacerts = "genm_cacerts";
    public static final String TYPE_genm_current_crl = "genm_current_crl";
    public static final String TYPE_kur = "kur";
    public static final String TYPE_p10cr = "p10cr";
    public static final String TYPE_pkiconf = "pkiconf";
    public static final String TYPE_rr_revoke = "rr_revoke";
    public static final String TYPE_rr_unrevoke = "rr_unrevoke";
    private static final Logger LOG;
    private static final int PVNO_CMP2000 = 2;
    private static final AlgorithmIdentifier prf_hmacWithSHA256;
    private static final ConcurrentBag<ConcurrentBagEntry<Cipher>> aesGcm_ciphers;
    private static final ConcurrentBag<ConcurrentBagEntry<SecretKeyFactory>> pbkdf2_kdfs;
    private static final Map<ErrorCode, Integer> errorCodeToPkiFailureMap;
    private static final boolean aesGcm_ciphers_initialized;
    private static final boolean pbkdf2_kdfs_initialized;
    protected final SecurityFactory securityFactory;
    private final SecureRandom random = new SecureRandom();
    protected final SdkClient sdk;
    protected final CmpControl cmpControl;
    protected final PopControl popControl;
    private final RequestorAuthenticator authenticator;
    private final CaNameSigners signers;
    private final KeyGenerator aesKeyGen;

    protected BaseCmpResponder(CmpControl cmpControl, SdkClient sdk, SecurityFactory securityFactory, CaNameSigners signers, RequestorAuthenticator authenticator, PopControl popControl) throws NoSuchAlgorithmException {
        this.sdk = sdk;
        this.securityFactory = securityFactory;
        this.authenticator = authenticator;
        this.cmpControl = cmpControl;
        this.popControl = popControl;
        this.signers = signers;
        this.aesKeyGen = KeyGenerator.getInstance("AES");
    }

    protected abstract PKIBody cmpEnrollCert(String var1, String var2, boolean var3, PKIMessage var4, PKIHeaderBuilder var5, PKIHeader var6, PKIBody var7, Requestor var8, ASN1OctetString var9, AuditEvent var10) throws InsufficientPermissionException, SdkErrorResponseException;

    protected abstract PKIBody cmpUnRevokeCertificates(String var1, PKIMessage var2, PKIHeaderBuilder var3, PKIHeader var4, PKIBody var5, Requestor var6, AuditEvent var7) throws SdkErrorResponseException;

    protected abstract PKIBody confirmCertificates(String var1, ASN1OctetString var2, CertConfirmContent var3) throws SdkErrorResponseException;

    protected abstract PKIBody revokePendingCertificates(String var1, ASN1OctetString var2) throws SdkErrorResponseException;

    private Requestor.CertRequestor getCertRequestor(X500Name requestorSender, byte[] senderKID, CMPCertificate[] extraCerts) {
        if (extraCerts == null) {
            return null;
        }
        for (CMPCertificate cc : extraCerts) {
            boolean match;
            Certificate c = cc.getX509v3PKCert();
            if (c == null) continue;
            boolean bl = match = requestorSender == null || requestorSender.equals((Object)c.getSubject());
            if (!match) continue;
            X509Cert xc = new X509Cert(c);
            boolean bl2 = match = senderKID == null || Arrays.equals(xc.getSubjectKeyId(), senderKID);
            if (!match) continue;
            return this.getCertRequestor(xc);
        }
        return null;
    }

    private Requestor.SimplePasswordRequestor getPasswordRequestor(byte[] senderKID) {
        return this.authenticator.getSimplePasswordRequestorByKeyId(senderKID);
    }

    private Requestor.CertRequestor getCertRequestor(X509Cert senderCert) {
        return this.authenticator.getCertRequestor(senderCert);
    }

    protected static X500Name getX500Name(GeneralName name) {
        if (name.getTagNo() != 4) {
            return null;
        }
        return (X500Name)name.getName();
    }

    private PKIMessage processPkiMessage0(String caName, PKIMessage request, Requestor requestor, ASN1OctetString tid, GeneralPKIMessage message, Map<String, String> parameters, AuditEvent event) {
        PKIBody respBody;
        event.addEventData("requestor", (Object)(requestor == null ? "null" : requestor.getName()));
        PKIHeader reqHeader = message.getHeader();
        PKIHeaderBuilder respHeader = new PKIHeaderBuilder(reqHeader.getPvno().getValue().intValue(), reqHeader.getRecipient(), reqHeader.getSender());
        respHeader.setTransactionID(tid);
        ASN1OctetString senderNonce = reqHeader.getSenderNonce();
        if (senderNonce != null) {
            respHeader.setRecipNonce(senderNonce);
        }
        PKIBody reqBody = message.getBody();
        int type = reqBody.getType();
        try {
            if (type == 0 || type == 2 || type == 7 || type == 4 || type == 13) {
                String eventType = 2 == type ? TYPE_cr : (0 == type ? TYPE_ir : (7 == type ? TYPE_kur : (4 == type ? TYPE_p10cr : TYPE_ccr)));
                event.addEventType(eventType);
                String dfltCertprofileName = null;
                boolean groupEnroll = false;
                if (parameters != null) {
                    dfltCertprofileName = parameters.get(HTTP_HEADER_certprofile);
                    String str = parameters.get(HTTP_HEADER_groupenroll);
                    groupEnroll = !StringUtil.isBlank((String)str) && Boolean.parseBoolean(str);
                }
                respBody = this.cmpEnrollCert(caName, dfltCertprofileName, groupEnroll, request, respHeader, reqHeader, reqBody, requestor, tid, event);
            } else if (type == 24) {
                event.addEventType(TYPE_certConf);
                CertConfirmContent certConf = (CertConfirmContent)reqBody.getContent();
                respBody = this.confirmCertificates(caName, tid, certConf);
            } else if (type == 11) {
                respBody = this.cmpUnRevokeCertificates(caName, request, respHeader, reqHeader, reqBody, requestor, event);
            } else if (type == 19) {
                event.addEventType(TYPE_pkiconf);
                respBody = new PKIBody(19, (ASN1Encodable)DERNull.INSTANCE);
            } else if (type == 21) {
                respBody = this.cmpGeneralMsg(caName, reqBody, event);
            } else if (type == 23) {
                event.addEventType(TYPE_error);
                respBody = this.revokePendingCertificates(caName, tid);
            } else {
                event.addEventType("PKIBody." + type);
                respBody = BaseCmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 32, "unsupported type " + type);
            }
        }
        catch (InsufficientPermissionException ex) {
            ErrorMsgContent emc = new ErrorMsgContent(new PKIStatusInfo(PKIStatus.rejection, new PKIFreeText(ex.getMessage()), new PKIFailureInfo(65536)));
            respBody = new PKIBody(23, (ASN1Encodable)emc);
        }
        catch (SdkErrorResponseException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex);
            ErrorResponse errResp = ex.getErrorResponse();
            respBody = new PKIBody(23, (ASN1Encodable)new ErrorMsgContent(BaseCmpResponder.buildPKIStatusInfo(errResp.getCode(), errResp.getMessage())));
        }
        if (respBody.getType() == 23) {
            ErrorMsgContent errorMsgContent = (ErrorMsgContent)respBody.getContent();
            PkiStatusInfo pkiStatus = new PkiStatusInfo(errorMsgContent.getPKIStatusInfo());
            event.setStatus(AuditStatus.FAILED);
            String statusString = pkiStatus.statusMessage();
            if (statusString != null) {
                event.addEventData("message", (Object)statusString);
            }
        } else if (event.getStatus() == null) {
            event.setStatus(AuditStatus.SUCCESSFUL);
        }
        return new PKIMessage(respHeader.build(), respBody);
    }

    public PKIMessage processPkiMessage(String caName, PKIMessage pkiMessage, X509Cert tlsClientCert, Map<String, String> parameters, AuditEvent event) {
        Requestor.CertRequestor requestor;
        String errorStatus;
        RDN[] rdns;
        Args.notNull((Object)event, (String)"event");
        GeneralPKIMessage message = new GeneralPKIMessage((PKIMessage)Args.notNull((Object)pkiMessage, (String)"pkiMessage"));
        PKIHeader reqHeader = message.getHeader();
        ASN1OctetString tid = reqHeader.getTransactionID();
        if (tid == null) {
            tid = new DEROctetString(this.randomTransactionId());
        }
        String tidStr = Base64.encodeToString((byte[])tid.getOctets());
        event.addEventData("tid", (Object)tidStr);
        GeneralName respSender = reqHeader.getRecipient();
        int reqPvno = reqHeader.getPvno().getValue().intValue();
        if (reqPvno < 2) {
            event.update(AuditLevel.INFO, AuditStatus.FAILED);
            event.addEventData("message", (Object)("unsupported version " + reqPvno));
            return this.buildErrorPkiMessage(tid, reqHeader, 131072, null, respSender);
        }
        Integer failureCode = null;
        String statusText = null;
        Instant messageTime = null;
        if (reqHeader.getMessageTime() != null) {
            try {
                messageTime = reqHeader.getMessageTime().getDate().toInstant();
            }
            catch (ParseException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)("tid=" + tidStr + ": could not parse messageTime"));
            }
        }
        ConcurrentContentSigner signer = this.signers.getSigner(caName);
        GeneralName recipient = reqHeader.getRecipient();
        X500Name x500Name = BaseCmpResponder.getX500Name(recipient);
        if (x500Name != null && (rdns = x500Name.getRDNs()) != null && rdns.length > 0 && !signer.getCertificate().getSubject().equals((Object)x500Name)) {
            LOG.warn("tid={}: I am not the intended recipient, but '{}'", (Object)tid, (Object)reqHeader.getRecipient());
            failureCode = 32;
            statusText = "I am not the intended recipient";
        }
        if (messageTime == null) {
            if (this.cmpControl.isMessageTimeRequired()) {
                failureCode = 32768;
                statusText = "missing time-stamp";
            }
        } else {
            long currentTime;
            long messageTimeBiasSeconds = this.cmpControl.getMessageTimeBias().getSeconds();
            long msgTime = messageTime.getEpochSecond();
            long bias = msgTime - (currentTime = Instant.now().getEpochSecond());
            if (bias > messageTimeBiasSeconds) {
                failureCode = 16;
                statusText = "message time is in the future";
            } else if (bias * -1L > messageTimeBiasSeconds) {
                failureCode = 16;
                statusText = "message too old";
            }
        }
        if (failureCode != null) {
            event.update(AuditLevel.INFO, AuditStatus.FAILED);
            event.addEventData("message", (Object)statusText);
            return this.buildErrorPkiMessage(tid, reqHeader, failureCode, statusText, respSender);
        }
        boolean isProtected = message.hasProtection();
        if (isProtected) {
            try {
                ProtectionVerificationResult verificationResult = this.verifyProtection(tidStr, message);
                ProtectionResult pr = verificationResult.getProtectionResult();
                switch (pr) {
                    case SIGNATURE_VALID: 
                    case MAC_VALID: {
                        errorStatus = null;
                        break;
                    }
                    case SIGNATURE_INVALID: {
                        errorStatus = "request is protected by signature but invalid";
                        break;
                    }
                    case MAC_INVALID: {
                        errorStatus = "request is protected by MAC but invalid";
                        break;
                    }
                    case SENDER_NOT_AUTHORIZED: {
                        errorStatus = "request is protected but the requestor is not authorized";
                        break;
                    }
                    case SIGNATURE_ALGO_FORBIDDEN: {
                        errorStatus = "request is protected by signature but the algorithm is forbidden";
                        break;
                    }
                    case MAC_ALGO_FORBIDDEN: {
                        errorStatus = "request is protected by MAC but the algorithm is forbidden";
                        break;
                    }
                    default: {
                        throw new IllegalStateException("should not reach here, unknown ProtectionResult " + pr);
                    }
                }
                requestor = (Requestor)verificationResult.getRequestor();
            }
            catch (Exception ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)("tid=" + tidStr + ": could not verify the signature"));
                errorStatus = "request has invalid signature based protection";
                requestor = null;
            }
        } else if (tlsClientCert != null) {
            X500Name x500ReqSender = BaseCmpResponder.getX500Name(reqHeader.getSender());
            Requestor.CertRequestor certRequestor = requestor = x500ReqSender == null ? null : this.getCertRequestor(tlsClientCert);
            if (requestor != null) {
                errorStatus = null;
            } else {
                LOG.warn("tid={}: not authorized requestor (TLS client '{}')", (Object)tid, (Object)tlsClientCert.getSubjectText());
                errorStatus = "requestor (TLS client certificate) is not authorized";
            }
        } else {
            requestor = null;
            int type = message.getBody().getType();
            if (type != 21) {
                LOG.warn("tid={}: nmessage is not protected", (Object)tid);
                errorStatus = "message is not protected";
            } else {
                errorStatus = null;
            }
        }
        if (errorStatus != null) {
            event.update(AuditLevel.INFO, AuditStatus.FAILED);
            event.addEventData("message", (Object)errorStatus);
            return this.buildErrorPkiMessage(tid, reqHeader, 64, errorStatus, respSender);
        }
        PKIMessage resp = this.processPkiMessage0(caName, pkiMessage, (Requestor)requestor, tid, message, parameters, event);
        if (isProtected) {
            resp = this.addProtection(signer, resp, event, (Requestor)requestor);
        }
        return resp;
    }

    private byte[] randomTransactionId() {
        return this.randomBytes(10);
    }

    private byte[] randomSalt() {
        return this.randomBytes(64);
    }

    private byte[] randomBytes(int len) {
        byte[] bytes = new byte[len];
        this.random.nextBytes(bytes);
        return bytes;
    }

    private ProtectionVerificationResult verifyProtection(String tid, GeneralPKIMessage pkiMessage) throws CMPException, InvalidKeyException {
        Requestor.CertRequestor requestor;
        ProtectedPKIMessage protectedMsg = new ProtectedPKIMessage(pkiMessage);
        PKIHeader header = protectedMsg.getHeader();
        byte[] senderKID = header.getSenderKID() == null ? null : header.getSenderKID().getOctets();
        AlgorithmIdentifier protectionAlg = header.getProtectionAlg();
        if (protectedMsg.hasPasswordBasedMacProtection()) {
            SignAlgo macAlg;
            HashAlgo owfAlg;
            PBMParameter parameter = PBMParameter.getInstance((Object)pkiMessage.getHeader().getProtectionAlg().getParameters());
            try {
                owfAlg = HashAlgo.getInstance((AlgorithmIdentifier)parameter.getOwf());
            }
            catch (NoSuchAlgorithmException ex) {
                LogUtil.warn((Logger)LOG, (Throwable)ex);
                return new ProtectionVerificationResult(null, ProtectionResult.MAC_ALGO_FORBIDDEN);
            }
            if (!this.cmpControl.isRequestPbmOwfPermitted(owfAlg)) {
                LOG.warn("MAC_ALGO_FORBIDDEN (PBMParameter.owf: {})", (Object)owfAlg.getJceName());
                return new ProtectionVerificationResult(null, ProtectionResult.MAC_ALGO_FORBIDDEN);
            }
            try {
                macAlg = SignAlgo.getInstance((AlgorithmIdentifier)parameter.getMac());
            }
            catch (NoSuchAlgorithmException ex) {
                LogUtil.warn((Logger)LOG, (Throwable)ex);
                return new ProtectionVerificationResult(null, ProtectionResult.MAC_ALGO_FORBIDDEN);
            }
            if (!this.cmpControl.isRequestPbmMacPermitted(macAlg)) {
                LOG.warn("MAC_ALGO_FORBIDDEN (PBMParameter.mac: {})", (Object)macAlg.getJceName());
                return new ProtectionVerificationResult(null, ProtectionResult.MAC_ALGO_FORBIDDEN);
            }
            int iterationCount = parameter.getIterationCount().getValue().intValue();
            if (iterationCount < 1000) {
                LOG.warn("MAC_ALGO_FORBIDDEN (PBMParameter.iterationCount: {} < 1000)", (Object)iterationCount);
                return new ProtectionVerificationResult(null, ProtectionResult.MAC_ALGO_FORBIDDEN);
            }
            PKMACBuilder pkMacBuilder = new PKMACBuilder((PKMACValuesCalculator)new JcePKMACValuesCalculator());
            Requestor.SimplePasswordRequestor requestor2 = this.getPasswordRequestor(senderKID);
            if (requestor2 == null) {
                LOG.warn("tid={}: not authorized requestor with senderKID '{}", (Object)tid, (Object)(senderKID == null ? "null" : Hex.toHexString((byte[])senderKID)));
                return new ProtectionVerificationResult(null, ProtectionResult.SENDER_NOT_AUTHORIZED);
            }
            boolean macValid = protectedMsg.verify((PBEMacCalculatorProvider)pkMacBuilder, requestor2.getPassword());
            return new ProtectionVerificationResult((Object)requestor2, macValid ? ProtectionResult.MAC_VALID : ProtectionResult.MAC_INVALID);
        }
        if (!this.cmpControl.getSigAlgoValidator().isAlgorithmPermitted(protectionAlg)) {
            LOG.warn("SIG_ALGO_FORBIDDEN: {}", (Object)pkiMessage.getHeader().getProtectionAlg().getAlgorithm().getId());
            return new ProtectionVerificationResult(null, ProtectionResult.SIGNATURE_ALGO_FORBIDDEN);
        }
        X500Name x500Sender = BaseCmpResponder.getX500Name(header.getSender());
        Requestor.CertRequestor certRequestor = requestor = x500Sender == null ? null : this.getCertRequestor(x500Sender, senderKID, pkiMessage.toASN1Structure().getExtraCerts());
        if (requestor == null) {
            LOG.warn("tid={}: not authorized requestor '{}'", (Object)tid, (Object)header.getSender());
            return new ProtectionVerificationResult(null, ProtectionResult.SENDER_NOT_AUTHORIZED);
        }
        ContentVerifierProvider verifierProvider = this.securityFactory.getContentVerifierProvider(requestor.getCert());
        if (verifierProvider == null) {
            LOG.warn("tid={}: not authorized requestor '{}'", (Object)tid, (Object)header.getSender());
            return new ProtectionVerificationResult((Object)requestor, ProtectionResult.SENDER_NOT_AUTHORIZED);
        }
        boolean signatureValid = protectedMsg.verify(verifierProvider);
        return new ProtectionVerificationResult((Object)requestor, signatureValid ? ProtectionResult.SIGNATURE_VALID : ProtectionResult.SIGNATURE_INVALID);
    }

    private PKIMessage addProtection(ConcurrentContentSigner signer, PKIMessage pkiMessage, AuditEvent event, Requestor requestor) {
        GeneralName respSender = pkiMessage.getHeader().getSender();
        try {
            if (requestor instanceof Requestor.CertRequestor) {
                return CmpUtil.addProtection((PKIMessage)pkiMessage, (ConcurrentContentSigner)signer, (GeneralName)respSender, (boolean)this.cmpControl.isSendResponderCert());
            }
            Requestor.SimplePasswordRequestor requestor0 = (Requestor.SimplePasswordRequestor)requestor;
            PBMParameter parameter = new PBMParameter(this.randomSalt(), this.cmpControl.getResponsePbmOwf().getAlgorithmIdentifier(), this.cmpControl.getResponsePbmIterationCount(), this.cmpControl.getResponsePbmMac().getAlgorithmIdentifier());
            return CmpUtil.addProtection((PKIMessage)pkiMessage, (char[])requestor0.getPassword(), (PBMParameter)parameter, (GeneralName)respSender, (byte[])requestor0.getKeyId());
        }
        catch (Exception ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"could not add protection to the PKI message");
            PKIStatusInfo status = BaseCmpResponder.generateRejectionStatus(0x40000000, "could not sign the PKIMessage");
            event.update(AuditLevel.ERROR, AuditStatus.FAILED);
            event.addEventData("message", (Object)"could not sign the PKIMessage");
            return new PKIMessage(pkiMessage.getHeader(), new PKIBody(23, (ASN1Encodable)new ErrorMsgContent(status)));
        }
    }

    private PKIMessage buildErrorPkiMessage(ASN1OctetString tid, PKIHeader requestHeader, int failureCode, String statusText, GeneralName respSender) {
        ASN1OctetString senderNonce;
        GeneralName respRecipient = requestHeader.getSender();
        PKIHeaderBuilder respHeader = new PKIHeaderBuilder(requestHeader.getPvno().getValue().intValue(), respSender, respRecipient);
        respHeader.setMessageTime(new ASN1GeneralizedTime(Date.from(Instant.now())));
        if (tid != null) {
            respHeader.setTransactionID(tid);
        }
        if ((senderNonce = requestHeader.getSenderNonce()) != null) {
            respHeader.setRecipNonce(senderNonce);
        }
        PKIStatusInfo status = BaseCmpResponder.generateRejectionStatus(failureCode, statusText);
        return new PKIMessage(respHeader.build(), new PKIBody(23, (ASN1Encodable)new ErrorMsgContent(status)));
    }

    protected static PKIStatusInfo generateRejectionStatus(Integer info, String errorMessage) {
        return BaseCmpResponder.generateRejectionStatus(PKIStatus.rejection, info, errorMessage);
    }

    protected static PKIStatusInfo generateRejectionStatus(PKIStatus status, Integer info, String errorMessage) {
        PKIFreeText statusMessage = errorMessage == null ? null : new PKIFreeText(errorMessage);
        PKIFailureInfo failureInfo = info == null ? null : new PKIFailureInfo(info.intValue());
        return new PKIStatusInfo(status, statusMessage, failureInfo);
    }

    protected static int getPKiFailureInfo(OperationException ex) {
        Integer failureInfo = errorCodeToPkiFailureMap.get(ex.getErrorCode());
        return failureInfo == null ? 0x40000000 : failureInfo;
    }

    protected void checkPermission(Requestor requestor, int requiredPermission) throws InsufficientPermissionException {
        if (!requestor.isPermitted(requiredPermission)) {
            throw new InsufficientPermissionException("Permission " + PermissionConstants.getTextForCode((int)requiredPermission) + "is not permitted");
        }
    }

    protected static PKIBody buildErrorMsgPkiBody(PKIStatus pkiStatus, int failureInfo, String statusMessage) {
        PKIFreeText pkiStatusMsg = statusMessage == null ? null : new PKIFreeText(statusMessage);
        ErrorMsgContent emc = new ErrorMsgContent(new PKIStatusInfo(pkiStatus, pkiStatusMsg, new PKIFailureInfo(failureInfo)));
        return new PKIBody(23, (ASN1Encodable)emc);
    }

    protected static CertRepMessage buildErrCertResp(ASN1Integer certReqId, int pkiFailureInfo, String pkiStatusText) {
        return new CertRepMessage(null, new CertResponse[]{new CertResponse(certReqId, BaseCmpResponder.generateRejectionStatus(pkiFailureInfo, pkiStatusText))});
    }

    protected static void addErrCertResp(Map<Integer, CertResponse> resps, int index, ASN1Integer certReqId, int pkiFailureInfo, String pkiStatusText) {
        resps.put(index, new CertResponse(certReqId, BaseCmpResponder.generateRejectionStatus(pkiFailureInfo, pkiStatusText)));
    }

    protected boolean verifyPop(CertificateRequestMessage certRequest, SubjectPublicKeyInfo spki) {
        SignAlgo popAlg;
        int popType = certRequest.getProofOfPossessionType();
        if (popType == 0) {
            return false;
        }
        if (popType != 1) {
            LOG.error("unsupported POP type: " + popType);
            return false;
        }
        ProofOfPossession pop = certRequest.toASN1Structure().getPop();
        POPOSigningKey popSign = POPOSigningKey.getInstance((Object)pop.getObject());
        try {
            popAlg = SignAlgo.getInstance((AlgorithmIdentifier)popSign.getAlgorithmIdentifier());
        }
        catch (NoSuchAlgorithmException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"Cannot parse POP signature algorithm");
            return false;
        }
        AlgorithmValidator algoValidator = this.popControl.getPopAlgoValidator();
        if (!algoValidator.isAlgorithmPermitted(popAlg)) {
            LOG.error("POP signature algorithm {} not permitted", (Object)popAlg.getJceName());
            return false;
        }
        try {
            PublicKey publicKey = this.securityFactory.generatePublicKey(spki);
            DHSigStaticKeyCertPair kaKeyAndCert = null;
            if (SignAlgo.DHPOP_X25519 == popAlg || SignAlgo.DHPOP_X448 == popAlg) {
                DhSigStatic dhSigStatic = DhSigStatic.getInstance((Object)popSign.getSignature().getBytes());
                IssuerAndSerialNumber isn = dhSigStatic.getIssuerAndSerial();
                ASN1ObjectIdentifier keyAlgOid = spki.getAlgorithm().getAlgorithm();
                kaKeyAndCert = this.popControl.getDhKeyCertPair(isn.getName(), isn.getSerialNumber().getValue(), EdECConstants.getName((ASN1ObjectIdentifier)keyAlgOid));
                if (kaKeyAndCert == null) {
                    return false;
                }
            }
            ContentVerifierProvider cvp = this.securityFactory.getContentVerifierProvider(publicKey, kaKeyAndCert);
            return certRequest.isValidSigningKeyPOP(cvp);
        }
        catch (IllegalStateException | InvalidKeyException | CRMFException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CertResponse postProcessCertInfo(ASN1Integer certReqId, Requestor requestor, byte[] cert, byte[] privateKeyinfo) {
        EncryptedValue encKey;
        CertOrEncCert cec;
        PKIStatusInfo statusInfo;
        block35: {
            statusInfo = new PKIStatusInfo(PKIStatus.granted);
            cec = new CertOrEncCert(new CMPCertificate(Certificate.getInstance((Object)cert)));
            if (privateKeyinfo == null) {
                return new CertResponse(certReqId, statusInfo, new CertifiedKeyPair(cec), null);
            }
            int aesGcmTagByteLen = 16;
            int aesGcmNonceLen = 12;
            PrivateKeyInfo privKey = PrivateKeyInfo.getInstance((Object)privateKeyinfo);
            AlgorithmIdentifier intendedAlg = privKey.getPrivateKeyAlgorithm();
            try {
                byte[] encValue;
                SecretKey key;
                if (requestor instanceof Requestor.CertRequestor) {
                    byte[] encValue2;
                    byte[] symmKeyBytes;
                    CrmfKeyWrapper wrapper;
                    Requestor.CertRequestor certRequestor = (Requestor.CertRequestor)requestor;
                    PublicKey reqPub = certRequestor.getCert().getPublicKey();
                    if (reqPub instanceof RSAPublicKey) {
                        wrapper = new CrmfKeyWrapper.RSAOAEPAsymmetricKeyWrapper(reqPub);
                    } else if (reqPub instanceof ECPublicKey) {
                        wrapper = new CrmfKeyWrapper.ECIESAsymmetricKeyWrapper(reqPub);
                    } else {
                        String msg = "Requestors's private key can not be used for encryption";
                        LOG.error(msg);
                        return new CertResponse(certReqId, new PKIStatusInfo(PKIStatus.rejection, new PKIFreeText(msg)));
                    }
                    KeyGenerator keyGenerator = this.aesKeyGen;
                    synchronized (keyGenerator) {
                        symmKeyBytes = this.aesKeyGen.generateKey().getEncoded();
                    }
                    byte[] encSymmKey = wrapper.generateWrappedKey(symmKeyBytes);
                    AlgorithmIdentifier keyAlg = wrapper.getAlgorithmIdentifier();
                    ASN1ObjectIdentifier symmAlgOid = NISTObjectIdentifiers.id_aes128_GCM;
                    byte[] nonce = this.randomBytes(12);
                    ConcurrentBagEntry cipher0 = null;
                    if (aesGcm_ciphers_initialized) {
                        try {
                            cipher0 = aesGcm_ciphers.borrow(5L, TimeUnit.SECONDS);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    Cipher dataCipher = cipher0 != null ? (Cipher)cipher0.value() : Cipher.getInstance(symmAlgOid.getId());
                    try {
                        try {
                            dataCipher.init(1, (Key)new SecretKeySpec(symmKeyBytes, "AES"), new GCMParameterSpec(128, nonce));
                        }
                        catch (InvalidAlgorithmParameterException | InvalidKeyException ex) {
                            throw new IllegalStateException(ex);
                        }
                        encValue2 = dataCipher.doFinal(privKey.getEncoded());
                    }
                    finally {
                        if (cipher0 != null) {
                            aesGcm_ciphers.requite(cipher0);
                        }
                    }
                    GCMParameters params = new GCMParameters(nonce, 16);
                    AlgorithmIdentifier symmAlg = new AlgorithmIdentifier(symmAlgOid, (ASN1Encodable)params);
                    encKey = new EncryptedValue(intendedAlg, symmAlg, (ASN1BitString)new DERBitString(encSymmKey), keyAlg, null, (ASN1BitString)new DERBitString(encValue2));
                    break block35;
                }
                Requestor.SimplePasswordRequestor passwordRequestor = (Requestor.SimplePasswordRequestor)requestor;
                ASN1ObjectIdentifier encAlgOid = NISTObjectIdentifiers.id_aes128_GCM;
                int keysizeBits = 128;
                int iterCount = 10240;
                int nonceLen = 12;
                int tagByteLen = 16;
                byte[] nonce = this.randomBytes(12);
                byte[] pbkdfSalt = this.randomBytes(16);
                ConcurrentBagEntry keyFact0 = null;
                if (pbkdf2_kdfs_initialized) {
                    try {
                        keyFact0 = pbkdf2_kdfs.borrow(5L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException dataCipher) {
                        // empty catch block
                    }
                }
                SecretKeyFactory keyFact = keyFact0 != null ? (SecretKeyFactory)keyFact0.value() : SecretKeyFactory.getInstance(PKCSObjectIdentifiers.id_PBKDF2.getId());
                try {
                    key = keyFact.generateSecret((KeySpec)new PBKDF2KeySpec(passwordRequestor.getPassword(), pbkdfSalt, 10240, 128, prf_hmacWithSHA256));
                    key = new SecretKeySpec(key.getEncoded(), "AES");
                }
                finally {
                    if (keyFact0 != null) {
                        pbkdf2_kdfs.requite(keyFact0);
                    }
                }
                GCMParameterSpec gcmParamSpec = new GCMParameterSpec(128, nonce);
                ConcurrentBagEntry cipher0 = null;
                if (aesGcm_ciphers_initialized) {
                    try {
                        cipher0 = aesGcm_ciphers.borrow(5L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                Cipher dataCipher = cipher0 != null ? (Cipher)cipher0.value() : Cipher.getInstance(encAlgOid.getId());
                try {
                    dataCipher.init(1, (Key)key, gcmParamSpec);
                    encValue = dataCipher.doFinal(privKey.getEncoded());
                }
                finally {
                    if (cipher0 != null) {
                        aesGcm_ciphers.requite(cipher0);
                    }
                }
                AlgorithmIdentifier symmAlg = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_PBES2, (ASN1Encodable)new PBES2Parameters(new KeyDerivationFunc(PKCSObjectIdentifiers.id_PBKDF2, (ASN1Encodable)new PBKDF2Params(pbkdfSalt, 10240, 16, prf_hmacWithSHA256)), new EncryptionScheme(encAlgOid, (ASN1Encodable)new GCMParameters(nonce, 16))));
                encKey = new EncryptedValue(intendedAlg, symmAlg, null, null, null, (ASN1BitString)new DERBitString(encValue));
            }
            catch (Throwable th) {
                String msg = "error while encrypting the private key";
                LogUtil.error((Logger)LOG, (Throwable)th, (String)msg);
                return new CertResponse(certReqId, new PKIStatusInfo(PKIStatus.rejection, new PKIFreeText(msg)));
            }
        }
        return new CertResponse(certReqId, statusInfo, new CertifiedKeyPair(cec, encKey, null), null);
    }

    protected PKIBody cmpGeneralMsg(String caName, PKIBody reqBody, AuditEvent event) throws SdkErrorResponseException {
        InfoTypeAndValue itvResp;
        GenMsgContent genMsgBody = GenMsgContent.getInstance((Object)reqBody.getContent());
        InfoTypeAndValue[] itvs = genMsgBody.toInfoTypeAndValueArray();
        InfoTypeAndValue itv = null;
        if (itvs != null) {
            for (InfoTypeAndValue entry : itvs) {
                String itvType = entry.getInfoType().getId();
                if (!CMPObjectIdentifiers.id_it_caCerts.getId().equals(itvType) && !CMPObjectIdentifiers.it_currentCRL.getId().equals(itvType)) continue;
                itv = entry;
                break;
            }
        }
        if (itv == null) {
            String statusMessage = "PKIBody type 21 with given sub-type is not supported";
            return BaseCmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 32, statusMessage);
        }
        ASN1ObjectIdentifier infoType = itv.getInfoType();
        try {
            if (CMPObjectIdentifiers.it_currentCRL.equals((ASN1Primitive)infoType)) {
                event.addEventType(TYPE_genm_current_crl);
                byte[] encodedCrl = this.sdk.currentCrl(caName);
                if (encodedCrl == null) {
                    return BaseCmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 0x40000000, "no CRL is available");
                }
                CertificateList crl = CertificateList.getInstance((Object)encodedCrl);
                itvResp = new InfoTypeAndValue(infoType, (ASN1Encodable)crl);
            } else {
                event.addEventType(TYPE_genm_cacerts);
                byte[][] certchain = this.sdk.cacerts(caName);
                if (certchain == null || certchain.length == 0) {
                    return BaseCmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 0x40000000, "no certchain is available");
                }
                ASN1EncodableVector vec = new ASN1EncodableVector();
                for (byte[] cert : certchain) {
                    vec.add((ASN1Encodable)new CMPCertificate(Certificate.getInstance((Object)cert)));
                }
                itvResp = new InfoTypeAndValue(infoType, (ASN1Encodable)new DERSequence(vec));
            }
        }
        catch (IOException e) {
            LogUtil.error((Logger)LOG, (Throwable)e);
            return new PKIBody(23, (ASN1Encodable)BaseCmpResponder.buildErrorMsgPkiBody(PKIStatus.rejection, 0x40000000, null));
        }
        GenRepContent genRepContent = new GenRepContent(itvResp);
        return new PKIBody(22, (ASN1Encodable)genRepContent);
    }

    static PKIStatusInfo buildPKIStatusInfo(int errorCode, String message) {
        ErrorCode code;
        try {
            code = ErrorCode.ofCode((int)errorCode);
        }
        catch (Exception ex) {
            LOG.warn("unknown error code {}, map it to {}", (Object)errorCode, (Object)ErrorCode.SYSTEM_FAILURE);
            code = ErrorCode.SYSTEM_FAILURE;
        }
        return BaseCmpResponder.buildPKIStatusInfo(code, message);
    }

    static PKIStatusInfo buildPKIStatusInfo(ErrorCode errorCode, String message) {
        int failureInfo;
        PKIFreeText freeText = message == null ? null : new PKIFreeText(message);
        switch (errorCode) {
            case ALREADY_ISSUED: {
                failureInfo = 0x20000000;
                break;
            }
            case BAD_CERT_TEMPLATE: 
            case INVALID_EXTENSION: {
                failureInfo = 0x100000;
                break;
            }
            case BAD_REQUEST: 
            case CERT_UNREVOKED: 
            case UNKNOWN_CERT: 
            case UNKNOWN_CERT_PROFILE: {
                failureInfo = 32;
                break;
            }
            case BAD_POP: {
                failureInfo = 16384;
                break;
            }
            case CERT_REVOKED: {
                failureInfo = 8192;
                break;
            }
            case NOT_PERMITTED: 
            case UNAUTHORIZED: {
                failureInfo = 65536;
                break;
            }
            case SYSTEM_UNAVAILABLE: {
                failureInfo = Integer.MIN_VALUE;
                break;
            }
            default: {
                failureInfo = 0x40000000;
            }
        }
        return new PKIStatusInfo(PKIStatus.rejection, freeText, new PKIFailureInfo(failureInfo));
    }

    static {
        int size;
        LOG = LoggerFactory.getLogger(BaseCmpResponder.class);
        prf_hmacWithSHA256 = SignAlgo.HMAC_SHA256.getAlgorithmIdentifier();
        errorCodeToPkiFailureMap = new HashMap<ErrorCode, Integer>(20);
        String oid = NISTObjectIdentifiers.id_aes128_GCM.getId();
        aesGcm_ciphers = new ConcurrentBag();
        for (int i = 0; i < 64; ++i) {
            Cipher cipher;
            try {
                cipher = Cipher.getInstance(oid);
            }
            catch (NoSuchAlgorithmException | NoSuchPaddingException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)("could not get Cipher of " + oid));
                break;
            }
            aesGcm_ciphers.add(new ConcurrentBagEntry((Object)cipher));
        }
        boolean bl = aesGcm_ciphers_initialized = (size = aesGcm_ciphers.size()) > 0;
        if (size > 0) {
            LOG.info("initialized {} AES GCM Cipher instances", (Object)size);
        } else {
            LOG.error("could not initialize any AES GCM Cipher instance");
        }
        oid = PKCSObjectIdentifiers.id_PBKDF2.getId();
        pbkdf2_kdfs = new ConcurrentBag();
        for (int i = 0; i < 64; ++i) {
            SecretKeyFactory keyFact;
            try {
                keyFact = SecretKeyFactory.getInstance(oid);
            }
            catch (NoSuchAlgorithmException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)("could not get SecretKeyFactory of " + oid));
                break;
            }
            pbkdf2_kdfs.add(new ConcurrentBagEntry((Object)keyFact));
        }
        boolean bl2 = pbkdf2_kdfs_initialized = (size = pbkdf2_kdfs.size()) > 0;
        if (size > 0) {
            LOG.info("initialized {} PBKDF2 SecretKeyFactory instances", (Object)size);
        } else {
            LOG.error("could not initialize any PBKDF2 SecretKeyFactory instance");
        }
        errorCodeToPkiFailureMap.put(ErrorCode.ALREADY_ISSUED, 32);
        errorCodeToPkiFailureMap.put(ErrorCode.BAD_CERT_TEMPLATE, 0x100000);
        errorCodeToPkiFailureMap.put(ErrorCode.BAD_REQUEST, 32);
        errorCodeToPkiFailureMap.put(ErrorCode.CERT_REVOKED, 8192);
        errorCodeToPkiFailureMap.put(ErrorCode.CERT_UNREVOKED, 65536);
        errorCodeToPkiFailureMap.put(ErrorCode.BAD_POP, 16384);
        errorCodeToPkiFailureMap.put(ErrorCode.NOT_PERMITTED, 65536);
        errorCodeToPkiFailureMap.put(ErrorCode.INVALID_EXTENSION, 32);
        errorCodeToPkiFailureMap.put(ErrorCode.SYSTEM_UNAVAILABLE, Integer.MIN_VALUE);
        errorCodeToPkiFailureMap.put(ErrorCode.UNKNOWN_CERT, 8);
        errorCodeToPkiFailureMap.put(ErrorCode.UNKNOWN_CERT_PROFILE, 0x100000);
    }
}

