/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway.cmp.servlet;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.gateway.GatewayUtil;
import org.xipki.ca.gateway.ProtocolProxyConfWrapper;
import org.xipki.ca.gateway.cmp.CmpControl;
import org.xipki.ca.gateway.cmp.CmpProxyConf;
import org.xipki.ca.gateway.cmp.CmpResponder;
import org.xipki.ca.gateway.cmp.servlet.CmpHttpServlet;
import org.xipki.ca.gateway.conf.ProtocolProxyConf;
import org.xipki.util.IoUtil;
import org.xipki.util.XipkiBaseDir;
import org.xipki.util.exception.InvalidConfException;
import org.xipki.util.http.XiHttpFilter;
import org.xipki.util.http.XiHttpRequest;
import org.xipki.util.http.XiHttpResponse;

public class CmpHttpFilter
implements XiHttpFilter {
    private static final Logger LOG = LoggerFactory.getLogger(CmpHttpFilter.class);
    private static final String DFLT_CFG = "etc/cmp-gateway.json";
    private final CmpHttpServlet servlet;
    private ProtocolProxyConfWrapper conf;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmpHttpFilter() throws Exception {
        boolean succ = false;
        try {
            CmpProxyConf conf0;
            XipkiBaseDir.init();
            try {
                conf0 = CmpProxyConf.readConfFromFile(IoUtil.expandFilepath((String)DFLT_CFG, (boolean)true));
            }
            catch (IOException ex) {
                throw new IOException("could not parse configuration file etc/cmp-gateway.json", ex);
            }
            catch (InvalidConfException ex) {
                throw new InvalidConfException("could not parse configuration file etc/cmp-gateway.json", (Throwable)ex);
            }
            CmpControl cmpControl = new CmpControl(conf0.getCmp());
            this.conf = new ProtocolProxyConfWrapper((ProtocolProxyConf)conf0);
            CmpResponder responder = new CmpResponder(cmpControl, this.conf.getSdkClient(), this.conf.getSecurities().getSecurityFactory(), this.conf.getSigners(), this.conf.getAuthenticator(), this.conf.getPopControl());
            this.servlet = new CmpHttpServlet(this.conf.isLogReqResp(), conf0.getReverseProxyMode(), responder);
            succ = true;
        }
        finally {
            GatewayUtil.auditLogPciEvent((Logger)LOG, (String)"CMP-Gateway", (boolean)succ, (String)"START");
        }
    }

    public void destroy() {
        try {
            if (this.conf != null) {
                this.conf.destroy();
                this.conf = null;
            }
            GatewayUtil.auditLogPciEvent((Logger)LOG, (String)"CMP-Gateway", (boolean)true, (String)"SHUTDOWN");
            GatewayUtil.closeAudits((Logger)LOG);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doFilter(XiHttpRequest req, XiHttpResponse resp) throws Exception {
        this.servlet.service(req, resp);
    }
}

