/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway.est.servlet;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.gateway.GatewayUtil;
import org.xipki.ca.gateway.ProtocolProxyConfWrapper;
import org.xipki.ca.gateway.conf.ProtocolProxyConf;
import org.xipki.ca.gateway.est.EstProxyConf;
import org.xipki.ca.gateway.est.EstResponder;
import org.xipki.ca.gateway.est.servlet.EstHttpServlet;
import org.xipki.util.IoUtil;
import org.xipki.util.XipkiBaseDir;
import org.xipki.util.exception.InvalidConfException;
import org.xipki.util.exception.ServletException0;
import org.xipki.util.http.XiHttpFilter;
import org.xipki.util.http.XiHttpRequest;
import org.xipki.util.http.XiHttpResponse;

public class EstHttpFilter
implements XiHttpFilter {
    private static final Logger LOG = LoggerFactory.getLogger(EstHttpFilter.class);
    private static final String DFLT_CFG = "etc/est-gateway.json";
    private final EstHttpServlet servlet;
    private ProtocolProxyConfWrapper conf;

    public EstHttpFilter() throws ServletException0 {
        try {
            EstProxyConf conf0;
            XipkiBaseDir.init();
            try {
                conf0 = EstProxyConf.readConfFromFile(IoUtil.expandFilepath((String)DFLT_CFG, (boolean)true));
            }
            catch (IOException | InvalidConfException ex) {
                throw new IllegalArgumentException("could not parse configuration file etc/est-gateway.json", ex);
            }
            this.conf = new ProtocolProxyConfWrapper((ProtocolProxyConf)conf0);
            EstResponder responder = new EstResponder(this.conf.getSdkClient(), this.conf.getSecurities().getSecurityFactory(), this.conf.getAuthenticator(), this.conf.getPopControl(), this.conf.getCaProfiles());
            this.servlet = new EstHttpServlet();
            this.servlet.setLogReqResp(this.conf.isLogReqResp());
            this.servlet.setResponder(responder);
            GatewayUtil.auditLogPciEvent((Logger)LOG, (String)"EST-Gateway", (boolean)true, (String)"START");
        }
        catch (Exception e) {
            String msg = "error initializing ServletFilter";
            LOG.error(msg, (Throwable)e);
            GatewayUtil.auditLogPciEvent((Logger)LOG, (String)"EST-Gateway", (boolean)false, (String)"START");
            throw new ServletException0(msg);
        }
    }

    public void destroy() {
        try {
            if (this.conf != null) {
                this.conf.destroy();
                this.conf = null;
            }
            GatewayUtil.auditLogPciEvent((Logger)LOG, (String)"EST-Gateway", (boolean)true, (String)"SHUTDOWN");
            GatewayUtil.closeAudits((Logger)LOG);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doFilter(XiHttpRequest req, XiHttpResponse resp) throws IOException {
        this.servlet.service(req, resp);
    }
}

