/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway;

import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.crmf.DhSigStatic;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.slf4j.Logger;
import org.xipki.audit.AuditEvent;
import org.xipki.audit.AuditStatus;
import org.xipki.ca.gateway.PopControl;
import org.xipki.security.AlgorithmValidator;
import org.xipki.security.DHSigStaticKeyCertPair;
import org.xipki.security.EdECConstants;
import org.xipki.security.ObjectIdentifiers;
import org.xipki.security.SecurityFactory;
import org.xipki.util.Args;

public class GatewayUtil {
    public static void logAuditEvent(Logger log, AuditEvent event) {
        if (event == null) {
            return;
        }
        if (event.getStatus() == AuditStatus.FAILED) {
            if (log.isWarnEnabled()) {
                log.warn(event.toTextMessage());
            }
        } else if (log.isInfoEnabled()) {
            log.info(event.toTextMessage());
        }
    }

    public static boolean verifyCsr(CertificationRequest csr, SecurityFactory securityFactory, PopControl popControl) {
        Args.notNull((Object)csr, (String)"csr");
        Args.notNull((Object)popControl, (String)"popControl");
        ASN1ObjectIdentifier algOid = csr.getSignatureAlgorithm().getAlgorithm();
        DHSigStaticKeyCertPair kaKeyAndCert = null;
        if (ObjectIdentifiers.Xipki.id_alg_dhPop_x25519.equals((ASN1Primitive)algOid) || ObjectIdentifiers.Xipki.id_alg_dhPop_x448.equals((ASN1Primitive)algOid)) {
            DhSigStatic dhSigStatic = DhSigStatic.getInstance((Object)csr.getSignature().getBytes());
            IssuerAndSerialNumber isn = dhSigStatic.getIssuerAndSerial();
            ASN1ObjectIdentifier keyOid = csr.getCertificationRequestInfo().getSubjectPublicKeyInfo().getAlgorithm().getAlgorithm();
            kaKeyAndCert = popControl.getDhKeyCertPair(isn.getName(), isn.getSerialNumber().getValue(), EdECConstants.getName((ASN1ObjectIdentifier)keyOid));
            if (kaKeyAndCert == null) {
                return false;
            }
        }
        AlgorithmValidator popValidator = popControl.getPopAlgoValidator();
        return securityFactory.verifyPop(csr, popValidator, kaKeyAndCert);
    }
}

