/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway;

import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.xipki.util.Base64;
import org.xipki.util.CollectionUtil;

public class RestResponse {
    private final int statusCode;
    private final String contentType;
    private final Map<String, String> headers;
    private boolean base64;
    private final byte[] body;

    public RestResponse(int statusCode) {
        this(statusCode, null, null, false, null);
    }

    public RestResponse(int statusCode, String contentType, Map<String, String> headers, byte[] body) {
        this(statusCode, contentType, headers, false, body);
    }

    public RestResponse(int statusCode, String contentType, Map<String, String> headers, boolean base64, byte[] body) {
        this.statusCode = statusCode;
        this.base64 = base64;
        this.contentType = contentType;
        this.headers = headers;
        this.body = body;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public byte[] getBody() {
        return this.body;
    }

    public void fillResponse(HttpServletResponse resp) throws IOException {
        resp.setStatus(this.statusCode);
        if (this.contentType != null) {
            resp.setContentType(this.contentType);
        }
        if (CollectionUtil.isNotEmpty(this.headers)) {
            for (Map.Entry<String, String> m : this.headers.entrySet()) {
                resp.setHeader(m.getKey(), m.getValue());
            }
        }
        if (this.body == null) {
            resp.setContentLength(0);
        } else {
            byte[] content;
            if (this.base64) {
                resp.setHeader("Content-Transfer-Encoding", "base64");
                content = Base64.encodeToByte((byte[])this.body, (boolean)true);
            } else {
                content = this.body;
            }
            resp.setContentLength(content.length);
            resp.getOutputStream().write(content);
        }
    }
}

