/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway.servlet;

import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.security.X509Cert;
import org.xipki.security.util.X509Util;
import org.xipki.util.LogUtil;
import org.xipki.util.LruCache;
import org.xipki.util.StringUtil;

public class ServletHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ServletHelper.class);
    private static final LruCache<String, X509Cert> clientCerts = new LruCache(50);
    private static final LruCache<Reference, X509Cert> clientCerts0 = new LruCache(50);
    private static final String reverseProxyMode;

    public static X509Cert getTlsClientCert(HttpServletRequest request) throws IOException {
        if (reverseProxyMode == null) {
            X509Certificate[] certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
            if (certs == null || certs.length < 1) {
                return null;
            }
            X509Certificate cert0 = certs[0];
            Reference ref = new Reference(cert0);
            X509Cert cert = (X509Cert)clientCerts0.get((Object)ref);
            if (cert == null) {
                cert = new X509Cert(cert0);
                clientCerts0.put((Object)ref, (Object)cert);
            }
            return cert;
        }
        if ("APACHE".equals(reverseProxyMode)) {
            String clientVerify = request.getHeader("SSL_CLIENT_VERIFY");
            LOG.debug("SSL_CLIENT_VERIFY: '{}'", (Object)clientVerify);
            if (StringUtil.isBlank((String)clientVerify)) {
                return null;
            }
            if (!"SUCCESS".equalsIgnoreCase(clientVerify.trim())) {
                return null;
            }
            String pemClientCert = request.getHeader("SSL_CLIENT_CERT");
            if (pemClientCert == null || pemClientCert.length() < 100) {
                LOG.error("SSL_CLIENT_CERT: '{}'", (Object)pemClientCert);
                return null;
            }
            X509Cert clientCert = (X509Cert)clientCerts.get((Object)pemClientCert);
            if (clientCert != null) {
                return clientCert;
            }
            try {
                clientCert = X509Util.parseCert((byte[])StringUtil.toUtf8Bytes((String)pemClientCert));
            }
            catch (CertificateException ex) {
                LOG.error("SSL_CLIENT_CERT: '{}'", (Object)pemClientCert);
                throw new IOException("could not parse Certificate", ex);
            }
            clientCerts.put((Object)pemClientCert, (Object)clientCert);
            return clientCert;
        }
        throw new IllegalStateException("unknown reverseProxyMode " + reverseProxyMode);
    }

    public static void logReqResp(String prefix, Logger log, boolean logReqResp, boolean viaPost, HttpServletRequest req, byte[] requestBytes, byte[] respBody) {
        if (logReqResp && log.isDebugEnabled()) {
            String requestURI = req.getRequestURI();
            if (viaPost) {
                log.debug("{} HTTP POST path: {}\nRequest:\n{}\nResponse:\n{}", new Object[]{prefix, requestURI, LogUtil.base64Encode((byte[])requestBytes), LogUtil.base64Encode((byte[])respBody)});
            } else {
                log.debug("{} HTTP GET path: {}\nResponse:\n{}", new Object[]{prefix, requestURI, LogUtil.base64Encode((byte[])respBody)});
            }
        }
    }

    static {
        String propName = "org.xipki.reverseproxy.mode";
        String mode = System.getProperty(propName);
        if (mode != null && !mode.trim().isEmpty()) {
            mode = mode.trim().toUpperCase();
        }
        if (mode == null || "NO".equals(mode)) {
            reverseProxyMode = null;
        } else if ("APACHE".equals(mode)) {
            reverseProxyMode = "APACHE";
        } else {
            LOG.error("invalid value of property {}: {} is not one of [NO, APACHE]", (Object)propName, (Object)mode);
            reverseProxyMode = null;
        }
        LOG.info("set reverseProxyMode to {}", (Object)reverseProxyMode);
    }

    private static class Reference {
        private final Object obj;

        Reference(Object obj) {
            this.obj = obj;
        }

        public int hashCode() {
            return this.obj.hashCode();
        }

        public boolean equals(Object another) {
            if (another instanceof Reference) {
                return this.obj == ((Reference)another).obj;
            }
            return false;
        }
    }
}

