/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.crmf.DhSigStatic;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.slf4j.Logger;
import org.xipki.audit.AuditEvent;
import org.xipki.audit.AuditLevel;
import org.xipki.audit.AuditStatus;
import org.xipki.audit.Audits;
import org.xipki.audit.PciAuditEvent;
import org.xipki.ca.gateway.PopControl;
import org.xipki.pki.ErrorCode;
import org.xipki.pki.OperationException;
import org.xipki.security.AlgorithmValidator;
import org.xipki.security.DHSigStaticKeyCertPair;
import org.xipki.security.EdECConstants;
import org.xipki.security.ObjectIdentifiers;
import org.xipki.security.SecurityFactory;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.LogUtil;

public class GatewayUtil {
    public static void logAuditEvent(Logger log, AuditEvent event) {
        if (event == null) {
            return;
        }
        if (event.getStatus() == AuditStatus.FAILED) {
            if (log.isWarnEnabled()) {
                log.warn(event.toTextMessage());
            }
        } else if (log.isInfoEnabled()) {
            log.info(event.toTextMessage());
        }
    }

    public static void logAuditEvent(Logger log, PciAuditEvent event) {
        if (event == null) {
            return;
        }
        if (event.getLevel() == AuditLevel.WARN) {
            if (log.isWarnEnabled()) {
                log.warn(event.toTextMessage());
            }
        } else if (log.isInfoEnabled()) {
            log.info(event.toTextMessage());
        }
    }

    public static boolean verifyCsr(CertificationRequest csr, SecurityFactory securityFactory, PopControl popControl) {
        Args.notNull((Object)popControl, (String)"popControl");
        ASN1ObjectIdentifier algOid = ((CertificationRequest)Args.notNull((Object)csr, (String)"csr")).getSignatureAlgorithm().getAlgorithm();
        DHSigStaticKeyCertPair kaKeyAndCert = null;
        if (ObjectIdentifiers.Xipki.id_alg_dhPop_x25519.equals((ASN1Primitive)algOid) || ObjectIdentifiers.Xipki.id_alg_dhPop_x448.equals((ASN1Primitive)algOid)) {
            DhSigStatic dhSigStatic = DhSigStatic.getInstance((Object)csr.getSignature().getBytes());
            IssuerAndSerialNumber isn = dhSigStatic.getIssuerAndSerial();
            ASN1ObjectIdentifier keyOid = csr.getCertificationRequestInfo().getSubjectPublicKeyInfo().getAlgorithm().getAlgorithm();
            kaKeyAndCert = popControl.getDhKeyCertPair(isn.getName(), isn.getSerialNumber().getValue(), EdECConstants.getName((ASN1ObjectIdentifier)keyOid));
            if (kaKeyAndCert == null) {
                return false;
            }
        }
        AlgorithmValidator popValidator = popControl.getPopAlgoValidator();
        return securityFactory.verifyPop(csr, popValidator, kaKeyAndCert);
    }

    public static void auditLogPciEvent(Logger log, String type, boolean successful, String eventType) {
        PciAuditEvent event = PciAuditEvent.newPciAuditEvent((String)type, (String)eventType, (String)"CORE", (AuditStatus)(successful ? AuditStatus.SUCCESSFUL : AuditStatus.FAILED), (AuditLevel)(successful ? AuditLevel.INFO : AuditLevel.ERROR));
        Audits.getAuditService().logEvent(event);
        GatewayUtil.logAuditEvent(log, event);
    }

    public static void closeAudits(Logger log) {
        if (Audits.getAuditService() != null) {
            try {
                Audits.getAuditService().close();
            }
            catch (Exception ex) {
                LogUtil.error((Logger)log, (Throwable)ex);
            }
        }
    }

    public static CertificationRequest parseCsrInRequest(byte[] csrBytes) throws OperationException {
        try {
            return CertificationRequest.getInstance((Object)X509Util.toDerEncoded((byte[])((byte[])Args.notNull((Object)csrBytes, (String)"csrBytes"))));
        }
        catch (Exception ex) {
            throw new OperationException(ErrorCode.BAD_REQUEST, "invalid CSR: " + ex.getMessage());
        }
    }

    public static CertificationRequest parseCsrInRequest(ASN1Encodable p10Asn1) throws OperationException {
        try {
            return CertificationRequest.getInstance((Object)p10Asn1);
        }
        catch (Exception ex) {
            throw new OperationException(ErrorCode.BAD_REQUEST, "invalid CSR: " + ex.getMessage());
        }
    }
}

