/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway.conf;

import java.util.HashSet;
import org.xipki.ca.gateway.conf.CaProfileConf;
import org.xipki.util.exception.InvalidConfException;

public class CaProfilesControl {
    private final CaProfileConf[] caProfiles;

    public CaProfilesControl(CaProfileConf[] caProfiles) {
        if (caProfiles == null) {
            this.caProfiles = new CaProfileConf[0];
        } else {
            for (CaProfileConf conf : caProfiles) {
                if (conf != null) continue;
                throw new IllegalArgumentException("caProfiles must not contain null element");
            }
            this.caProfiles = caProfiles;
        }
    }

    public CaProfileConf getCaProfile(String name) {
        for (CaProfileConf conf : this.caProfiles) {
            if (!conf.getName().equalsIgnoreCase(name)) continue;
            return conf;
        }
        return null;
    }

    public void validate() throws InvalidConfException {
        HashSet<String> names = new HashSet<String>();
        for (CaProfileConf entry : this.caProfiles) {
            String name = entry.getName();
            CaProfilesControl.checkName(name, "caProfile name");
            if (names.contains(name)) {
                throw new InvalidConfException("caProfile " + name + " duplicated");
            }
            names.add(name);
            entry.validate();
        }
    }

    private static void checkName(String param, String paramName) throws InvalidConfException {
        if (param == null || param.isEmpty()) {
            throw new InvalidConfException(paramName + " must not be blank");
        }
        for (int i = 0; i < param.length(); ++i) {
            char c = param.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '-' || c == '_' || c == '.') continue;
            throw new InvalidConfException("invalid char '" + c + "' in " + paramName);
        }
    }
}

