/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway.rest;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.audit.AuditEvent;
import org.xipki.audit.AuditLevel;
import org.xipki.audit.AuditStatus;
import org.xipki.ca.gateway.GatewayUtil;
import org.xipki.ca.gateway.PopControl;
import org.xipki.ca.gateway.Requestor;
import org.xipki.ca.gateway.RequestorAuthenticator;
import org.xipki.ca.gateway.RestResponse;
import org.xipki.ca.gateway.rest.RestResponder;
import org.xipki.ca.sdk.CertsMode;
import org.xipki.ca.sdk.EnrollCertRequestEntry;
import org.xipki.ca.sdk.EnrollCertsRequest;
import org.xipki.ca.sdk.EnrollOrPollCertsResponse;
import org.xipki.ca.sdk.EnrollOrPullCertResponseEntry;
import org.xipki.ca.sdk.RevokeCertRequestEntry;
import org.xipki.ca.sdk.RevokeCertsRequest;
import org.xipki.ca.sdk.SdkClient;
import org.xipki.ca.sdk.SdkErrorResponseException;
import org.xipki.ca.sdk.UnsuspendOrRemoveRequest;
import org.xipki.ca.sdk.X500NameType;
import org.xipki.security.CrlReason;
import org.xipki.security.SecurityFactory;
import org.xipki.security.X509Cert;
import org.xipki.security.XiSecurityException;
import org.xipki.security.util.HttpRequestMetadataRetriever;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.CollectionUtil;
import org.xipki.util.DateUtil;
import org.xipki.util.Hex;
import org.xipki.util.LogUtil;
import org.xipki.util.PemEncoder;
import org.xipki.util.StringUtil;
import org.xipki.util.exception.ErrorCode;
import org.xipki.util.exception.OperationException;
import org.xipki.util.http.HttpRespContent;

/*
 * Exception performing whole class analysis ignored.
 */
public class RestResponder {
    final byte[] NEWLINE = new byte[]{13, 10};
    private static final int OK = 200;
    private static final int BAD_REQUEST = 400;
    private static final int UNAUTHORIZED = 401;
    private static final int NOT_FOUND = 404;
    private static final int CONFLICT = 409;
    private static final int UNSUPPORTED_MEDIA_TYPE = 415;
    private static final int INTERNAL_SERVER_ERROR = 500;
    private static final int SERVICE_UNAVAILABLE = 503;
    private static final String CT_pkcs10 = "application/pkcs10";
    private static final String CT_pkix_crl = "application/pkix-crl";
    private static final String CT_pkix_cert = "application/pkix-cert";
    private static final String CT_pem_file = "application/x-pem-file";
    private static final String HEADER_PKISTATUS = "X-xipki-pkistatus";
    private static final String PKISTATUS_accepted = "accepted";
    private static final String PKISTATUS_rejection = "rejection";
    private static final String HEADER_failInfo = "X-xipki-fail-info";
    private static final String FAILINFO_badRequest = "badRequest";
    private static final String FAILINFO_badCertId = "badCertId";
    private static final String FAILINFO_badPOP = "badPOP";
    private static final String FAILINFO_certRevoked = "certRevoked";
    private static final String FAILINFO_badCertTemplate = "badCertTemplate";
    private static final String FAILINFO_notAuthorized = "notAuthorized";
    private static final String FAILINFO_systemUnavail = "systemUnavail";
    private static final String FAILINFO_systemFailure = "systemFailure";
    private static final String CMD_cacert = "cacert";
    private static final String CMD_cacerts = "cacerts";
    private static final String CMD_revoke_cert = "revoke-cert";
    private static final String CMD_unsuspend_cert = "unsuspend-cert";
    @Deprecated
    private static final String CMD_unrevoke_cert = "unrevoke-cert";
    private static final String CMD_enroll_cert = "enroll-cert";
    private static final String CMD_enroll_cross_cert = "enroll-cross-cert";
    private static final String CMD_enroll_serverkeygen = "enroll-serverkeygen";
    private static final String CMD_enroll_cert_twin = "enroll-cert-twin";
    private static final String CMD_enroll_serverkeygen_twin = "enroll-serverkeygen-twin";
    private static final String CMD_crl = "crl";
    private static final String PARAM_profile = "profile";
    private static final String PARAM_reason = "reason";
    private static final String PARAM_not_before = "not-before";
    private static final String PARAM_not_after = "not-after";
    private static final String PARAM_invalidity_time = "invalidity-time";
    private static final String PARAM_crl_number = "crl-number";
    private static final String PARAM_ca_sha1 = "ca-sha1";
    private static final String PARAM_serial_number = "serial-number";
    private static final Logger LOG = LoggerFactory.getLogger(RestResponder.class);
    private final SdkClient sdk;
    private final SecurityFactory securityFactory;
    private final PopControl popControl;
    private final RequestorAuthenticator authenticator;
    private static final Set<String> knownCommands = CollectionUtil.asUnmodifiableSet((Object[])new String[]{"cacert", "cacerts", "revoke-cert", "unsuspend-cert", "unrevoke-cert", "enroll-cert", "enroll-cross-cert", "enroll-serverkeygen", "enroll-cert-twin", "enroll-serverkeygen-twin", "crl"});

    public RestResponder(SdkClient sdk, SecurityFactory securityFactory, RequestorAuthenticator authenticator, PopControl popControl) {
        this.sdk = (SdkClient)Args.notNull((Object)sdk, (String)"sdk");
        this.securityFactory = (SecurityFactory)Args.notNull((Object)securityFactory, (String)"securityFactory");
        this.authenticator = (RequestorAuthenticator)Args.notNull((Object)authenticator, (String)"authenticator");
        this.popControl = (PopControl)Args.notNull((Object)popControl, (String)"popControl");
    }

    private Requestor getRequestor(String user) {
        return this.authenticator.getPasswordRequestorByUser(user);
    }

    private Requestor getRequestor(X509Cert cert) {
        return this.authenticator.getCertRequestor(cert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RestResponse service(String path, byte[] request, HttpRequestMetadataRetriever httpRetriever, AuditEvent event) {
        RestResponse restResponse;
        AuditLevel auditLevel = AuditLevel.INFO;
        AuditStatus auditStatus = AuditStatus.SUCCESSFUL;
        String auditMessage = null;
        try {
            HttpRespContent respContent;
            Requestor requestor;
            Object certsBytes;
            String message;
            String caName = null;
            String command = null;
            if (path.length() > 1) {
                String coreUri = path;
                int sepIndex = coreUri.indexOf(47, 1);
                if (sepIndex == -1 || sepIndex == coreUri.length() - 1) {
                    String message2 = "invalid path " + path;
                    LOG.error(message2);
                    throw new HttpRespAuditException(404, message2, AuditLevel.ERROR, AuditStatus.FAILED);
                }
                caName = coreUri.substring(1, sepIndex).toLowerCase();
                command = coreUri.substring(sepIndex + 1).toLowerCase();
            }
            if (StringUtil.isBlank(command)) {
                message = "command is not specified";
                LOG.warn(message);
                throw new HttpRespAuditException(404, message, AuditLevel.INFO, AuditStatus.FAILED);
            }
            if (StringUtil.isBlank(caName)) {
                message = "CA is not specified";
                LOG.warn(message);
                throw new HttpRespAuditException(404, message, AuditLevel.INFO, AuditStatus.FAILED);
            }
            event.addEventData("ca", caName);
            event.addEventType(command);
            if (!knownCommands.contains(command)) {
                message = "invalid command '" + command + "'";
                LOG.error(message);
                throw new HttpRespAuditException(404, message, AuditLevel.INFO, AuditStatus.FAILED);
            }
            if ("cacert".equals(command)) {
                message = this.toRestResponse(HttpRespContent.ofOk((String)"application/pkix-cert", (byte[])this.sdk.cacert(caName)));
                return message;
            }
            if ("cacerts".equals(command)) {
                certsBytes = this.sdk.cacerts(caName);
                RestResponse sepIndex = this.toRestResponse(HttpRespContent.ofOk((String)"application/x-pem-file", (byte[])StringUtil.toUtf8Bytes((String)X509Util.encodeCertificates((byte[][])certsBytes))));
                return sepIndex;
            }
            if ("crl".equals(command)) {
                certsBytes = this.toRestResponse(this.getCrl(caName, httpRetriever));
                return certsBytes;
            }
            String hdrValue = httpRetriever.getHeader("Authorization");
            if (hdrValue != null && hdrValue.startsWith("Basic ")) {
                boolean authorized;
                String user = null;
                byte[] password = null;
                if (hdrValue.length() > 6) {
                    String b64 = hdrValue.substring(6);
                    byte[] userPwd = Base64.decodeFast((String)b64);
                    int idx = -1;
                    for (int i = 0; i < userPwd.length; ++i) {
                        if (userPwd[i] != 58) continue;
                        idx = i;
                        break;
                    }
                    if (idx != -1 && idx < userPwd.length - 1) {
                        user = StringUtil.toUtf8String((byte[])Arrays.copyOfRange((byte[])userPwd, (int)0, (int)idx));
                        password = Arrays.copyOfRange((byte[])userPwd, (int)(idx + 1), (int)userPwd.length);
                    }
                }
                if (user == null) {
                    throw new HttpRespAuditException(401, "invalid Authorization information", AuditLevel.INFO, AuditStatus.FAILED);
                }
                requestor = this.getRequestor(user);
                boolean bl = authorized = requestor != null && requestor.authenticate(password);
                if (!authorized) {
                    throw new HttpRespAuditException(401, "could not authenticate user " + user, AuditLevel.INFO, AuditStatus.FAILED);
                }
            } else {
                X509Cert clientCert = httpRetriever.getTlsClientCert();
                if (clientCert == null) {
                    throw new HttpRespAuditException(401, "no client certificate", AuditLevel.INFO, AuditStatus.FAILED);
                }
                requestor = this.getRequestor(clientCert);
                if (requestor == null) {
                    throw new OperationException(ErrorCode.NOT_PERMITTED, "no requestor specified");
                }
            }
            event.addEventData("requestor", (Object)requestor.getName());
            switch (command) {
                case "enroll-cross-cert": {
                    respContent = this.enrollCrossCert(caName, requestor, request, httpRetriever, event);
                    break;
                }
                case "enroll-cert": 
                case "enroll-serverkeygen": 
                case "enroll-cert-twin": 
                case "enroll-serverkeygen-twin": {
                    respContent = this.enrollCerts(command, caName, requestor, request, httpRetriever, event);
                    break;
                }
                case "revoke-cert": 
                case "unsuspend-cert": 
                case "unrevoke-cert": {
                    this.unRevoke(command, caName, requestor, httpRetriever, event);
                    respContent = null;
                    break;
                }
                default: {
                    throw new IllegalStateException("invalid command '" + command + "'");
                }
            }
            String string = this.toRestResponse(respContent);
            return string;
        }
        catch (OperationException ex) {
            String failureInfo;
            int sc;
            ErrorCode code = ex.getErrorCode();
            if (LOG.isWarnEnabled()) {
                String msg = StringUtil.concat((String)"generate certificate, OperationException: code=", (String[])new String[]{code.name(), ", message=", ex.getErrorMessage()});
                LogUtil.warn((Logger)LOG, (Throwable)ex, (String)msg);
            }
            switch (1.$SwitchMap$org$xipki$util$exception$ErrorCode[code.ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    sc = 400;
                    failureInfo = "badRequest";
                    break;
                }
                case 6: {
                    sc = 400;
                    failureInfo = "badCertTemplate";
                    break;
                }
                case 7: {
                    sc = 409;
                    failureInfo = "certRevoked";
                    break;
                }
                case 8: 
                case 9: {
                    sc = 401;
                    failureInfo = "notAuthorized";
                    break;
                }
                case 10: {
                    sc = 503;
                    failureInfo = "systemUnavail";
                    break;
                }
                case 11: {
                    sc = 400;
                    failureInfo = "badCertId";
                    break;
                }
                case 12: {
                    sc = 400;
                    failureInfo = "badPOP";
                    break;
                }
                case 13: {
                    sc = 404;
                    failureInfo = "systemUnavail";
                    break;
                }
                default: {
                    sc = 500;
                    failureInfo = "systemFailure";
                }
            }
            event.setStatus(AuditStatus.FAILED);
            event.addEventData("message", (Object)code.name());
            auditMessage = code.name();
            if (code != ErrorCode.DATABASE_FAILURE && code == ErrorCode.SYSTEM_FAILURE) {
                auditMessage = auditMessage + ": " + ex.getErrorMessage();
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("X-xipki-pkistatus", "rejection");
            if (StringUtil.isNotBlank((String)failureInfo)) {
                headers.put("X-xipki-fail-info", failureInfo);
            }
            RestResponse restResponse2 = new RestResponse(sc, null, headers, null);
            return restResponse2;
        }
        catch (HttpRespAuditException ex) {
            auditStatus = ex.getAuditStatus();
            auditLevel = ex.getAuditLevel();
            auditMessage = ex.getAuditMessage();
            restResponse = new RestResponse(ex.getHttpStatus(), null, null, null);
            return restResponse;
        }
        catch (Throwable th) {
            if (th instanceof EOFException) {
                LogUtil.warn((Logger)LOG, (Throwable)th, (String)"connection reset by peer");
            } else {
                LOG.error("Throwable thrown, this should not happen!", th);
            }
            auditLevel = AuditLevel.ERROR;
            auditStatus = AuditStatus.FAILED;
            auditMessage = "internal error";
            restResponse = new RestResponse(500, null, null, null);
            return restResponse;
        }
        finally {
            event.setStatus(auditStatus);
            event.setLevel(auditLevel);
            if (auditMessage != null) {
                event.addEventData("message", (Object)auditMessage);
            }
        }
    }

    private RestResponse toRestResponse(HttpRespContent respContent) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-xipki-pkistatus", "accepted");
        return respContent == null ? new RestResponse(200, null, headers, null) : new RestResponse(200, respContent.getContentType(), headers, respContent.isBase64(), respContent.getContent());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private HttpRespContent enrollCerts(String command, String caName, Requestor requestor, byte[] request, HttpRequestMetadataRetriever httpRetriever, AuditEvent event) throws HttpRespAuditException, OperationException, IOException, SdkErrorResponseException {
        Extensions extensions;
        X500Name subject;
        SubjectPublicKeyInfo subjectPublicKeyInfo;
        String profileEnc;
        if (!requestor.isPermitted(1)) {
            throw new OperationException(ErrorCode.NOT_PERMITTED, "ENROLL_CERT is not allowed");
        }
        boolean twin = "enroll-cert-twin".equals(command) || "enroll-serverkeygen-twin".equals(command);
        boolean caGenKeyPair = "enroll-serverkeygen".equals(command) || "enroll-serverkeygen-twin".equals(command);
        String profile = RestResponder.checkProfile((Requestor)requestor, (HttpRequestMetadataRetriever)httpRetriever);
        String string = profileEnc = twin ? profile + "-enc" : null;
        if (profileEnc != null && !requestor.isCertprofilePermitted(profileEnc)) {
            throw new OperationException(ErrorCode.NOT_PERMITTED, "certprofile " + profileEnc + " is not allowed");
        }
        String strNotBefore = httpRetriever.getParameter("not-before");
        Date notBefore = strNotBefore == null ? null : DateUtil.parseUtcTimeyyyyMMddhhmmss((String)strNotBefore);
        String strNotAfter = httpRetriever.getParameter("not-after");
        Date notAfter = strNotAfter == null ? null : DateUtil.parseUtcTimeyyyyMMddhhmmss((String)strNotAfter);
        String ct = httpRetriever.getHeader("Content-Type");
        if (caGenKeyPair) {
            subjectPublicKeyInfo = null;
            if (ct.startsWith("text/plain")) {
                Properties props = new Properties();
                props.load(new ByteArrayInputStream(request));
                String strSubject = props.getProperty("subject");
                if (strSubject == null) {
                    throw new OperationException(ErrorCode.BAD_CERT_TEMPLATE, "subject is not specified");
                }
                try {
                    subject = new X500Name(strSubject);
                }
                catch (Exception ex) {
                    throw new OperationException(ErrorCode.BAD_CERT_TEMPLATE, "invalid subject");
                }
                extensions = null;
            } else {
                if (!"application/pkcs10".equalsIgnoreCase(ct)) throw new HttpRespAuditException(415, "unsupported media type " + ct, AuditLevel.INFO, AuditStatus.FAILED);
                request = X509Util.toDerEncoded((byte[])request);
                CertificationRequestInfo certTemp = CertificationRequest.getInstance((Object)request).getCertificationRequestInfo();
                subject = certTemp.getSubject();
                extensions = X509Util.getExtensions((CertificationRequestInfo)certTemp);
            }
        } else {
            if (!"application/pkcs10".equalsIgnoreCase(ct)) {
                throw new HttpRespAuditException(415, "unsupported media type " + ct, AuditLevel.INFO, AuditStatus.FAILED);
            }
            CertificationRequest csr = CertificationRequest.getInstance((Object)request);
            if (!GatewayUtil.verifyCsr((CertificationRequest)csr, (SecurityFactory)this.securityFactory, (PopControl)this.popControl)) {
                throw new OperationException(ErrorCode.BAD_POP);
            }
            CertificationRequestInfo certTemp = csr.getCertificationRequestInfo();
            subject = certTemp.getSubject();
            subjectPublicKeyInfo = certTemp.getSubjectPublicKeyInfo();
            extensions = X509Util.getExtensions((CertificationRequestInfo)certTemp);
        }
        BigInteger certId = BigInteger.ONE;
        BigInteger certIdEnc = twin ? BigInteger.valueOf(2L) : null;
        EnrollCertRequestEntry template = new EnrollCertRequestEntry();
        template.setCertReqId(certId);
        template.setCertprofile(profile);
        template.setSubject(new X500NameType(subject));
        template.notBefore(notBefore);
        template.notAfter(notAfter);
        event.addEventData("certprofile", (Object)profile);
        event.addEventData("req_subject", (Object)("\"" + X509Util.x500NameText((X500Name)subject) + "\""));
        try {
            template.extensions(extensions);
        }
        catch (IOException e) {
            String message = "could not encode extensions";
            throw new HttpRespAuditException(400, message, AuditLevel.INFO, AuditStatus.FAILED);
        }
        try {
            template.subjectPublicKey(subjectPublicKeyInfo);
        }
        catch (IOException e) {
            String message = "could not encode SubjectPublicKeyInfo";
            throw new HttpRespAuditException(400, message, AuditLevel.INFO, AuditStatus.FAILED);
        }
        ArrayList<EnrollCertRequestEntry> templates = new ArrayList<EnrollCertRequestEntry>(twin ? 2 : 1);
        templates.add(template);
        if (twin) {
            template = new EnrollCertRequestEntry();
            template.setCertReqId(certIdEnc);
            template.setCertprofile(profileEnc);
            template.setSubject(new X500NameType(subject));
            template.notBefore(notBefore);
            template.notAfter(notAfter);
            event.addEventData("certprofile", (Object)profileEnc);
            event.addEventData("req_subject", (Object)("\"" + X509Util.x500NameText((X500Name)subject) + "\""));
            try {
                template.extensions(extensions);
            }
            catch (IOException e) {
                String message = "could not encode extensions";
                throw new HttpRespAuditException(400, message, AuditLevel.INFO, AuditStatus.FAILED);
            }
            templates.add(template);
        }
        EnrollCertsRequest sdkReq = new EnrollCertsRequest();
        sdkReq.setEntries(templates);
        sdkReq.setExplicitConfirm(Boolean.valueOf(false));
        sdkReq.setGroupEnroll(Boolean.valueOf(twin));
        sdkReq.setCaCertMode(CertsMode.NONE);
        EnrollOrPollCertsResponse sdkResp = this.sdk.enrollCerts(caName, sdkReq);
        RestResponder.checkResponse((int)templates.size(), (EnrollOrPollCertsResponse)sdkResp);
        EnrollOrPullCertResponseEntry entry = RestResponder.getEntry((List)sdkResp.getEntries(), (BigInteger)certId);
        if (!caGenKeyPair && !twin) {
            return HttpRespContent.ofOk((String)"application/pkix-cert", (byte[])entry.getCert());
        }
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        if (caGenKeyPair) {
            bo.write(PemEncoder.encode((byte[])entry.getPrivateKey(), (PemEncoder.PemLabel)PemEncoder.PemLabel.PRIVATE_KEY));
            bo.write(this.NEWLINE);
        }
        bo.write(PemEncoder.encode((byte[])entry.getCert(), (PemEncoder.PemLabel)PemEncoder.PemLabel.CERTIFICATE));
        bo.write(this.NEWLINE);
        if (twin) {
            entry = RestResponder.getEntry((List)sdkResp.getEntries(), (BigInteger)certIdEnc);
            bo.write(PemEncoder.encode((byte[])entry.getPrivateKey(), (PemEncoder.PemLabel)PemEncoder.PemLabel.PRIVATE_KEY));
            bo.write(this.NEWLINE);
            bo.write(PemEncoder.encode((byte[])entry.getCert(), (PemEncoder.PemLabel)PemEncoder.PemLabel.CERTIFICATE));
            bo.write(this.NEWLINE);
        }
        bo.flush();
        return HttpRespContent.ofOk((String)"application/x-pem-file", (byte[])bo.toByteArray());
    }

    private HttpRespContent enrollCrossCert(String caName, Requestor requestor, byte[] request, HttpRequestMetadataRetriever httpRetriever, AuditEvent event) throws HttpRespAuditException, OperationException, IOException, SdkErrorResponseException {
        byte[] targetCertBytes;
        byte[] csrBytes;
        Date notAfter;
        Date notBefore;
        String profile;
        block29: {
            if (!requestor.isPermitted(128)) {
                throw new OperationException(ErrorCode.NOT_PERMITTED, "ENROLL_CROSS is not allowed");
            }
            profile = RestResponder.checkProfile((Requestor)requestor, (HttpRequestMetadataRetriever)httpRetriever);
            String ct = httpRetriever.getHeader("Content-Type");
            if (!"application/x-pem-file".equalsIgnoreCase(ct)) {
                String message = "unsupported media type " + ct;
                throw new HttpRespAuditException(415, message, AuditLevel.INFO, AuditStatus.FAILED);
            }
            String strNotBefore = httpRetriever.getParameter("not-before");
            notBefore = strNotBefore == null ? null : DateUtil.parseUtcTimeyyyyMMddhhmmss((String)strNotBefore);
            String strNotAfter = httpRetriever.getParameter("not-after");
            notAfter = strNotAfter == null ? null : DateUtil.parseUtcTimeyyyyMMddhhmmss((String)strNotAfter);
            csrBytes = null;
            targetCertBytes = null;
            try (PemReader pemReader = new PemReader((Reader)new InputStreamReader(new ByteArrayInputStream(request)));){
                String type;
                while (true) {
                    PemObject pemObject;
                    if ((pemObject = pemReader.readPemObject()) == null) {
                        break block29;
                    }
                    type = pemObject.getType();
                    if (PemEncoder.PemLabel.CERTIFICATE_REQUEST.getType().equals(type)) {
                        if (csrBytes != null) {
                            throw new HttpRespAuditException(400, "duplicated PEM CSRs", AuditLevel.INFO, AuditStatus.FAILED);
                        }
                        csrBytes = pemObject.getContent();
                        continue;
                    }
                    if (!PemEncoder.PemLabel.CERTIFICATE.getType().equals(type)) break;
                    if (targetCertBytes != null) {
                        throw new HttpRespAuditException(400, "duplicated PEM certificates", AuditLevel.INFO, AuditStatus.FAILED);
                    }
                    targetCertBytes = pemObject.getContent();
                }
                throw new HttpRespAuditException(400, "unknown PEM object type " + type, AuditLevel.INFO, AuditStatus.FAILED);
            }
        }
        if (csrBytes == null) {
            throw new HttpRespAuditException(400, "PEM CSR is not specified", AuditLevel.INFO, AuditStatus.FAILED);
        }
        if (targetCertBytes == null) {
            throw new HttpRespAuditException(400, "PEM CERTIFICATE is not specified", AuditLevel.INFO, AuditStatus.FAILED);
        }
        CertificationRequest csr = CertificationRequest.getInstance(csrBytes);
        if (!GatewayUtil.verifyCsr((CertificationRequest)csr, (SecurityFactory)this.securityFactory, (PopControl)this.popControl)) {
            throw new OperationException(ErrorCode.BAD_POP);
        }
        Certificate targetCert = Certificate.getInstance((Object)targetCertBytes);
        try {
            X509Util.assertCsrAndCertMatch((CertificationRequest)csr, (Certificate)targetCert, (boolean)true);
        }
        catch (XiSecurityException ex) {
            throw new HttpRespAuditException(400, ex.getMessage(), AuditLevel.INFO, AuditStatus.FAILED);
        }
        SubjectPublicKeyInfo subjectPublicKeyInfo = targetCert.getSubjectPublicKeyInfo();
        Extensions extensions = targetCert.getTBSCertificate().getExtensions();
        X500Name subject = targetCert.getSubject();
        BigInteger certId = BigInteger.ONE;
        if (notAfter == null || notAfter.after(targetCert.getEndDate().getDate())) {
            notAfter = targetCert.getEndDate().getDate();
        }
        EnrollCertRequestEntry template = new EnrollCertRequestEntry();
        template.setCertReqId(certId);
        template.setCertprofile(profile);
        template.setSubject(new X500NameType(subject));
        template.notBefore(notBefore);
        template.notAfter(notAfter);
        event.addEventData("certprofile", (Object)profile);
        event.addEventData("req_subject", (Object)("\"" + X509Util.x500NameText((X500Name)subject) + "\""));
        try {
            template.extensions(extensions);
        }
        catch (IOException e) {
            String message = "could not encode extensions";
            throw new HttpRespAuditException(400, message, AuditLevel.INFO, AuditStatus.FAILED);
        }
        try {
            template.subjectPublicKey(subjectPublicKeyInfo);
        }
        catch (IOException e) {
            String message = "could not encode SubjectPublicKeyInfo";
            throw new HttpRespAuditException(400, message, AuditLevel.INFO, AuditStatus.FAILED);
        }
        List<EnrollCertRequestEntry> templates = Collections.singletonList(template);
        EnrollCertsRequest sdkReq = new EnrollCertsRequest();
        sdkReq.setEntries(templates);
        sdkReq.setExplicitConfirm(Boolean.valueOf(false));
        sdkReq.setGroupEnroll(Boolean.valueOf(false));
        sdkReq.setCaCertMode(CertsMode.NONE);
        EnrollOrPollCertsResponse sdkResp = this.sdk.enrollCrossCerts(caName, sdkReq);
        RestResponder.checkResponse((int)templates.size(), (EnrollOrPollCertsResponse)sdkResp);
        EnrollOrPullCertResponseEntry entry = RestResponder.getEntry((List)sdkResp.getEntries(), (BigInteger)certId);
        return HttpRespContent.ofOk((String)"application/pkix-cert", (byte[])entry.getCert());
    }

    private static void checkResponse(int expectedSize, EnrollOrPollCertsResponse resp) throws HttpRespAuditException {
        int n;
        List entries = resp.getEntries();
        if (entries != null) {
            for (EnrollOrPullCertResponseEntry entry : entries) {
                if (entry.getError() == null) continue;
                throw new HttpRespAuditException(500, entry.getError().toString(), AuditLevel.INFO, AuditStatus.FAILED);
            }
        }
        int n2 = n = entries == null ? 0 : entries.size();
        if (n != expectedSize) {
            throw new HttpRespAuditException(500, "expected " + expectedSize + " cert, but received " + n, AuditLevel.INFO, AuditStatus.FAILED);
        }
    }

    private static String checkProfile(Requestor requestor, HttpRequestMetadataRetriever httpRetriever) throws HttpRespAuditException, OperationException {
        String profile = httpRetriever.getParameter("profile");
        if (StringUtil.isBlank((String)profile)) {
            throw new HttpRespAuditException(400, "required parameter profile not specified", AuditLevel.INFO, AuditStatus.FAILED);
        }
        if (!requestor.isCertprofilePermitted(profile = profile.toLowerCase())) {
            throw new OperationException(ErrorCode.NOT_PERMITTED, "certprofile " + profile + " is not allowed");
        }
        return profile;
    }

    private static EnrollOrPullCertResponseEntry getEntry(List<EnrollOrPullCertResponseEntry> entries, BigInteger certReqId) throws HttpRespAuditException {
        for (EnrollOrPullCertResponseEntry m : entries) {
            if (!certReqId.equals(m.getId())) continue;
            return m;
        }
        throw new HttpRespAuditException(500, "found no response entry with certReqId " + certReqId, AuditLevel.INFO, AuditStatus.FAILED);
    }

    private void unRevoke(String command, String caName, Requestor requestor, HttpRequestMetadataRetriever httpRetriever, AuditEvent event) throws OperationException, HttpRespAuditException, IOException, SdkErrorResponseException {
        BigInteger serialNumber;
        int permission;
        boolean revoke = command.equals("revoke-cert");
        int n = permission = revoke ? 2 : 4;
        if (!requestor.isPermitted(permission)) {
            throw new OperationException(ErrorCode.NOT_PERMITTED, command + " is not allowed");
        }
        String strCaSha1 = httpRetriever.getParameter("ca-sha1");
        if (StringUtil.isBlank((String)strCaSha1)) {
            throw new HttpRespAuditException(400, "required parameter ca-sha1 not specified", AuditLevel.INFO, AuditStatus.FAILED);
        }
        byte[] caSha1 = Hex.decode((String)strCaSha1);
        String strSerialNumber = httpRetriever.getParameter("serial-number");
        if (StringUtil.isBlank((String)strSerialNumber)) {
            throw new HttpRespAuditException(400, "required parameter serial-number not specified", AuditLevel.INFO, AuditStatus.FAILED);
        }
        try {
            serialNumber = StringUtil.toBigInt((String)strSerialNumber);
        }
        catch (NumberFormatException ex) {
            throw new OperationException(ErrorCode.BAD_REQUEST, ex.getMessage());
        }
        event.addEventData("serial", (Object)LogUtil.formatCsn((BigInteger)serialNumber));
        if (!revoke) {
            UnsuspendOrRemoveRequest sdkReq = new UnsuspendOrRemoveRequest();
            sdkReq.setIssuerCertSha1Fp(caSha1);
            sdkReq.setEntries(Collections.singletonList(serialNumber));
            this.sdk.unsuspendCerts(caName, sdkReq);
        } else {
            CrlReason reason;
            String strReason = httpRetriever.getParameter("reason");
            CrlReason crlReason = reason = strReason == null ? CrlReason.UNSPECIFIED : CrlReason.forNameOrText((String)strReason);
            if (reason == CrlReason.REMOVE_FROM_CRL) {
                throw new OperationException(ErrorCode.BAD_REQUEST, "reason " + CrlReason.REMOVE_FROM_CRL.getDescription() + " is not allowed!");
            }
            event.addEventData("reason", (Object)reason);
            Date invalidityTime = null;
            String strInvalidityTime = httpRetriever.getParameter("invalidity-time");
            if (StringUtil.isNotBlank((String)strInvalidityTime)) {
                invalidityTime = DateUtil.parseUtcTimeyyyyMMddhhmmss((String)strInvalidityTime);
            }
            RevokeCertRequestEntry entry = new RevokeCertRequestEntry();
            entry.setSerialNumber(serialNumber);
            if (invalidityTime != null) {
                entry.setInvalidityTime(Long.valueOf(invalidityTime.getTime() / 1000L));
            }
            entry.setReason(reason);
            RevokeCertsRequest sdkReq = new RevokeCertsRequest();
            sdkReq.setIssuerCertSha1Fp(caSha1);
            sdkReq.setEntries(Collections.singletonList(entry));
            this.sdk.revokeCerts(caName, sdkReq);
        }
    }

    private HttpRespContent getCrl(String caName, HttpRequestMetadataRetriever httpRetriever) throws OperationException, HttpRespAuditException, IOException, SdkErrorResponseException {
        byte[] respBytes;
        String strCrlNumber = httpRetriever.getParameter("crl-number");
        BigInteger crlNumber = null;
        if (StringUtil.isNotBlank((String)strCrlNumber)) {
            try {
                crlNumber = StringUtil.toBigInt((String)strCrlNumber);
            }
            catch (NumberFormatException ex) {
                String message = "invalid crlNumber '" + strCrlNumber + "'";
                LOG.warn(message);
                throw new HttpRespAuditException(400, message, AuditLevel.INFO, AuditStatus.FAILED);
            }
        }
        if ((respBytes = this.sdk.currentCrl(caName, crlNumber, null, null)) == null) {
            String message = "could not get CRL";
            LOG.warn(message);
            throw new HttpRespAuditException(500, message, AuditLevel.INFO, AuditStatus.FAILED);
        }
        return HttpRespContent.ofOk((String)"application/pkix-crl", (byte[])respBytes);
    }
}

