/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway.rest.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.audit.AuditEvent;
import org.xipki.audit.AuditLevel;
import org.xipki.audit.AuditService;
import org.xipki.audit.AuditStatus;
import org.xipki.audit.Audits;
import org.xipki.ca.gateway.GatewayUtil;
import org.xipki.ca.gateway.RestResponse;
import org.xipki.ca.gateway.rest.RestResponder;
import org.xipki.ca.gateway.servlet.HttpRequestMetadataRetrieverImpl;
import org.xipki.ca.gateway.servlet.ServletHelper;
import org.xipki.security.util.HttpRequestMetadataRetriever;
import org.xipki.util.Args;
import org.xipki.util.IoUtil;

public class HttpRestServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(HttpRestServlet.class);
    private boolean logReqResp;
    private RestResponder responder;

    public void setLogReqResp(boolean logReqResp) {
        this.logReqResp = logReqResp;
    }

    public void setResponder(RestResponder responder) {
        this.responder = (RestResponder)Args.notNull((Object)responder, (String)"responder");
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.service0(req, resp, false);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.service0(req, resp, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void service0(HttpServletRequest req, HttpServletResponse resp, boolean viaPost) throws IOException {
        AuditService auditService = Audits.getAuditService();
        AuditEvent event = new AuditEvent(new Date());
        event.setApplicationName("rest-gw");
        try {
            String path = req.getServletPath();
            byte[] requestBytes = viaPost ? IoUtil.read((InputStream)req.getInputStream()) : null;
            RestResponse restResp = this.responder.service(path, requestBytes, (HttpRequestMetadataRetriever)new HttpRequestMetadataRetrieverImpl(req), event);
            restResp.fillResponse(resp);
            ServletHelper.logReqResp((String)"REST Gateway", (Logger)LOG, (boolean)this.logReqResp, (boolean)viaPost, (HttpServletRequest)req, (byte[])requestBytes, (byte[])restResp.getBody());
            if (event.getStatus() == null) {
                event.setStatus(AuditStatus.SUCCESSFUL);
            }
        }
        catch (RuntimeException ex) {
            event.setStatus(AuditStatus.FAILED);
            event.setLevel(AuditLevel.ERROR);
            LOG.error("RuntimeException thrown, this should not happen!", (Throwable)ex);
            resp.sendError(500);
        }
        finally {
            event.finish();
            auditService.logEvent(event);
            GatewayUtil.logAuditEvent((Logger)LOG, (AuditEvent)event);
        }
    }
}

