/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway.rest.servlet;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.gateway.GatewayUtil;
import org.xipki.ca.gateway.ProtocolProxyConfWrapper;
import org.xipki.ca.gateway.conf.ProtocolProxyConf;
import org.xipki.ca.gateway.rest.RestProxyConf;
import org.xipki.ca.gateway.rest.RestResponder;
import org.xipki.ca.gateway.rest.servlet.RestHttpServlet;
import org.xipki.util.IoUtil;
import org.xipki.util.XipkiBaseDir;
import org.xipki.util.exception.InvalidConfException;
import org.xipki.util.http.XiHttpFilter;
import org.xipki.util.http.XiHttpRequest;
import org.xipki.util.http.XiHttpResponse;

public class RestHttpFilter
implements XiHttpFilter {
    private static final Logger LOG = LoggerFactory.getLogger(RestHttpFilter.class);
    private static final String DFLT_CFG = "etc/rest-gateway.json";
    private RestHttpServlet servlet;
    private ProtocolProxyConfWrapper conf;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RestHttpFilter() throws Exception {
        boolean succ = false;
        try {
            RestProxyConf conf0;
            XipkiBaseDir.init();
            try {
                conf0 = RestProxyConf.readConfFromFile(IoUtil.expandFilepath((String)DFLT_CFG, (boolean)true));
            }
            catch (IOException ex) {
                throw new IOException("could not parse configuration file etc/rest-gateway.json", ex);
            }
            catch (InvalidConfException ex) {
                throw new InvalidConfException("could not parse configuration file etc/rest-gateway.json", (Throwable)ex);
            }
            this.conf = new ProtocolProxyConfWrapper((ProtocolProxyConf)conf0);
            RestResponder responder = new RestResponder(this.conf.getSdkClient(), this.conf.getSecurities().getSecurityFactory(), this.conf.getAuthenticator(), this.conf.getPopControl(), this.conf.getCaProfiles(), conf0.getReverseProxyMode());
            this.servlet = new RestHttpServlet(this.conf.isLogReqResp(), responder);
            succ = true;
        }
        finally {
            GatewayUtil.auditLogPciEvent((Logger)LOG, (String)"REST-Gateway", (boolean)true, (String)"START");
        }
    }

    public void destroy() {
        try {
            if (this.conf != null) {
                this.conf.destroy();
                this.conf = null;
            }
            GatewayUtil.auditLogPciEvent((Logger)LOG, (String)"REST-Gateway", (boolean)true, (String)"SHUTDOWN");
            GatewayUtil.closeAudits((Logger)LOG);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doFilter(XiHttpRequest req, XiHttpResponse resp) throws IOException {
        this.servlet.service(req, resp);
    }
}

