/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.scep.message;

import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.KeyTransRecipientId;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import org.xipki.scep.message.MessageDecodingException;
import org.xipki.security.X509Cert;
import org.xipki.util.Args;

public final class EnvelopedDataDecryptor {
    private final List<EnvelopedDataDecryptorInstance> decryptors;

    public EnvelopedDataDecryptor(List<EnvelopedDataDecryptorInstance> decryptors) {
        this.decryptors = new ArrayList<EnvelopedDataDecryptorInstance>(Args.notEmpty(decryptors, (String)"decryptors"));
    }

    public EnvelopedDataDecryptor(EnvelopedDataDecryptorInstance decryptor) {
        this.decryptors = Collections.singletonList(Args.notNull((Object)decryptor, (String)"decryptor"));
    }

    public byte[] decrypt(CMSEnvelopedData envData) throws MessageDecodingException {
        Args.notNull((Object)envData, (String)"envData");
        RecipientInformationStore recipientInfos = envData.getRecipientInfos();
        RecipientInformation recipientInfo = null;
        EnvelopedDataDecryptorInstance decryptor = null;
        for (EnvelopedDataDecryptorInstance m : this.decryptors) {
            recipientInfo = recipientInfos.get(m.getRecipientId());
            if (recipientInfo == null) continue;
            decryptor = m;
            break;
        }
        if (recipientInfo == null || decryptor == null) {
            throw new MessageDecodingException("missing expected key transfer recipient");
        }
        try {
            return recipientInfo.getContent(decryptor.getRecipient());
        }
        catch (CMSException ex) {
            throw new MessageDecodingException("could not decrypt the envelopedData");
        }
    }

    public static final class EnvelopedDataDecryptorInstance {
        private final RecipientId recipientId;
        private final Recipient recipient;

        public EnvelopedDataDecryptorInstance(X509Cert recipientCert, PrivateKey privKey) {
            Args.notNull((Object)recipientCert, (String)"recipientCert");
            Args.notNull((Object)privKey, (String)"privKey");
            this.recipientId = new KeyTransRecipientId(recipientCert.getIssuer(), recipientCert.getSerialNumber(), recipientCert.getSubjectKeyId());
            this.recipient = new JceKeyTransEnvelopedRecipient(privKey);
        }

        public Recipient getRecipient() {
            return this.recipient;
        }

        public RecipientId getRecipientId() {
            return this.recipientId;
        }
    }
}

