/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.scep.transaction;

import java.io.IOException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.xipki.util.Args;
import org.xipki.util.Hex;

public class TransactionId {
    private static final SecureRandom RANDOM = new SecureRandom();
    private final String id;

    public TransactionId(String id) {
        this.id = Args.notBlank((String)id, (String)"id");
    }

    private TransactionId(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            throw new IllegalArgumentException("bytes must not be empty");
        }
        this.id = Hex.encode((byte[])bytes);
    }

    public String getId() {
        return this.id;
    }

    public static TransactionId randomTransactionId() {
        byte[] bytes = new byte[20];
        RANDOM.nextBytes(bytes);
        return new TransactionId(bytes);
    }

    public static TransactionId sha1TransactionId(SubjectPublicKeyInfo spki) throws InvalidKeySpecException {
        byte[] encoded;
        Args.notNull((Object)spki, (String)"spki");
        try {
            encoded = spki.getEncoded();
        }
        catch (IOException ex) {
            throw new InvalidKeySpecException("IOException while ");
        }
        return TransactionId.sha1TransactionId(encoded);
    }

    public static TransactionId sha1TransactionId(byte[] content) {
        Args.notNull((Object)content, (String)"content");
        SHA1Digest dgst = new SHA1Digest();
        dgst.update(content, 0, content.length);
        byte[] digest = new byte[20];
        dgst.doFinal(digest, 0);
        return new TransactionId(digest);
    }
}

