/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.scep.util;

import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.Time;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.util.Store;
import org.xipki.security.HashAlgo;
import org.xipki.security.SignAlgo;
import org.xipki.security.X509Cert;
import org.xipki.util.Args;

public class ScepUtil {
    private ScepUtil() {
    }

    public static List<X509Cert> getCertsFromSignedData(SignedData signedData) throws CertificateException {
        Args.notNull((Object)signedData, (String)"signedData");
        ASN1Set set = signedData.getCertificates();
        if (set == null) {
            return Collections.emptyList();
        }
        int n = set.size();
        if (n == 0) {
            return Collections.emptyList();
        }
        LinkedList<X509Cert> certs = new LinkedList<X509Cert>();
        X509Cert eeCert = null;
        for (int i = 0; i < n; ++i) {
            X509Cert cert;
            try {
                cert = new X509Cert(Certificate.getInstance((Object)set.getObjectAt(i)));
            }
            catch (IllegalArgumentException ex) {
                throw new CertificateException(ex);
            }
            if (eeCert == null && cert.getBasicConstraints() == -1) {
                eeCert = cert;
                continue;
            }
            certs.add(cert);
        }
        if (eeCert != null) {
            certs.add(0, eeCert);
        }
        return certs;
    }

    public static X509CRLHolder getCrlFromPkiMessage(SignedData signedData) throws CRLException {
        ASN1Set set = ((SignedData)Args.notNull((Object)signedData, (String)"signedData")).getCRLs();
        if (set == null || set.size() == 0) {
            return null;
        }
        try {
            return new X509CRLHolder(CertificateList.getInstance((Object)set.getObjectAt(0)));
        }
        catch (IllegalArgumentException ex) {
            throw new CRLException(ex);
        }
    }

    public static String getSignatureAlgName(Key key, HashAlgo hashAlgo) throws NoSuchAlgorithmException {
        return SignAlgo.getInstance((Key)key, (HashAlgo)hashAlgo, null).getJceName();
    }

    public static ASN1Encodable getFirstAttrValue(AttributeTable attrs, ASN1ObjectIdentifier type) {
        Args.notNull((Object)attrs, (String)"attrs");
        Args.notNull((Object)type, (String)"type");
        Attribute attr = attrs.get(type);
        if (attr == null) {
            return null;
        }
        ASN1Set set = attr.getAttrValues();
        return set.size() == 0 ? null : set.getObjectAt(0);
    }

    public static void addCmsCertSet(CMSSignedDataGenerator generator, X509Cert[] cmsCertSet) throws CertificateEncodingException, CMSException {
        if (cmsCertSet == null || cmsCertSet.length == 0) {
            return;
        }
        Args.notNull((Object)generator, (String)"generator");
        LinkedList<X509CertificateHolder> certColl = new LinkedList<X509CertificateHolder>();
        for (X509Cert m : cmsCertSet) {
            certColl.add(m.toBcCert());
        }
        generator.addCertificates((Store)new JcaCertStore(certColl));
    }

    public static Date getTime(Object obj) {
        if (obj instanceof byte[]) {
            byte[] encoded = (byte[])obj;
            int tag = encoded[0] & 0xFF;
            try {
                if (tag == 23) {
                    return DERUTCTime.getInstance((Object)encoded).getDate();
                }
                if (tag == 24) {
                    return DERGeneralizedTime.getInstance((Object)encoded).getDate();
                }
                throw new IllegalArgumentException("invalid tag " + tag);
            }
            catch (ParseException ex) {
                throw new IllegalArgumentException("error parsing time", ex);
            }
        }
        if (obj instanceof org.bouncycastle.asn1.x509.Time) {
            return ((org.bouncycastle.asn1.x509.Time)obj).getDate();
        }
        if (obj instanceof Time) {
            return ((Time)obj).getDate();
        }
        return org.bouncycastle.asn1.x509.Time.getInstance((Object)obj).getDate();
    }
}

