/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.scep.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.xipki.scep.client.ScepClientException;
import org.xipki.util.Args;
import org.xipki.util.IoUtil;

public class ScepHttpResponse {
    private final String contentType;
    private final int contentLength;
    private final InputStream content;
    private String contentEncoding;

    public ScepHttpResponse(String contentType, int contentLength, InputStream content) {
        this.contentType = (String)Args.notNull((Object)contentType, (String)"contentType");
        this.content = (InputStream)Args.notNull((Object)content, (String)"content");
        this.contentLength = contentLength;
    }

    public ScepHttpResponse(String contentType, byte[] contentBytes) {
        this(contentType, ((byte[])Args.notNull((Object)contentBytes, (String)"contentBytes")).length, new ByteArrayInputStream(contentBytes));
    }

    public String getContentType() {
        return this.contentType;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public void setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
    }

    public InputStream getContent() {
        return this.content;
    }

    public byte[] getContentBytes() throws ScepClientException {
        if (this.content == null) {
            return null;
        }
        try {
            return IoUtil.read((InputStream)this.content);
        }
        catch (IOException ex) {
            throw new ScepClientException(ex);
        }
    }
}

