/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.scep.client;

import java.io.IOException;
import java.math.BigInteger;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.time.Instant;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.util.CollectionStore;
import org.xipki.scep.client.CaCertValidator;
import org.xipki.scep.client.CaIdentifier;
import org.xipki.scep.client.EnrolmentResponse;
import org.xipki.scep.client.ScepClientException;
import org.xipki.scep.client.ScepHttpResponse;
import org.xipki.scep.message.AuthorityCertStore;
import org.xipki.scep.message.CaCaps;
import org.xipki.scep.message.DecodedNextCaMessage;
import org.xipki.scep.message.DecodedPkiMessage;
import org.xipki.scep.message.IssuerAndSubject;
import org.xipki.scep.message.MessageDecodingException;
import org.xipki.scep.message.MessageEncodingException;
import org.xipki.scep.message.PkiMessage;
import org.xipki.scep.transaction.MessageType;
import org.xipki.scep.transaction.Operation;
import org.xipki.scep.transaction.PkiStatus;
import org.xipki.scep.transaction.TransactionId;
import org.xipki.scep.util.ScepUtil;
import org.xipki.security.HashAlgo;
import org.xipki.security.SignAlgo;
import org.xipki.security.X509Cert;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.StringUtil;

public abstract class Client {
    public static final String REQ_CONTENT_TYPE = "application/octet-stream";
    public static final long DEFAULT_SIGNINGTIME_BIAS = 300000L;
    protected final CaIdentifier caId;
    protected CaCaps caCaps;
    private final CaCertValidator caCertValidator;
    private long maxSigningTimeBiasInMs = 300000L;
    private AuthorityCertStore authorityCertStore;
    private CollectionStore<X509CertificateHolder> responseSignerCerts;
    private boolean httpGetOnly;

    public Client(CaIdentifier caId, CaCertValidator caCertValidator) {
        this.caId = (CaIdentifier)Args.notNull((Object)caId, (String)"caId");
        this.caCertValidator = (CaCertValidator)Args.notNull((Object)caCertValidator, (String)"caCertValidator");
    }

    protected abstract ScepHttpResponse httpPost(String var1, String var2, byte[] var3) throws ScepClientException;

    protected abstract ScepHttpResponse httpGet(String var1) throws ScepClientException;

    public boolean isHttpGetOnly() {
        return this.httpGetOnly;
    }

    public void setHttpGetOnly(boolean httpGetOnly) {
        this.httpGetOnly = httpGetOnly;
    }

    public long getMaxSigningTimeBiasInMs() {
        return this.maxSigningTimeBiasInMs;
    }

    public void setMaxSigningTimeBiasInMs(long maxSigningTimeBiasInMs) {
        this.maxSigningTimeBiasInMs = maxSigningTimeBiasInMs;
    }

    private ScepHttpResponse httpSend(Operation operation, ContentInfo pkiMessage) throws ScepClientException {
        byte[] request = null;
        if (pkiMessage != null) {
            try {
                request = pkiMessage.getEncoded();
            }
            catch (IOException ex) {
                throw new ScepClientException(ex);
            }
        }
        if (Operation.GetCACaps == operation || Operation.GetCACert == operation || Operation.GetNextCACert == operation) {
            return this.httpGet(this.caId.buildGetUrl(operation, this.caId.getProfile()));
        }
        if (!this.httpGetOnly && this.caCaps.supportsPost()) {
            return this.httpPost(this.caId.buildPostUrl(operation), REQ_CONTENT_TYPE, request);
        }
        String url = this.caId.buildGetUrl(operation, request == null ? null : Base64.encodeToString((byte[])request));
        return this.httpGet(url);
    }

    private ScepHttpResponse httpSend(Operation operation) throws ScepClientException {
        return this.httpSend(operation, null);
    }

    public void init() throws ScepClientException {
        this.refresh();
    }

    public void refresh() throws ScepClientException {
        X509CertificateHolder certHolder;
        ScepHttpResponse getCaCapsResp = this.httpSend(Operation.GetCACaps);
        this.caCaps = CaCaps.getInstance(StringUtil.toUtf8String((byte[])getCaCapsResp.getContentBytes()));
        ScepHttpResponse getCaCertResp = this.httpSend(Operation.GetCACert);
        this.authorityCertStore = Client.retrieveCaCertStore(getCaCertResp, this.caCertValidator);
        try {
            certHolder = new X509CertificateHolder(this.authorityCertStore.getSignatureCert().getEncoded());
        }
        catch (IOException ex) {
            throw new ScepClientException(ex);
        }
        this.responseSignerCerts = new CollectionStore(Collections.singletonList(certHolder));
    }

    public CaCaps getCaCaps() throws ScepClientException {
        this.initIfNotInited();
        return this.caCaps;
    }

    public X509Cert getCaCert() {
        return this.authorityCertStore == null ? null : this.authorityCertStore.getCaCert();
    }

    public CaIdentifier getCaId() throws ScepClientException {
        this.initIfNotInited();
        return this.caId;
    }

    public CaCertValidator getCaCertValidator() throws ScepClientException {
        this.initIfNotInited();
        return this.caCertValidator;
    }

    public AuthorityCertStore getAuthorityCertStore() throws ScepClientException {
        this.initIfNotInited();
        return this.authorityCertStore;
    }

    public X509CRLHolder scepGetCrl(PrivateKey identityKey, X509Cert identityCert, X500Name issuer, BigInteger serialNumber) throws ScepClientException {
        Args.notNull((Object)identityKey, (String)"identityKey");
        Args.notNull((Object)identityCert, (String)"identityCert");
        Args.notNull((Object)issuer, (String)"issuer");
        Args.notNull((Object)serialNumber, (String)"serialNumber");
        this.initIfNotInited();
        PkiMessage pkiMessage = new PkiMessage(TransactionId.randomTransactionId(), MessageType.GetCRL);
        IssuerAndSerialNumber isn = new IssuerAndSerialNumber(issuer, serialNumber);
        pkiMessage.setMessageData((ASN1Encodable)isn);
        ContentInfo request = this.encryptThenSign(pkiMessage, identityKey, identityCert);
        ScepHttpResponse httpResp = this.httpSend(Operation.PKIOperation, request);
        CMSSignedData cmsSignedData = Client.parsePkiMessage(httpResp.getContentBytes());
        DecodedPkiMessage response = this.decode(cmsSignedData, identityKey, identityCert);
        if (response.getPkiStatus() != PkiStatus.SUCCESS) {
            throw new ScepClientException("server returned " + (Object)((Object)response.getPkiStatus()));
        }
        ContentInfo messageData = ContentInfo.getInstance((Object)response.getMessageData());
        try {
            return ScepUtil.getCrlFromPkiMessage(SignedData.getInstance((Object)messageData.getContent()));
        }
        catch (CRLException ex) {
            throw new ScepClientException(ex.getMessage(), ex);
        }
    }

    public List<X509Cert> scepGetCert(PrivateKey identityKey, X509Cert identityCert, X500Name issuer, BigInteger serialNumber) throws ScepClientException {
        Args.notNull((Object)identityKey, (String)"identityKey");
        Args.notNull((Object)identityCert, (String)"identityCert");
        Args.notNull((Object)issuer, (String)"issuer");
        Args.notNull((Object)serialNumber, (String)"serialNumber");
        this.initIfNotInited();
        PkiMessage request = new PkiMessage(TransactionId.randomTransactionId(), MessageType.GetCert);
        IssuerAndSerialNumber isn = new IssuerAndSerialNumber(issuer, serialNumber);
        request.setMessageData((ASN1Encodable)isn);
        ContentInfo envRequest = this.encryptThenSign(request, identityKey, identityCert);
        ScepHttpResponse httpResp = this.httpSend(Operation.PKIOperation, envRequest);
        CMSSignedData cmsSignedData = Client.parsePkiMessage(httpResp.getContentBytes());
        DecodedPkiMessage response = this.decode(cmsSignedData, identityKey, identityCert);
        if (response.getPkiStatus() != PkiStatus.SUCCESS) {
            throw new ScepClientException("server returned " + (Object)((Object)response.getPkiStatus()));
        }
        ContentInfo messageData = ContentInfo.getInstance((Object)response.getMessageData());
        try {
            return ScepUtil.getCertsFromSignedData(SignedData.getInstance((Object)messageData.getContent()));
        }
        catch (CertificateException ex) {
            throw new ScepClientException(ex.getMessage(), ex);
        }
    }

    public EnrolmentResponse scepCertPoll(PrivateKey identityKey, X509Cert identityCert, CertificationRequest csr, X500Name issuer) throws ScepClientException {
        TransactionId tid;
        Args.notNull((Object)csr, (String)"csr");
        try {
            tid = TransactionId.sha1TransactionId(csr.getCertificationRequestInfo().getSubjectPublicKeyInfo());
        }
        catch (InvalidKeySpecException ex) {
            throw new ScepClientException(ex.getMessage(), ex);
        }
        return this.scepCertPoll(identityKey, identityCert, tid, issuer, csr.getCertificationRequestInfo().getSubject());
    }

    public EnrolmentResponse scepCertPoll(PrivateKey identityKey, X509Cert identityCert, TransactionId transactionId, X500Name issuer, X500Name subject) throws ScepClientException {
        Args.notNull((Object)identityKey, (String)"identityKey");
        Args.notNull((Object)identityCert, (String)"identityCert");
        Args.notNull((Object)issuer, (String)"issuer");
        Args.notNull((Object)transactionId, (String)"transactionId");
        this.initIfNotInited();
        PkiMessage pkiMessage = new PkiMessage(transactionId, MessageType.CertPoll);
        IssuerAndSubject is = new IssuerAndSubject(issuer, subject);
        pkiMessage.setMessageData((ASN1Encodable)is);
        ContentInfo envRequest = this.encryptThenSign(pkiMessage, identityKey, identityCert);
        ScepHttpResponse httpResp = this.httpSend(Operation.PKIOperation, envRequest);
        CMSSignedData cmsSignedData = Client.parsePkiMessage(httpResp.getContentBytes());
        DecodedPkiMessage response = this.decode(cmsSignedData, identityKey, identityCert);
        Client.assertSameNonce(pkiMessage, response);
        return new EnrolmentResponse(response);
    }

    public EnrolmentResponse scepEnrol(CertificationRequest csr, PrivateKey identityKey, X509Cert identityCert) throws ScepClientException {
        Args.notNull((Object)csr, (String)"csr");
        Args.notNull((Object)identityKey, (String)"identityKey");
        Args.notNull((Object)identityCert, (String)"identityCert");
        this.initIfNotInited();
        if (!identityCert.isSelfSigned() && this.caCaps.supportsRenewal()) {
            return this.scepRenewalReq(csr, identityKey, identityCert);
        }
        return this.scepPkcsReq(csr, identityKey, identityCert);
    }

    public EnrolmentResponse scepPkcsReq(CertificationRequest csr, PrivateKey identityKey, X509Cert identityCert) throws ScepClientException {
        Args.notNull((Object)csr, (String)"csr");
        Args.notNull((Object)identityKey, (String)"identityKey");
        Args.notNull((Object)identityCert, (String)"identityCert");
        this.initIfNotInited();
        if (!identityCert.isSelfSigned()) {
            throw new IllegalArgumentException("identityCert is not self-signed");
        }
        return this.enroll(MessageType.PKCSReq, csr, identityKey, identityCert);
    }

    public EnrolmentResponse scepRenewalReq(CertificationRequest csr, PrivateKey identityKey, X509Cert identityCert) throws ScepClientException {
        this.initIfNotInited();
        if (!this.caCaps.supportsRenewal()) {
            throw new ScepClientException.OperationNotSupportedException("unsupported messageType '" + (Object)((Object)MessageType.RenewalReq) + "'");
        }
        if (identityCert.isSelfSigned()) {
            throw new IllegalArgumentException("identityCert must not be self-signed");
        }
        return this.enroll(MessageType.RenewalReq, csr, identityKey, identityCert);
    }

    private EnrolmentResponse enroll(MessageType messageType, CertificationRequest csr, PrivateKey identityKey, X509Cert identityCert) throws ScepClientException {
        TransactionId tid;
        try {
            tid = TransactionId.sha1TransactionId(csr.getCertificationRequestInfo().getSubjectPublicKeyInfo());
        }
        catch (InvalidKeySpecException ex) {
            throw new ScepClientException(ex.getMessage(), ex);
        }
        PkiMessage pkiMessage = new PkiMessage(tid, messageType);
        pkiMessage.setMessageData((ASN1Encodable)csr);
        ContentInfo envRequest = this.encryptThenSign(pkiMessage, identityKey, identityCert);
        ScepHttpResponse httpResp = this.httpSend(Operation.PKIOperation, envRequest);
        CMSSignedData cmsSignedData = Client.parsePkiMessage(httpResp.getContentBytes());
        DecodedPkiMessage response = this.decode(cmsSignedData, identityKey, identityCert);
        Client.assertSameNonce(pkiMessage, response);
        return new EnrolmentResponse(response);
    }

    public AuthorityCertStore scepNextCaCert() throws ScepClientException {
        this.initIfNotInited();
        if (!this.caCaps.supportsGetNextCACert()) {
            throw new ScepClientException.OperationNotSupportedException("unsupported operation '" + Operation.GetNextCACert.getCode() + "'");
        }
        return this.retrieveNextCaAuthorityCertStore(this.httpSend(Operation.GetNextCACert));
    }

    private ContentInfo encryptThenSign(PkiMessage request, PrivateKey identityKey, X509Cert identityCert) throws ScepClientException {
        ASN1ObjectIdentifier encAlgId;
        HashAlgo hashAlgo = this.caCaps.mostSecureHashAlgo();
        if (this.caCaps.supportsAES()) {
            encAlgId = CMSAlgorithm.AES128_CBC;
        } else if (this.caCaps.supportsDES3()) {
            encAlgId = CMSAlgorithm.DES_EDE3_CBC;
        } else {
            throw new ScepClientException("DES will not be supported by this client");
        }
        try {
            SignAlgo signatureAlgorithm = SignAlgo.getInstance((Key)identityKey, (HashAlgo)hashAlgo, null);
            return request.encode(identityKey, signatureAlgorithm, identityCert, new X509Cert[]{identityCert}, this.authorityCertStore.getEncryptionCert(), encAlgId);
        }
        catch (NoSuchAlgorithmException | MessageEncodingException ex) {
            throw new ScepClientException(ex);
        }
    }

    public void destroy() {
    }

    private AuthorityCertStore retrieveNextCaAuthorityCertStore(ScepHttpResponse httpResp) throws ScepClientException {
        DecodedNextCaMessage resp;
        CMSSignedData cmsSignedData;
        String ct = httpResp.getContentType();
        if (!"application/x-x509-next-ca-cert".equalsIgnoreCase(ct)) {
            throw new ScepClientException("invalid Content-Type '" + ct + "'");
        }
        try {
            cmsSignedData = new CMSSignedData(httpResp.getContentBytes());
        }
        catch (IllegalArgumentException | CMSException ex) {
            throw new ScepClientException("invalid SignedData message: " + ex.getMessage(), ex);
        }
        try {
            resp = DecodedNextCaMessage.decode(cmsSignedData, this.responseSignerCerts);
        }
        catch (MessageDecodingException ex) {
            throw new ScepClientException("could not decode response: " + ex.getMessage(), ex);
        }
        if (resp.getFailureMessage() != null) {
            throw new ScepClientException("Error: " + resp.getFailureMessage());
        }
        Boolean bo = resp.isSignatureValid();
        if (bo != null && !bo.booleanValue()) {
            throw new ScepClientException("Signature is invalid");
        }
        Instant signingTime = resp.getSigningTime();
        long maxSigningTimeBias = this.getMaxSigningTimeBiasInMs();
        if (maxSigningTimeBias > 0L) {
            if (signingTime == null) {
                throw new ScepClientException("CMS signingTime attribute is not present");
            }
            if (Math.abs(Instant.now().toEpochMilli() - signingTime.toEpochMilli()) > maxSigningTimeBias) {
                throw new ScepClientException("CMS signingTime is out of permitted period");
            }
        }
        if (!resp.getSignatureCert().equals((Object)this.authorityCertStore.getSignatureCert())) {
            throw new ScepClientException("the signature certificate must not be trusted");
        }
        return resp.getAuthorityCertStore();
    }

    private void initIfNotInited() throws ScepClientException {
        if (this.caCaps == null) {
            this.init();
        }
    }

    private DecodedPkiMessage decode(CMSSignedData pkiMessage, PrivateKey recipientKey, X509Cert recipientCert) throws ScepClientException {
        DecodedPkiMessage resp;
        try {
            resp = DecodedPkiMessage.decode(pkiMessage, recipientKey, recipientCert, this.responseSignerCerts);
        }
        catch (MessageDecodingException ex) {
            throw new ScepClientException(ex);
        }
        if (resp.getFailureMessage() != null) {
            throw new ScepClientException("Error: " + resp.getFailureMessage());
        }
        Boolean bo = resp.isSignatureValid();
        if (bo != null && !bo.booleanValue()) {
            throw new ScepClientException("Signature is invalid");
        }
        bo = resp.isDecryptionSuccessful();
        if (bo != null && !bo.booleanValue()) {
            throw new ScepClientException("Decryption failed");
        }
        Instant signingTime = resp.getSigningTime();
        long maxSigningTimeBias = this.getMaxSigningTimeBiasInMs();
        if (maxSigningTimeBias > 0L) {
            if (signingTime == null) {
                throw new ScepClientException("CMS signingTime attribute is not present");
            }
            if (Math.abs(Instant.now().toEpochMilli() - signingTime.toEpochMilli()) > maxSigningTimeBias) {
                throw new ScepClientException("CMS signingTime is out of permitted period");
            }
        }
        if (!resp.getSignatureCert().equals((Object)this.authorityCertStore.getSignatureCert())) {
            throw new ScepClientException("the signature certificate must not be trusted");
        }
        return resp;
    }

    private static CMSSignedData parsePkiMessage(byte[] messageBytes) throws ScepClientException {
        try {
            return new CMSSignedData(messageBytes);
        }
        catch (CMSException ex) {
            throw new ScepClientException(ex);
        }
    }

    private static AuthorityCertStore retrieveCaCertStore(ScepHttpResponse resp, CaCertValidator caValidator) throws ScepClientException {
        String ct = resp.getContentType();
        X509Cert caCert = null;
        LinkedList<X509Cert> raCerts = new LinkedList<X509Cert>();
        if ("application/x-x509-ca-cert".equalsIgnoreCase(ct)) {
            try {
                caCert = X509Util.parseCert((byte[])resp.getContentBytes());
            }
            catch (CertificateEncodingException ex) {
                throw new ScepClientException("error parsing certificate: " + ex.getMessage(), ex);
            }
        }
        if ("application/x-x509-ca-ra-cert".equalsIgnoreCase(ct)) {
            List<X509Cert> certs;
            SignedData signedData;
            ContentInfo contentInfo = ContentInfo.getInstance((Object)resp.getContentBytes());
            try {
                signedData = SignedData.getInstance((Object)contentInfo.getContent());
            }
            catch (IllegalArgumentException ex) {
                throw new ScepClientException("invalid SignedData message: " + ex.getMessage(), ex);
            }
            try {
                certs = ScepUtil.getCertsFromSignedData(signedData);
            }
            catch (CertificateException ex) {
                throw new ScepClientException(ex.getMessage(), ex);
            }
            int n = certs.size();
            if (n < 2) {
                throw new ScepClientException("at least 2 certificates are expected, but only " + n + " is available");
            }
            for (X509Cert cert : certs) {
                if (cert.getBasicConstraints() > -1) {
                    if (caCert != null) {
                        throw new ScepClientException("multiple CA certificates is returned, but exactly 1 is expected");
                    }
                    caCert = cert;
                    continue;
                }
                raCerts.add(cert);
            }
            if (caCert == null) {
                throw new ScepClientException("no CA certificate is returned");
            }
        } else {
            throw new ScepClientException("invalid Content-Type '" + ct + "'");
        }
        if (!caValidator.isTrusted(caCert)) {
            throw new ScepClientException("CA certificate '" + caCert.getSubjectText() + "' is not trusted");
        }
        if (raCerts.isEmpty()) {
            return AuthorityCertStore.getInstance(caCert, new X509Cert[0]);
        }
        AuthorityCertStore cs = AuthorityCertStore.getInstance(caCert, raCerts.toArray(new X509Cert[0]));
        X509Cert raEncCert = cs.getEncryptionCert();
        X509Cert raSignCert = cs.getSignatureCert();
        try {
            if (!X509Util.issues((X509Cert)caCert, (X509Cert)raEncCert)) {
                throw new ScepClientException("RA certificate '" + raEncCert.getSubjectText() + " is not issued by the CA");
            }
            if (raSignCert != raEncCert && X509Util.issues((X509Cert)caCert, (X509Cert)raSignCert)) {
                throw new ScepClientException("RA certificate '" + raSignCert.getSubjectText() + " is not issued by the CA");
            }
        }
        catch (CertificateException ex) {
            throw new ScepClientException("invalid certificate: " + ex.getMessage(), ex);
        }
        return cs;
    }

    private static void assertSameNonce(PkiMessage request, PkiMessage response) throws ScepClientException {
        if (request.getSenderNonce().equals(response.getRecipientNonce())) {
            throw new ScepClientException("SenderNonce in request != RecipientNonce in response");
        }
    }
}

