/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.scep.message;

import java.util.Collection;
import java.util.HashSet;
import org.xipki.security.HashAlgo;
import org.xipki.security.X509Cert;
import org.xipki.util.Args;

public interface CertificateValidator {
    public boolean trustCertificate(X509Cert var1, X509Cert[] var2);

    public static class TrustAllCertValidator
    implements CertificateValidator {
        @Override
        public boolean trustCertificate(X509Cert target, X509Cert[] otherCerts) {
            return true;
        }
    }

    public static class CollectionCertificateValidator
    implements CertificateValidator {
        private final Collection<String> certHashes;

        public CollectionCertificateValidator(Collection<X509Cert> certs) {
            Args.notEmpty(certs, (String)"certs");
            this.certHashes = new HashSet<String>(certs.size());
            for (X509Cert cert : certs) {
                String hash = HashAlgo.SHA256.hexHash((byte[][])new byte[][]{cert.getEncoded()});
                this.certHashes.add(hash);
            }
        }

        public CollectionCertificateValidator(X509Cert cert) {
            Args.notNull((Object)cert, (String)"cert");
            this.certHashes = new HashSet<String>(2);
            String hash = HashAlgo.SHA256.hexHash((byte[][])new byte[][]{cert.getEncoded()});
            this.certHashes.add(hash);
        }

        @Override
        public boolean trustCertificate(X509Cert signerCert, X509Cert[] otherCerts) {
            Args.notNull((Object)signerCert, (String)"signerCert");
            String hash = HashAlgo.SHA256.hexHash((byte[][])new byte[][]{signerCert.getEncoded()});
            return this.certHashes.contains(hash);
        }
    }
}

