/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.scep.client;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.xipki.scep.transaction.Operation;
import org.xipki.util.Args;
import org.xipki.util.StringUtil;

public class CaIdentifier {
    private final String url;
    private final String profile;

    public CaIdentifier(String serverUrl, String profile) throws MalformedURLException {
        Args.notBlank((String)serverUrl, (String)"serverUrl");
        URL tmpUrl = new URL(serverUrl);
        String protocol = tmpUrl.getProtocol();
        if (!StringUtil.orEqualsIgnoreCase((String)protocol, (String[])new String[]{"http", "https"})) {
            throw new IllegalArgumentException("URL protocol should be HTTP or HTTPS, but not '" + protocol + "'");
        }
        if (tmpUrl.getQuery() != null) {
            throw new IllegalArgumentException("URL should contain no query string");
        }
        this.url = serverUrl;
        this.profile = profile;
    }

    public String getUrl() {
        return this.url;
    }

    public String getProfile() {
        return this.profile;
    }

    public String buildGetUrl(Operation operation) {
        return this.buildGetUrl(operation, null);
    }

    public String buildGetUrl(Operation operation, String message) {
        Args.notNull((Object)((Object)operation), (String)"operation");
        StringBuilder ub = new StringBuilder(this.url);
        ub.append('?').append("operation=").append(operation.getCode());
        if (StringUtil.isNotBlank((String)message)) {
            String urlMessage = URLEncoder.encode(message, StandardCharsets.UTF_8);
            ub.append("&message=").append(urlMessage);
        }
        return ub.toString();
    }

    public String buildPostUrl(Operation operation) {
        Args.notNull((Object)((Object)operation), (String)"operation");
        return this.url + "?operation=" + operation.getCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("URL: ").append(this.url);
        if (StringUtil.isNotBlank((String)this.profile)) {
            sb.append(", CA-Ident: ").append(this.profile);
        }
        return sb.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CaIdentifier)) {
            return false;
        }
        CaIdentifier objB = (CaIdentifier)object;
        if (!this.url.equals(objB.url)) {
            return false;
        }
        if (this.profile == null) {
            return objB.profile == null;
        }
        return this.profile.equals(objB.profile);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

