/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.scep.message;

import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.time.Instant;
import java.util.Collection;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1PrintableString;
import org.bouncycastle.asn1.ASN1UTF8String;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.util.CollectionStore;
import org.bouncycastle.util.Selector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.scep.message.EnvelopedDataDecryptor;
import org.xipki.scep.message.IssuerAndSubject;
import org.xipki.scep.message.MessageDecodingException;
import org.xipki.scep.message.PkiMessage;
import org.xipki.scep.transaction.FailInfo;
import org.xipki.scep.transaction.MessageType;
import org.xipki.scep.transaction.Nonce;
import org.xipki.scep.transaction.PkiStatus;
import org.xipki.scep.transaction.TransactionId;
import org.xipki.scep.util.ScepConstants;
import org.xipki.scep.util.ScepUtil;
import org.xipki.security.HashAlgo;
import org.xipki.security.SignAlgo;
import org.xipki.security.X509Cert;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.StringUtil;

public class DecodedPkiMessage
extends PkiMessage {
    private static final Logger LOG = LoggerFactory.getLogger(DecodedPkiMessage.class);
    private static final Set<ASN1ObjectIdentifier> SCEP_ATTR_TYPES = CollectionUtil.asSet((Object[])new ASN1ObjectIdentifier[]{ScepConstants.ID_FAILINFO, ScepConstants.ID_MESSAGE_TYPE, ScepConstants.ID_PKI_STATUS, ScepConstants.ID_RECIPIENT_NONCE, ScepConstants.ID_SENDER_NONCE, ScepConstants.ID_TRANSACTION_ID, CMSAttributes.signingTime});
    private X509Cert signatureCert;
    private HashAlgo digestAlgorithm;
    private ASN1ObjectIdentifier contentEncryptionAlgorithm;
    private Boolean signatureValid;
    private Boolean decryptionSuccessful;
    private Instant signingTime;
    private String failureMessage;

    public DecodedPkiMessage(TransactionId transactionId, MessageType messageType, Nonce senderNonce) {
        super(transactionId, messageType, senderNonce);
    }

    public X509Cert getSignatureCert() {
        return this.signatureCert;
    }

    public void setSignatureCert(X509Cert signatureCert) {
        this.signatureCert = signatureCert;
    }

    public HashAlgo getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public void setDigestAlgorithm(HashAlgo digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
    }

    public void setSignatureValid(Boolean signatureValid) {
        this.signatureValid = signatureValid;
    }

    public void setContentEncryptionAlgorithm(ASN1ObjectIdentifier encryptionAlgorithm) {
        this.contentEncryptionAlgorithm = encryptionAlgorithm;
    }

    public String getFailureMessage() {
        return this.failureMessage;
    }

    public void setFailureMessage(String failureMessage) {
        this.failureMessage = failureMessage;
    }

    public ASN1ObjectIdentifier getContentEncryptionAlgorithm() {
        return this.contentEncryptionAlgorithm;
    }

    public Boolean isDecryptionSuccessful() {
        return this.decryptionSuccessful;
    }

    public void setDecryptionSuccessful(Boolean decryptionSuccessful) {
        this.decryptionSuccessful = decryptionSuccessful;
    }

    public Boolean isSignatureValid() {
        return this.signatureValid;
    }

    public Instant getSigningTime() {
        return this.signingTime;
    }

    public void setSigningTime(Instant signingTime) {
        this.signingTime = signingTime;
    }

    public static DecodedPkiMessage decode(CMSSignedData pkiMessage, PrivateKey recipientKey, X509Cert recipientCert, CollectionStore<X509CertificateHolder> certStore) throws MessageDecodingException {
        EnvelopedDataDecryptor.EnvelopedDataDecryptorInstance decInstance = new EnvelopedDataDecryptor.EnvelopedDataDecryptorInstance(recipientCert, recipientKey);
        return DecodedPkiMessage.decode(pkiMessage, new EnvelopedDataDecryptor(decInstance), certStore);
    }

    public static DecodedPkiMessage decode(CMSSignedData pkiMessage, EnvelopedDataDecryptor recipient, CollectionStore<X509CertificateHolder> certStore) throws MessageDecodingException {
        DecodedPkiMessage ret;
        block51: {
            byte[] encodedMessageData;
            CMSEnvelopedData envData;
            boolean signatureValid;
            SignerInformationVerifier verifier;
            Attribute[] attrs;
            MessageType messageType;
            Collection signedDataCerts;
            Args.notNull((Object)recipient, (String)"recipient");
            SignerInformationStore signerStore = ((CMSSignedData)Args.notNull((Object)pkiMessage, (String)"pkiMessage")).getSignerInfos();
            Collection signerInfos = signerStore.getSigners();
            if (signerInfos.size() != 1) {
                throw new MessageDecodingException("number of signerInfos is not 1, but " + signerInfos.size());
            }
            SignerInformation signerInfo = (SignerInformation)signerInfos.iterator().next();
            SignerId sid = signerInfo.getSID();
            Collection collection = signedDataCerts = certStore == null ? null : certStore.getMatches((Selector)sid);
            if (CollectionUtil.isEmpty((Collection)signedDataCerts)) {
                signedDataCerts = pkiMessage.getCertificates().getMatches((Selector)signerInfo.getSID());
            }
            if (signedDataCerts == null || signedDataCerts.size() != 1) {
                throw new MessageDecodingException("could not find embedded certificate to verify the signature");
            }
            AttributeTable signedAttrs = signerInfo.getSignedAttributes();
            if (signedAttrs == null) {
                throw new MessageDecodingException("missing SCEP attributes");
            }
            ASN1Encodable attrValue = ScepUtil.getFirstAttrValue(signedAttrs, CMSAttributes.signingTime);
            Instant signingTime = attrValue == null ? null : ScepUtil.getTime(attrValue);
            String str = DecodedPkiMessage.getPrintableStringAttrValue(signedAttrs, ScepConstants.ID_TRANSACTION_ID);
            if (StringUtil.isBlank((String)str)) {
                throw new MessageDecodingException("missing required SCEP attribute transactionId");
            }
            TransactionId tid = new TransactionId(str);
            Integer intValue = DecodedPkiMessage.getIntegerPrintStringAttrValue(signedAttrs, ScepConstants.ID_MESSAGE_TYPE);
            if (intValue == null) {
                throw new MessageDecodingException("tid " + tid.getId() + ": missing required SCEP attribute messageType");
            }
            try {
                messageType = MessageType.forValue(intValue);
            }
            catch (IllegalArgumentException ex) {
                throw new MessageDecodingException("tid " + tid.getId() + ": invalid messageType '" + intValue + "'");
            }
            Nonce senderNonce = DecodedPkiMessage.getNonceAttrValue(signedAttrs, ScepConstants.ID_SENDER_NONCE);
            if (senderNonce == null) {
                throw new MessageDecodingException("tid " + tid.getId() + ": missing required SCEP attribute senderNonce");
            }
            ret = new DecodedPkiMessage(tid, messageType, senderNonce);
            if (signingTime != null) {
                ret.setSigningTime(signingTime);
            }
            Nonce recipientNonce = null;
            try {
                recipientNonce = DecodedPkiMessage.getNonceAttrValue(signedAttrs, ScepConstants.ID_RECIPIENT_NONCE);
            }
            catch (MessageDecodingException ex) {
                ret.setFailureMessage("could not parse recipientNonce: " + ex.getMessage());
            }
            if (recipientNonce != null) {
                ret.setRecipientNonce(recipientNonce);
            }
            PkiStatus pkiStatus = null;
            if (MessageType.CertRep == messageType) {
                try {
                    intValue = DecodedPkiMessage.getIntegerPrintStringAttrValue(signedAttrs, ScepConstants.ID_PKI_STATUS);
                }
                catch (MessageDecodingException ex) {
                    ret.setFailureMessage("could not parse pkiStatus: " + ex.getMessage());
                    return ret;
                }
                if (intValue == null) {
                    ret.setFailureMessage("missing required SCEP attribute pkiStatus");
                    return ret;
                }
                try {
                    pkiStatus = PkiStatus.forValue(intValue);
                }
                catch (IllegalArgumentException ex) {
                    ret.setFailureMessage("invalid pkiStatus '" + intValue + "'");
                    return ret;
                }
                ret.setPkiStatus(pkiStatus);
                if (pkiStatus == PkiStatus.FAILURE) {
                    FailInfo failInfo;
                    try {
                        intValue = DecodedPkiMessage.getIntegerPrintStringAttrValue(signedAttrs, ScepConstants.ID_FAILINFO);
                    }
                    catch (MessageDecodingException ex) {
                        ret.setFailureMessage("could not parse failInfo: " + ex.getMessage());
                        return ret;
                    }
                    if (intValue == null) {
                        ret.setFailureMessage("missing required SCEP attribute failInfo");
                        return ret;
                    }
                    try {
                        failInfo = FailInfo.forValue(intValue);
                    }
                    catch (IllegalArgumentException ex) {
                        ret.setFailureMessage("invalid failInfo '" + intValue + "'");
                        return ret;
                    }
                    ret.setFailInfo(failInfo);
                    ASN1Encodable value = ScepUtil.getFirstAttrValue(signedAttrs, ScepConstants.ID_SCEP_FAILINFOTEXT);
                    if (value != null) {
                        if (value instanceof ASN1UTF8String) {
                            ret.setFailInfoText(((ASN1UTF8String)value).getString());
                        } else {
                            throw new MessageDecodingException("the value of attribute failInfoText is not UTF8String");
                        }
                    }
                }
            }
            for (Attribute attr : attrs = signedAttrs.toASN1Structure().getAttributes()) {
                ASN1ObjectIdentifier type = attr.getAttrType();
                if (SCEP_ATTR_TYPES.contains(type)) continue;
                ret.addSignendAttribute(type, attr.getAttrValues().getObjectAt(0));
            }
            AttributeTable unsignedAttrs = signerInfo.getUnsignedAttributes();
            Attribute[] attributeArray = attrs = unsignedAttrs == null ? null : unsignedAttrs.toASN1Structure().getAttributes();
            if (attrs != null) {
                for (Attribute attr : attrs) {
                    ASN1ObjectIdentifier type = attr.getAttrType();
                    ret.addUnsignendAttribute(type, attr.getAttrValues().getObjectAt(0));
                }
            }
            try {
                SignAlgo signAlgo;
                HashAlgo digestAlgo = HashAlgo.getInstance((AlgorithmIdentifier)signerInfo.getDigestAlgorithmID());
                ret.setDigestAlgorithm(digestAlgo);
                String sigAlgOid = signerInfo.getEncryptionAlgOID();
                if (!PKCSObjectIdentifiers.rsaEncryption.getId().equals(sigAlgOid) && digestAlgo != (signAlgo = SignAlgo.getInstance((AlgorithmIdentifier)signerInfo.toASN1Structure().getDigestEncryptionAlgorithm())).getHashAlgo()) {
                    ret.setFailureMessage("digestAlgorithm and encryptionAlgorithm do not use the same digestAlgorithm");
                    return ret;
                }
            }
            catch (NoSuchAlgorithmException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex);
                ret.setFailureMessage(ex.getMessage());
                return ret;
            }
            X509CertificateHolder signerCert = (X509CertificateHolder)signedDataCerts.iterator().next();
            ret.setSignatureCert(new X509Cert(signerCert));
            try {
                verifier = new JcaSimpleSignerInfoVerifierBuilder().build(signerCert);
            }
            catch (CertificateException | OperatorCreationException ex) {
                String msg = "could not build signature verifier";
                LogUtil.error((Logger)LOG, (Throwable)ex);
                ret.setFailureMessage("could not build signature verifier: " + ex.getMessage());
                return ret;
            }
            try {
                signatureValid = signerInfo.verify(verifier);
            }
            catch (CMSException ex) {
                String msg = "could not verify the signature";
                LogUtil.error((Logger)LOG, (Throwable)ex);
                ret.setFailureMessage("could not verify the signature: " + ex.getMessage());
                return ret;
            }
            ret.setSignatureValid(signatureValid);
            if (!signatureValid) {
                return ret;
            }
            if (MessageType.CertRep == messageType && pkiStatus == PkiStatus.FAILURE | pkiStatus == PkiStatus.PENDING) {
                return ret;
            }
            CMSTypedData signedContent = pkiMessage.getSignedContent();
            ASN1ObjectIdentifier signedContentType = signedContent.getContentType();
            if (!CMSObjectIdentifiers.envelopedData.equals((ASN1Primitive)signedContentType) && !CMSObjectIdentifiers.data.equals((ASN1Primitive)signedContentType)) {
                ret.setFailureMessage("either id-envelopedData or id-data is excepted, but not '" + signedContentType.getId());
                return ret;
            }
            try {
                envData = new CMSEnvelopedData((byte[])signedContent.getContent());
            }
            catch (CMSException ex) {
                String msg = "could not create the CMSEnvelopedData";
                LogUtil.error((Logger)LOG, (Throwable)ex);
                ret.setFailureMessage("could not create the CMSEnvelopedData: " + ex.getMessage());
                return ret;
            }
            ret.setContentEncryptionAlgorithm(envData.getContentEncryptionAlgorithm().getAlgorithm());
            try {
                encodedMessageData = recipient.decrypt(envData);
            }
            catch (MessageDecodingException ex) {
                String msg = "could not create the CMSEnvelopedData";
                LogUtil.error((Logger)LOG, (Throwable)ex);
                ret.setFailureMessage("could not create the CMSEnvelopedData: " + ex.getMessage());
                ret.setDecryptionSuccessful(false);
                return ret;
            }
            ret.setDecryptionSuccessful(true);
            try {
                if (MessageType.PKCSReq == messageType || MessageType.RenewalReq == messageType) {
                    ret.setMessageData((ASN1Encodable)X509Util.parseCsrInRequest((byte[])encodedMessageData));
                    break block51;
                }
                if (MessageType.CertPoll == messageType) {
                    ret.setMessageData((ASN1Encodable)IssuerAndSubject.getInstance(encodedMessageData));
                    break block51;
                }
                if (MessageType.GetCert == messageType || MessageType.GetCRL == messageType) {
                    ret.setMessageData((ASN1Encodable)IssuerAndSerialNumber.getInstance((Object)encodedMessageData));
                    break block51;
                }
                if (MessageType.CertRep == messageType) {
                    ret.setMessageData((ASN1Encodable)ContentInfo.getInstance((Object)encodedMessageData));
                    break block51;
                }
                throw new RuntimeException("should not reach here, unknown messageType " + messageType);
            }
            catch (Exception ex) {
                String msg = "could not parse the messageData";
                LogUtil.error((Logger)LOG, (Throwable)ex);
                ret.setFailureMessage("could not parse the messageData: " + ex.getMessage());
                return ret;
            }
        }
        return ret;
    }

    private static String getPrintableStringAttrValue(AttributeTable attrs, ASN1ObjectIdentifier type) throws MessageDecodingException {
        ASN1Encodable value = ScepUtil.getFirstAttrValue(attrs, type);
        if (value instanceof ASN1PrintableString) {
            return ((ASN1PrintableString)value).getString();
        }
        if (value != null) {
            throw new MessageDecodingException("the value of attribute " + type.getId() + " is not PrintableString");
        }
        return null;
    }

    private static Integer getIntegerPrintStringAttrValue(AttributeTable attrs, ASN1ObjectIdentifier type) throws MessageDecodingException {
        String str = DecodedPkiMessage.getPrintableStringAttrValue(attrs, type);
        if (str == null) {
            return null;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException ex) {
            throw new MessageDecodingException("invalid integer '" + str + "'");
        }
    }

    private static Nonce getNonceAttrValue(AttributeTable attrs, ASN1ObjectIdentifier type) throws MessageDecodingException {
        ASN1Encodable value = ScepUtil.getFirstAttrValue(attrs, type);
        if (value instanceof ASN1OctetString) {
            byte[] bytes = ((ASN1OctetString)value).getOctets();
            return new Nonce(bytes);
        }
        if (value != null) {
            throw new MessageDecodingException("the value of attribute " + type.getId() + " is not OctetString");
        }
        return null;
    }
}

