/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.scep.message;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.scep.transaction.CaCapability;
import org.xipki.security.HashAlgo;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.StringUtil;

public class CaCaps {
    private static final Logger LOG = LoggerFactory.getLogger(CaCaps.class);
    private byte[] bytes;
    private final Set<CaCapability> capabilities;

    public CaCaps() {
        this.capabilities = new HashSet<CaCapability>();
    }

    public CaCaps(Set<CaCapability> capabilities) {
        this.capabilities = CollectionUtil.isEmpty(capabilities) ? new HashSet<CaCapability>() : new HashSet<CaCapability>(capabilities);
        this.refresh();
    }

    public Set<CaCapability> capabilities() {
        return Collections.unmodifiableSet(this.capabilities);
    }

    public void addCapabilities(CaCapability ... caps) {
        Args.notNull((Object)caps, (String)"caps");
        Collections.addAll(this.capabilities, caps);
        this.refresh();
    }

    public void removeCapabilities(CaCaps caCaps) {
        Args.notNull((Object)caCaps, (String)"caCaps");
        this.capabilities.retainAll(caCaps.capabilities);
        this.refresh();
    }

    public void removeCapabilities(CaCapability ... caps) {
        Args.notNull((Object)caps, (String)"caps");
        for (CaCapability m : caps) {
            this.capabilities.remove((Object)m);
        }
        this.refresh();
    }

    private boolean containsCapability(CaCapability cap) {
        Args.notNull((Object)((Object)cap), (String)"cap");
        return this.capabilities.contains((Object)cap);
    }

    public boolean supportsSHA1() {
        return this.containsCapability(CaCapability.SHA1);
    }

    public boolean supportsSHA512() {
        return this.containsCapability(CaCapability.SHA512);
    }

    public boolean supportsSHA256() {
        return this.containsCapability(CaCapability.SHA256) || this.containsCapability(CaCapability.SCEPStandard);
    }

    public boolean supportsAES() {
        return this.containsCapability(CaCapability.AES) || this.containsCapability(CaCapability.SCEPStandard);
    }

    public boolean supportsDES3() {
        return this.containsCapability(CaCapability.DES3);
    }

    public boolean supportsRenewal() {
        return this.containsCapability(CaCapability.Renewal);
    }

    public boolean supportsGetNextCACert() {
        return this.containsCapability(CaCapability.GetNextCACert);
    }

    public String toString() {
        return this.toScepMessage();
    }

    public int hashCode() {
        return this.toScepMessage().hashCode();
    }

    public String toScepMessage() {
        if (this.capabilities.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (CaCapability cap : this.capabilities) {
            sb.append(cap.getText()).append("\n");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public boolean supportsPost() {
        return this.containsCapability(CaCapability.POSTPKIOperation) || this.containsCapability(CaCapability.SCEPStandard);
    }

    public HashAlgo mostSecureHashAlgo() {
        return this.supportsSHA512() ? HashAlgo.SHA512 : (this.supportsSHA256() ? HashAlgo.SHA256 : HashAlgo.SHA1);
    }

    private void refresh() {
        if (this.capabilities != null) {
            this.bytes = StringUtil.toUtf8Bytes((String)this.toString());
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CaCaps)) {
            return false;
        }
        return this.capabilities.equals(((CaCaps)obj).capabilities);
    }

    public byte[] getBytes() {
        return Arrays.copyOf(this.bytes, this.bytes.length);
    }

    public static CaCaps getInstance(String scepMessage) {
        CaCaps ret = new CaCaps();
        if (StringUtil.isBlank((String)scepMessage)) {
            return ret;
        }
        StringTokenizer st = new StringTokenizer(scepMessage, "\r\n");
        ArrayList<CaCapability> caps = new ArrayList<CaCapability>(st.countTokens());
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            try {
                caps.add(CaCapability.forValue(token));
            }
            catch (IllegalArgumentException ex) {
                LOG.warn("ignore unknown CACap '{}'", (Object)token);
            }
        }
        if (!caps.isEmpty()) {
            ret.addCapabilities(caps.toArray(new CaCapability[0]));
        }
        return ret;
    }
}

