/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway.scep;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.xipki.ca.gateway.conf.ProtocolProxyConf;
import org.xipki.ca.gateway.scep.ScepControl;
import org.xipki.security.util.JSON;
import org.xipki.util.Args;
import org.xipki.util.exception.InvalidConfException;

public class ScepProxyConf
extends ProtocolProxyConf {
    private ScepControl scep;

    public static ScepProxyConf readConfFromFile(String fileName) throws IOException, InvalidConfException {
        Args.notBlank((String)fileName, (String)"fileName");
        try (InputStream is = Files.newInputStream(Paths.get(fileName, new String[0]), new OpenOption[0]);){
            ScepProxyConf conf = (ScepProxyConf)JSON.parseObject((InputStream)is, ScepProxyConf.class);
            conf.validate();
            ScepProxyConf scepProxyConf = conf;
            return scepProxyConf;
        }
    }

    public ScepControl getScep() {
        return this.scep;
    }

    public void setScep(ScepControl scep) {
        this.scep = scep;
    }

    public void validate() throws InvalidConfException {
        super.validate();
        this.notNull((Object)this.signers, "signers");
        this.notNull((Object)this.scep, "scep");
    }
}

