/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway.scep;

import java.security.Key;
import java.security.PrivateKey;
import java.security.interfaces.RSAPublicKey;
import org.xipki.scep.message.EnvelopedDataDecryptor;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.X509Cert;

public class ScepSigner {
    private final PrivateKey key;
    private final X509Cert cert;
    private final EnvelopedDataDecryptor decryptor;

    public ScepSigner(ConcurrentContentSigner signer) {
        Key signingKey = signer.getSigningKey();
        if (!(signingKey instanceof PrivateKey)) {
            throw new IllegalArgumentException("Unsupported signer type: the signing key is not a PrivateKey");
        }
        if (!(signer.getCertificate().getPublicKey() instanceof RSAPublicKey)) {
            throw new IllegalArgumentException("The SCEP responder key is not RSA key");
        }
        this.key = (PrivateKey)signingKey;
        this.cert = signer.getCertificate();
        this.decryptor = new EnvelopedDataDecryptor(new EnvelopedDataDecryptor.EnvelopedDataDecryptorInstance(this.cert, this.key));
    }

    public ScepSigner(PrivateKey key, X509Cert cert, EnvelopedDataDecryptor decryptor) {
        this.key = key;
        this.cert = cert;
        this.decryptor = decryptor;
    }

    public PrivateKey getKey() {
        return this.key;
    }

    public X509Cert getCert() {
        return this.cert;
    }

    public EnvelopedDataDecryptor getDecryptor() {
        return this.decryptor;
    }
}

