/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway.scep.servlet;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.gateway.ProtocolProxyConfWrapper;
import org.xipki.ca.gateway.conf.ProtocolProxyConf;
import org.xipki.ca.gateway.scep.CaNameScepSigners;
import org.xipki.ca.gateway.scep.ScepProxyConf;
import org.xipki.ca.gateway.scep.ScepResponder;
import org.xipki.ca.gateway.scep.servlet.HttpScepServlet;
import org.xipki.util.IoUtil;
import org.xipki.util.StringUtil;
import org.xipki.util.XipkiBaseDir;
import org.xipki.util.exception.InvalidConfException;
import org.xipki.util.exception.ObjectCreationException;

public class ProtocolServletFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(ProtocolServletFilter.class);
    private static final String DFLT_CFG = "etc/scep-gateway.json";
    private HttpScepServlet servlet;
    private ProtocolProxyConfWrapper conf;

    public void init(FilterConfig filterConfig) throws ServletException {
        ScepProxyConf conf0;
        LOG.info("XiPKI SCEP Gateway version {}", (Object)StringUtil.getVersion(this.getClass()));
        XipkiBaseDir.init();
        try {
            conf0 = ScepProxyConf.readConfFromFile((String)IoUtil.expandFilepath((String)DFLT_CFG, (boolean)true));
        }
        catch (IOException | InvalidConfException ex) {
            throw new IllegalArgumentException("could not parse configuration file etc/scep-gateway.json", ex);
        }
        try {
            this.conf = new ProtocolProxyConfWrapper((ProtocolProxyConf)conf0);
            CaNameScepSigners signers = new CaNameScepSigners(this.conf.getSigners());
            ScepResponder responder = new ScepResponder(conf0.getScep(), this.conf.getSdkClient(), this.conf.getSecurities().getSecurityFactory(), signers, this.conf.getAuthenticator(), this.conf.getPopControl());
            this.servlet = new HttpScepServlet();
            this.servlet.setLogReqResp(this.conf.isLogReqResp());
            this.servlet.setResponder(responder);
        }
        catch (InvalidConfException | ObjectCreationException e) {
            String msg = "error initializing ServletFilter";
            LOG.error(msg, e);
            throw new ServletException(msg);
        }
    }

    public void destroy() {
        if (this.conf != null) {
            this.conf.destroy();
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest & response instanceof HttpServletResponse)) {
            throw new ServletException("Only HTTP request is supported");
        }
        this.servlet.service(request, response);
    }
}

