/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway.scep.servlet;

import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.gateway.scep.ScepResponder;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.IoUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.http.HttpResponse;
import org.xipki.util.http.XiHttpRequest;
import org.xipki.util.http.XiHttpResponse;

class ScepHttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(ScepHttpServlet.class);
    private final boolean logReqResp;
    private final ScepResponder responder;

    public ScepHttpServlet(boolean logReqResp, ScepResponder responder) {
        this.logReqResp = logReqResp;
        this.responder = (ScepResponder)Args.notNull((Object)responder, (String)"responder");
    }

    public void service(XiHttpRequest req, XiHttpResponse resp) throws IOException {
        String method = req.getMethod();
        if ("GET".equalsIgnoreCase(method)) {
            this.service0(req, false).fillResponse(resp);
        } else if ("POST".equalsIgnoreCase(method)) {
            this.service0(req, true).fillResponse(resp);
        } else {
            resp.setStatus(405);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse service0(XiHttpRequest req, boolean viaPost) throws IOException {
        HttpResponse httpResponse;
        String path = req.getServletPath();
        byte[] requestBytes = null;
        HttpResponse httpResp = null;
        try {
            requestBytes = viaPost ? IoUtil.readAllBytes((InputStream)req.getInputStream()) : Base64.decode((String)req.getParameter("message"));
            httpResponse = httpResp = this.responder.service(path, requestBytes, req);
        }
        catch (Throwable throwable) {
            LogUtil.logReqResp((String)"SCEP Gateway", (Logger)LOG, (boolean)this.logReqResp, (boolean)viaPost, (String)req.getRequestURI(), (byte[])requestBytes, (byte[])(httpResp == null ? null : httpResp.getBody()));
            throw throwable;
        }
        LogUtil.logReqResp((String)"SCEP Gateway", (Logger)LOG, (boolean)this.logReqResp, (boolean)viaPost, (String)req.getRequestURI(), (byte[])requestBytes, (byte[])(httpResp == null ? null : httpResp.getBody()));
        return httpResponse;
    }
}

