/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.hsmproxy;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.pkcs11.wrapper.PKCS11KeyId;
import org.xipki.pkcs11.wrapper.TokenException;
import org.xipki.security.X509Cert;
import org.xipki.security.XiSecurityException;
import org.xipki.security.pkcs11.P11CryptService;
import org.xipki.security.pkcs11.P11CryptServiceFactory;
import org.xipki.security.pkcs11.P11Key;
import org.xipki.security.pkcs11.P11Module;
import org.xipki.security.pkcs11.P11ModuleConf;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.pkcs11.P11SlotId;
import org.xipki.security.pkcs11.hsmproxy.ProxyAction;
import org.xipki.security.pkcs11.hsmproxy.ProxyMessage;
import org.xipki.security.util.TlsHelper;
import org.xipki.util.Args;
import org.xipki.util.IoUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.StringUtil;
import org.xipki.util.cbor.ByteArrayCborDecoder;
import org.xipki.util.cbor.ByteArrayCborEncoder;
import org.xipki.util.cbor.CborDecoder;
import org.xipki.util.cbor.CborEncoder;
import org.xipki.util.exception.DecodeException;
import org.xipki.util.http.HttpResponse;
import org.xipki.util.http.XiHttpRequest;
import org.xipki.util.http.XiHttpResponse;

public class HsmProxyResponder {
    private static final Logger LOG = LoggerFactory.getLogger(HsmProxyResponder.class);
    private static final String REQUEST_MIMETYPE = "application/x-xipki-pkcs11";
    private static final String RESPONSE_MIMETYPE = "application/x-xipki-pkcs11";
    private static final ProxyMessage NULL_MESSAGE = new ProxyMessage(){

        protected void encode0(CborEncoder encoder) throws IOException {
            encoder.writeNull();
        }
    };
    private final Map<String, P11Module> modules = new HashMap<String, P11Module>();
    private final boolean logReqResp;
    private final String reverseProxyMode;
    private final Set<X509Cert> clientCerts;

    public HsmProxyResponder(boolean logReqResp, String reverseProxyMode, P11CryptServiceFactory p11CryptServiceFactory, Collection<X509Cert> clientCerts) throws XiSecurityException, TokenException {
        this.logReqResp = logReqResp;
        this.reverseProxyMode = reverseProxyMode;
        this.clientCerts = new HashSet<X509Cert>(Args.notEmpty(clientCerts, (String)"clientCerts"));
        Args.notNull((Object)p11CryptServiceFactory, (String)"p11CryptServiceFactory");
        Set moduleNames = p11CryptServiceFactory.getModuleNames();
        for (String moduleName : moduleNames) {
            P11CryptService p11Service = p11CryptServiceFactory.getP11CryptService(moduleName = moduleName.toLowerCase(Locale.ROOT));
            if (p11Service == null) continue;
            if (this.modules.containsKey(moduleName)) {
                throw new XiSecurityException("module for name " + moduleName + " already used, use another module name");
            }
            this.modules.put(moduleName, p11Service.getModule());
            Object msg = "module access path: 'https://<host>:<port>/hp/{}'";
            if ("default".equals(moduleName)) {
                msg = (String)msg + " or 'https://<host>:<port>/hp'";
            }
            LOG.info((String)msg, (Object)moduleName);
        }
    }

    public void service(XiHttpRequest req, XiHttpResponse resp) throws IOException {
        String method = req.getMethod();
        if (!"POST".equalsIgnoreCase(method)) {
            resp.setStatus(405);
            return;
        }
        X509Cert clientCert = TlsHelper.getTlsClientCert((XiHttpRequest)req, (String)this.reverseProxyMode);
        if (clientCert == null || !this.clientCerts.contains(clientCert)) {
            resp.setStatus(401);
            return;
        }
        String path = req.getServletPath();
        byte[] requestBytes = IoUtil.readAllBytes((InputStream)req.getInputStream());
        HttpResponse httpResp = this.service(path, requestBytes, req);
        LogUtil.logReqResp((String)("REST Gateway path=" + req.getServletPath()), (Logger)LOG, (boolean)this.logReqResp, (boolean)true, (String)req.getRequestURI(), (byte[])requestBytes, (byte[])httpResp.getBody());
        httpResp.fillResponse(resp);
    }

    public HttpResponse service(String path, byte[] requestBytes, XiHttpRequest request) {
        try {
            ProxyMessage respMessage;
            String command;
            String moduleName;
            String reqContentType = request.getHeader("Content-Type");
            if (!"application/x-xipki-pkcs11".equalsIgnoreCase(reqContentType)) {
                return new HttpResponse(415);
            }
            String coreUri = path.substring(1);
            String[] tokens = StringUtil.splitAsArray((String)coreUri, (String)"/");
            if (tokens.length == 1) {
                moduleName = "default";
                command = tokens[0];
            } else if (tokens.length == 2) {
                moduleName = tokens[0];
                command = tokens[1];
            } else {
                return new HttpResponse(404);
            }
            P11Module module = this.modules.get(moduleName);
            if (module == null) {
                LOG.warn("found no module named {}", (Object)moduleName);
                return new HttpResponse(404);
            }
            ProxyAction action = ProxyAction.ofNameIgnoreCase((String)command);
            if (action == null) {
                LOG.warn("unknown action {}", (Object)command);
                return new HttpResponse(404);
            }
            try {
                respMessage = this.processRequest(action, module, requestBytes);
            }
            catch (Exception ex) {
                LOG.debug("error while processing request", (Throwable)ex);
                respMessage = new ProxyMessage.ErrorResponse((Throwable)ex);
            }
            ByteArrayCborEncoder cborEncoder = new ByteArrayCborEncoder();
            if (respMessage instanceof ProxyMessage.ErrorResponse) {
                cborEncoder.writeTag(524288L);
                ProxyMessage.ErrorResponse errorResponse = (ProxyMessage.ErrorResponse)respMessage;
                LOG.warn("{} FAILED with {}: {}", new Object[]{action, errorResponse.getErrorCode(), errorResponse.getDetail()});
            } else {
                LOG.info("{} SUCCESSFUL", (Object)action);
            }
            respMessage.encode((CborEncoder)cborEncoder);
            byte[] responseBytes = cborEncoder.toByteArray();
            return new HttpResponse(200, "application/x-xipki-pkcs11", null, responseBytes);
        }
        catch (Throwable th) {
            if (th instanceof EOFException) {
                LogUtil.warn((Logger)LOG, (Throwable)th, (String)"Connection reset by peer");
            } else {
                LOG.error("Throwable thrown, this should not happen!", th);
            }
            return new HttpResponse(500);
        }
    }

    private ProxyMessage processRequest(ProxyAction action, P11Module module, byte[] reqBytes) throws TokenException, DecodeException, IOException {
        Args.notNull((Object)action, (String)"action");
        Args.notNull((Object)module, (String)"module");
        Args.notNull((Object)reqBytes, (String)"reqBytes");
        try (ByteArrayCborDecoder reqDecoder = new ByteArrayCborDecoder(reqBytes);){
            Long id;
            if (reqDecoder.readNullOrArrayLength(2)) {
                ProxyMessage.ErrorResponse errorResponse = new ProxyMessage.ErrorResponse(ProxyMessage.ProxyErrorCode.badRequest, "request shall not be a CBOR null.");
                return errorResponse;
            }
            try {
                id = reqDecoder.readLongObj();
            }
            catch (IOException e) {
                ProxyMessage.ErrorResponse errorResponse = new ProxyMessage.ErrorResponse(ProxyMessage.ProxyErrorCode.badRequest, e.getMessage());
                reqDecoder.close();
                return errorResponse;
            }
            if (action == ProxyAction.moduleCaps) {
                reqDecoder.readNull();
                P11ModuleConf mc = module.getConf();
                ProxyMessage.ModuleCapsResponse moduleCapsResponse = new ProxyMessage.ModuleCapsResponse(module.isReadOnly(), mc.getMaxMessageSize(), mc.getP11NewObjectConf(), mc.getSecretKeyTypes(), mc.getKeyPairTypes());
                return moduleCapsResponse;
            }
            if (action == ProxyAction.slotIds) {
                reqDecoder.readNull();
                List slotIds = module.getSlotIds();
                ProxyMessage.SlotIdsResponse slotIdsResponse = new ProxyMessage.SlotIdsResponse(slotIds);
                return slotIdsResponse;
            }
            if (id == null) {
                ProxyMessage.ErrorResponse slotIds = new ProxyMessage.ErrorResponse(ProxyMessage.ProxyErrorCode.badRequest, "no slot specified");
                return slotIds;
            }
            P11SlotId slotId = module.getSlotIdForId(id.longValue());
            if (slotId == null) {
                ProxyMessage.ErrorResponse errorResponse = new ProxyMessage.ErrorResponse(ProxyMessage.ProxyErrorCode.badRequest, "unknown slot id " + id);
                return errorResponse;
            }
            P11Slot slot = module.getSlot(slotId);
            if (slot == null) {
                ProxyMessage.ErrorResponse errorResponse = new ProxyMessage.ErrorResponse(ProxyMessage.ProxyErrorCode.badRequest, "error finding slot for id " + id);
                return errorResponse;
            }
            switch (action) {
                case destroyAllObjects: {
                    reqDecoder.readNull();
                    int numObjects = slot.destroyAllObjects();
                    ProxyMessage.IntMessage intMessage = new ProxyMessage.IntMessage(numObjects);
                    return intMessage;
                }
                case destroyObjectsByHandle: {
                    ProxyMessage.LongArrayMessage req = ProxyMessage.LongArrayMessage.decode((CborDecoder)reqDecoder);
                    long[] failedHandles = slot.destroyObjectsByHandle(req.getValue());
                    ProxyMessage proxyMessage = failedHandles == null ? NULL_MESSAGE : new ProxyMessage.LongArrayMessage(failedHandles);
                    return proxyMessage;
                }
                case destroyObjectsByIdLabel: {
                    ProxyMessage.IdLabelMessage req = ProxyMessage.IdLabelMessage.decode((CborDecoder)reqDecoder);
                    int numObjects = slot.destroyObjectsByIdLabel(req.getId(), req.getLabel());
                    ProxyMessage.IntMessage intMessage = new ProxyMessage.IntMessage(numObjects);
                    return intMessage;
                }
                case genDSAKeypair: {
                    ProxyMessage.GenerateDSAKeyPairRequest req = ProxyMessage.GenerateDSAKeyPairRequest.decode((CborDecoder)reqDecoder);
                    ProxyMessage numObjects = HsmProxyResponder.toProxyMessage(slot.generateDSAKeypair(req.getP(), req.getQ(), req.getG(), req.getNewKeyControl()));
                    return numObjects;
                }
                case genDSAKeypair2: {
                    ProxyMessage.GenerateDSAKeyPairByKeysizeRequest req = ProxyMessage.GenerateDSAKeyPairByKeysizeRequest.decode((CborDecoder)reqDecoder);
                    ProxyMessage numObjects = HsmProxyResponder.toProxyMessage(slot.generateDSAKeypair(req.getPlength(), req.getQlength(), req.getNewKeyControl()));
                    return numObjects;
                }
                case genECKeypair: {
                    ProxyMessage.GenerateECKeyPairRequest req = ProxyMessage.GenerateECKeyPairRequest.decode((CborDecoder)reqDecoder);
                    ProxyMessage numObjects = HsmProxyResponder.toProxyMessage(slot.generateECKeypair(req.getCurveOid(), req.getNewKeyControl()));
                    return numObjects;
                }
                case genRSAKeypair: {
                    ProxyMessage.GenerateRSAKeyPairRequest req = ProxyMessage.GenerateRSAKeyPairRequest.decode((CborDecoder)reqDecoder);
                    ProxyMessage numObjects = HsmProxyResponder.toProxyMessage(slot.generateRSAKeypair(req.getKeySize(), req.getPublicExponent(), req.getNewKeyControl()));
                    return numObjects;
                }
                case genSM2Keypair: {
                    ProxyMessage.GenerateSM2KeyPairRequest req = ProxyMessage.GenerateSM2KeyPairRequest.decode((CborDecoder)reqDecoder);
                    ProxyMessage numObjects = HsmProxyResponder.toProxyMessage(slot.generateSM2Keypair(req.getNewKeyControl()));
                    return numObjects;
                }
                case genSecretKey: {
                    ProxyMessage.GenerateSecretKeyRequest req = ProxyMessage.GenerateSecretKeyRequest.decode((CborDecoder)reqDecoder);
                    ProxyMessage numObjects = HsmProxyResponder.toProxyMessage(slot.generateSecretKey(req.getKeyType(), req.getKeySize(), req.getNewOKeyControl()));
                    return numObjects;
                }
                case genDSAKeypairOtf: {
                    ProxyMessage.GenerateDSAKeyPairOtfRequest req = ProxyMessage.GenerateDSAKeyPairOtfRequest.decode((CborDecoder)reqDecoder);
                    ProxyMessage numObjects = HsmProxyResponder.toProxyMessage(slot.generateDSAKeypairOtf(req.getP(), req.getQ(), req.getG()));
                    return numObjects;
                }
                case genECKeypairOtf: {
                    ProxyMessage.GenerateECKeyPairOtfRequest req = ProxyMessage.GenerateECKeyPairOtfRequest.decode((CborDecoder)reqDecoder);
                    ProxyMessage numObjects = HsmProxyResponder.toProxyMessage(slot.generateECKeypairOtf(req.getCurveOid()));
                    return numObjects;
                }
                case genRSAKeypairOtf: {
                    ProxyMessage.GenerateRSAKeyPairOtfRequest req = ProxyMessage.GenerateRSAKeyPairOtfRequest.decode((CborDecoder)reqDecoder);
                    ProxyMessage numObjects = HsmProxyResponder.toProxyMessage(slot.generateRSAKeypairOtf(req.getKeySize(), req.getPublicExponent()));
                    return numObjects;
                }
                case genSM2KeypairOtf: {
                    reqDecoder.readNull();
                    ProxyMessage req = HsmProxyResponder.toProxyMessage(slot.generateSM2KeypairOtf());
                    return req;
                }
                case keyByIdLabel: {
                    ProxyMessage.IdLabelMessage req = ProxyMessage.IdLabelMessage.decode((CborDecoder)reqDecoder);
                    ProxyMessage numObjects = HsmProxyResponder.toProxyMessage(slot.getKey(req.getId(), req.getLabel()));
                    return numObjects;
                }
                case keyByKeyId: {
                    ProxyMessage.KeyIdMessage req = ProxyMessage.KeyIdMessage.decode((CborDecoder)reqDecoder);
                    ProxyMessage numObjects = HsmProxyResponder.toProxyMessage(slot.getKey(req.getKeyId()));
                    return numObjects;
                }
                case keyIdByIdLabel: {
                    ProxyMessage.IdLabelMessage req = ProxyMessage.IdLabelMessage.decode((CborDecoder)reqDecoder);
                    ProxyMessage numObjects = HsmProxyResponder.toProxyMessage(slot.getKeyId(req.getId(), req.getLabel()));
                    return numObjects;
                }
                case mechInfos: {
                    reqDecoder.readNull();
                    Map mechanismInfoMap = slot.getMechanisms();
                    ProxyMessage numObjects = mechanismInfoMap == null ? NULL_MESSAGE : new ProxyMessage.GetMechanismInfosResponse(mechanismInfoMap);
                    return numObjects;
                }
                case publicKeyByHandle: {
                    ProxyMessage.LongMessage req = ProxyMessage.LongMessage.decode((CborDecoder)reqDecoder);
                    ProxyMessage numObjects = HsmProxyResponder.toProxyMessage(slot.getPublicKey(req.getValue()).getEncoded());
                    return numObjects;
                }
                case digestSecretKey: {
                    ProxyMessage.DigestSecretKeyRequest req = ProxyMessage.DigestSecretKeyRequest.decode((CborDecoder)reqDecoder);
                    ProxyMessage numObjects = HsmProxyResponder.toProxyMessage(slot.digestSecretKey(req.getMechanism(), req.getObjectHandle()));
                    return numObjects;
                }
                case sign: {
                    ProxyMessage.SignRequest req = ProxyMessage.SignRequest.decode((CborDecoder)reqDecoder);
                    ProxyMessage numObjects = HsmProxyResponder.toProxyMessage(slot.sign(req.getMechanism(), req.getP11params(), req.getExtraParams(), req.getKeyHandle(), req.getContent()));
                    return numObjects;
                }
                case importSecretKey: {
                    ProxyMessage.ImportSecretKeyRequest req = ProxyMessage.ImportSecretKeyRequest.decode((CborDecoder)reqDecoder);
                    ProxyMessage numObjects = HsmProxyResponder.toProxyMessage(slot.importSecretKey(req.getKeyType(), req.getKeyValue(), req.getNewKeyControl()));
                    return numObjects;
                }
                case objectExistsByIdLabel: {
                    ProxyMessage.IdLabelMessage req = ProxyMessage.IdLabelMessage.decode((CborDecoder)reqDecoder);
                    boolean exists = slot.objectExistsByIdLabel(req.getId(), req.getLabel());
                    ProxyMessage.BooleanMessage booleanMessage = new ProxyMessage.BooleanMessage(exists);
                    return booleanMessage;
                }
                case showDetails: {
                    ProxyMessage.ShowDetailsRequest req = ProxyMessage.ShowDetailsRequest.decode((CborDecoder)reqDecoder);
                    ByteArrayOutputStream bout = new ByteArrayOutputStream(2048);
                    try {
                        slot.showDetails((OutputStream)bout, req.getObjectHandle(), req.isVerbose());
                    }
                    catch (IOException ex) {
                        throw new TokenException((Exception)ex);
                    }
                    byte[] bytes = bout.toByteArray();
                    ProxyMessage.ByteArrayMessage byteArrayMessage = new ProxyMessage.ByteArrayMessage(bytes);
                    return byteArrayMessage;
                }
            }
            throw new IllegalStateException("unknown command " + action);
        }
    }

    private static ProxyMessage toProxyMessage(PKCS11KeyId keyId) {
        return keyId == null ? NULL_MESSAGE : new ProxyMessage.KeyIdMessage(keyId);
    }

    private static ProxyMessage toProxyMessage(P11Key key) {
        return key == null ? NULL_MESSAGE : new ProxyMessage.P11KeyResponse(key);
    }

    private static ProxyMessage toProxyMessage(PrivateKeyInfo key) throws IOException {
        return key == null ? NULL_MESSAGE : new ProxyMessage.ByteArrayMessage(key.getEncoded());
    }

    private static ProxyMessage toProxyMessage(byte[] bytes) {
        return bytes == null ? NULL_MESSAGE : new ProxyMessage.ByteArrayMessage(bytes);
    }

    static {
        LOG.info("HSM PKCS#11 proxy version {}", (Object)StringUtil.getBundleVersion(HsmProxyResponder.class));
    }
}

