/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.pkcs11.wrapper;

import iaik.pkcs.pkcs11.wrapper.CK_ATTRIBUTE;
import iaik.pkcs.pkcs11.wrapper.CK_MECHANISM;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPoint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.xipki.pkcs11.wrapper.AttributeVector;
import org.xipki.pkcs11.wrapper.Functions;
import org.xipki.pkcs11.wrapper.KeyPairTemplate;
import org.xipki.pkcs11.wrapper.Mechanism;
import org.xipki.pkcs11.wrapper.PKCS11Constants;
import org.xipki.pkcs11.wrapper.PKCS11Exception;
import org.xipki.pkcs11.wrapper.PKCS11KeyPair;
import org.xipki.pkcs11.wrapper.PKCS11Module;
import org.xipki.pkcs11.wrapper.SessionInfo;
import org.xipki.pkcs11.wrapper.Token;
import org.xipki.pkcs11.wrapper.attrs.Attribute;
import org.xipki.pkcs11.wrapper.attrs.BooleanAttribute;
import org.xipki.pkcs11.wrapper.attrs.ByteArrayAttribute;
import org.xipki.pkcs11.wrapper.attrs.CharArrayAttribute;
import org.xipki.pkcs11.wrapper.attrs.LongAttribute;
import org.xipki.pkcs11.wrapper.attrs.MechanismArrayAttribute;
import org.xipki.pkcs11.wrapper.params.CkMessageParams;
import org.xipki.pkcs11.wrapper.params.CkParams;

public class Session {
    private static final int SIGN_TYPE_ECDSA = 1;
    private static final int SIGN_TYPE_SM2 = 2;
    private final PKCS11Module module;
    private final PKCS11 pkcs11;
    private long sessionHandle;
    protected Token token;
    private final boolean useUtf8;
    private Boolean rwSession = null;
    private int signatureType;
    private long signOrVerifyKeyHandle;
    private final LruCache<Long, byte[]> handleEcParamsMap = new LruCache(1000);

    protected Session(Token token, long sessionHandle) {
        this.token = Functions.requireNonNull("token", token);
        this.module = token.getSlot().getModule();
        this.pkcs11 = this.module.getPKCS11Module();
        this.sessionHandle = sessionHandle;
        this.useUtf8 = token.isUseUtf8Encoding();
    }

    public void initPIN(char[] pin) throws PKCS11Exception {
        this.pkcs11.C_InitPIN(this.sessionHandle, pin, this.useUtf8);
    }

    public void setPIN(char[] oldPin, char[] newPin) throws PKCS11Exception {
        this.pkcs11.C_SetPIN(this.sessionHandle, oldPin, newPin, this.useUtf8);
    }

    public void closeSession() throws PKCS11Exception {
        this.handleEcParamsMap.evictAll();
        this.pkcs11.C_CloseSession(this.sessionHandle);
    }

    public long getSessionHandle() {
        return this.sessionHandle;
    }

    public SessionInfo getSessionInfo() throws PKCS11Exception {
        return new SessionInfo(this.pkcs11.C_GetSessionInfo(this.sessionHandle));
    }

    public void sessionCancel() throws PKCS11Exception {
        long flags = 0L;
        this.pkcs11.C_SessionCancel(this.sessionHandle, flags);
    }

    public PKCS11Module getModule() {
        return this.module;
    }

    public Token getToken() {
        return this.token;
    }

    public byte[] getOperationState() throws PKCS11Exception {
        return this.pkcs11.C_GetOperationState(this.sessionHandle);
    }

    public void setOperationState(byte[] operationState, long encryptionKeyHandle, long authenticationKeyHandle) throws PKCS11Exception {
        this.pkcs11.C_SetOperationState(this.sessionHandle, operationState, encryptionKeyHandle, authenticationKeyHandle);
    }

    public void setSessionHandle(long sessionHandle) {
        this.sessionHandle = sessionHandle;
    }

    public boolean isSetUtf8Encoding() {
        return this.useUtf8;
    }

    public void login(long userType, char[] pin) throws PKCS11Exception {
        this.pkcs11.C_Login(this.sessionHandle, userType, pin, this.useUtf8);
    }

    public void loginUser(long userType, char[] pin, char[] username) throws PKCS11Exception {
        this.pkcs11.C_LoginUser(this.sessionHandle, userType, pin, username, this.useUtf8);
    }

    public void logout() throws PKCS11Exception {
        this.pkcs11.C_Logout(this.sessionHandle);
    }

    public long createObject(AttributeVector template) throws PKCS11Exception {
        return this.pkcs11.C_CreateObject(this.sessionHandle, this.toOutCKAttributes(template), this.useUtf8);
    }

    public long createPrivateKeyObject(AttributeVector template, PublicKey publicKey) throws PKCS11Exception {
        if (publicKey instanceof ECPublicKey && this.privateKeyWithEcPoint(template.keyType())) {
            byte[] ecParams = template.ecParams();
            Integer fieldSize = Functions.getECFieldSize(ecParams);
            ECPoint w = ((ECPublicKey)publicKey).getW();
            byte[] wx = Functions.asUnsignedByteArray(w.getAffineX());
            byte[] wy = Functions.asUnsignedByteArray(w.getAffineY());
            if (fieldSize == null) {
                fieldSize = Math.max(wx.length, wy.length);
            } else if (wx.length > fieldSize || wy.length > fieldSize) {
                throw new IllegalStateException("should not happen, public key and ecParams do not match");
            }
            byte[] ecPoint = new byte[1 + 2 * fieldSize];
            ecPoint[0] = 4;
            System.arraycopy(wx, 0, ecPoint, 1 + fieldSize - wx.length, wx.length);
            System.arraycopy(wy, 0, ecPoint, ecPoint.length - wy.length, wy.length);
            template.ecPoint(ecPoint);
        }
        return this.createObject(template);
    }

    public long createECPrivateKeyObject(AttributeVector template, byte[] ecPoint) throws PKCS11Exception {
        if (ecPoint != null && this.privateKeyWithEcPoint(template.keyType())) {
            template.ecPoint(ecPoint);
        }
        return this.createObject(template);
    }

    private boolean privateKeyWithEcPoint(Long keyType) {
        if (keyType == null) {
            return false;
        }
        if (3L == keyType) {
            return this.module.hasVendorBehaviour(3);
        }
        if (0xFFFFF001L == keyType) {
            return this.module.hasVendorBehaviour(4);
        }
        return false;
    }

    public long copyObject(long sourceObjectHandle, AttributeVector template) throws PKCS11Exception {
        return this.pkcs11.C_CopyObject(this.sessionHandle, sourceObjectHandle, this.toOutCKAttributes(template), this.useUtf8);
    }

    public void setAttributeValues(long objectToUpdateHandle, AttributeVector template) throws PKCS11Exception {
        this.pkcs11.C_SetAttributeValue(this.sessionHandle, objectToUpdateHandle, this.toOutCKAttributes(template), this.useUtf8);
    }

    public void destroyObject(long objectHandle) throws PKCS11Exception {
        this.pkcs11.C_DestroyObject(this.sessionHandle, objectHandle);
    }

    public long getObjectSize(long objectHandle) throws PKCS11Exception {
        return this.pkcs11.C_GetObjectSize(this.sessionHandle, objectHandle);
    }

    public void findObjectsInit(AttributeVector template) throws PKCS11Exception {
        this.pkcs11.C_FindObjectsInit(this.sessionHandle, this.toOutCKAttributes(template, true), this.useUtf8);
    }

    public long[] findObjects(int maxObjectCount) throws PKCS11Exception {
        return this.pkcs11.C_FindObjects(this.sessionHandle, maxObjectCount);
    }

    public void findObjectsFinal() throws PKCS11Exception {
        this.pkcs11.C_FindObjectsFinal(this.sessionHandle);
    }

    public void encryptInit(Mechanism mechanism, long keyHandle) throws PKCS11Exception {
        this.pkcs11.C_EncryptInit(this.sessionHandle, this.toCkMechanism(mechanism), keyHandle, this.useUtf8);
    }

    public byte[] encrypt(byte[] plaintext) throws PKCS11Exception {
        return Session.toNonNull(this.pkcs11.C_Encrypt(this.sessionHandle, plaintext));
    }

    public byte[] encryptUpdate(byte[] plaintextPat) throws PKCS11Exception {
        return Session.toNonNull(this.pkcs11.C_EncryptUpdate(this.sessionHandle, plaintextPat));
    }

    public byte[] encryptFinal() throws PKCS11Exception {
        return Session.toNonNull(this.pkcs11.C_EncryptFinal(this.sessionHandle));
    }

    public void messageEncryptInit(Mechanism mechanism, long keyHandle) throws PKCS11Exception {
        this.pkcs11.C_MessageEncryptInit(this.sessionHandle, this.toCkMechanism(mechanism), keyHandle, this.useUtf8);
    }

    public byte[] encryptMessage(CkParams params, byte[] associatedData, byte[] plaintext) throws PKCS11Exception {
        Object paramObject = this.toCkParameters(params);
        byte[] rv = this.pkcs11.C_EncryptMessage(this.sessionHandle, paramObject, associatedData, plaintext, this.useUtf8);
        if (params instanceof CkMessageParams) {
            ((CkMessageParams)((Object)params)).setValuesFromPKCS11Object(paramObject);
        }
        return Session.toNonNull(rv);
    }

    public void encryptMessageBegin(CkParams params, byte[] associatedData) throws PKCS11Exception {
        this.pkcs11.C_EncryptMessageBegin(this.sessionHandle, this.toCkParameters(params), associatedData, this.useUtf8);
    }

    public byte[] encryptMessageNext(CkParams params, byte[] plaintext, boolean isLastOperation) throws PKCS11Exception {
        Object paramObject = this.toCkParameters(params);
        if (params instanceof CkMessageParams) {
            ((CkMessageParams)((Object)params)).setValuesFromPKCS11Object(paramObject);
        }
        return Session.toNonNull(this.pkcs11.C_EncryptMessageNext(this.sessionHandle, paramObject, plaintext, isLastOperation ? 1L : 0L, this.useUtf8));
    }

    public void messageEncryptFinal() throws PKCS11Exception {
        this.pkcs11.C_MessageEncryptFinal(this.sessionHandle);
    }

    public void decryptInit(Mechanism mechanism, long keyHandle) throws PKCS11Exception {
        this.pkcs11.C_DecryptInit(this.sessionHandle, this.toCkMechanism(mechanism), keyHandle, this.useUtf8);
    }

    public byte[] decrypt(byte[] ciphertext) throws PKCS11Exception {
        return Session.toNonNull(this.pkcs11.C_Decrypt(this.sessionHandle, ciphertext));
    }

    public byte[] decryptUpdate(byte[] ciphertextPart) throws PKCS11Exception {
        return Session.toNonNull(this.pkcs11.C_DecryptUpdate(this.sessionHandle, ciphertextPart));
    }

    public byte[] decryptFinal() throws PKCS11Exception {
        return Session.toNonNull(this.pkcs11.C_DecryptFinal(this.sessionHandle));
    }

    public void messageDecryptInit(Mechanism mechanism, long keyHandle) throws PKCS11Exception {
        this.pkcs11.C_MessageDecryptInit(this.sessionHandle, this.toCkMechanism(mechanism), keyHandle, this.useUtf8);
    }

    public byte[] decryptMessage(CkParams params, byte[] associatedData, byte[] plaintext) throws PKCS11Exception {
        return Session.toNonNull(this.pkcs11.C_DecryptMessage(this.sessionHandle, this.toCkParameters(params), associatedData, plaintext, this.useUtf8));
    }

    public void decryptMessageBegin(CkParams params, byte[] associatedData) throws PKCS11Exception {
        this.pkcs11.C_DecryptMessageBegin(this.sessionHandle, this.toCkParameters(params), associatedData, this.useUtf8);
    }

    public byte[] decryptMessageNext(CkParams params, byte[] ciphertext, boolean isLastOperation) throws PKCS11Exception {
        return Session.toNonNull(this.pkcs11.C_DecryptMessageNext(this.sessionHandle, this.toCkParameters(params), ciphertext, isLastOperation ? 1L : 0L, this.useUtf8));
    }

    public void messageDecryptFinal() throws PKCS11Exception {
        this.pkcs11.C_MessageDecryptFinal(this.sessionHandle);
    }

    public void digestInit(Mechanism mechanism) throws PKCS11Exception {
        this.pkcs11.C_DigestInit(this.sessionHandle, this.toCkMechanism(mechanism), this.useUtf8);
    }

    public byte[] digest(byte[] data) throws PKCS11Exception {
        return Session.toNonNull(this.pkcs11.C_Digest(this.sessionHandle, data));
    }

    public void digestUpdate(byte[] dataPart) throws PKCS11Exception {
        this.pkcs11.C_DigestUpdate(this.sessionHandle, dataPart);
    }

    public void digestKey(long keyHandle) throws PKCS11Exception {
        this.pkcs11.C_DigestKey(this.sessionHandle, keyHandle);
    }

    public byte[] digestFinal() throws PKCS11Exception {
        return Session.toNonNull(this.pkcs11.C_DigestFinal(this.sessionHandle));
    }

    public int digestFinal(byte[] out, int outOfs, int outLen) throws PKCS11Exception {
        byte[] digest = this.pkcs11.C_DigestFinal(this.sessionHandle);
        if (digest.length > outLen) {
            throw new PKCS11Exception(336L);
        }
        System.arraycopy(digest, 0, out, outOfs, digest.length);
        return digest.length;
    }

    public void signInit(Mechanism mechanism, long keyHandle) throws PKCS11Exception {
        this.initSignVerify(mechanism, keyHandle);
        this.pkcs11.C_SignInit(this.sessionHandle, this.toCkMechanism(mechanism), keyHandle, this.useUtf8);
    }

    private void initSignVerify(Mechanism mechanism, long keyHandle) {
        this.signOrVerifyKeyHandle = keyHandle;
        long code = mechanism.getMechanismCode();
        this.signatureType = code == 4161L || code == 4162L || code == 4163L || code == 4164L || code == 4165L || code == 4166L || code == 4167L || code == 4168L || code == 4169L || code == 4170L ? 1 : (code == 0xFFFFF002L || code == 0xFFFFF003L ? 2 : 0);
    }

    public byte[] sign(byte[] data) throws PKCS11Exception {
        byte[] sigValue = this.pkcs11.C_Sign(this.sessionHandle, data);
        return Session.toNonNull(this.fixSignOutput(sigValue));
    }

    public void signUpdate(byte[] dataPart) throws PKCS11Exception {
        this.pkcs11.C_SignUpdate(this.sessionHandle, dataPart);
    }

    public void signUpdate(byte[] in, int inOfs, int inLen) throws PKCS11Exception {
        if (inOfs == 0 && inLen == in.length) {
            this.pkcs11.C_SignUpdate(this.sessionHandle, in);
        } else {
            this.pkcs11.C_SignUpdate(this.sessionHandle, Arrays.copyOfRange(in, inOfs, inOfs + inLen));
        }
    }

    public byte[] signFinal() throws PKCS11Exception {
        byte[] sigValue = this.pkcs11.C_SignFinal(this.sessionHandle);
        return Session.toNonNull(this.fixSignOutput(sigValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] fixSignOutput(byte[] signatureValue) {
        if (this.signatureType == 0) {
            return signatureValue;
        }
        PKCS11Module pKCS11Module = this.module;
        synchronized (pKCS11Module) {
            Boolean b;
            if (this.signatureType == 1) {
                Boolean b2 = this.module.getEcdsaSignatureFixNeeded();
                if (b2 == null || b2.booleanValue()) {
                    byte[] ecParams = this.handleEcParamsMap.get(this.signOrVerifyKeyHandle);
                    if (ecParams == null) {
                        try {
                            ecParams = this.getByteArrayAttrValue(this.signOrVerifyKeyHandle, 384L);
                        }
                        catch (PKCS11Exception e) {
                            return signatureValue;
                        }
                        if (ecParams != null) {
                            this.handleEcParamsMap.put(this.signOrVerifyKeyHandle, ecParams);
                        }
                    }
                    if (ecParams != null) {
                        boolean fixed;
                        byte[] fixedSigValue = Functions.fixECDSASignature(signatureValue, ecParams);
                        boolean bl = fixed = !Arrays.equals(fixedSigValue, signatureValue);
                        if (b2 == null) {
                            this.module.setEcdsaSignatureFixNeeded(fixed);
                        }
                        return fixedSigValue;
                    }
                }
            } else if (this.signatureType == 2 && ((b = this.module.getSm2SignatureFixNeeded()) == null || b.booleanValue())) {
                boolean fixed;
                byte[] fixedSigValue = Functions.fixECDSASignature(signatureValue, 32);
                boolean bl = fixed = !Arrays.equals(fixedSigValue, signatureValue);
                if (b == null) {
                    this.module.setSm2SignatureFixNeeded(fixed);
                }
                return fixedSigValue;
            }
            return signatureValue;
        }
    }

    private byte[] fixSignatureToVerify(byte[] signatureValue) {
        if (this.signatureType == 1 ? this.module.hasVendorBehaviour(1) : this.signatureType == 2 && this.module.hasVendorBehaviour(2)) {
            return Functions.toX962DSASignature(signatureValue);
        }
        return signatureValue;
    }

    public void signRecoverInit(Mechanism mechanism, long keyHandle) throws PKCS11Exception {
        this.pkcs11.C_SignRecoverInit(this.sessionHandle, this.toCkMechanism(mechanism), keyHandle, this.useUtf8);
    }

    public byte[] signRecover(byte[] data) throws PKCS11Exception {
        return Session.toNonNull(this.pkcs11.C_SignRecover(this.sessionHandle, data));
    }

    public void messageSignInit(Mechanism mechanism, long keyHandle) throws PKCS11Exception {
        this.initSignVerify(mechanism, keyHandle);
        this.pkcs11.C_MessageSignInit(this.sessionHandle, this.toCkMechanism(mechanism), keyHandle, this.useUtf8);
    }

    public byte[] signMessage(CkParams params, byte[] data) throws PKCS11Exception {
        return Session.toNonNull(this.pkcs11.C_SignMessage(this.sessionHandle, this.toCkParameters(params), data, this.useUtf8));
    }

    public void signMessageBegin(CkParams params) throws PKCS11Exception {
        this.pkcs11.C_SignMessageBegin(this.sessionHandle, this.toCkParameters(params), this.useUtf8);
    }

    public byte[] signMessageNext(CkParams params, byte[] data, boolean isLastOperation) throws PKCS11Exception {
        byte[] signature = this.pkcs11.C_SignMessageNext(this.sessionHandle, this.toCkParameters(params), data, isLastOperation, this.useUtf8);
        return Session.toNonNull(this.fixSignOutput(signature));
    }

    public void messageSignFinal() throws PKCS11Exception {
        this.pkcs11.C_MessageSignFinal(this.sessionHandle);
    }

    public void verifyInit(Mechanism mechanism, long keyHandle) throws PKCS11Exception {
        this.initSignVerify(mechanism, keyHandle);
        this.pkcs11.C_VerifyInit(this.sessionHandle, this.toCkMechanism(mechanism), keyHandle, this.useUtf8);
    }

    public void verify(byte[] data, byte[] signature) throws PKCS11Exception {
        this.pkcs11.C_Verify(this.sessionHandle, data, this.fixSignatureToVerify(signature));
    }

    public void verifyUpdate(byte[] dataPart) throws PKCS11Exception {
        this.pkcs11.C_VerifyUpdate(this.sessionHandle, dataPart);
    }

    public void verifyFinal(byte[] signature) throws PKCS11Exception {
        this.pkcs11.C_VerifyFinal(this.sessionHandle, this.fixSignatureToVerify(signature));
    }

    public void verifyRecoverInit(Mechanism mechanism, long keyHandle) throws PKCS11Exception {
        this.pkcs11.C_VerifyRecoverInit(this.sessionHandle, this.toCkMechanism(mechanism), keyHandle, this.useUtf8);
    }

    public byte[] verifyRecover(byte[] data) throws PKCS11Exception {
        return Session.toNonNull(this.pkcs11.C_VerifyRecover(this.sessionHandle, data));
    }

    public void messageVerifyInit(Mechanism mechanism, long keyHandle) throws PKCS11Exception {
        this.initSignVerify(mechanism, keyHandle);
        this.pkcs11.C_MessageVerifyInit(this.sessionHandle, this.toCkMechanism(mechanism), keyHandle, this.useUtf8);
    }

    public void verifyMessage(CkParams params, byte[] data, byte[] signature) throws PKCS11Exception {
        this.pkcs11.C_VerifyMessage(this.sessionHandle, this.toCkParameters(params), data, this.fixSignatureToVerify(signature), this.useUtf8);
    }

    public void verifyMessageBegin(CkParams params) throws PKCS11Exception {
        this.pkcs11.C_VerifyMessageBegin(this.sessionHandle, this.toCkParameters(params), this.useUtf8);
    }

    public void verifyMessageNext(CkParams params, byte[] data, byte[] signature) throws PKCS11Exception {
        this.pkcs11.C_VerifyMessageNext(this.sessionHandle, this.toCkParameters(params), data, this.fixSignatureToVerify(signature), this.useUtf8);
    }

    public void messageVerifyFinal() throws PKCS11Exception {
        this.pkcs11.C_MessageVerifyFinal(this.sessionHandle);
    }

    public byte[] digestEncryptedUpdate(byte[] part) throws PKCS11Exception {
        return Session.toNonNull(this.pkcs11.C_DigestEncryptUpdate(this.sessionHandle, part));
    }

    public byte[] decryptDigestUpdate(byte[] part) throws PKCS11Exception {
        return Session.toNonNull(this.pkcs11.C_DecryptDigestUpdate(this.sessionHandle, part));
    }

    public byte[] signEncryptUpdate(byte[] part) throws PKCS11Exception {
        return Session.toNonNull(this.pkcs11.C_SignEncryptUpdate(this.sessionHandle, part));
    }

    public byte[] decryptVerifyUpdate(byte[] encryptedPart) throws PKCS11Exception {
        return Session.toNonNull(this.pkcs11.C_DecryptVerifyUpdate(this.sessionHandle, encryptedPart));
    }

    public long generateKey(Mechanism mechanism, AttributeVector template) throws PKCS11Exception {
        return this.pkcs11.C_GenerateKey(this.sessionHandle, this.toCkMechanism(mechanism), this.toOutCKAttributes(template), this.useUtf8);
    }

    public PKCS11KeyPair generateKeyPair(Mechanism mechanism, KeyPairTemplate template) throws PKCS11Exception {
        template.id();
        long[] objectHandles = this.pkcs11.C_GenerateKeyPair(this.sessionHandle, this.toCkMechanism(mechanism), this.toOutCKAttributes(template.publicKey()), this.toOutCKAttributes(template.privateKey()), this.useUtf8);
        return new PKCS11KeyPair(objectHandles[0], objectHandles[1]);
    }

    public byte[] wrapKey(Mechanism mechanism, long wrappingKeyHandle, long keyHandle) throws PKCS11Exception {
        return Session.toNonNull(this.pkcs11.C_WrapKey(this.sessionHandle, this.toCkMechanism(mechanism), wrappingKeyHandle, keyHandle, this.useUtf8));
    }

    public long unwrapKey(Mechanism mechanism, long unwrappingKeyHandle, byte[] wrappedKey, AttributeVector keyTemplate) throws PKCS11Exception {
        return this.pkcs11.C_UnwrapKey(this.sessionHandle, this.toCkMechanism(mechanism), unwrappingKeyHandle, wrappedKey, this.toOutCKAttributes(keyTemplate), this.useUtf8);
    }

    public long deriveKey(Mechanism mechanism, long baseKeyHandle, AttributeVector template) throws PKCS11Exception {
        return this.pkcs11.C_DeriveKey(this.sessionHandle, this.toCkMechanism(mechanism), baseKeyHandle, this.toOutCKAttributes(template), this.useUtf8);
    }

    public void seedRandom(byte[] seed) throws PKCS11Exception {
        this.pkcs11.C_SeedRandom(this.sessionHandle, seed);
    }

    public byte[] generateRandom(int numberOfBytesToGenerate) throws PKCS11Exception {
        byte[] randomBytesBuffer = new byte[numberOfBytesToGenerate];
        this.pkcs11.C_GenerateRandom(this.sessionHandle, randomBytesBuffer);
        return randomBytesBuffer;
    }

    public void getFunctionStatus() throws PKCS11Exception {
        this.pkcs11.C_GetFunctionStatus(this.sessionHandle);
    }

    public void cancelFunction() throws PKCS11Exception {
        this.pkcs11.C_CancelFunction(this.sessionHandle);
    }

    public boolean isRwSession() throws PKCS11Exception {
        if (this.rwSession == null) {
            this.rwSession = this.getSessionInfo().isRwSession();
        }
        return this.rwSession;
    }

    public String toString() {
        return "Session Handle: 0x" + Long.toHexString(this.sessionHandle) + "\nToken: " + this.token;
    }

    private CK_MECHANISM toCkMechanism(Mechanism mechanism) {
        CK_MECHANISM ckMechanism = mechanism.toCkMechanism();
        long code = ckMechanism.mechanism;
        if ((code & 0x80000000L) != 0L) {
            ckMechanism.mechanism = this.module.ckmGenericToVendor(code);
        }
        return ckMechanism;
    }

    private Object toCkParameters(CkParams params) {
        return params == null ? null : params.getParams();
    }

    public Integer getIntAttrValue(long objectHandle, long attributeType) throws PKCS11Exception {
        Long value = this.getLongAttrValue(objectHandle, attributeType);
        return value == null ? null : Integer.valueOf(value.intValue());
    }

    public Long getLongAttrValue(long objectHandle, long attributeType) throws PKCS11Exception {
        LongAttribute attr = new LongAttribute(attributeType);
        this.doGetAttrValue(objectHandle, attr);
        return attr.getValue();
    }

    public String getStringAttrValue(long objectHandle, long attributeType) throws PKCS11Exception {
        CharArrayAttribute attr = new CharArrayAttribute(attributeType);
        this.doGetAttrValue(objectHandle, attr);
        return attr.getValue();
    }

    public BigInteger getBigIntAttrValue(long objectHandle, long attributeType) throws PKCS11Exception {
        byte[] value = this.getByteArrayAttrValue(objectHandle, attributeType);
        return value == null ? null : new BigInteger(1, value);
    }

    public byte[] getByteArrayAttrValue(long objectHandle, long attributeType) throws PKCS11Exception {
        ByteArrayAttribute attr = new ByteArrayAttribute(attributeType);
        this.doGetAttrValue(objectHandle, attr);
        return attr.getValue();
    }

    public Boolean getBooleanAttrValue(long objectHandle, long attributeType) throws PKCS11Exception {
        BooleanAttribute attr = new BooleanAttribute(attributeType);
        this.doGetAttrValue(objectHandle, attr);
        return attr.getValue();
    }

    public String getCkaLabel(long objectHandle) throws PKCS11Exception {
        return this.getStringAttrValue(objectHandle, 3L);
    }

    public byte[] getCkaId(long objectHandle) throws PKCS11Exception {
        return this.getByteArrayAttrValue(objectHandle, 258L);
    }

    public Long getCkaClass(long objectHandle) throws PKCS11Exception {
        return this.getLongAttrValue(objectHandle, 0L);
    }

    public Long getCkaKeyType(long objectHandle) throws PKCS11Exception {
        return this.getLongAttrValue(objectHandle, 256L);
    }

    public Long getCkaCertificateType(long objectHandle) throws PKCS11Exception {
        return this.getLongAttrValue(objectHandle, 128L);
    }

    public Object getAttrValue(long objectHandle, long attributeType) throws PKCS11Exception {
        Attribute attr = Attribute.getInstance(attributeType);
        this.doGetAttrValue(objectHandle, attr);
        return attr.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeVector getAttrValues(long objectHandle, long ... attributeTypes) throws PKCS11Exception {
        ArrayList<Long> typeList = new ArrayList<Long>(attributeTypes.length);
        for (long attrType : attributeTypes) {
            typeList.add(attrType);
        }
        if (typeList.contains(385L) && !typeList.contains(384L)) {
            PKCS11Module pKCS11Module = this.module;
            synchronized (pKCS11Module) {
                Boolean b = this.module.getEcPointFixNeeded();
                if (b == null || b.booleanValue()) {
                    typeList.add(384L);
                }
            }
        }
        Attribute[] attributeArray = new Attribute[typeList.size()];
        int index = 0;
        long[] firstTypes = new long[]{0L, 256L, 384L, 385L};
        for (long type : firstTypes) {
            if (!typeList.remove(type)) continue;
            attributeArray[index++] = Attribute.getInstance(type);
        }
        Object object = typeList.iterator();
        while (object.hasNext()) {
            long type = (Long)object.next();
            attributeArray[index++] = Attribute.getInstance(type);
        }
        this.doGetAttrValues(objectHandle, attributeArray);
        return new AttributeVector(attributeArray);
    }

    private void doGetAttrValues(long objectHandle, Attribute ... attributes) throws PKCS11Exception {
        Functions.requireNonNull("attributes", attributes);
        if (attributes.length == 1) {
            this.doGetAttrValue(objectHandle, attributes[0]);
            return;
        }
        CK_ATTRIBUTE[] attributeTemplateList = new CK_ATTRIBUTE[attributes.length];
        for (int i = 0; i < attributes.length; ++i) {
            attributeTemplateList[i] = new CK_ATTRIBUTE();
            attributeTemplateList[i].type = attributes[i].getType();
        }
        PKCS11Exception delayedEx = null;
        try {
            this.pkcs11.C_GetAttributeValue(this.sessionHandle, objectHandle, attributeTemplateList, this.useUtf8);
        }
        catch (PKCS11Exception ex) {
            delayedEx = ex;
        }
        for (int i = 0; i < attributes.length; ++i) {
            Attribute attribute = attributes[i];
            CK_ATTRIBUTE template = attributeTemplateList[i];
            if (template == null) continue;
            attribute.present(true).sensitive(false).ckAttribute(template);
        }
        if (delayedEx != null) {
            delayedEx = null;
            for (Attribute attr : attributes) {
                if (attr.getCkAttribute() != null && attr.getCkAttribute().pValue != null) continue;
                try {
                    this.doGetAttrValue0(objectHandle, attr, false);
                }
                catch (PKCS11Exception ex) {
                    if (delayedEx != null) continue;
                    delayedEx = ex;
                }
            }
        }
        for (Attribute attr : attributes) {
            this.postProcessGetAttribute(attr, objectHandle, attributes);
        }
        if (delayedEx != null) {
            throw delayedEx;
        }
    }

    private void doGetAttrValue(long objectHandle, Attribute attribute) throws PKCS11Exception {
        Boolean b;
        if (attribute.getType() == 385L && ((b = this.module.getEcPointFixNeeded()) == null || b.booleanValue())) {
            this.doGetAttrValues(objectHandle, new ByteArrayAttribute(384L), attribute);
            return;
        }
        this.doGetAttrValue0(objectHandle, attribute, true);
    }

    private void doGetAttrValue0(long objectHandle, Attribute attribute, boolean postProcess) throws PKCS11Exception {
        attribute.present(false);
        try {
            CK_ATTRIBUTE[] attributeTemplateList = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE()};
            attributeTemplateList[0].type = attribute.getType();
            this.pkcs11.C_GetAttributeValue(this.sessionHandle, objectHandle, attributeTemplateList, this.useUtf8);
            attribute.ckAttribute(attributeTemplateList[0]).present(true).sensitive(false);
        }
        catch (PKCS11Exception ex) {
            long ec = ex.getErrorCode();
            if (ec == 18L) {
                if (attribute.getType() == 384L) {
                    attribute.present((boolean)false).getCkAttribute().pValue = null;
                }
            }
            if (ec == 17L) {
                attribute.getCkAttribute().pValue = null;
                attribute.present((boolean)true).sensitive((boolean)true).getCkAttribute().pValue = null;
            }
            if (ec == 7L || ec == 6L || ec == 512L) {
                attribute.present((boolean)false).sensitive((boolean)false).getCkAttribute().pValue = null;
            }
            throw ex;
        }
        if (postProcess) {
            this.postProcessGetAttribute(attribute, objectHandle, new Attribute[0]);
        }
    }

    private CK_ATTRIBUTE[] toOutCKAttributes(AttributeVector template) {
        return this.toOutCKAttributes(template, false);
    }

    private CK_ATTRIBUTE[] toOutCKAttributes(AttributeVector template, boolean withoutNullValueAttr) {
        if (template == null) {
            return null;
        }
        CK_ATTRIBUTE[] ckAttrs = template.toCkAttributes();
        ArrayList<CK_ATTRIBUTE> nonNullCkAttrs = null;
        if (withoutNullValueAttr) {
            nonNullCkAttrs = new ArrayList<CK_ATTRIBUTE>(ckAttrs.length);
        }
        for (CK_ATTRIBUTE ckAttr : ckAttrs) {
            if (ckAttr.pValue == null) continue;
            if (withoutNullValueAttr) {
                nonNullCkAttrs.add(ckAttr);
            }
            if (ckAttr.type == 256L) {
                long value = (Long)ckAttr.pValue;
                if ((value & 0x80000000L) == 0L) continue;
                ckAttr.pValue = this.module.ckkGenericToVendor(value);
                continue;
            }
            if (ckAttr.type != 385L) continue;
            ckAttr.pValue = Functions.toOctetString((byte[])ckAttr.pValue);
        }
        return nonNullCkAttrs != null && nonNullCkAttrs.size() != ckAttrs.length ? nonNullCkAttrs.toArray(new CK_ATTRIBUTE[0]) : ckAttrs;
    }

    private void postProcessGetAttribute(Attribute attr, long objectHandle, Attribute ... otherAttrs) {
        long type = attr.getType();
        CK_ATTRIBUTE ckAttr = attr.getCkAttribute();
        if (type == 384L) {
            if (ckAttr.pValue == null) {
                Long keyType = null;
                if (otherAttrs != null) {
                    for (Attribute otherAttr : otherAttrs) {
                        if (otherAttr.type() != 256L) continue;
                        keyType = ((LongAttribute)otherAttr).getValue();
                    }
                }
                if (keyType == null) {
                    try {
                        keyType = this.getCkaKeyType(objectHandle);
                    }
                    catch (PKCS11Exception pKCS11Exception) {
                        // empty catch block
                    }
                }
                if (keyType != null && keyType == 0xFFFFF001L) {
                    attr.present((boolean)false).getCkAttribute().pValue = Functions.decodeHex("06082a811ccf5501822d");
                }
            } else {
                byte[] ecParams = (byte[])ckAttr.pValue;
                if (ecParams[0] != 6) {
                    ckAttr.pValue = Functions.fixECParams((byte[])ckAttr.pValue);
                }
            }
            return;
        }
        if (ckAttr == null || ckAttr.pValue == null) {
            return;
        }
        if (type == 256L) {
            long value = (Long)ckAttr.pValue;
            if ((value & 0x80000000L) != 0L && !PKCS11Constants.isUnavailableInformation(value)) {
                ckAttr.pValue = this.module.ckkVendorToGeneric(value);
            }
        } else if (type == 358L) {
            long value = (Long)ckAttr.pValue;
            if ((value & 0x80000000L) != 0L && !PKCS11Constants.isUnavailableInformation(value)) {
                ckAttr.pValue = this.module.ckmVendorToGeneric(value);
            }
        } else if (type == 0x40000600L) {
            long[] mechs;
            for (long mech : mechs = ((MechanismArrayAttribute)attr).getValue()) {
                if ((mech & 0x80000000L) == 0L) continue;
                ckAttr.pValue = this.module.ckmVendorToGeneric(mech);
            }
        } else if (type == 385L) {
            Boolean b = this.module.getEcPointFixNeeded();
            byte[] pValue = (byte[])ckAttr.pValue;
            if (b == null || b.booleanValue()) {
                byte[] ecParams = null;
                if (otherAttrs != null) {
                    for (Attribute otherAttr : otherAttrs) {
                        if (otherAttr.getType() != 384L) continue;
                        ecParams = ((ByteArrayAttribute)otherAttr).getValue();
                        break;
                    }
                }
                byte[] fixedCoreEcPoint = Functions.getCoreECPoint(pValue, ecParams);
                if (b == null) {
                    byte[] coreEcPoint = Functions.getCoreECPoint(pValue);
                    this.module.setEcPointFixNeeded(!Arrays.equals(coreEcPoint, fixedCoreEcPoint));
                }
                ckAttr.pValue = fixedCoreEcPoint;
            } else {
                ckAttr.pValue = Functions.getCoreECPoint(pValue);
            }
        } else if (attr instanceof BooleanAttribute && ckAttr.pValue instanceof byte[]) {
            byte[] value = (byte[])ckAttr.pValue;
            boolean allZeros = true;
            for (byte b : value) {
                if (b == 0) continue;
                allZeros = false;
                break;
            }
            ckAttr.pValue = !allZeros;
        }
    }

    private static byte[] toNonNull(byte[] bytes) {
        return bytes == null ? new byte[]{} : bytes;
    }

    private static class LruCache<K, V> {
        private final LinkedHashMap<K, V> map;
        private int size;
        private final int maxSize;

        public LruCache(int maxSize) {
            if (maxSize < 0) {
                throw new IllegalArgumentException("maxSize is not positive: " + maxSize);
            }
            this.maxSize = maxSize;
            this.map = new LinkedHashMap(0, 0.75f, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final V get(K key) {
            if (key == null) {
                throw new NullPointerException("key == null");
            }
            LruCache lruCache = this;
            synchronized (lruCache) {
                V mapValue = this.map.get(key);
                if (mapValue != null) {
                    return mapValue;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final V put(K key, V value) {
            V previous;
            if (key == null || value == null) {
                throw new NullPointerException("key == null || value == null");
            }
            LruCache lruCache = this;
            synchronized (lruCache) {
                ++this.size;
                previous = this.map.put(key, value);
                if (previous != null) {
                    --this.size;
                }
            }
            this.trimToSize(this.maxSize);
            return previous;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void trimToSize(int maxSize) {
            while (true) {
                LruCache lruCache = this;
                synchronized (lruCache) {
                    if (this.size < 0 || this.map.isEmpty() && this.size != 0) {
                        throw new IllegalStateException(this.getClass().getName() + ".sizeOf() is reporting inconsistent results!");
                    }
                    if (this.size <= maxSize || this.map.isEmpty()) {
                        break;
                    }
                    Map.Entry<K, V> toEvict = this.map.entrySet().iterator().next();
                    K key = toEvict.getKey();
                    this.map.remove(key);
                    --this.size;
                }
            }
        }

        public final void evictAll() {
            this.trimToSize(-1);
        }
    }
}

