/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.pkcs11.wrapper;

import org.xipki.pkcs11.wrapper.Functions;
import org.xipki.pkcs11.wrapper.MechanismInfo;
import org.xipki.pkcs11.wrapper.PKCS11Exception;
import org.xipki.pkcs11.wrapper.PKCS11Module;
import org.xipki.pkcs11.wrapper.Session;
import org.xipki.pkcs11.wrapper.Slot;
import org.xipki.pkcs11.wrapper.TokenInfo;

public class Token {
    private final Slot slot;
    private final boolean useUtf8Encoding;

    protected Token(Slot slot) {
        this.slot = Functions.requireNonNull("slot", slot);
        this.useUtf8Encoding = slot.isUseUtf8Encoding();
    }

    public Slot getSlot() {
        return this.slot;
    }

    public boolean isUseUtf8Encoding() {
        return this.useUtf8Encoding;
    }

    public long getTokenID() {
        return this.slot.getSlotID();
    }

    public TokenInfo getTokenInfo() throws PKCS11Exception {
        return new TokenInfo(this.slot.getModule().getPKCS11Module().C_GetTokenInfo(this.slot.getSlotID()));
    }

    public long[] getMechanismList() throws PKCS11Exception {
        PKCS11Module module = this.slot.getModule();
        long[] mechanisms = module.getPKCS11Module().C_GetMechanismList(this.slot.getSlotID());
        for (int i = 0; i < mechanisms.length; ++i) {
            long code = mechanisms[i];
            if ((code & 0x80000000L) == 0L) continue;
            mechanisms[i] = module.ckmVendorToGeneric(code);
        }
        return mechanisms;
    }

    public MechanismInfo getMechanismInfo(long mechanism) throws PKCS11Exception {
        if ((mechanism & 0x80000000L) != 0L) {
            mechanism = this.slot.getModule().ckmGenericToVendor(mechanism);
        }
        return new MechanismInfo(this.slot.getModule().getPKCS11Module().C_GetMechanismInfo(this.slot.getSlotID(), mechanism));
    }

    public Session openSession(boolean rwSession) throws PKCS11Exception {
        return this.openSession(rwSession, null);
    }

    public Session openSession(boolean rwSession, Object application) throws PKCS11Exception {
        long flags = rwSession ? 6L : 4L;
        long sessionHandle = this.slot.getModule().getPKCS11Module().C_OpenSession(this.slot.getSlotID(), flags, application, null);
        return new Session(this, sessionHandle);
    }

    public String toString() {
        return "Token in Slot: " + this.slot;
    }
}

