/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.pkcs11.wrapper;

import iaik.pkcs.pkcs11.wrapper.CK_MECHANISM;
import org.xipki.pkcs11.wrapper.PKCS11Constants;
import org.xipki.pkcs11.wrapper.params.CkParams;

public class Mechanism {
    private final long mechanismCode;
    private final CkParams parameters;

    public Mechanism(long mechanismCode) {
        this(mechanismCode, null);
    }

    public Mechanism(long mechanismCode, CkParams parameters) {
        this.mechanismCode = mechanismCode;
        this.parameters = parameters;
    }

    public CkParams getParameters() {
        return this.parameters;
    }

    public long getMechanismCode() {
        return this.mechanismCode;
    }

    public String getName() {
        return PKCS11Constants.ckmCodeToName(this.mechanismCode);
    }

    CK_MECHANISM toCkMechanism() {
        CK_MECHANISM ckMechanism = new CK_MECHANISM();
        ckMechanism.mechanism = this.mechanismCode;
        if (this.parameters != null) {
            ckMechanism.pParameter = this.parameters.getParams();
        }
        return ckMechanism;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        return indent + "Mechanism: " + this.getName() + "\n" + indent + "Parameters:" + (this.parameters == null ? " null" : "\n" + this.parameters.toString(indent + "  "));
    }
}

