/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.pkcs11.wrapper;

import java.math.BigInteger;
import java.util.Objects;
import org.xipki.pkcs11.wrapper.AttributeVector;
import org.xipki.pkcs11.wrapper.Functions;
import org.xipki.pkcs11.wrapper.PKCS11KeyId;

public class PKCS11Key {
    protected final PKCS11KeyId id;
    private final Boolean sign;
    private final Boolean verify;
    private final Boolean encrypt;
    private final Boolean decrypt;
    private final Boolean derive;
    private final Boolean signRecover;
    private final Boolean verifyRecover;
    private final Boolean wrap;
    private final Boolean unwrap;
    private final Boolean extractable;
    private final Boolean neverExtractable;
    private final Boolean private_;
    private final Boolean wrapWithTrusted;
    private final Boolean sensitive;
    private final Boolean alwaysSensitive;
    private final Boolean trusted;
    private final Integer valueLen;
    private final byte[] ecParams;
    private final Integer ecOrderBitSize;
    private final byte[] ecPublicPoint;
    private final BigInteger rsaModulus;
    private final BigInteger rsaPublicExponent;
    private final BigInteger dsaPrime;
    private final BigInteger dsaSubprime;
    private final BigInteger dsaBase;

    PKCS11Key(PKCS11KeyId id, AttributeVector attrs) {
        this.id = Objects.requireNonNull(id, "id must not be null");
        this.decrypt = attrs.decrypt();
        this.encrypt = attrs.encrypt();
        this.sign = attrs.sign();
        this.verify = attrs.verify();
        this.signRecover = attrs.signRecover();
        this.verifyRecover = attrs.verifyRecover();
        this.wrap = attrs.wrap();
        this.unwrap = attrs.unwrap();
        this.derive = attrs.derive();
        this.sensitive = attrs.sensitive();
        this.alwaysSensitive = attrs.alwaysSensitive();
        this.extractable = attrs.extractable();
        this.neverExtractable = attrs.neverExtractable();
        this.private_ = attrs.private_();
        this.trusted = attrs.trusted();
        this.wrapWithTrusted = attrs.wrapWithTrusted();
        this.valueLen = attrs.valueLen();
        this.rsaModulus = attrs.modulus();
        this.rsaPublicExponent = attrs.publicExponent();
        this.dsaPrime = attrs.prime();
        this.dsaSubprime = attrs.subprime();
        this.dsaBase = attrs.base();
        this.ecPublicPoint = attrs.ecPoint();
        this.ecParams = attrs.ecParams();
        this.ecOrderBitSize = this.ecParams == null ? null : Functions.getCurveOrderBitLength(this.ecParams);
    }

    public PKCS11KeyId id() {
        return this.id;
    }

    public Boolean sign() {
        return this.sign;
    }

    public Boolean verify() {
        return this.verify;
    }

    public Boolean encrypt() {
        return this.encrypt;
    }

    public Boolean decrypt() {
        return this.decrypt;
    }

    public Boolean derive() {
        return this.derive;
    }

    public Boolean signRecover() {
        return this.signRecover;
    }

    public Boolean verifyRecover() {
        return this.verifyRecover;
    }

    public Boolean wrap() {
        return this.wrap;
    }

    public Boolean unwrap() {
        return this.unwrap;
    }

    public Boolean extractable() {
        return this.extractable;
    }

    public Boolean neverExtractable() {
        return this.neverExtractable;
    }

    public Boolean private_() {
        return this.private_;
    }

    public Boolean wrapWithTrusted() {
        return this.wrapWithTrusted;
    }

    public Boolean sensitive() {
        return this.sensitive;
    }

    public Boolean alwaysSensitive() {
        return this.alwaysSensitive;
    }

    public Boolean trusted() {
        return this.trusted;
    }

    public Integer valueLen() {
        return this.valueLen;
    }

    public byte[] ecParams() {
        return this.ecParams;
    }

    public Integer ecOrderBitSize() {
        return this.ecOrderBitSize;
    }

    public byte[] ecPublicPoint() {
        return this.ecPublicPoint;
    }

    public BigInteger rsaModulus() {
        return this.rsaModulus;
    }

    public BigInteger rsaPublicExponent() {
        return this.rsaPublicExponent;
    }

    public BigInteger dsaPrime() {
        return this.dsaPrime;
    }

    public BigInteger dsaSubprime() {
        return this.dsaSubprime;
    }

    public BigInteger dsaBase() {
        return this.dsaBase;
    }
}

