/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.pkcs11.wrapper;

import iaik.pkcs.pkcs11.wrapper.CK_C_INITIALIZE_ARGS;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Implementation;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.xipki.pkcs11.wrapper.Functions;
import org.xipki.pkcs11.wrapper.ModuleInfo;
import org.xipki.pkcs11.wrapper.PKCS11Exception;
import org.xipki.pkcs11.wrapper.Slot;
import org.xipki.pkcs11.wrapper.StaticLogger;
import org.xipki.pkcs11.wrapper.Version;

public class PKCS11Module {
    static final int BEHAVIOUR_ECDSA_SIGNATURE_X962 = 1;
    static final int BEHAVIOUR_SM2_SIGNATURE_X962 = 2;
    static final int BEHAVIOUR_EC_PRIVATEKEY_ECPOINT = 3;
    static final int BEHAVIOUR_SM2_PRIVATEKEY_ECPOINT = 4;
    private final PKCS11Implementation pkcs11;
    private static boolean linkedAndInitialized;
    private Boolean ecPointFixNeeded;
    private Boolean ecdsaSignatureFixNeeded;
    private Boolean sm2SignatureFixNeeded;
    private boolean withVendorCodeMap;
    private final Map<Long, Long> ckkGenericToVendorMap = new HashMap<Long, Long>();
    private final Map<Long, Long> ckkVendorToGenericMap = new HashMap<Long, Long>();
    private final Map<Long, Long> ckmGenericToVendorMap = new HashMap<Long, Long>();
    private final Map<Long, Long> ckmVendorToGenericMap = new HashMap<Long, Long>();
    private final Set<Integer> vendorBehaviours = new HashSet<Integer>();
    private static final AtomicBoolean licensePrinted;

    protected PKCS11Module(PKCS11Implementation pkcs11) {
        this.pkcs11 = Functions.requireNonNull("pkcs11", pkcs11);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PKCS11Module getInstance(String pkcs11ModulePath) throws IOException {
        AtomicBoolean atomicBoolean = licensePrinted;
        synchronized (atomicBoolean) {
            if (!licensePrinted.get()) {
                StaticLogger.info("This product (ipkcs11wrapper) includes software (IAIK PKCS#11 wrapper version 1.6.8)\ndeveloped by Stiftung SIC which is licensed under \"IAIK PKCS#11 Wrapper License\"- \nA copy of this license is downloadable under \nhttps://jce.iaik.tugraz.at/products/core-crypto-toolkits/pkcs11-wrapper/#License.\nAll other parts are licensed under Apache License, version 2.", new Object[0]);
                licensePrinted.set(true);
            }
        }
        PKCS11Module.ensureLinkedAndInitialized();
        StaticLogger.info("PKCS11Module.getInstance: pkcs11ModulePath={}", pkcs11ModulePath);
        return new PKCS11Module(new PKCS11Implementation(Functions.requireNonNull("pkcs11ModulePath", pkcs11ModulePath)));
    }

    private static synchronized void ensureLinkedAndInitialized() {
        if (!linkedAndInitialized) {
            try {
                System.loadLibrary("pkcs11wrapper");
            }
            catch (UnsatisfiedLinkError e) {
                try {
                    PKCS11Module.loadWrapperFromJar();
                }
                catch (IOException ioe) {
                    throw new UnsatisfiedLinkError("no pkcs11wrapper in library path or jar file. " + ioe.getMessage());
                }
            }
            PKCS11Implementation.initializeLibrary();
            linkedAndInitialized = true;
        }
    }

    Boolean getEcPointFixNeeded() {
        return this.ecPointFixNeeded;
    }

    void setEcPointFixNeeded(Boolean ecPointFixNeeded) {
        this.ecPointFixNeeded = ecPointFixNeeded;
    }

    Boolean getEcdsaSignatureFixNeeded() {
        return this.ecdsaSignatureFixNeeded;
    }

    void setEcdsaSignatureFixNeeded(Boolean ecdsaSignatureFixNeeded) {
        this.ecdsaSignatureFixNeeded = ecdsaSignatureFixNeeded;
    }

    Boolean getSm2SignatureFixNeeded() {
        return this.sm2SignatureFixNeeded;
    }

    void setSm2SignatureFixNeeded(Boolean sm2SignatureFixNeeded) {
        this.sm2SignatureFixNeeded = sm2SignatureFixNeeded;
    }

    public ModuleInfo getInfo() throws PKCS11Exception {
        return new ModuleInfo(this.pkcs11.C_GetInfo());
    }

    public void initialize() throws PKCS11Exception {
        CK_C_INITIALIZE_ARGS wrapperInitArgs = new CK_C_INITIALIZE_ARGS();
        wrapperInitArgs.flags |= 2L;
        StaticLogger.info("C_Initialize: flags=0x{}", Functions.toFullHex(wrapperInitArgs.flags));
        this.pkcs11.C_Initialize(wrapperInitArgs, true);
        this.initVendor();
    }

    public void finalize(Object args) throws PKCS11Exception {
        this.pkcs11.C_Finalize(args);
    }

    public Slot[] getSlotList(boolean tokenPresent) throws PKCS11Exception {
        long[] slotIDs = this.pkcs11.C_GetSlotList(tokenPresent);
        Slot[] slots = new Slot[slotIDs.length];
        for (int i = 0; i < slots.length; ++i) {
            slots[i] = new Slot(this, slotIDs[i]);
        }
        return slots;
    }

    public Slot waitForSlotEvent(boolean dontBlock) throws PKCS11Exception {
        return new Slot(this, this.pkcs11.C_WaitForSlotEvent(dontBlock ? 1L : 0L, null));
    }

    public PKCS11 getPKCS11Module() {
        return this.pkcs11;
    }

    boolean hasVendorBehaviour(int vendorBehavior) {
        return this.vendorBehaviours.contains(vendorBehavior);
    }

    long ckkGenericToVendor(long genericCode) {
        return this.withVendorCodeMap ? this.ckkGenericToVendorMap.getOrDefault(genericCode, genericCode) : genericCode;
    }

    long ckkVendorToGeneric(long vendorCode) {
        return this.withVendorCodeMap ? this.ckkVendorToGenericMap.getOrDefault(vendorCode, vendorCode) : vendorCode;
    }

    long ckmGenericToVendor(long genericCode) {
        return this.withVendorCodeMap ? this.ckmGenericToVendorMap.getOrDefault(genericCode, genericCode) : genericCode;
    }

    long ckmVendorToGeneric(long vendorCode) {
        return this.withVendorCodeMap ? this.ckmVendorToGenericMap.getOrDefault(vendorCode, vendorCode) : vendorCode;
    }

    public String toString() {
        return this.pkcs11 != null ? this.pkcs11.toString() : "null";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void loadWrapperFromJar() throws IOException {
        ClassLoader classLoader;
        String PKCS11_TEMP_DIR = "PKCS11_TEMP_DIR";
        boolean LINUX_INDEX = false;
        boolean WIN_INDEX = true;
        int MAC_INDEX = 2;
        String[] WRAPPER_OS_PATH = new String[]{"unix/linux-", "windows/win-", "unix/macosx_universal/"};
        String[] WRAPPER_FILE_SUFFIX = new String[]{".so", ".dll", ".jnilib"};
        String[] WRAPPER_FILE_PREFIX = new String[]{"lib", "", "lib", "lib"};
        boolean X64_INDEX = false;
        boolean X86_INDEX = true;
        int ARM_INDEX = 2;
        int AARCH64_INDEX = 3;
        String[] WRAPPER_ARCH_PATH = new String[]{"x86_64/", "x86/", "arm/", "aarch64/"};
        int trialCounter = 0;
        String osName = System.getProperty("os.name");
        int osIndex = (osName = osName.toLowerCase(Locale.ROOT)).contains("win") ? 1 : (osName.contains("linux") ? 0 : (osName.contains("mac") ? 2 : 0));
        String archName = System.getProperty("os.arch").toLowerCase(Locale.ROOT);
        int archIndex = archName.contains("aarch64") ? 3 : (archName.contains("arm") ? 2 : (archName.contains("64") ? 0 : (archName.contains("32") || archName.contains("86") ? 1 : -1)));
        if (archIndex == -1) {
            archIndex = 0;
            ++trialCounter;
        }
        boolean isRelease = null != (classLoader = PKCS11Module.class.getClassLoader()).getResource("natives/unix/linux-x86/release/libpkcs11wrapper.so");
        String releaseOrDebugDir = isRelease ? "release/" : "debug/";
        String system = "natives/" + WRAPPER_OS_PATH[osIndex];
        String architecture = osIndex == 2 ? "" : WRAPPER_ARCH_PATH[archIndex];
        String libName = WRAPPER_FILE_PREFIX[osIndex] + "pkcs11wrapper";
        String osFileEnding = WRAPPER_FILE_SUFFIX[osIndex];
        boolean success = false;
        do {
            String jarFilePath;
            InputStream wrapperLibrary;
            if ((wrapperLibrary = classLoader.getResourceAsStream(jarFilePath = system + architecture + releaseOrDebugDir + libName + osFileEnding)) == null) {
                if (trialCounter >= WRAPPER_ARCH_PATH.length) throw new IOException("No suitable wrapper native library for " + osName + " " + archName + " found in jar file.");
                archIndex = trialCounter++;
                architecture = WRAPPER_ARCH_PATH[archIndex];
                continue;
            }
            File tempWrapperFile = null;
            try {
                String directory = System.getProperty("PKCS11_TEMP_DIR", null);
                if (directory != null && !directory.isEmpty()) {
                    File tempWrapperDirectory = new File(directory);
                    if (!tempWrapperDirectory.exists()) throw new IOException("Specified local temp directory '" + directory + "' does not exist!");
                    tempWrapperFile = File.createTempFile(libName, osFileEnding, tempWrapperDirectory);
                } else {
                    tempWrapperFile = File.createTempFile(libName, osFileEnding);
                }
                if (!tempWrapperFile.canWrite()) {
                    throw new IOException("Can't copy wrapper native library to local temporary directory - no write permission in " + tempWrapperFile.getAbsolutePath());
                }
                tempWrapperFile.deleteOnExit();
                StaticLogger.info("PKCS11Mdule.loadWrapperFromJar: copy file {} to {}", jarFilePath, tempWrapperFile.getAbsolutePath());
                try {
                    Files.copy(wrapperLibrary, tempWrapperFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                finally {
                    wrapperLibrary.close();
                }
            }
            catch (IOException e) {
                if (tempWrapperFile == null) throw new IOException("Can't copy wrapper native library to local temporary directory. " + e.getMessage());
                tempWrapperFile.delete();
                throw new IOException("Can't copy wrapper native library to local temporary directory. " + e.getMessage());
            }
            catch (RuntimeException e) {
                if (tempWrapperFile == null) throw e;
                tempWrapperFile.delete();
                throw e;
            }
            try {
                System.load(tempWrapperFile.getAbsolutePath());
                return;
            }
            catch (UnsatisfiedLinkError e) {
                tempWrapperFile.delete();
                if (trialCounter >= WRAPPER_ARCH_PATH.length) throw new IOException("No suitable wrapper native library found in jar file. " + osName + " " + archName + " not supported.");
                archIndex = trialCounter++;
                architecture = WRAPPER_ARCH_PATH[archIndex];
            }
        } while (!success);
    }

    private static VendorConfBlock readVendorBlock(BufferedReader reader) throws IOException {
        String line;
        boolean inBlock = false;
        VendorConfBlock block = null;
        while ((line = reader.readLine()) != null) {
            String value;
            int idx;
            if ((line = line.trim()).isEmpty() || line.charAt(0) == '#') continue;
            if (line.startsWith("<vendor>")) {
                block = new VendorConfBlock();
                inBlock = true;
                continue;
            }
            if (line.startsWith("</vendor>")) {
                block.validate();
                return block;
            }
            if (!inBlock) continue;
            if (line.startsWith("module.")) {
                idx = line.indexOf(32);
                if (idx == -1 || (value = line.substring(idx + 1).trim()).isEmpty()) continue;
                String name = line.substring(0, idx).trim();
                List<String> textList = Arrays.asList(value.toLowerCase(Locale.ROOT).split(":"));
                if (name.equalsIgnoreCase("module.path")) {
                    block.modulePaths = textList;
                    continue;
                }
                if (name.equalsIgnoreCase("module.mid")) {
                    block.manufacturerIDs = textList;
                    continue;
                }
                if (name.equalsIgnoreCase("module.description")) {
                    block.descriptions = textList;
                    continue;
                }
                if (!name.equalsIgnoreCase("module.version")) continue;
                block.versions = textList;
                continue;
            }
            if (line.startsWith("CKK_") || line.startsWith("CKM_")) {
                idx = line.indexOf(32);
                if (idx == -1) continue;
                block.nameToCodeMap.put(line.substring(0, idx).trim(), line.substring(idx + 1).trim());
                continue;
            }
            if (!line.startsWith("VENDOR_BEHAVIORS ") || (value = line.substring((idx = line.indexOf(32)) + 1).trim()).isEmpty()) continue;
            block.vendorBehaviours = value;
        }
        return block;
    }

    /*
     * Exception decompiling
     */
    private void initVendor() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[UNCONDITIONALDOLOOP]], but top level block is 11[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static {
        licensePrinted = new AtomicBoolean(false);
    }

    private static final class VendorConfBlock {
        private List<String> modulePaths;
        private List<String> manufacturerIDs;
        private List<String> descriptions;
        private List<String> versions;
        private String vendorBehaviours;
        private final Map<String, String> nameToCodeMap = new HashMap<String, String>();

        private VendorConfBlock() {
        }

        void validate() throws IOException {
            if (VendorConfBlock.isEmpty(this.modulePaths) && VendorConfBlock.isEmpty(this.manufacturerIDs) && VendorConfBlock.isEmpty(this.descriptions)) {
                throw new IOException("invalid <vendor>-block");
            }
        }

        boolean matches(String modulePath, String manufacturerID, String libraryDescription, Version libraryVersion) {
            if (!VendorConfBlock.isEmpty(this.modulePaths) && !VendorConfBlock.contains(this.modulePaths, Paths.get(modulePath, new String[0]).getFileName().toString()) || !VendorConfBlock.isEmpty(this.manufacturerIDs) && !VendorConfBlock.contains(this.manufacturerIDs, manufacturerID) || !VendorConfBlock.isEmpty(this.descriptions) && !VendorConfBlock.contains(this.descriptions, libraryDescription)) {
                return false;
            }
            if (VendorConfBlock.isEmpty(this.versions)) {
                return true;
            }
            int iVersion = ((0xFF & libraryVersion.getMajor()) << 8) + (0xFF & libraryVersion.getMinor());
            boolean match = false;
            for (String t : this.versions) {
                int to;
                int idx = t.indexOf("-");
                int from = idx == -1 ? VendorConfBlock.toIntVersion(t) : VendorConfBlock.toIntVersion(t.substring(0, idx));
                int n = to = idx == -1 ? from : VendorConfBlock.toIntVersion(t.substring(idx + 1));
                if (iVersion < from || iVersion > to) continue;
                match = true;
                break;
            }
            return match;
        }

        private static int toIntVersion(String version) {
            StringTokenizer st = new StringTokenizer(version, ".");
            return (Integer.parseInt(st.nextToken()) << 8) + Integer.parseInt(st.nextToken());
        }

        private static boolean isEmpty(Collection<?> c) {
            return c == null || c.isEmpty();
        }

        private static boolean contains(List<String> list, String str) {
            str = str.toLowerCase(Locale.ROOT);
            for (String s : list) {
                if (!str.contains(s)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return "VendorConfBlock\n  modulePaths:      " + this.modulePaths + "\n  manufacturerIDs:  " + this.manufacturerIDs + "\n  descriptions:     " + this.descriptions + "\n  versions:         " + this.versions + "\n  vendorBehaviours: " + this.vendorBehaviours + "\n  nameToCodeMap:    " + this.nameToCodeMap;
        }

        static /* synthetic */ String access$600(VendorConfBlock x0) {
            return x0.vendorBehaviours;
        }
    }
}

