/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.pkcs11.wrapper;

import iaik.pkcs.pkcs11.wrapper.CK_ATTRIBUTE;
import iaik.pkcs.pkcs11.wrapper.CK_MECHANISM;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPoint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.xipki.pkcs11.wrapper.AttributeVector;
import org.xipki.pkcs11.wrapper.Functions;
import org.xipki.pkcs11.wrapper.KeyPairTemplate;
import org.xipki.pkcs11.wrapper.Mechanism;
import org.xipki.pkcs11.wrapper.PKCS11Constants;
import org.xipki.pkcs11.wrapper.PKCS11Exception;
import org.xipki.pkcs11.wrapper.PKCS11KeyPair;
import org.xipki.pkcs11.wrapper.PKCS11Module;
import org.xipki.pkcs11.wrapper.SessionInfo;
import org.xipki.pkcs11.wrapper.StaticLogger;
import org.xipki.pkcs11.wrapper.Token;
import org.xipki.pkcs11.wrapper.attrs.Attribute;
import org.xipki.pkcs11.wrapper.attrs.BooleanAttribute;
import org.xipki.pkcs11.wrapper.attrs.ByteArrayAttribute;
import org.xipki.pkcs11.wrapper.attrs.CharArrayAttribute;
import org.xipki.pkcs11.wrapper.attrs.LongAttribute;
import org.xipki.pkcs11.wrapper.attrs.MechanismArrayAttribute;
import org.xipki.pkcs11.wrapper.params.CkMessageParams;
import org.xipki.pkcs11.wrapper.params.CkParams;
import org.xipki.pkcs11.wrapper.params.CkParamsWithExtra;
import org.xipki.pkcs11.wrapper.params.ExtraParams;

public class Session {
    private static final int SIGN_TYPE_ECDSA = 1;
    private static final int SIGN_TYPE_SM2 = 2;
    private final PKCS11Module module;
    private final PKCS11 pkcs11;
    private long sessionHandle;
    protected Token token;
    private final boolean useUtf8;
    private Boolean rwSession = null;
    private int signatureType;
    private long signOrVerifyKeyHandle;
    private ExtraParams signVerifyExtraParams;

    protected Session(Token token, long sessionHandle) {
        this.token = Functions.requireNonNull("token", token);
        this.module = token.getSlot().getModule();
        this.pkcs11 = this.module.getPKCS11Module();
        this.sessionHandle = sessionHandle;
        this.useUtf8 = token.isUseUtf8Encoding();
    }

    public void initPIN(char[] pin) throws PKCS11Exception {
        String method = "C_InitPIN";
        this.debugIn("C_InitPIN");
        try {
            this.pkcs11.C_InitPIN(this.sessionHandle, pin, this.useUtf8);
            this.debugOut("C_InitPIN");
        }
        catch (PKCS11Exception e) {
            this.debugError("C_InitPIN", e);
            throw e;
        }
    }

    public void setPIN(char[] oldPin, char[] newPin) throws PKCS11Exception {
        String method = "C_SetPIN";
        this.debugIn("C_SetPIN");
        try {
            this.pkcs11.C_SetPIN(this.sessionHandle, oldPin, newPin, this.useUtf8);
            this.debugOut("C_SetPIN");
        }
        catch (PKCS11Exception e) {
            this.debugError("C_SetPIN", e);
            throw e;
        }
    }

    public void closeSession() throws PKCS11Exception {
        String method = "C_CloseSession";
        this.debugIn("C_CloseSession");
        try {
            this.pkcs11.C_CloseSession(this.sessionHandle);
            this.debugOut("C_CloseSession");
        }
        catch (PKCS11Exception e) {
            this.debugError("C_CloseSession", e);
            throw e;
        }
    }

    public long getSessionHandle() {
        return this.sessionHandle;
    }

    public SessionInfo getSessionInfo() throws PKCS11Exception {
        return new SessionInfo(this.pkcs11.C_GetSessionInfo(this.sessionHandle));
    }

    public void sessionCancel() throws PKCS11Exception {
        String method = "C_SessionCancel";
        long flags = 0L;
        this.debugIn("C_SessionCancel");
        try {
            this.pkcs11.C_SessionCancel(this.sessionHandle, flags);
            this.debugOut("C_SessionCancel");
        }
        catch (PKCS11Exception e) {
            this.debugError("C_SessionCancel", e);
            throw e;
        }
    }

    public PKCS11Module getModule() {
        return this.module;
    }

    public Token getToken() {
        return this.token;
    }

    public byte[] getOperationState() throws PKCS11Exception {
        return this.pkcs11.C_GetOperationState(this.sessionHandle);
    }

    public void setOperationState(byte[] operationState, long encryptionKeyHandle, long authenticationKeyHandle) throws PKCS11Exception {
        this.pkcs11.C_SetOperationState(this.sessionHandle, operationState, encryptionKeyHandle, authenticationKeyHandle);
    }

    public void setSessionHandle(long sessionHandle) {
        this.sessionHandle = sessionHandle;
    }

    public boolean isSetUtf8Encoding() {
        return this.useUtf8;
    }

    public void login(long userType, char[] pin) throws PKCS11Exception {
        String method = "C_Login";
        if (StaticLogger.isDebugEnabled()) {
            this.debugIn("C_Login", "userType={}", PKCS11Constants.codeToName(PKCS11Constants.Category.CKU, userType));
        }
        try {
            this.pkcs11.C_Login(this.sessionHandle, userType, pin, this.useUtf8);
            this.debugOut("C_Login");
        }
        catch (PKCS11Exception e) {
            this.debugError("C_Login", e);
            throw e;
        }
    }

    public void loginUser(long userType, char[] pin, char[] username) throws PKCS11Exception {
        String method = "C_LoginUser";
        if (StaticLogger.isDebugEnabled()) {
            this.debugIn("C_LoginUser", "userType={}, username={}", PKCS11Constants.codeToName(PKCS11Constants.Category.CKU, userType), username == null ? null : new String(username));
        }
        try {
            this.pkcs11.C_LoginUser(this.sessionHandle, userType, pin, username, this.useUtf8);
            this.debugOut("C_LoginUser");
        }
        catch (PKCS11Exception e) {
            this.debugError("C_LoginUser", e);
            throw e;
        }
    }

    public void logout() throws PKCS11Exception {
        String method = "C_Logout";
        this.debugIn("C_Logout");
        try {
            this.pkcs11.C_Logout(this.sessionHandle);
            this.debugOut("C_Logout");
        }
        catch (PKCS11Exception e) {
            this.debugError("C_Logout", e);
            throw e;
        }
    }

    public long createObject(AttributeVector template) throws PKCS11Exception {
        String method = "C_CreateObject";
        if (StaticLogger.isDebugEnabled()) {
            long objClass = template.class_();
            if (objClass == 3L || objClass == 4L) {
                AttributeVector logTemplate = template.copyWithoutByteArrayAttributes();
                logTemplate.id(template.id()).modulus(template.modulus()).publicExponent(template.publicExponent()).ecParams(template.ecParams()).ecPoint(template.ecPoint()).prime(template.prime()).subprime(template.subprime()).base(template.base());
                this.debugIn("C_CreateObject", "part of template={}", logTemplate);
            } else {
                this.debugIn("C_CreateObject", "template={}", template);
            }
        }
        try {
            long hObject = this.pkcs11.C_CreateObject(this.sessionHandle, this.toOutCKAttributes(template), this.useUtf8);
            this.debugOut("C_CreateObject", "hObject={}", hObject);
            return hObject;
        }
        catch (PKCS11Exception e) {
            this.debugError("C_CreateObject", e);
            throw e;
        }
    }

    public long createPrivateKeyObject(AttributeVector template, PublicKey publicKey) throws PKCS11Exception {
        if (publicKey instanceof ECPublicKey && this.privateKeyWithEcPoint(template.keyType())) {
            byte[] ecParams = template.ecParams();
            Integer fieldSize = Functions.getECFieldSize(ecParams);
            ECPoint w = ((ECPublicKey)publicKey).getW();
            byte[] wx = Functions.asUnsignedByteArray(w.getAffineX());
            byte[] wy = Functions.asUnsignedByteArray(w.getAffineY());
            if (fieldSize == null) {
                fieldSize = Math.max(wx.length, wy.length);
            } else if (wx.length > fieldSize || wy.length > fieldSize) {
                throw new IllegalStateException("should not happen, public key and ecParams do not match");
            }
            byte[] ecPoint = new byte[1 + 2 * fieldSize];
            ecPoint[0] = 4;
            System.arraycopy(wx, 0, ecPoint, 1 + fieldSize - wx.length, wx.length);
            System.arraycopy(wy, 0, ecPoint, ecPoint.length - wy.length, wy.length);
            template.ecPoint(ecPoint);
        }
        return this.createObject(template);
    }

    public long createECPrivateKeyObject(AttributeVector template, byte[] ecPoint) throws PKCS11Exception {
        if (ecPoint != null && this.privateKeyWithEcPoint(template.keyType())) {
            template.ecPoint(ecPoint);
        }
        return this.createObject(template);
    }

    private boolean privateKeyWithEcPoint(Long keyType) {
        if (keyType == null) {
            return false;
        }
        if (3L == keyType) {
            return this.module.hasVendorBehaviour(3);
        }
        if (0xFFFFF001L == keyType) {
            return this.module.hasVendorBehaviour(4);
        }
        return false;
    }

    public long copyObject(long sourceObjectHandle, AttributeVector template) throws PKCS11Exception {
        String method = "C_CopyObject";
        this.debugIn("C_CopyObject", "sourceObjectHandle={}, template={}", sourceObjectHandle, template);
        try {
            long hObject = this.pkcs11.C_CopyObject(this.sessionHandle, sourceObjectHandle, this.toOutCKAttributes(template), this.useUtf8);
            this.debugOut("C_CopyObject", "hObject={}", hObject);
            return hObject;
        }
        catch (PKCS11Exception e) {
            this.debugError("C_CopyObject", e);
            throw e;
        }
    }

    public void setAttributeValues(long objectToUpdateHandle, AttributeVector template) throws PKCS11Exception {
        String method = "C_SetAttributeValue";
        this.debugIn("C_SetAttributeValue", "objectToUpdateHandle={}, template={}", objectToUpdateHandle, template);
        try {
            this.pkcs11.C_SetAttributeValue(this.sessionHandle, objectToUpdateHandle, this.toOutCKAttributes(template), this.useUtf8);
            this.debugOut("C_SetAttributeValue");
        }
        catch (PKCS11Exception e) {
            this.debugError("C_SetAttributeValue", e);
            throw e;
        }
    }

    public void destroyObject(long objectHandle) throws PKCS11Exception {
        String method = "C_DestroyObject";
        this.debugIn("C_DestroyObject", "objectHandle={}", objectHandle);
        try {
            this.pkcs11.C_DestroyObject(this.sessionHandle, objectHandle);
            this.debugOut("C_DestroyObject");
        }
        catch (PKCS11Exception e) {
            this.debugError("C_DestroyObject", e);
            throw e;
        }
    }

    public long getObjectSize(long objectHandle) throws PKCS11Exception {
        return this.pkcs11.C_GetObjectSize(this.sessionHandle, objectHandle);
    }

    public void findObjectsInit(AttributeVector template) throws PKCS11Exception {
        String method = "C_FindObjectsInit";
        this.debugIn("C_FindObjectsInit", "template={}", template);
        try {
            this.pkcs11.C_FindObjectsInit(this.sessionHandle, this.toOutCKAttributes(template, true), this.useUtf8);
            this.debugOut("C_FindObjectsInit");
        }
        catch (PKCS11Exception e) {
            this.debugError("C_FindObjectsInit", e);
            throw e;
        }
    }

    public long[] findObjects(int maxObjectCount) throws PKCS11Exception {
        long[] handles;
        int countPerCall = 1000;
        if (maxObjectCount <= maxObjectCount) {
            return this.findObjects0(maxObjectCount);
        }
        LinkedList<Long> list = new LinkedList<Long>();
        for (int i = 0; i < maxObjectCount && (handles = this.findObjects0(Math.min(1000, maxObjectCount - i))).length != 0; i += 1000) {
            for (Object handle : (Object)handles) {
                list.add((long)handle);
            }
        }
        long[] ret = new long[list.size()];
        int idx = 0;
        for (Long handle : list) {
            ret[idx++] = handle;
        }
        return ret;
    }

    private long[] findObjects0(int maxObjectCount) throws PKCS11Exception {
        String method = "C_FindObjects";
        this.debugIn("C_FindObjects", "maxObjectCount={}", maxObjectCount);
        try {
            long[] hObjects = this.pkcs11.C_FindObjects(this.sessionHandle, maxObjectCount);
            if (StaticLogger.isDebugEnabled()) {
                this.debugOut("C_FindObjects", "hObjects={}", Arrays.toString(hObjects));
            }
            return hObjects;
        }
        catch (PKCS11Exception e) {
            this.debugError("C_FindObjects", e);
            throw e;
        }
    }

    public void findObjectsFinal() throws PKCS11Exception {
        String method = "C_FindObjectsFinal";
        this.debugIn("C_FindObjectsFinal");
        try {
            this.pkcs11.C_FindObjectsFinal(this.sessionHandle);
            this.debugOut("C_FindObjectsFinal");
        }
        catch (PKCS11Exception e) {
            this.debugError("C_FindObjectsFinal", e);
            throw e;
        }
    }

    public long[] findAllObjectsSingle(AttributeVector template) throws PKCS11Exception {
        return this.findObjectsSingle(template, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] findObjectsSingle(AttributeVector template, int maxObjectCount) throws PKCS11Exception {
        this.findObjectsInit(template);
        try {
            long[] lArray = this.findObjects(maxObjectCount);
            return lArray;
        }
        finally {
            this.findObjectsFinal();
        }
    }

    public void encryptInit(Mechanism mechanism, long keyHandle) throws PKCS11Exception {
        String method = "C_EncryptInit";
        this.debugIn("C_EncryptInit", "mechanism={}, keyHandle={}", mechanism, keyHandle);
        try {
            this.pkcs11.C_EncryptInit(this.sessionHandle, this.toCkMechanism(mechanism), keyHandle, this.useUtf8);
            this.debugOut("C_EncryptInit");
        }
        catch (PKCS11Exception e) {
            this.debugError("C_EncryptInit", e);
            throw e;
        }
    }

    public byte[] encrypt(byte[] plaintext) throws PKCS11Exception {
        String method = "C_Encrypt";
        this.debugIn("C_Encrypt", "plaintext.length={}", Session.len(plaintext));
        try {
            return this.toNonNull("C_Encrypt", this.pkcs11.C_Encrypt(this.sessionHandle, plaintext));
        }
        catch (PKCS11Exception e) {
            this.debugError("C_Encrypt", e);
            throw e;
        }
    }

    public byte[] encryptSingle(Mechanism mechanism, long keyHandle, byte[] plaintext) throws PKCS11Exception {
        this.encryptInit(mechanism, keyHandle);
        return this.encrypt(plaintext);
    }

    public byte[] encryptUpdate(byte[] plaintextPat) throws PKCS11Exception {
        String method = "C_EncryptUpdate";
        this.debugIn("C_EncryptUpdate", "plaintextPat.length={}", Session.len(plaintextPat));
        try {
            return this.toNonNull("C_EncryptUpdate", this.pkcs11.C_EncryptUpdate(this.sessionHandle, plaintextPat));
        }
        catch (PKCS11Exception e) {
            this.debugError("C_EncryptUpdate", e);
            throw e;
        }
    }

    public byte[] encryptFinal() throws PKCS11Exception {
        String method = "C_EncryptFinal";
        this.debugIn("C_EncryptFinal");
        try {
            return this.toNonNull("C_EncryptFinal", this.pkcs11.C_EncryptFinal(this.sessionHandle));
        }
        catch (PKCS11Exception e) {
            this.debugError("C_EncryptFinal", e);
            throw e;
        }
    }

    public void messageEncryptInit(Mechanism mechanism, long keyHandle) throws PKCS11Exception {
        String method = "C_MessageEncryptInit";
        this.debugIn("C_MessageEncryptInit", "mechanism={}, keyHandle={}", mechanism, keyHandle);
        try {
            this.pkcs11.C_MessageEncryptInit(this.sessionHandle, this.toCkMechanism(mechanism), keyHandle, this.useUtf8);
            this.debugOut("C_MessageEncryptInit");
        }
        catch (PKCS11Exception e) {
            this.debugError("C_MessageEncryptInit", e);
            throw e;
        }
    }

    public byte[] encryptMessage(CkParams params, byte[] associatedData, byte[] plaintext) throws PKCS11Exception {
        String method = "C_EncryptMessage";
        Object paramObject = this.toCkParameters(params);
        this.debugIn("C_EncryptMessage", "associatedData.length={}, plaintext.length", Session.len(associatedData), Session.len(plaintext));
        try {
            byte[] rv = this.pkcs11.C_EncryptMessage(this.sessionHandle, paramObject, associatedData, plaintext, this.useUtf8);
            if (params instanceof CkMessageParams) {
                ((CkMessageParams)((Object)params)).setValuesFromPKCS11Object(paramObject);
            }
            return this.toNonNull("C_EncryptMessage", rv);
        }
        catch (PKCS11Exception e) {
            this.debugError("C_EncryptMessage", e);
            throw e;
        }
    }

    public void encryptMessageBegin(CkParams params, byte[] associatedData) throws PKCS11Exception {
        String method = "C_EncryptMessageBegin";
        this.debugIn("C_EncryptMessageBegin", "params={}, associatedData.length={}", params, Session.len(associatedData));
        try {
            this.pkcs11.C_EncryptMessageBegin(this.sessionHandle, this.toCkParameters(params), associatedData, this.useUtf8);
            this.debugOut("C_EncryptMessageBegin");
        }
        catch (PKCS11Exception e) {
            this.debugError("C_EncryptMessageBegin", e);
            throw e;
        }
    }

    public byte[] encryptMessageNext(CkParams params, byte[] plaintext, boolean isLastOperation) throws PKCS11Exception {
        Object paramObject = this.toCkParameters(params);
        if (params instanceof CkMessageParams) {
            ((CkMessageParams)((Object)params)).setValuesFromPKCS11Object(paramObject);
        }
        String method = "C_EncryptMessageNext";
        this.debugIn("C_EncryptMessageNext", "params={}, plaintext.length={}, isLastOperation={}", params, Session.len(plaintext), isLastOperation);
        try {
            return this.toNonNull("C_EncryptMessageNext", this.pkcs11.C_EncryptMessageNext(this.sessionHandle, paramObject, plaintext, isLastOperation ? 1L : 0L, this.useUtf8));
        }
        catch (PKCS11Exception e) {
            this.debugError("C_EncryptMessageNext", e);
            throw e;
        }
    }

    public void messageEncryptFinal() throws PKCS11Exception {
        String method = "C_MessageEncryptFinal";
        this.debugIn("C_MessageEncryptFinal");
        try {
            this.pkcs11.C_MessageEncryptFinal(this.sessionHandle);
            this.debugOut("C_MessageEncryptFinal");
        }
        catch (PKCS11Exception e) {
            this.debugError("C_MessageEncryptFinal", e);
            throw e;
        }
    }

    public void decryptInit(Mechanism mechanism, long keyHandle) throws PKCS11Exception {
        String method = "C_DecryptInit";
        this.debugIn("C_DecryptInit", "mechanism={}, keyHandle={}", mechanism, keyHandle);
        try {
            this.pkcs11.C_DecryptInit(this.sessionHandle, this.toCkMechanism(mechanism), keyHandle, this.useUtf8);
            this.debugOut("C_DecryptInit");
        }
        catch (PKCS11Exception e) {
            this.debugError("C_DecryptInit", e);
            throw e;
        }
    }

    public byte[] decrypt(byte[] ciphertext) throws PKCS11Exception {
        String method = "C_Decrypt";
        this.debugIn("C_Decrypt", "ciphertext.length={}", Session.len(ciphertext));
        try {
            return this.toNonNull("C_Decrypt", this.pkcs11.C_Decrypt(this.sessionHandle, ciphertext));
        }
        catch (PKCS11Exception e) {
            this.debugError("C_Decrypt", e);
            throw e;
        }
    }

    public byte[] decryptSingle(Mechanism mechanism, long keyHandle, byte[] ciphertext) throws PKCS11Exception {
        this.decryptInit(mechanism, keyHandle);
        return this.decrypt(ciphertext);
    }

    public byte[] decryptUpdate(byte[] ciphertextPart) throws PKCS11Exception {
        String method = "C_DecryptUpdate";
        this.debugIn("C_DecryptUpdate", "ciphertextPart.length={}", Session.len(ciphertextPart));
        try {
            return this.toNonNull("C_DecryptUpdate", this.pkcs11.C_DecryptUpdate(this.sessionHandle, ciphertextPart));
        }
        catch (PKCS11Exception e) {
            this.debugError("C_DecryptUpdate", e);
            throw e;
        }
    }

    public byte[] decryptFinal() throws PKCS11Exception {
        String method = "C_DecryptFinal";
        this.debugIn("C_DecryptFinal");
        try {
            return this.toNonNull("C_DecryptFinal", this.pkcs11.C_DecryptFinal(this.sessionHandle));
        }
        catch (PKCS11Exception e) {
            this.debugError("C_DecryptFinal", e);
            throw e;
        }
    }

    public void messageDecryptInit(Mechanism mechanism, long keyHandle) throws PKCS11Exception {
        String method = "C_MessageDecryptInit";
        this.debugIn("C_MessageDecryptInit", "mechanism={}, keyHandle={}", mechanism, keyHandle);
        try {
            this.pkcs11.C_MessageDecryptInit(this.sessionHandle, this.toCkMechanism(mechanism), keyHandle, this.useUtf8);
            this.debugOut("C_MessageDecryptInit");
        }
        catch (PKCS11Exception e) {
            this.debugError("C_MessageDecryptInit", e);
            throw e;
        }
    }

    public byte[] decryptMessage(CkParams params, byte[] associatedData, byte[] ciphertext) throws PKCS11Exception {
        String method = "C_DecryptMessage";
        this.debugIn("C_DecryptMessage", "params={}, associatedData.length={}, ciphertext.length={}", params, Session.len(associatedData), Session.len(ciphertext));
        try {
            return this.toNonNull("C_DecryptMessage", this.pkcs11.C_DecryptMessage(this.sessionHandle, this.toCkParameters(params), associatedData, ciphertext, this.useUtf8));
        }
        catch (PKCS11Exception e) {
            this.debugError("C_DecryptMessage", e);
            throw e;
        }
    }

    public void decryptMessageBegin(CkParams params, byte[] associatedData) throws PKCS11Exception {
        String method = "C_DecryptMessageBegin";
        this.debugIn("C_DecryptMessageBegin", "params={}, associatedData.length={}", params, Session.len(associatedData));
        try {
            this.pkcs11.C_DecryptMessageBegin(this.sessionHandle, this.toCkParameters(params), associatedData, this.useUtf8);
            this.debugOut("C_DecryptMessageBegin");
        }
        catch (PKCS11Exception e) {
            this.debugError("C_DecryptMessageBegin", e);
            throw e;
        }
    }

    public byte[] decryptMessageNext(CkParams params, byte[] ciphertext, boolean isLastOperation) throws PKCS11Exception {
        String method = "C_DecryptMessageNext";
        this.debugIn("C_DecryptMessageNext", "params={}, ciphertext.length={}, isLastOperation={}", params, Session.len(ciphertext), isLastOperation);
        try {
            return this.toNonNull("C_DecryptMessageNext", this.pkcs11.C_DecryptMessageNext(this.sessionHandle, this.toCkParameters(params), ciphertext, isLastOperation ? 1L : 0L, this.useUtf8));
        }
        catch (PKCS11Exception e) {
            this.debugError("C_DecryptMessageNext", e);
            throw e;
        }
    }

    public void messageDecryptFinal() throws PKCS11Exception {
        String method = "C_MessageDecryptFinal";
        this.debugIn("C_MessageDecryptFinal");
        try {
            this.pkcs11.C_MessageDecryptFinal(this.sessionHandle);
            this.debugOut("C_MessageDecryptFinal");
        }
        catch (PKCS11Exception e) {
            this.debugError("C_MessageDecryptFinal", e);
            throw e;
        }
    }

    public void digestInit(Mechanism mechanism) throws PKCS11Exception {
        String method = "C_DigestInit";
        this.debugIn("C_DigestInit", "mechanism={}", mechanism);
        try {
            this.pkcs11.C_DigestInit(this.sessionHandle, this.toCkMechanism(mechanism), this.useUtf8);
            this.debugOut("C_DigestInit");
        }
        catch (PKCS11Exception e) {
            this.debugError("C_DigestInit", e);
            throw e;
        }
    }

    public byte[] digest(byte[] data) throws PKCS11Exception {
        String method = "C_Digest";
        this.debugIn("C_Digest", "data.length={}", Session.len(data));
        try {
            return this.toNonNull("C_Digest", this.pkcs11.C_Digest(this.sessionHandle, data));
        }
        catch (PKCS11Exception e) {
            this.debugError("C_Digest", e);
            throw e;
        }
    }

    public byte[] digestSingle(Mechanism mechanism, byte[] data) throws PKCS11Exception {
        this.digestInit(mechanism);
        return this.digest(data);
    }

    public void digestUpdate(byte[] dataPart) throws PKCS11Exception {
        String method = "C_DigestUpdate";
        this.debugIn("C_DigestUpdate", "dataPart.length={}", Session.len(dataPart));
        try {
            this.pkcs11.C_DigestUpdate(this.sessionHandle, dataPart);
            this.debugOut("C_DigestUpdate");
        }
        catch (PKCS11Exception e) {
            this.debugError("C_DigestUpdate", e);
            throw e;
        }
    }

    public void digestKey(long keyHandle) throws PKCS11Exception {
        String method = "C_DigestKey";
        this.debugIn("C_DigestKey", "keyHandle={}", keyHandle);
        try {
            this.pkcs11.C_DigestKey(this.sessionHandle, keyHandle);
            this.debugOut("C_DigestKey");
        }
        catch (PKCS11Exception e) {
            this.debugError("C_DigestKey", e);
            throw e;
        }
    }

    public byte[] digestFinal() throws PKCS11Exception {
        String method = "C_DigestFinal";
        this.debugIn("C_DigestFinal");
        try {
            return this.toNonNull("C_DigestFinal", this.pkcs11.C_DigestFinal(this.sessionHandle));
        }
        catch (PKCS11Exception e) {
            this.debugError("C_DigestFinal", e);
            throw e;
        }
    }

    public int digestFinal(byte[] out, int outOfs, int outLen) throws PKCS11Exception {
        byte[] digest = this.digestFinal();
        if (digest.length > outLen) {
            throw new PKCS11Exception(336L);
        }
        System.arraycopy(digest, 0, out, outOfs, digest.length);
        return digest.length;
    }

    public void signInit(Mechanism mechanism, long keyHandle) throws PKCS11Exception {
        String method = "C_SignInit";
        this.debugIn("C_SignInit", "mechanism={}, keyHandle={}", mechanism, keyHandle);
        this.initSignVerify(mechanism, keyHandle);
        try {
            this.pkcs11.C_SignInit(this.sessionHandle, this.toCkMechanism(mechanism), keyHandle, this.useUtf8);
            this.debugOut("C_SignInit");
        }
        catch (PKCS11Exception e) {
            this.debugError("C_SignInit", e);
            throw e;
        }
    }

    private void initSignVerify(Mechanism mechanism, long keyHandle) {
        this.signOrVerifyKeyHandle = keyHandle;
        long code = mechanism.getMechanismCode();
        this.signatureType = code == 4161L || code == 4162L || code == 4163L || code == 4164L || code == 4165L || code == 4166L || code == 4167L || code == 4168L || code == 4169L || code == 4170L ? 1 : (code == 0xFFFFF002L || code == 0xFFFFF003L ? 2 : 0);
        this.signVerifyExtraParams = mechanism.getParameters() instanceof CkParamsWithExtra ? ((CkParamsWithExtra)mechanism.getParameters()).getExtraParams() : null;
    }

    public byte[] sign(byte[] data) throws PKCS11Exception {
        String method = "C_Sign";
        this.debugIn("C_Sign", "data.length={}", Session.len(data));
        try {
            byte[] sigValue = this.pkcs11.C_Sign(this.sessionHandle, data);
            this.debugOut("C_Sign", "rv.length={]", Session.len(sigValue));
            return this.toNonNull(this.fixSignOutput(sigValue));
        }
        catch (PKCS11Exception e) {
            this.debugError("C_Sign", e);
            throw e;
        }
    }

    public byte[] signSingle(Mechanism mechanism, long keyHandle, byte[] data) throws PKCS11Exception {
        this.signInit(mechanism, keyHandle);
        return this.sign(data);
    }

    public void signUpdate(byte[] dataPart) throws PKCS11Exception {
        String method = "C_SignUpdate";
        this.debugIn("C_SignUpdate", "dataPart.length={}", Session.len(dataPart));
        try {
            this.pkcs11.C_SignUpdate(this.sessionHandle, dataPart);
            this.debugOut("C_SignUpdate");
        }
        catch (PKCS11Exception e) {
            this.debugError("C_SignUpdate", e);
            throw e;
        }
    }

    public void signUpdate(byte[] in, int inOfs, int inLen) throws PKCS11Exception {
        String method = "C_SignUpdate";
        this.debugIn("C_SignUpdate", "in.length={}", Session.len(in));
        try {
            if (inOfs == 0 && inLen == in.length) {
                this.pkcs11.C_SignUpdate(this.sessionHandle, in);
            } else {
                this.pkcs11.C_SignUpdate(this.sessionHandle, Arrays.copyOfRange(in, inOfs, inOfs + inLen));
            }
            this.debugOut("C_SignUpdate");
        }
        catch (PKCS11Exception e) {
            this.debugError("C_SignUpdate", e);
            throw e;
        }
    }

    public byte[] signFinal() throws PKCS11Exception {
        String method = "C_SignFinal";
        this.debugIn("C_SignFinal");
        try {
            byte[] sigValue = this.pkcs11.C_SignFinal(this.sessionHandle);
            this.debugOut("C_SignFinal", "rv.length={]", Session.len(sigValue));
            return this.toNonNull(this.fixSignOutput(sigValue));
        }
        catch (PKCS11Exception e) {
            this.debugError("C_SignFinal", e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] fixSignOutput(byte[] signatureValue) {
        if (this.signatureType == 0) {
            return signatureValue;
        }
        PKCS11Module pKCS11Module = this.module;
        synchronized (pKCS11Module) {
            if (this.signatureType == 1) {
                Boolean b = this.module.getEcdsaSignatureFixNeeded();
                if (b == null) {
                    StaticLogger.info("EcdsaSignatureFixNeeded: null", new Object[0]);
                } else {
                    StaticLogger.debug("EcdsaSignatureFixNeeded: {}", b);
                }
                if (b == null || b.booleanValue()) {
                    boolean fixed;
                    byte[] fixedSigValue;
                    if (this.signVerifyExtraParams != null) {
                        int rOrSLen = (this.signVerifyExtraParams.ecOrderBitSize() + 7) / 8;
                        fixedSigValue = Functions.fixECDSASignature(signatureValue, rOrSLen);
                    } else {
                        byte[] ecParams;
                        try {
                            ecParams = this.getAttrValues(this.signOrVerifyKeyHandle, 384L).ecParams();
                        }
                        catch (PKCS11Exception e) {
                            StaticLogger.debug("error getting CKA_EC_PARAMS for key {}", this.signOrVerifyKeyHandle);
                            return signatureValue;
                        }
                        if (ecParams == null) {
                            StaticLogger.debug("found no CKA_EC_PARAMS for key {}", this.signOrVerifyKeyHandle);
                            return signatureValue;
                        }
                        fixedSigValue = Functions.fixECDSASignature(signatureValue, ecParams);
                    }
                    boolean bl = fixed = !Arrays.equals(fixedSigValue, signatureValue);
                    if (b == null) {
                        StaticLogger.info("Set EcdsaSignatureFixNeeded to {}", b);
                        this.module.setEcdsaSignatureFixNeeded(fixed);
                    }
                    return fixedSigValue;
                }
            } else if (this.signatureType == 2) {
                Boolean b = this.module.getSm2SignatureFixNeeded();
                if (b == null) {
                    StaticLogger.info("Sm2SignatureFixNeeded: null", new Object[0]);
                } else {
                    StaticLogger.debug("Sm2SignatureFixNeeded: {}", b);
                }
                if (b == null || b.booleanValue()) {
                    boolean fixed;
                    byte[] fixedSigValue = Functions.fixECDSASignature(signatureValue, 32);
                    boolean bl = fixed = !Arrays.equals(fixedSigValue, signatureValue);
                    if (b == null) {
                        StaticLogger.info("Set Sm2SignatureFixNeeded to {}", b);
                        this.module.setSm2SignatureFixNeeded(fixed);
                    }
                    return fixedSigValue;
                }
            }
            return signatureValue;
        }
    }

    private byte[] fixSignatureToVerify(byte[] signatureValue) {
        if (this.signatureType == 1 ? this.module.hasVendorBehaviour(1) : this.signatureType == 2 && this.module.hasVendorBehaviour(2)) {
            return Functions.dsaSigPlainToX962(signatureValue);
        }
        return signatureValue;
    }

    public void signRecoverInit(Mechanism mechanism, long keyHandle) throws PKCS11Exception {
        String method = "C_SignRecoverInit";
        this.debugIn("C_SignRecoverInit", "mechanism={}, keyHandle={}", mechanism, keyHandle);
        try {
            this.pkcs11.C_SignRecoverInit(this.sessionHandle, this.toCkMechanism(mechanism), keyHandle, this.useUtf8);
            this.debugOut("C_SignRecoverInit");
        }
        catch (PKCS11Exception e) {
            this.debugError("C_SignRecoverInit", e);
            throw e;
        }
    }

    public byte[] signRecover(byte[] data) throws PKCS11Exception {
        String method = "C_SignRecover";
        this.debugIn("C_SignRecover", "data.length={}", Session.len(data));
        try {
            return this.toNonNull("C_SignRecover", this.pkcs11.C_SignRecover(this.sessionHandle, data));
        }
        catch (PKCS11Exception e) {
            this.debugError("C_SignRecover", e);
            throw e;
        }
    }

    public byte[] signRecoverSingle(Mechanism mechanism, long keyHandle, byte[] data) throws PKCS11Exception {
        this.signRecoverInit(mechanism, keyHandle);
        return this.signRecover(data);
    }

    public void messageSignInit(Mechanism mechanism, long keyHandle) throws PKCS11Exception {
        String method = "C_MessageSignInit";
        this.initSignVerify(mechanism, keyHandle);
        this.debugIn("C_MessageSignInit", "mechanism={}, keyHandle={}", mechanism, keyHandle);
        try {
            this.pkcs11.C_MessageSignInit(this.sessionHandle, this.toCkMechanism(mechanism), keyHandle, this.useUtf8);
            this.debugOut("C_MessageSignInit");
        }
        catch (PKCS11Exception e) {
            this.debugError("C_MessageSignInit", e);
            throw e;
        }
    }

    public byte[] signMessage(CkParams params, byte[] data) throws PKCS11Exception {
        String method = "C_SignMessage";
        this.debugIn("C_SignMessage", "params={}, data.length={}", params, Session.len(data));
        try {
            return this.toNonNull("C_SignMessage", this.pkcs11.C_SignMessage(this.sessionHandle, this.toCkParameters(params), data, this.useUtf8));
        }
        catch (PKCS11Exception e) {
            this.debugError("C_SignMessage", e);
            throw e;
        }
    }

    public void signMessageBegin(CkParams params) throws PKCS11Exception {
        String method = "C_SignMessageBegin";
        this.debugIn("C_SignMessageBegin", "params={}", params);
        try {
            this.pkcs11.C_SignMessageBegin(this.sessionHandle, this.toCkParameters(params), this.useUtf8);
            this.debugOut("C_SignMessageBegin");
        }
        catch (PKCS11Exception e) {
            this.debugError("C_SignMessageBegin", e);
            throw e;
        }
    }

    public byte[] signMessageNext(CkParams params, byte[] data, boolean isLastOperation) throws PKCS11Exception {
        String method = "C_SignMessageNext";
        this.debugIn("C_SignMessageNext", "params={}, data.length={}, isLastOperation={}", params, Session.len(data), isLastOperation);
        try {
            byte[] signature = this.pkcs11.C_SignMessageNext(this.sessionHandle, this.toCkParameters(params), data, isLastOperation, this.useUtf8);
            return this.toNonNull("C_SignMessageNext", this.fixSignOutput(signature));
        }
        catch (PKCS11Exception e) {
            this.debugError("C_SignMessageNext", e);
            throw e;
        }
    }

    public void messageSignFinal() throws PKCS11Exception {
        String method = "C_MessageSignFinal";
        this.debugIn("C_MessageSignFinal");
        try {
            this.pkcs11.C_MessageSignFinal(this.sessionHandle);
            this.debugOut("C_MessageSignFinal");
        }
        catch (PKCS11Exception e) {
            this.debugError("C_MessageSignFinal", e);
            throw e;
        }
    }

    public void verifyInit(Mechanism mechanism, long keyHandle) throws PKCS11Exception {
        String method = "C_VerifyInit";
        this.initSignVerify(mechanism, keyHandle);
        this.debugIn("C_VerifyInit", "mechanism={}, keyHandle={}", mechanism, keyHandle);
        try {
            this.pkcs11.C_VerifyInit(this.sessionHandle, this.toCkMechanism(mechanism), keyHandle, this.useUtf8);
            this.debugOut("C_VerifyInit");
        }
        catch (PKCS11Exception e) {
            this.debugError("C_VerifyInit", e);
            throw e;
        }
    }

    public void verify(byte[] data, byte[] signature) throws PKCS11Exception {
        String method = "C_Verify";
        byte[] realSig = this.fixSignatureToVerify(signature);
        this.debugIn("C_Verify", "data.length={}, signature.length={}", Session.len(data), Session.len(realSig));
        try {
            this.pkcs11.C_Verify(this.sessionHandle, data, realSig);
            this.debugOut("C_Verify");
        }
        catch (PKCS11Exception e) {
            this.debugError("C_Verify", e);
            throw e;
        }
    }

    public void verifySingle(Mechanism mechanism, long keyHandle, byte[] data, byte[] signature) throws PKCS11Exception {
        this.verifyInit(mechanism, keyHandle);
        this.verify(data, signature);
    }

    public void verifyUpdate(byte[] dataPart) throws PKCS11Exception {
        String method = "C_VerifyUpdate";
        this.debugIn("C_VerifyUpdate", "dataPart.length={}", Session.len(dataPart));
        try {
            this.pkcs11.C_VerifyUpdate(this.sessionHandle, dataPart);
            this.debugOut("C_VerifyUpdate");
        }
        catch (PKCS11Exception e) {
            this.debugError("C_VerifyUpdate", e);
            throw e;
        }
    }

    public void verifyFinal(byte[] signature) throws PKCS11Exception {
        String method = "C_VerifyFinal";
        byte[] realSig = this.fixSignatureToVerify(signature);
        this.debugIn("C_VerifyFinal", "signature.length={}", Session.len(realSig));
        try {
            this.pkcs11.C_VerifyFinal(this.sessionHandle, realSig);
            this.debugOut("C_VerifyFinal");
        }
        catch (PKCS11Exception e) {
            this.debugError("C_VerifyFinal", e);
            throw e;
        }
    }

    public void verifyRecoverInit(Mechanism mechanism, long keyHandle) throws PKCS11Exception {
        String method = "C_VerifyRecoverInit";
        this.debugIn("C_VerifyRecoverInit", "mechanism={}, keyHandle={}", mechanism, keyHandle);
        try {
            this.pkcs11.C_VerifyRecoverInit(this.sessionHandle, this.toCkMechanism(mechanism), keyHandle, this.useUtf8);
            this.debugOut("C_VerifyRecoverInit");
        }
        catch (PKCS11Exception e) {
            this.debugError("C_VerifyRecoverInit", e);
            throw e;
        }
    }

    public byte[] verifyRecover(byte[] data) throws PKCS11Exception {
        String method = "C_VerifyRecover";
        this.debugIn("C_VerifyRecover", "data.length={}", Session.len(data));
        try {
            return this.toNonNull("C_VerifyRecover", this.pkcs11.C_VerifyRecover(this.sessionHandle, data));
        }
        catch (PKCS11Exception e) {
            this.debugError("C_VerifyRecover", e);
            throw e;
        }
    }

    public byte[] verifyRecoverSingle(Mechanism mechanism, long keyHandle, byte[] data) throws PKCS11Exception {
        this.verifyRecoverInit(mechanism, keyHandle);
        return this.verifyRecover(data);
    }

    public void messageVerifyInit(Mechanism mechanism, long keyHandle) throws PKCS11Exception {
        String method = "C_MessageVerifyInit";
        this.initSignVerify(mechanism, keyHandle);
        this.debugIn("C_MessageVerifyInit", "mechanism={}, keyHandle={}", mechanism, keyHandle);
        try {
            this.pkcs11.C_MessageVerifyInit(this.sessionHandle, this.toCkMechanism(mechanism), keyHandle, this.useUtf8);
            this.debugOut("C_MessageVerifyInit");
        }
        catch (PKCS11Exception e) {
            this.debugError("C_MessageVerifyInit", e);
            throw e;
        }
    }

    public void verifyMessage(CkParams params, byte[] data, byte[] signature) throws PKCS11Exception {
        String method = "C_VerifyMessage";
        this.debugIn("C_VerifyMessage", "params={}, data.length={}, signature.length={}", params, Session.len(data), Session.len(signature));
        try {
            this.pkcs11.C_VerifyMessage(this.sessionHandle, this.toCkParameters(params), data, this.fixSignatureToVerify(signature), this.useUtf8);
            this.debugOut("C_VerifyMessage");
        }
        catch (PKCS11Exception e) {
            this.debugError("C_VerifyMessage", e);
            throw e;
        }
    }

    public void verifyMessageBegin(CkParams params) throws PKCS11Exception {
        String method = "C_VerifyMessageBegin";
        this.debugIn("C_VerifyMessageBegin", "params={}", params);
        try {
            this.pkcs11.C_VerifyMessageBegin(this.sessionHandle, this.toCkParameters(params), this.useUtf8);
            this.debugOut("C_VerifyMessageBegin");
        }
        catch (PKCS11Exception e) {
            this.debugError("C_VerifyMessageBegin", e);
            throw e;
        }
    }

    public void verifyMessageNext(CkParams params, byte[] data, byte[] signature) throws PKCS11Exception {
        String method = "C_VerifyMessageNext";
        this.debugIn("C_VerifyMessageNext", "params={}, data.length={}, signature.length={}", params, Session.len(data), Session.len(signature));
        try {
            this.pkcs11.C_VerifyMessageNext(this.sessionHandle, this.toCkParameters(params), data, this.fixSignatureToVerify(signature), this.useUtf8);
            this.debugOut("C_VerifyMessageNext");
        }
        catch (PKCS11Exception e) {
            this.debugError("C_VerifyMessageNext", e);
            throw e;
        }
    }

    public void messageVerifyFinal() throws PKCS11Exception {
        String method = "C_MessageVerifyFinal";
        this.debugIn("C_MessageVerifyFinal");
        try {
            this.pkcs11.C_MessageVerifyFinal(this.sessionHandle);
            this.debugOut("C_MessageVerifyFinal");
        }
        catch (PKCS11Exception e) {
            this.debugError("C_MessageVerifyFinal", e);
            throw e;
        }
    }

    public byte[] digestEncryptedUpdate(byte[] part) throws PKCS11Exception {
        String method = "C_DigestEncryptUpdate";
        this.debugIn("C_DigestEncryptUpdate", "part.length={}", Session.len(part));
        try {
            return this.toNonNull("C_DigestEncryptUpdate", this.pkcs11.C_DigestEncryptUpdate(this.sessionHandle, part));
        }
        catch (PKCS11Exception e) {
            this.debugError("C_DigestEncryptUpdate", e);
            throw e;
        }
    }

    public byte[] decryptDigestUpdate(byte[] part) throws PKCS11Exception {
        String method = "C_DecryptDigestUpdate";
        this.debugIn("C_DecryptDigestUpdate", "part.length={}", Session.len(part));
        try {
            return this.toNonNull("C_DecryptDigestUpdate", this.pkcs11.C_DecryptDigestUpdate(this.sessionHandle, part));
        }
        catch (PKCS11Exception e) {
            this.debugError("C_DecryptDigestUpdate", e);
            throw e;
        }
    }

    public byte[] signEncryptUpdate(byte[] part) throws PKCS11Exception {
        String method = "C_SignEncryptUpdate";
        this.debugIn("C_SignEncryptUpdate", "part.length={}", Session.len(part));
        try {
            return this.toNonNull("C_SignEncryptUpdate", this.pkcs11.C_SignEncryptUpdate(this.sessionHandle, part));
        }
        catch (PKCS11Exception e) {
            this.debugError("C_SignEncryptUpdate", e);
            throw e;
        }
    }

    public byte[] decryptVerifyUpdate(byte[] encryptedPart) throws PKCS11Exception {
        String method = "C_DecryptVerifyUpdate";
        this.debugIn("C_DecryptVerifyUpdate", "encryptedPart.length={}", Session.len(encryptedPart));
        try {
            return this.toNonNull("C_DecryptVerifyUpdate", this.pkcs11.C_DecryptVerifyUpdate(this.sessionHandle, encryptedPart));
        }
        catch (PKCS11Exception e) {
            this.debugError("C_DecryptVerifyUpdate", e);
            throw e;
        }
    }

    public long generateKey(Mechanism mechanism, AttributeVector template) throws PKCS11Exception {
        String method = "C_GenerateKey";
        this.debugIn("C_GenerateKey", "mechanism={}, template={}", mechanism, template);
        try {
            long hKey = this.pkcs11.C_GenerateKey(this.sessionHandle, this.toCkMechanism(mechanism), this.toOutCKAttributes(template), this.useUtf8);
            this.debugOut("C_GenerateKey", "hKey={}", hKey);
            return hKey;
        }
        catch (PKCS11Exception e) {
            this.debugError("C_GenerateKey", e);
            throw e;
        }
    }

    public PKCS11KeyPair generateKeyPair(Mechanism mechanism, KeyPairTemplate template) throws PKCS11Exception {
        String method = "C_GenerateKeyPair";
        this.debugIn("C_GenerateKeyPair", "mechanism={}, template={}", mechanism, template);
        try {
            long[] objectHandles = this.pkcs11.C_GenerateKeyPair(this.sessionHandle, this.toCkMechanism(mechanism), this.toOutCKAttributes(template.publicKey()), this.toOutCKAttributes(template.privateKey()), this.useUtf8);
            PKCS11KeyPair rv = new PKCS11KeyPair(objectHandles[0], objectHandles[1]);
            this.debugOut("C_GenerateKeyPair", "hPublicKey={}, hPrivateKey={}", rv.getPublicKey(), rv.getPrivateKey());
            return rv;
        }
        catch (PKCS11Exception e) {
            this.debugError("C_GenerateKeyPair", e);
            throw e;
        }
    }

    public byte[] wrapKey(Mechanism mechanism, long wrappingKeyHandle, long keyHandle) throws PKCS11Exception {
        String method = "C_WrapKey";
        this.debugIn("C_WrapKey", "mechanism={}, wrappingKeyHandle={}, keyHandle={}", mechanism, wrappingKeyHandle, keyHandle);
        try {
            return this.toNonNull("C_WrapKey", this.pkcs11.C_WrapKey(this.sessionHandle, this.toCkMechanism(mechanism), wrappingKeyHandle, keyHandle, this.useUtf8));
        }
        catch (PKCS11Exception e) {
            this.debugError("C_WrapKey", e);
            throw e;
        }
    }

    public long unwrapKey(Mechanism mechanism, long unwrappingKeyHandle, byte[] wrappedKey, AttributeVector keyTemplate) throws PKCS11Exception {
        String method = "C_UnwrapKey";
        this.debugIn("C_UnwrapKey", "mechanism={}, unwrappingKeyHandle={}, wrappedKey.length={}, template={}", mechanism, unwrappingKeyHandle, Session.len(wrappedKey), keyTemplate);
        try {
            long hKey = this.pkcs11.C_UnwrapKey(this.sessionHandle, this.toCkMechanism(mechanism), unwrappingKeyHandle, wrappedKey, this.toOutCKAttributes(keyTemplate), this.useUtf8);
            this.debugOut("C_UnwrapKey", "hKey={}", hKey);
            return hKey;
        }
        catch (PKCS11Exception e) {
            this.debugError("C_UnwrapKey", e);
            throw e;
        }
    }

    public long deriveKey(Mechanism mechanism, long baseKeyHandle, AttributeVector template) throws PKCS11Exception {
        String method = "C_DeriveKey";
        this.debugIn("C_DeriveKey", "mechanism={}, baseKeyHandle={}, template={}", mechanism, baseKeyHandle, template);
        try {
            long hKey = this.pkcs11.C_DeriveKey(this.sessionHandle, this.toCkMechanism(mechanism), baseKeyHandle, this.toOutCKAttributes(template), this.useUtf8);
            this.debugOut("C_DeriveKey", "hKey={}", hKey);
            return hKey;
        }
        catch (PKCS11Exception e) {
            this.debugError("C_DeriveKey", e);
            throw e;
        }
    }

    public void seedRandom(byte[] seed) throws PKCS11Exception {
        this.pkcs11.C_SeedRandom(this.sessionHandle, seed);
    }

    public byte[] generateRandom(int numberOfBytesToGenerate) throws PKCS11Exception {
        byte[] randomBytesBuffer = new byte[numberOfBytesToGenerate];
        String method = "C_GenerateRandom";
        this.debugIn("C_GenerateRandom", "numberOfBytesToGenerate={}", numberOfBytesToGenerate);
        try {
            this.pkcs11.C_GenerateRandom(this.sessionHandle, randomBytesBuffer);
            return this.toNonNull("C_GenerateRandom", randomBytesBuffer);
        }
        catch (PKCS11Exception e) {
            this.debugError("C_GenerateRandom", e);
            throw e;
        }
    }

    public void getFunctionStatus() throws PKCS11Exception {
        this.pkcs11.C_GetFunctionStatus(this.sessionHandle);
    }

    public void cancelFunction() throws PKCS11Exception {
        this.pkcs11.C_CancelFunction(this.sessionHandle);
    }

    public boolean isRwSession() throws PKCS11Exception {
        if (this.rwSession == null) {
            this.rwSession = this.getSessionInfo().isRwSession();
        }
        return this.rwSession;
    }

    public String toString() {
        return "Session Handle: 0x" + Long.toHexString(this.sessionHandle) + "\nToken: " + this.token;
    }

    private CK_MECHANISM toCkMechanism(Mechanism mechanism) {
        CK_MECHANISM ckMechanism = mechanism.toCkMechanism();
        long code = ckMechanism.mechanism;
        if ((code & 0x80000000L) != 0L) {
            ckMechanism.mechanism = this.module.ckmGenericToVendor(code);
        }
        return ckMechanism;
    }

    private Object toCkParameters(CkParams params) {
        return params == null ? null : params.getParams();
    }

    public String getStringAttrValue(long objectHandle, long attributeType) throws PKCS11Exception {
        CharArrayAttribute attr = new CharArrayAttribute(attributeType);
        this.doGetAttrValue(objectHandle, attr);
        return attr.getValue();
    }

    public AttributeVector getAttrValues(long objectHandle, long ... attributeTypes) throws PKCS11Exception {
        ArrayList<Long> typeList = new ArrayList<Long>(attributeTypes.length);
        for (long attrType : attributeTypes) {
            typeList.add(attrType);
        }
        return this.getAttrValues(objectHandle, typeList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeVector getAttrValues(long objectHandle, List<Long> attributeTypes) throws PKCS11Exception {
        if (attributeTypes.contains(385L) && !attributeTypes.contains(384L)) {
            PKCS11Module pKCS11Module = this.module;
            synchronized (pKCS11Module) {
                Boolean b = this.module.getEcPointFixNeeded();
                if (b == null || b.booleanValue()) {
                    attributeTypes.add(384L);
                }
            }
        }
        Attribute[] attrs = new Attribute[attributeTypes.size()];
        int index = 0;
        long[] firstTypes = new long[]{0L, 256L, 384L, 385L};
        for (long type : firstTypes) {
            if (!attributeTypes.remove(type)) continue;
            attrs[index++] = Attribute.getInstance(type);
        }
        Object object = attributeTypes.iterator();
        while (object.hasNext()) {
            long type = (Long)object.next();
            attrs[index++] = Attribute.getInstance(type);
        }
        this.doGetAttrValues(objectHandle, attrs);
        return new AttributeVector(attrs);
    }

    public AttributeVector getDefaultAttrValues(long objectHandle) throws PKCS11Exception {
        long objClass = this.getAttrValues(objectHandle, 0L).class_();
        LinkedList<Long> ckaTypes = new LinkedList<Long>();
        Session.addCkaTypes(ckaTypes, 3L, 258L, 1L);
        if (objClass == 4L || objClass == 3L) {
            boolean isSensitive;
            Session.addCkaTypes(ckaTypes, 0x40000600L, 261L, 354L, 358L, 356L, 2L, 264L, 263L, 1073742354L, 528L);
            AttributeVector attrs = this.getAttrValues(objectHandle, 256L, 259L, 357L);
            long keyType = attrs.keyType();
            Boolean sensitive = attrs.sensitive();
            Boolean alwaysSensitive = attrs.alwaysSensitive();
            boolean bl = isSensitive = sensitive == null || sensitive != false;
            if (alwaysSensitive != null) {
                isSensitive |= alwaysSensitive.booleanValue();
            }
            if (objClass == 4L) {
                Session.addCkaTypes(ckaTypes, 260L, 134L, 266L, 262L, 1073742353L);
                if (keyType != 19L && keyType != 20L && keyType != 21L) {
                    ckaTypes.add(353L);
                }
                if (!isSensitive) {
                    ckaTypes.add(17L);
                }
            } else {
                Session.addCkaTypes(ckaTypes, 514L, 265L);
                if (keyType == 0L) {
                    Session.addCkaTypes(ckaTypes, 288L, 290L);
                    if (!isSensitive) {
                        Session.addCkaTypes(ckaTypes, 291L, 292L, 293L, 294L, 295L, 296L);
                    }
                } else if (keyType == 3L || keyType == 64L || keyType == 65L || keyType == 0xFFFFF001L) {
                    ckaTypes.add(384L);
                    if (!isSensitive) {
                        ckaTypes.add(17L);
                    }
                } else if (keyType == 1L) {
                    Session.addCkaTypes(ckaTypes, 304L, 305L, 306L);
                    if (!isSensitive) {
                        ckaTypes.add(17L);
                    }
                }
            }
            return this.getAttrValues(objectHandle, ckaTypes).class_(objClass).keyType(keyType).sensitive(sensitive).alwaysSensitive(alwaysSensitive);
        }
        if (objClass == 2L) {
            Session.addCkaTypes(ckaTypes, 0x40000600L, 260L, 358L, 134L, 266L, 267L, 262L, 1073742353L);
            long keyType = this.getAttrValues(objectHandle, 256L).keyType();
            if (keyType == 0L) {
                Session.addCkaTypes(ckaTypes, 288L, 290L);
            } else if (keyType == 3L || keyType == 64L || keyType == 65L || keyType == 0xFFFFF001L) {
                Session.addCkaTypes(ckaTypes, 384L, 385L);
            } else if (keyType == 1L) {
                Session.addCkaTypes(ckaTypes, 304L, 305L, 306L);
            }
            return this.getAttrValues(objectHandle, ckaTypes).class_(objClass).keyType(keyType);
        }
        if (objClass == 1L) {
            Session.addCkaTypes(ckaTypes, 134L, 135L, 272L, 273L);
            long certType = this.getAttrValues(objectHandle, 128L).certificateType();
            if (certType == 0L) {
                Session.addCkaTypes(ckaTypes, 17L, 137L, 129L, 257L, 130L, 139L, 138L);
            }
            return this.getAttrValues(objectHandle, ckaTypes).class_(objClass).certificateType(certType);
        }
        return this.getAttrValues(objectHandle, ckaTypes);
    }

    private static void addCkaTypes(List<Long> list, long ... types) {
        for (long type : types) {
            list.add(type);
        }
    }

    private void doGetAttrValues(long objectHandle, Attribute ... attributes) throws PKCS11Exception {
        Functions.requireNonNull("attributes", attributes);
        if (attributes.length == 1) {
            this.doGetAttrValue(objectHandle, attributes[0]);
            return;
        }
        CK_ATTRIBUTE[] attributeTemplateList = new CK_ATTRIBUTE[attributes.length];
        for (int i = 0; i < attributes.length; ++i) {
            attributeTemplateList[i] = new CK_ATTRIBUTE();
            attributeTemplateList[i].type = attributes[i].getType();
        }
        PKCS11Exception delayedEx = null;
        try {
            this.pkcs11.C_GetAttributeValue(this.sessionHandle, objectHandle, attributeTemplateList, this.useUtf8);
        }
        catch (PKCS11Exception ex) {
            delayedEx = ex;
        }
        for (int i = 0; i < attributes.length; ++i) {
            Attribute attribute = attributes[i];
            CK_ATTRIBUTE template = attributeTemplateList[i];
            if (template == null) continue;
            attribute.present(true).sensitive(false).ckAttribute(template);
        }
        if (delayedEx != null) {
            delayedEx = null;
            for (Attribute attr : attributes) {
                if (attr.getCkAttribute() != null && attr.getCkAttribute().pValue != null) continue;
                try {
                    this.doGetAttrValue0(objectHandle, attr, false);
                }
                catch (PKCS11Exception ex) {
                    if (delayedEx != null) continue;
                    delayedEx = ex;
                }
            }
        }
        for (Attribute attr : attributes) {
            this.postProcessGetAttribute(attr, objectHandle, attributes);
        }
        if (delayedEx != null) {
            throw delayedEx;
        }
    }

    private void doGetAttrValue(long objectHandle, Attribute attribute) throws PKCS11Exception {
        Boolean b;
        if (attribute.getType() == 385L && ((b = this.module.getEcPointFixNeeded()) == null || b.booleanValue())) {
            this.doGetAttrValues(objectHandle, new ByteArrayAttribute(384L), attribute);
            return;
        }
        this.doGetAttrValue0(objectHandle, attribute, true);
    }

    private void doGetAttrValue0(long objectHandle, Attribute attribute, boolean postProcess) throws PKCS11Exception {
        attribute.present(false);
        try {
            CK_ATTRIBUTE[] attributeTemplateList = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE()};
            attributeTemplateList[0].type = attribute.getType();
            this.pkcs11.C_GetAttributeValue(this.sessionHandle, objectHandle, attributeTemplateList, this.useUtf8);
            attribute.ckAttribute(attributeTemplateList[0]).present(true).sensitive(false);
        }
        catch (PKCS11Exception ex) {
            long ec = ex.getErrorCode();
            if (ec == 18L) {
                if (attribute.getType() == 384L) {
                    attribute.present((boolean)false).getCkAttribute().pValue = null;
                }
            }
            if (ec == 17L) {
                attribute.getCkAttribute().pValue = null;
                attribute.present((boolean)true).sensitive((boolean)true).getCkAttribute().pValue = null;
            }
            if (ec == 7L || ec == 6L || ec == 512L) {
                attribute.present((boolean)false).sensitive((boolean)false).getCkAttribute().pValue = null;
            }
            throw ex;
        }
        if (postProcess) {
            this.postProcessGetAttribute(attribute, objectHandle, new Attribute[0]);
        }
    }

    private CK_ATTRIBUTE[] toOutCKAttributes(AttributeVector template) {
        return this.toOutCKAttributes(template, false);
    }

    private CK_ATTRIBUTE[] toOutCKAttributes(AttributeVector template, boolean withoutNullValueAttr) {
        if (template == null) {
            return null;
        }
        CK_ATTRIBUTE[] ckAttrs = template.toCkAttributes();
        ArrayList<CK_ATTRIBUTE> nonNullCkAttrs = null;
        if (withoutNullValueAttr) {
            nonNullCkAttrs = new ArrayList<CK_ATTRIBUTE>(ckAttrs.length);
        }
        for (CK_ATTRIBUTE ckAttr : ckAttrs) {
            if (ckAttr.pValue == null) continue;
            if (withoutNullValueAttr) {
                nonNullCkAttrs.add(ckAttr);
            }
            if (ckAttr.type == 256L) {
                long value = (Long)ckAttr.pValue;
                if ((value & 0x80000000L) == 0L) continue;
                ckAttr.pValue = this.module.ckkGenericToVendor(value);
                continue;
            }
            if (ckAttr.type != 385L) continue;
            ckAttr.pValue = Functions.toOctetString((byte[])ckAttr.pValue);
        }
        return nonNullCkAttrs != null && nonNullCkAttrs.size() != ckAttrs.length ? nonNullCkAttrs.toArray(new CK_ATTRIBUTE[0]) : ckAttrs;
    }

    private void postProcessGetAttribute(Attribute attr, long objectHandle, Attribute ... otherAttrs) {
        long type = attr.getType();
        CK_ATTRIBUTE ckAttr = attr.getCkAttribute();
        if (type == 384L) {
            if (ckAttr.pValue == null) {
                Long keyType = null;
                if (otherAttrs != null) {
                    for (Attribute otherAttr : otherAttrs) {
                        if (otherAttr.type() != 256L) continue;
                        keyType = ((LongAttribute)otherAttr).getValue();
                    }
                }
                if (keyType == null) {
                    try {
                        keyType = this.getAttrValues(objectHandle, 256L).keyType();
                    }
                    catch (PKCS11Exception pKCS11Exception) {
                        // empty catch block
                    }
                }
                if (keyType != null && keyType == 0xFFFFF001L) {
                    attr.present((boolean)false).getCkAttribute().pValue = Functions.decodeHex("06082a811ccf5501822d");
                }
            } else {
                byte[] ecParams = (byte[])ckAttr.pValue;
                if (ecParams[0] != 6) {
                    ckAttr.pValue = Functions.fixECParams((byte[])ckAttr.pValue);
                }
            }
            return;
        }
        if (ckAttr == null || ckAttr.pValue == null) {
            return;
        }
        if (type == 256L) {
            long value = (Long)ckAttr.pValue;
            if ((value & 0x80000000L) != 0L && !PKCS11Constants.isUnavailableInformation(value)) {
                ckAttr.pValue = this.module.ckkVendorToGeneric(value);
            }
        } else if (type == 358L) {
            long value = (Long)ckAttr.pValue;
            if ((value & 0x80000000L) != 0L && !PKCS11Constants.isUnavailableInformation(value)) {
                ckAttr.pValue = this.module.ckmVendorToGeneric(value);
            }
        } else if (type == 0x40000600L) {
            long[] mechs;
            for (long mech : mechs = ((MechanismArrayAttribute)attr).getValue()) {
                if ((mech & 0x80000000L) == 0L) continue;
                ckAttr.pValue = this.module.ckmVendorToGeneric(mech);
            }
        } else if (type == 385L) {
            Boolean b = this.module.getEcPointFixNeeded();
            byte[] pValue = (byte[])ckAttr.pValue;
            if (b == null || b.booleanValue()) {
                byte[] ecParams = null;
                if (otherAttrs != null) {
                    for (Attribute otherAttr : otherAttrs) {
                        if (otherAttr.getType() != 384L) continue;
                        ecParams = ((ByteArrayAttribute)otherAttr).getValue();
                        break;
                    }
                }
                byte[] fixedCoreEcPoint = Functions.getCoreECPoint(pValue, ecParams);
                if (b == null) {
                    byte[] coreEcPoint = Functions.getCoreECPoint(pValue);
                    this.module.setEcPointFixNeeded(!Arrays.equals(coreEcPoint, fixedCoreEcPoint));
                }
                ckAttr.pValue = fixedCoreEcPoint;
            } else {
                ckAttr.pValue = Functions.getCoreECPoint(pValue);
            }
        } else if (attr instanceof BooleanAttribute && ckAttr.pValue instanceof byte[]) {
            byte[] value = (byte[])ckAttr.pValue;
            boolean allZeros = true;
            for (byte b : value) {
                if (b == 0) continue;
                allZeros = false;
                break;
            }
            ckAttr.pValue = !allZeros;
        }
    }

    private void debugIn(String method) {
        if (StaticLogger.isDebugEnabled()) {
            StaticLogger.debug("IN  " + method + ": hSession=" + this.sessionHandle, new Object[0]);
        }
    }

    private void debugIn(String method, String format, Object ... arguments) {
        if (StaticLogger.isDebugEnabled()) {
            StaticLogger.debug("IN  " + method + ": hSession=" + this.sessionHandle + ", " + format, arguments);
        }
    }

    private void debugOut(String method) {
        if (StaticLogger.isDebugEnabled()) {
            StaticLogger.debug("OUT " + method + ": hSession=" + this.sessionHandle, new Object[0]);
        }
    }

    private void debugOut(String method, String format, Object ... arguments) {
        if (StaticLogger.isDebugEnabled()) {
            StaticLogger.debug("OUT " + method + ": hSession=" + this.sessionHandle + ", " + format, arguments);
        }
    }

    private void debugError(String method, PKCS11Exception e) {
        if (StaticLogger.isDebugEnabled()) {
            StaticLogger.debug("ERR " + method + ": " + PKCS11Constants.ckrCodeToName(e.getErrorCode()), new Object[0]);
        }
    }

    private static int len(byte[] bytes) {
        return bytes == null ? 0 : bytes.length;
    }

    private byte[] toNonNull(String method, byte[] bytes) {
        if (bytes == null) {
            this.debugOut(method, "rv=null", new Object[0]);
        } else {
            this.debugOut(method, "rv.length={}", bytes.length);
        }
        return bytes == null ? new byte[]{} : bytes;
    }

    private byte[] toNonNull(byte[] bytes) {
        return bytes == null ? new byte[]{} : bytes;
    }
}

