/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.pkcs11.wrapper;

import org.xipki.pkcs11.wrapper.Functions;
import org.xipki.pkcs11.wrapper.PKCS11Exception;
import org.xipki.pkcs11.wrapper.PKCS11Module;
import org.xipki.pkcs11.wrapper.SlotInfo;
import org.xipki.pkcs11.wrapper.Token;

public class Slot {
    private final PKCS11Module module;
    private final long slotID;
    private boolean useUtf8Encoding = true;

    protected Slot(PKCS11Module module, long slotID) {
        this.module = Functions.requireNonNull("module", module);
        this.slotID = slotID;
    }

    public void setUseUtf8Encoding(boolean useUtf8Encoding) {
        this.useUtf8Encoding = useUtf8Encoding;
    }

    public boolean isUseUtf8Encoding() {
        return this.useUtf8Encoding;
    }

    public PKCS11Module getModule() {
        return this.module;
    }

    public long getSlotID() {
        return this.slotID;
    }

    public SlotInfo getSlotInfo() throws PKCS11Exception {
        return new SlotInfo(this.module.getPKCS11Module().C_GetSlotInfo(this.slotID));
    }

    public Token getToken() throws PKCS11Exception {
        return this.getSlotInfo().isTokenPresent() ? new Token(this) : null;
    }

    public String toString() {
        return "Slot ID: 0x" + Long.toHexString(this.slotID) + "\nModule: " + this.module;
    }
}

