/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.pkcs11.wrapper.params;

import iaik.pkcs.pkcs11.wrapper.CK_CCM_PARAMS;
import org.xipki.pkcs11.wrapper.Functions;
import org.xipki.pkcs11.wrapper.params.CkParams;

public class CCM_PARAMS
extends CkParams {
    private final CK_CCM_PARAMS params = new CK_CCM_PARAMS();

    public CCM_PARAMS(int dataLen, byte[] nonce, byte[] aad, int macLen) {
        this.params.pNonce = CCM_PARAMS.requireNonNull("nonce", nonce);
        Functions.requireRange("nonce.length", nonce.length, 7, 13);
        this.params.ulMacLen = Functions.requireAmong("macLen", macLen, 4, 6, 8, 10, 12, 14, 16);
        this.params.ulDataLen = dataLen;
        this.params.pAAD = aad;
    }

    @Override
    public CK_CCM_PARAMS getParams() {
        return this.params;
    }

    public void setDataLen(int dataLen) {
        this.params.ulDataLen = dataLen;
    }

    @Override
    protected int getMaxFieldLen() {
        return 9;
    }

    @Override
    public String toString(String indent) {
        return indent + "CK_CCM_PARAMS:" + this.val2Str(indent, "ulDataLen", this.params.ulDataLen) + this.ptr2str(indent, "pNonce", this.params.pNonce) + this.ptr2str(indent, "pAAD", this.params.pAAD) + this.val2Str(indent, "ulMacLen", this.params.ulMacLen);
    }
}

