/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.pkcs11.wrapper;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PublicKey;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.xipki.pkcs11.wrapper.AttributeVector;
import org.xipki.pkcs11.wrapper.KeyPairTemplate;
import org.xipki.pkcs11.wrapper.Mechanism;
import org.xipki.pkcs11.wrapper.MechanismInfo;
import org.xipki.pkcs11.wrapper.PKCS11Constants;
import org.xipki.pkcs11.wrapper.PKCS11Exception;
import org.xipki.pkcs11.wrapper.PKCS11Key;
import org.xipki.pkcs11.wrapper.PKCS11KeyId;
import org.xipki.pkcs11.wrapper.PKCS11KeyPair;
import org.xipki.pkcs11.wrapper.Session;
import org.xipki.pkcs11.wrapper.SessionInfo;
import org.xipki.pkcs11.wrapper.StaticLogger;
import org.xipki.pkcs11.wrapper.Token;
import org.xipki.pkcs11.wrapper.TokenException;
import org.xipki.pkcs11.wrapper.TokenInfo;
import org.xipki.pkcs11.wrapper.concurrent.ConcurrentBag;
import org.xipki.pkcs11.wrapper.concurrent.ConcurrentBagEntry;
import org.xipki.pkcs11.wrapper.multipart.DecryptMessageBytesEntry;
import org.xipki.pkcs11.wrapper.multipart.DecryptMessageStreamEntry;
import org.xipki.pkcs11.wrapper.multipart.EncryptMessageBytesEntry;
import org.xipki.pkcs11.wrapper.multipart.EncryptMessageStreamEntry;
import org.xipki.pkcs11.wrapper.multipart.SignMessageBytesEntry;
import org.xipki.pkcs11.wrapper.multipart.SignMessageStreamEntry;
import org.xipki.pkcs11.wrapper.multipart.VerifyMessageBytesEntry;
import org.xipki.pkcs11.wrapper.multipart.VerifyMessageStreamEntry;
import org.xipki.pkcs11.wrapper.params.CkParams;

public class PKCS11Token {
    private static final Clock clock = Clock.systemUTC();
    private int maxMessageSize = 2048;
    private final Token token;
    private final Map<Long, MechanismInfo> mechanisms = new HashMap<Long, MechanismInfo>();
    private final long userType;
    private final char[] userName;
    private final List<char[]> pins;
    private final int maxSessionCount;
    private final boolean readOnly;
    private final boolean isProtectedAuthenticationPath;
    private long timeOutWaitNewSessionMs = 10000L;
    private final AtomicLong countSessions = new AtomicLong(0L);
    private final ConcurrentBag<ConcurrentBagEntry<Session>> sessions = new ConcurrentBag();

    public PKCS11Token(Token token, boolean readOnly, char[] pin) throws TokenException {
        this(token, readOnly, 1L, null, pin == null ? null : Collections.singletonList(pin), null);
    }

    public PKCS11Token(Token token, boolean readOnly, long userType, char[] userName, List<char[]> pins, Integer numSessions) throws TokenException {
        this.token = Objects.requireNonNull(token, "token shall not be null");
        this.readOnly = readOnly;
        this.userType = userType;
        this.userName = userName;
        this.pins = pins;
        TokenInfo tokenInfo = token.getTokenInfo();
        int tokenMaxSessionCount = (int)tokenInfo.getMaxSessionCount();
        this.isProtectedAuthenticationPath = tokenInfo.isProtectedAuthenticationPath();
        this.maxSessionCount = numSessions == null ? (tokenMaxSessionCount < 1 ? 32 : Math.max(1, tokenMaxSessionCount - 2)) : numSessions;
        StaticLogger.info("tokenMaxSessionCount={}, maxSessionCount={}", tokenMaxSessionCount, this.maxSessionCount);
        for (long mech : token.getMechanismList()) {
            MechanismInfo mechInfo = token.getMechanismInfo(mech);
            this.mechanisms.put(mech, mechInfo);
        }
        Session session = this.openSession();
        this.login(session);
        this.sessions.add(new ConcurrentBagEntry<Session>(session));
    }

    public void setTimeOutWaitNewSession(int timeOutWaitNewSessionMs) {
        if (timeOutWaitNewSessionMs < 1000) {
            throw new IllegalArgumentException("timeOutWaitNewSessionMs is not greater than 999");
        }
        this.timeOutWaitNewSessionMs = timeOutWaitNewSessionMs;
    }

    public void setMaxMessageSize(int maxMessageSize) {
        if (maxMessageSize < 256) {
            throw new IllegalArgumentException("maxMessageSize too small, at least 256 is required: " + maxMessageSize);
        }
        this.maxMessageSize = maxMessageSize;
    }

    public Set<Long> getMechanisms() {
        return Collections.unmodifiableSet(this.mechanisms.keySet());
    }

    public MechanismInfo getMechanismInfo(long mechanism) {
        return this.mechanisms.get(mechanism);
    }

    public boolean supportsMechanism(long mechanism, long flagBit) {
        return this.supportsMechanism(mechanism, flagBit, false);
    }

    private boolean supportsMechanism(long mechanism, long flagBit, boolean withCorrection) {
        MechanismInfo info = this.mechanisms.get(mechanism);
        if (info == null) {
            return false;
        }
        if (info.hasFlagBit(flagBit)) {
            return true;
        }
        return withCorrection && flagBit == 8192L && info.hasFlagBit(2048L) && PKCS11Token.isMacMechanism(mechanism);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPIN(char[] oldPin, char[] newPin) throws TokenException {
        ConcurrentBagEntry<Session> session0 = this.borrowSession();
        Session session = session0.value();
        try {
            long sessionState = session.getSessionInfo().getState();
            if (sessionState == 0L) {
                return;
            }
            if (sessionState != 4L) {
                throw new TokenException("Session is not logged in as CKU_SO");
            }
            session.setPIN(oldPin, newPin);
            StaticLogger.info("setPIN", new Object[0]);
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initPIN(char[] pin) throws TokenException {
        ConcurrentBagEntry<Session> session0 = this.borrowSession();
        Session session = session0.value();
        try {
            long sessionState = session.getSessionInfo().getState();
            if (sessionState == 0L) {
                return;
            }
            if (sessionState != 4L) {
                throw new TokenException("Session is not logged in as CKU_SO");
            }
            session.initPIN(pin);
            StaticLogger.info("initPIN", new Object[0]);
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    public void closeAllSessions() {
        if (this.token != null) {
            try {
                StaticLogger.info("close all sessions on token: {}", this.token.getTokenInfo());
                for (ConcurrentBagEntry<Session> session : this.sessions.values()) {
                    session.value().closeSession();
                }
            }
            catch (Throwable th) {
                StaticLogger.error("error closing sessions, {}", th.getMessage());
            }
        }
        this.sessions.close();
        this.countSessions.lazySet(0L);
    }

    public long getTokenId() {
        return this.token.getTokenID();
    }

    public Token getToken() {
        return this.token;
    }

    public String getModuleInfo() throws TokenException {
        return this.token.getSlot().getModule().getInfo().toString();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logInSecurityOfficer(char[] userName, char[] pin) throws TokenException {
        ConcurrentBagEntry<Session> session0 = this.borrowNoLoginSession();
        Session session = session0.value();
        try {
            this.login(session, 0L, userName, pin == null ? null : Collections.singletonList(pin));
            StaticLogger.info("logIn CKU_SO", new Object[0]);
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    public void logout() throws TokenException {
        ConcurrentBagEntry<Session> session0 = this.borrowSession();
        Session session = session0.value();
        try {
            session.logout();
            StaticLogger.info("logout", new Object[0]);
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createObject(AttributeVector template) throws TokenException {
        ConcurrentBagEntry<Session> session0 = this.borrowSession();
        try {
            long l = session0.value().createObject(template);
            return l;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createPrivateKeyObject(AttributeVector template, PublicKey publicKey) throws TokenException {
        ConcurrentBagEntry<Session> session0 = this.borrowSession();
        try {
            long l = session0.value().createPrivateKeyObject(template, publicKey);
            return l;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createECPrivateKeyObject(AttributeVector template, byte[] ecPoint) throws TokenException {
        ConcurrentBagEntry<Session> session0 = this.borrowSession();
        try {
            long l = session0.value().createECPrivateKeyObject(template, ecPoint);
            return l;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long copyObject(long sourceObjectHandle, AttributeVector template) throws TokenException {
        ConcurrentBagEntry<Session> session0 = this.borrowSession();
        try {
            long l = session0.value().copyObject(sourceObjectHandle, template);
            return l;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributeValues(long objectToUpdateHandle, AttributeVector template) throws TokenException {
        ConcurrentBagEntry<Session> session0 = this.borrowSession();
        try {
            session0.value().setAttributeValues(objectToUpdateHandle, template);
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyObject(long objectHandle) throws TokenException {
        ConcurrentBagEntry<Session> session0 = this.borrowSession();
        try {
            session0.value().destroyObject(objectHandle);
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    public long[] destroyObjects(long ... objectHandles) throws TokenException {
        ArrayList<Long> list = new ArrayList<Long>(objectHandles.length);
        for (long handle : objectHandles) {
            list.add(handle);
        }
        List<Long> destroyedHandles = this.destroyObjects(list);
        long[] ret = new long[destroyedHandles.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = destroyedHandles.get(i);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> destroyObjects(List<Long> objectHandles) throws TokenException {
        ConcurrentBagEntry<Session> session0 = this.borrowSession();
        Session session = session0.value();
        try {
            ArrayList<Long> destroyedHandles = new ArrayList<Long>(objectHandles.size());
            Object object = objectHandles.iterator();
            while (object.hasNext()) {
                long objectHandle = object.next();
                try {
                    session.destroyObject(objectHandle);
                    destroyedHandles.add(objectHandle);
                }
                catch (PKCS11Exception e) {
                    StaticLogger.warn("error destroying object {}: {}", objectHandle, e.getMessage());
                }
            }
            object = destroyedHandles;
            return object;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getObjectSize(long objectHandle) throws TokenException {
        ConcurrentBagEntry<Session> session0 = this.borrowSession();
        try {
            long l = session0.value().getObjectSize(objectHandle);
            return l;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] generateUniqueId(AttributeVector template, int idLength, Random random) throws TokenException {
        if (template != null && template.id() != null) {
            throw new IllegalArgumentException("template shall not have CKA_ID");
        }
        if (template == null) {
            template = new AttributeVector();
        }
        byte[] keyId = new byte[idLength];
        template.id(keyId);
        ConcurrentBagEntry<Session> session0 = this.borrowSession();
        Session session = session0.value();
        try {
            do {
                random.nextBytes(keyId);
            } while (session.findObjectsSingle(template, 1).length != 0);
            byte[] byArray = keyId;
            return byArray;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PKCS11Key getKey(PKCS11KeyId keyId) throws TokenException {
        if (keyId == null) {
            return null;
        }
        ConcurrentBagEntry<Session> session0 = this.borrowSession();
        Session session = session0.value();
        try {
            PKCS11Key pKCS11Key = this.getKey(session, keyId);
            return pKCS11Key;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PKCS11Key getKey(AttributeVector criteria) throws TokenException {
        ConcurrentBagEntry<Session> session0 = this.borrowSession();
        Session session = session0.value();
        try {
            PKCS11KeyId keyId = this.getKeyId(session, criteria);
            PKCS11Key pKCS11Key = keyId == null ? null : this.getKey(session, keyId);
            return pKCS11Key;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    private PKCS11Key getKey(Session session, PKCS11KeyId keyId) throws TokenException {
        long objClass = keyId.getObjectCLass();
        long keyType = keyId.getKeyType();
        LinkedList<Long> ckaTypes = new LinkedList<Long>();
        if (objClass == 4L || objClass == 3L) {
            PKCS11Token.addCkaTypes(ckaTypes, 354L, 356L, 2L, 261L, 264L, 263L, 528L, 259L, 357L);
            if (objClass == 4L) {
                PKCS11Token.addCkaTypes(ckaTypes, 260L, 134L, 266L, 262L);
                if (keyType != 19L && keyType != 20L && keyType != 21L) {
                    ckaTypes.add(353L);
                }
            } else {
                PKCS11Token.addCkaTypes(ckaTypes, 514L, 265L);
                if (keyType == 0L) {
                    PKCS11Token.addCkaTypes(ckaTypes, 288L, 290L);
                } else if (keyType == 3L || keyType == 64L || keyType == 65L || keyType == 0xFFFFF001L) {
                    ckaTypes.add(384L);
                } else if (keyType == 1L) {
                    PKCS11Token.addCkaTypes(ckaTypes, 304L, 305L, 306L);
                }
            }
        } else {
            PKCS11Token.addCkaTypes(ckaTypes, 260L, 134L, 266L, 267L, 262L);
            if (keyType == 0L) {
                PKCS11Token.addCkaTypes(ckaTypes, 288L, 290L);
            } else if (keyType == 3L || keyType == 64L || keyType == 65L || keyType == 0xFFFFF001L) {
                PKCS11Token.addCkaTypes(ckaTypes, 384L, 385L);
            } else if (keyType == 1L) {
                PKCS11Token.addCkaTypes(ckaTypes, 304L, 305L, 306L);
            }
        }
        AttributeVector attrs = session.getAttrValues(keyId.getHandle(), ckaTypes);
        return new PKCS11Key(keyId, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PKCS11KeyId getKeyId(AttributeVector criteria) throws TokenException {
        ConcurrentBagEntry<Session> session0 = this.borrowSession();
        Session session = session0.value();
        try {
            PKCS11KeyId pKCS11KeyId = this.getKeyId(session, criteria);
            return pKCS11KeyId;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    private PKCS11KeyId getKeyId(Session session, AttributeVector criteria) throws TokenException {
        byte[] id = criteria.id();
        String label = criteria.label();
        if (!(id != null && id.length != 0 || label != null && !label.isEmpty())) {
            return null;
        }
        Long oClass = criteria.class_();
        if (oClass != null) {
            if (3L != oClass && 2L != oClass && 4L != oClass) {
                return null;
            }
            long[] handles = session.findObjectsSingle(criteria, 2);
            if (handles.length == 0) {
                return null;
            }
            if (handles.length > 1) {
                throw new TokenException("found more than 1 key for the criteria " + criteria);
            }
            return this.getKeyIdByHandle(session, handles[0]);
        }
        oClass = 3L;
        long[] handles = session.findObjectsSingle(criteria.class_(oClass), 2);
        if (handles.length == 0 && (handles = session.findObjectsSingle(criteria.class_(oClass = Long.valueOf(4L)), 2)).length == 0) {
            oClass = 2L;
            handles = session.findObjectsSingle(criteria.class_(oClass), 2);
        }
        if (handles.length == 0) {
            return null;
        }
        if (handles.length > 1) {
            throw new TokenException("found more than 1 key of " + PKCS11Constants.ckoCodeToName(oClass) + " for the criteria " + criteria.class_(null));
        }
        return this.getKeyIdByHandle(session, handles[0]);
    }

    private PKCS11KeyId getKeyIdByHandle(Session session, long hKey) throws TokenException {
        AttributeVector attrs = session.getAttrValues(hKey, 0L, 256L, 258L, 3L);
        long oClass = attrs.class_();
        long keyType = attrs.keyType();
        byte[] id = attrs.id();
        PKCS11KeyId ret = new PKCS11KeyId(hKey, oClass, keyType, id, attrs.label());
        if (oClass == 3L) {
            long[] pubKeyHandles = session.findObjectsSingle(AttributeVector.newPublicKey(keyType).id(id), 2);
            if (pubKeyHandles.length == 1) {
                ret.setPublicKeyHandle(pubKeyHandles[0]);
            } else if (pubKeyHandles.length > 1) {
                StaticLogger.warn("found more than 1 public key for the private key {}, ignore them.", hKey);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] findAllObjects(AttributeVector template) throws TokenException {
        ConcurrentBagEntry<Session> session0 = this.borrowSession();
        try {
            long[] lArray = session0.value().findAllObjectsSingle(template);
            return lArray;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] findObjects(AttributeVector template, int maxObjectCount) throws TokenException {
        ConcurrentBagEntry<Session> session0 = this.borrowSession();
        try {
            long[] lArray = session0.value().findObjectsSingle(template, maxObjectCount);
            return lArray;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encrypt(Mechanism mechanism, long keyHandle, byte[] plaintext) throws TokenException {
        ConcurrentBagEntry<Session> session0 = this.borrowSession();
        Session session = session0.value();
        try {
            int len = plaintext.length;
            if (len <= this.maxMessageSize) {
                byte[] byArray = session.encryptSingle(mechanism, keyHandle, plaintext);
                return byArray;
            }
            session.encryptInit(mechanism, keyHandle);
            ByteArrayOutputStream bout = new ByteArrayOutputStream(plaintext.length + 16);
            try {
                for (int ofs = 0; ofs < len; ofs += this.maxMessageSize) {
                    byte[] ciphertextPart = session.encryptUpdate(PKCS11Token.copyOfLen(plaintext, ofs, Math.min(this.maxMessageSize, len - ofs)));
                    bout.write(ciphertextPart, 0, ciphertextPart.length);
                }
            }
            finally {
                byte[] ciphertextPart = session.encryptFinal();
                bout.write(ciphertextPart, 0, ciphertextPart.length);
            }
            byte[] byArray = bout.toByteArray();
            return byArray;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int encrypt(OutputStream out, Mechanism mechanism, long keyHandle, InputStream plaintext) throws TokenException, IOException {
        ConcurrentBagEntry<Session> session0 = this.borrowSession();
        Session session = session0.value();
        try {
            byte[] res;
            byte[] buffer = new byte[this.maxMessageSize];
            int readed = 0;
            int resSum = 0;
            session.encryptInit(mechanism, keyHandle);
            try {
                while ((readed = plaintext.read(buffer)) != -1) {
                    if (readed <= 0 || (res = session.encryptUpdate(PKCS11Token.copyOfLen(buffer, readed))) == null || res.length <= 0) continue;
                    resSum += res.length;
                    out.write(res, 0, res.length);
                }
            }
            finally {
                res = session.encryptFinal();
                if (res != null && res.length > 0) {
                    resSum += res.length;
                    out.write(res, 0, res.length);
                }
            }
            int n = resSum;
            return n;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] decrypt(Mechanism mechanism, long keyHandle, byte[] ciphertext) throws TokenException {
        ConcurrentBagEntry<Session> session0 = this.borrowSession();
        Session session = session0.value();
        try {
            int len = ciphertext.length;
            if (len <= this.maxMessageSize) {
                byte[] byArray = session.decryptSingle(mechanism, keyHandle, ciphertext);
                return byArray;
            }
            session.decryptInit(mechanism, keyHandle);
            ByteArrayOutputStream bout = new ByteArrayOutputStream(ciphertext.length);
            try {
                for (int ofs = 0; ofs < len; ofs += this.maxMessageSize) {
                    byte[] plaintextPart = session.decryptUpdate(PKCS11Token.copyOfLen(ciphertext, ofs, Math.min(this.maxMessageSize, len - ofs)));
                    bout.write(plaintextPart, 0, plaintextPart.length);
                }
            }
            finally {
                byte[] plaintextPart = session.decryptFinal();
                bout.write(plaintextPart, 0, plaintextPart.length);
            }
            byte[] byArray = bout.toByteArray();
            return byArray;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int decrypt(OutputStream out, Mechanism mechanism, long keyHandle, InputStream ciphertext) throws TokenException, IOException {
        ConcurrentBagEntry<Session> session0 = this.borrowSession();
        Session session = session0.value();
        try {
            byte[] res;
            byte[] buffer = new byte[this.maxMessageSize];
            int resSum = 0;
            session.decryptInit(mechanism, keyHandle);
            try {
                int readed;
                while ((readed = ciphertext.read(buffer)) != -1) {
                    if (readed <= 0 || (res = session.decryptUpdate(PKCS11Token.copyOfLen(buffer, readed))) == null || res.length <= 0) continue;
                    resSum += res.length;
                    out.write(res, 0, res.length);
                }
            }
            finally {
                res = session.decryptFinal();
                if (res != null && res.length > 0) {
                    resSum += res.length;
                    out.write(res, 0, res.length);
                }
            }
            int n = resSum;
            return n;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] digest(Mechanism mechanism, byte[] data) throws TokenException {
        ConcurrentBagEntry<Session> session0 = this.borrowSession();
        Session session = session0.value();
        int len = data.length;
        try {
            byte[] digest;
            if (len < this.maxMessageSize) {
                byte[] byArray = session.digestSingle(mechanism, data);
                return byArray;
            }
            session.digestInit(mechanism);
            try {
                for (int ofs = 0; ofs < len; ofs += this.maxMessageSize) {
                    session.signUpdate(data, ofs, Math.min(this.maxMessageSize, len - ofs));
                }
            }
            finally {
                digest = session.digestFinal();
            }
            byte[] byArray = digest;
            return byArray;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] digestKey(Mechanism mechanism, long keyHandle) throws TokenException {
        ConcurrentBagEntry<Session> session0 = this.borrowSession();
        Session session = session0.value();
        try {
            byte[] digest;
            session.digestInit(mechanism);
            try {
                session.digestKey(keyHandle);
            }
            finally {
                digest = session.digestFinal();
            }
            byte[] byArray = digest;
            return byArray;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] digest(Mechanism mechanism, InputStream data) throws TokenException, IOException {
        ConcurrentBagEntry<Session> session0 = this.borrowSession();
        Session session = session0.value();
        try {
            byte[] digest;
            byte[] buffer = new byte[this.maxMessageSize];
            session.digestInit(mechanism);
            try {
                int readed;
                while ((readed = data.read(buffer)) != -1) {
                    if (readed <= 0) continue;
                    session.digestUpdate(PKCS11Token.copyOfLen(buffer, readed));
                }
            }
            finally {
                digest = session.digestFinal();
            }
            byte[] byArray = digest;
            return byArray;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] sign(Mechanism mechanism, long keyHandle, byte[] data) throws TokenException {
        ConcurrentBagEntry<Session> session0 = this.borrowSession();
        Session session = session0.value();
        try {
            byte[] signature;
            int len = data.length;
            if (len < this.maxMessageSize) {
                byte[] byArray = session.signSingle(mechanism, keyHandle, data);
                return byArray;
            }
            session.signInit(mechanism, keyHandle);
            try {
                for (int ofs = 0; ofs < len; ofs += this.maxMessageSize) {
                    session.signUpdate(data, ofs, Math.min(this.maxMessageSize, len - ofs));
                }
            }
            finally {
                signature = session.signFinal();
            }
            byte[] byArray = signature;
            return byArray;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] sign(Mechanism mechanism, long keyHandle, InputStream data) throws TokenException, IOException {
        ConcurrentBagEntry<Session> session0 = this.borrowSession();
        Session session = session0.value();
        try {
            byte[] signature;
            byte[] buffer;
            block13: {
                buffer = new byte[this.maxMessageSize];
                int firstBlockLen = PKCS11Token.readBytes(data, buffer, this.maxMessageSize);
                byte[] firstBlock = PKCS11Token.copyOfLen(buffer, firstBlockLen);
                if (firstBlockLen < this.maxMessageSize) {
                    byte[] byArray = session.signSingle(mechanism, keyHandle, firstBlock);
                    return byArray;
                }
                session.signInit(mechanism, keyHandle);
                try {
                    session.signUpdate(firstBlock);
                }
                catch (PKCS11Exception e) {
                    int readed;
                    if (e.getErrorCode() != 145L) break block13;
                    ByteArrayOutputStream bout = new ByteArrayOutputStream(this.maxMessageSize + data.available());
                    bout.write(firstBlock);
                    while ((readed = data.read(buffer)) != -1) {
                        bout.write(buffer, 0, readed);
                    }
                    byte[] byArray = session.signSingle(mechanism, keyHandle, bout.toByteArray());
                    this.sessions.requite(session0);
                    return byArray;
                }
            }
            try {
                int readed;
                while ((readed = data.read(buffer)) != -1) {
                    if (readed <= 0) continue;
                    session.signUpdate(PKCS11Token.copyOfLen(buffer, readed));
                }
            }
            finally {
                signature = session.signFinal();
            }
            byte[] byArray = signature;
            return byArray;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] signRecover(Mechanism mechanism, long keyHandle, byte[] data) throws TokenException {
        ConcurrentBagEntry<Session> session0 = this.borrowSession();
        try {
            byte[] byArray = session0.value().signRecoverSingle(mechanism, keyHandle, data);
            return byArray;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean verify(Mechanism mechanism, long keyHandle, byte[] data, byte[] signature) throws TokenException {
        byte[] sig2;
        ConcurrentBagEntry<Session> session0 = this.borrowSession();
        Session session = session0.value();
        int len = data.length;
        long code = mechanism.getMechanismCode();
        if (this.supportsMechanism(code, 8192L, false)) {
            try {
                if (len <= this.maxMessageSize) {
                    session.verifySingle(mechanism, keyHandle, data, signature);
                    boolean bl = true;
                    return bl;
                }
            }
            catch (PKCS11Exception e2) {
                long ckr = e2.getErrorCode();
                if (ckr != 192L) {
                    if (ckr != 193L) throw e2;
                }
                boolean bl = false;
                return bl;
            }
            try {
                session.verifyInit(mechanism, keyHandle);
                try {
                    for (int ofs = 0; ofs < len; ofs += this.maxMessageSize) {
                        session.verifyUpdate(PKCS11Token.copyOfLen(data, ofs, Math.min(this.maxMessageSize, len - ofs)));
                    }
                }
                finally {
                    session.verifyFinal(signature);
                }
            }
            catch (PKCS11Exception e) {
                if (e.getErrorCode() != 145L) throw e;
                session.verifySingle(mechanism, keyHandle, data, signature);
            }
            boolean e = true;
            return e;
        }
        if (!this.supportsMechanism(code, 2048L)) throw new PKCS11Exception(112L);
        if (!PKCS11Token.isMacMechanism(code)) throw new PKCS11Exception(112L);
        if (len > this.maxMessageSize) {
            session.signInit(mechanism, keyHandle);
            try {
                int ofs = 0;
                while (ofs < len) {
                    session.signUpdate(PKCS11Token.copyOfLen(data, ofs, Math.min(this.maxMessageSize, len - ofs)));
                    ofs += this.maxMessageSize;
                }
                return Arrays.equals(signature, sig2);
            }
            finally {
                sig2 = session.signFinal();
            }
        }
        sig2 = session.signSingle(mechanism, keyHandle, data);
        return Arrays.equals(signature, sig2);
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verify(Mechanism mechanism, long keyHandle, InputStream data, byte[] signature) throws TokenException, IOException {
        ConcurrentBagEntry<Session> session0 = this.borrowSession();
        Session session = session0.value();
        try {
            byte[] buffer = new byte[this.maxMessageSize];
            int firstBlockLen = PKCS11Token.readBytes(data, buffer, this.maxMessageSize);
            byte[] firstBlock = PKCS11Token.copyOfLen(buffer, firstBlockLen);
            long code = mechanism.getMechanismCode();
            if (this.supportsMechanism(code, 8192L, false)) {
                boolean readed;
                block27: {
                    if (firstBlockLen < this.maxMessageSize) {
                        session.verifySingle(mechanism, keyHandle, firstBlock, signature);
                        boolean bl = true;
                        return bl;
                    }
                    session.verifyInit(mechanism, keyHandle);
                    try {
                        session.verifyUpdate(firstBlock);
                    }
                    catch (PKCS11Exception e) {
                        int readed2;
                        if (e.getErrorCode() != 145L) break block27;
                        ByteArrayOutputStream bout = new ByteArrayOutputStream(this.maxMessageSize + data.available());
                        bout.write(firstBlock);
                        while ((readed2 = data.read(buffer)) != -1) {
                            bout.write(buffer, 0, readed2);
                        }
                        session.verifySingle(mechanism, keyHandle, bout.toByteArray(), signature);
                        boolean bl = true;
                        this.sessions.requite(session0);
                        return bl;
                    }
                }
                try {
                    while (!(readed = data.read(buffer))) {
                        if (readed <= false) continue;
                        session.verifyUpdate(PKCS11Token.copyOfLen(buffer, readed ? 1 : 0));
                    }
                }
                finally {
                    session.verifyFinal(signature);
                }
                readed = true;
                return readed;
            }
            if (this.supportsMechanism(code, 2048L) && PKCS11Token.isMacMechanism(code)) {
                byte[] sig2;
                if (firstBlockLen < this.maxMessageSize) {
                    sig2 = session.signSingle(mechanism, keyHandle, firstBlock);
                } else {
                    session.signInit(mechanism, keyHandle);
                    try {
                        int readed;
                        session.signUpdate(firstBlock);
                        while ((readed = data.read(buffer)) != -1) {
                            if (readed <= 0) continue;
                            session.signUpdate(buffer, 0, readed);
                        }
                    }
                    finally {
                        sig2 = session.signFinal();
                    }
                }
                boolean bl = Arrays.equals(signature, sig2);
                return bl;
            }
            try {
                throw new PKCS11Exception(112L);
            }
            catch (PKCS11Exception e) {
                long ckr = e.getErrorCode();
                if (ckr == 192L || ckr == 193L) {
                    boolean bl = false;
                    return bl;
                }
                throw e;
            }
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] verifyRecover(Mechanism mechanism, long keyHandle, byte[] data) throws TokenException {
        ConcurrentBagEntry<Session> session0 = this.borrowSession();
        try {
            byte[] byArray = session0.value().verifyRecoverSingle(mechanism, keyHandle, data);
            return byArray;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long generateKey(Mechanism mechanism, AttributeVector template) throws TokenException {
        ConcurrentBagEntry<Session> session0 = this.borrowSession();
        try {
            long l = session0.value().generateKey(mechanism, template);
            return l;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PKCS11KeyPair generateKeyPair(Mechanism mechanism, KeyPairTemplate template) throws TokenException {
        ConcurrentBagEntry<Session> session0 = this.borrowSession();
        try {
            PKCS11KeyPair pKCS11KeyPair = session0.value().generateKeyPair(mechanism, template);
            return pKCS11KeyPair;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] wrapKey(Mechanism mechanism, long wrappingKeyHandle, long keyHandle) throws TokenException {
        ConcurrentBagEntry<Session> session0 = this.borrowSession();
        try {
            byte[] byArray = session0.value().wrapKey(mechanism, wrappingKeyHandle, keyHandle);
            return byArray;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long unwrapKey(Mechanism mechanism, long unwrappingKeyHandle, byte[] wrappedKey, AttributeVector keyTemplate) throws TokenException {
        ConcurrentBagEntry<Session> session0 = this.borrowSession();
        try {
            long l = session0.value().unwrapKey(mechanism, unwrappingKeyHandle, wrappedKey, keyTemplate);
            return l;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long deriveKey(Mechanism mechanism, long baseKeyHandle, AttributeVector template) throws TokenException {
        ConcurrentBagEntry<Session> session0 = this.borrowSession();
        try {
            long l = session0.value().deriveKey(mechanism, baseKeyHandle, template);
            return l;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    public byte[] generateRandom(int numberOfBytesToGenerate) throws TokenException {
        return this.generateRandom(numberOfBytesToGenerate, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] generateRandom(int numberOfBytesToGenerate, byte[] extraSeed) throws TokenException {
        ConcurrentBagEntry<Session> session0 = this.borrowSession();
        Session session = session0.value();
        try {
            if (extraSeed != null && extraSeed.length > 0) {
                session.seedRandom(extraSeed);
            }
            byte[] byArray = session.generateRandom(numberOfBytesToGenerate);
            return byArray;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[][] encryptMessages(Mechanism mechanism, long keyHandle, EncryptMessageBytesEntry[] entries) throws TokenException {
        byte[][] ciphertexts = new byte[entries.length][];
        ConcurrentBagEntry<Session> session0 = this.borrowSession();
        Session session = session0.value();
        try {
            session.messageEncryptInit(mechanism, keyHandle);
            try {
                for (int i = 0; i < entries.length; ++i) {
                    EncryptMessageBytesEntry entry = entries[i];
                    byte[] plaintext = entry.plaintext();
                    int len = plaintext.length;
                    if (len <= this.maxMessageSize) {
                        ciphertexts[i] = session.encryptMessage(entry.params(), entry.associatedData(), entry.plaintext());
                        continue;
                    }
                    session.encryptMessageBegin(entry.params(), entry.associatedData());
                    ByteArrayOutputStream bout = new ByteArrayOutputStream(plaintext.length + 16);
                    for (int ofs = 0; ofs < len; ofs += this.maxMessageSize) {
                        boolean lastBlock = ofs + this.maxMessageSize >= len;
                        byte[] ciphertextPart = session.encryptMessageNext(entry.params(), PKCS11Token.copyOfLen(plaintext, ofs, Math.min(len - ofs, this.maxMessageSize)), lastBlock);
                        bout.write(ciphertextPart, 0, ciphertextPart.length);
                    }
                    ciphertexts[i] = bout.toByteArray();
                }
            }
            finally {
                session.messageEncryptFinal();
            }
            byte[][] byArrayArray = ciphertexts;
            return byArrayArray;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] encryptMessages(Mechanism mechanism, long keyHandle, EncryptMessageStreamEntry[] entries) throws TokenException, IOException {
        int[] ciphertextLens = new int[entries.length];
        ConcurrentBagEntry<Session> session0 = this.borrowSession();
        Session session = session0.value();
        try {
            session.messageEncryptInit(mechanism, keyHandle);
            try {
                for (int i = 0; i < entries.length; ++i) {
                    EncryptMessageStreamEntry entry = entries[i];
                    byte[] buffer = new byte[this.maxMessageSize];
                    InputStream inPlaintext = entry.inPlaintext();
                    OutputStream outCiphertext = entry.outCiphertext();
                    CkParams params = entry.params();
                    try {
                        byte[] ciphertextPart;
                        int readed;
                        session.encryptMessageBegin(params, entry.associatedData());
                        int ciphertextLen = 0;
                        while ((readed = inPlaintext.read(buffer)) != -1) {
                            if (readed <= 0) continue;
                            ciphertextPart = session.encryptMessageNext(params, PKCS11Token.copyOfLen(buffer, readed), false);
                            ciphertextLen += ciphertextPart.length;
                            outCiphertext.write(ciphertextPart);
                        }
                        ciphertextPart = session.encryptMessageNext(params, new byte[0], true);
                        outCiphertext.write(ciphertextPart);
                        ciphertextLens[i] = ciphertextLen += ciphertextPart.length;
                        continue;
                    }
                    catch (PKCS11Exception pKCS11Exception) {
                        // empty catch block
                    }
                }
            }
            finally {
                session.messageEncryptFinal();
            }
            int[] nArray = ciphertextLens;
            return nArray;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[][] decryptMessages(Mechanism mechanism, long keyHandle, DecryptMessageBytesEntry[] entries) throws TokenException {
        byte[][] plaintexts = new byte[entries.length][];
        ConcurrentBagEntry<Session> session0 = this.borrowSession();
        Session session = session0.value();
        try {
            session.messageDecryptInit(mechanism, keyHandle);
            try {
                for (int i = 0; i < entries.length; ++i) {
                    DecryptMessageBytesEntry entry = entries[i];
                    byte[] ciphertext = entry.ciphertext();
                    int len = ciphertext.length;
                    if (len <= this.maxMessageSize) {
                        plaintexts[i] = session.decryptMessage(entry.params(), entry.associatedData(), ciphertext);
                        continue;
                    }
                    session.decryptMessageBegin(entry.params(), entry.associatedData());
                    ByteArrayOutputStream bout = new ByteArrayOutputStream(ciphertext.length);
                    for (int ofs = 0; ofs < len; ofs += this.maxMessageSize) {
                        boolean lastBlock = ofs + this.maxMessageSize >= len;
                        byte[] plaintextPart = session.decryptMessageNext(entry.params(), PKCS11Token.copyOfLen(ciphertext, ofs, Math.min(len - ofs, this.maxMessageSize)), lastBlock);
                        bout.write(plaintextPart, 0, plaintextPart.length);
                    }
                    plaintexts[i] = bout.toByteArray();
                }
            }
            finally {
                session.messageDecryptFinal();
            }
            byte[][] byArrayArray = plaintexts;
            return byArrayArray;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] decryptMessages(Mechanism mechanism, long keyHandle, DecryptMessageStreamEntry[] entries) throws TokenException, IOException {
        int[] plaintextLens = new int[entries.length];
        ConcurrentBagEntry<Session> session0 = this.borrowSession();
        Session session = session0.value();
        try {
            session.messageDecryptInit(mechanism, keyHandle);
            try {
                for (int i = 0; i < entries.length; ++i) {
                    DecryptMessageStreamEntry entry = entries[i];
                    byte[] buffer = new byte[this.maxMessageSize];
                    InputStream inCiphertext = entry.inCiphertext();
                    OutputStream outPlaintext = entry.outPlaintext();
                    CkParams params = entry.params();
                    try {
                        byte[] plaintextPart;
                        int readed;
                        session.decryptMessageBegin(params, entry.associatedData());
                        int plaintextLen = 0;
                        while ((readed = inCiphertext.read(buffer)) != -1) {
                            if (readed <= 0) continue;
                            plaintextPart = session.decryptMessageNext(params, PKCS11Token.copyOfLen(buffer, readed), false);
                            plaintextLen += plaintextPart.length;
                            outPlaintext.write(plaintextPart);
                        }
                        plaintextPart = session.decryptMessageNext(params, new byte[0], true);
                        outPlaintext.write(plaintextPart);
                        plaintextLens[i] = plaintextLen += plaintextPart.length;
                        continue;
                    }
                    catch (PKCS11Exception pKCS11Exception) {
                        // empty catch block
                    }
                }
            }
            finally {
                session.messageDecryptFinal();
            }
            int[] nArray = plaintextLens;
            return nArray;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[][] signMessages(Mechanism mechanism, long keyHandle, SignMessageBytesEntry[] entries) throws TokenException {
        byte[][] signatures = new byte[entries.length][];
        ConcurrentBagEntry<Session> session0 = this.borrowSession();
        Session session = session0.value();
        try {
            session.messageSignInit(mechanism, keyHandle);
            try {
                for (int i = 0; i < entries.length; ++i) {
                    SignMessageBytesEntry entry = entries[i];
                    byte[] data = entry.data();
                    int len = data.length;
                    if (len <= this.maxMessageSize) {
                        signatures[i] = session.signMessage(entry.params(), entry.data());
                        continue;
                    }
                    session.signMessageBegin(entry.params());
                    for (int ofs = 0; ofs < len; ofs += this.maxMessageSize) {
                        boolean lastBlock = ofs + this.maxMessageSize >= len;
                        signatures[i] = session.signMessageNext(entry.params(), PKCS11Token.copyOfLen(data, ofs, Math.min(this.maxMessageSize, len - ofs)), lastBlock);
                    }
                }
            }
            finally {
                session.messageSignFinal();
            }
            byte[][] byArrayArray = signatures;
            return byArrayArray;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[][] signMessages(Mechanism mechanism, long keyHandle, SignMessageStreamEntry[] entries) throws TokenException, IOException {
        byte[][] signatures = new byte[entries.length][];
        ConcurrentBagEntry<Session> session0 = this.borrowSession();
        Session session = session0.value();
        try {
            session.messageSignInit(mechanism, keyHandle);
            try {
                for (int i = 0; i < entries.length; ++i) {
                    SignMessageStreamEntry entry = entries[i];
                    byte[] buffer = new byte[this.maxMessageSize];
                    InputStream data = entry.data();
                    CkParams params = entry.params();
                    try {
                        int readed;
                        session.signMessageBegin(params);
                        while ((readed = data.read(buffer)) != -1) {
                            if (readed <= 0) continue;
                            session.signMessageNext(params, PKCS11Token.copyOfLen(buffer, readed), false);
                        }
                        signatures[i] = session.signMessageNext(params, new byte[0], true);
                        continue;
                    }
                    catch (PKCS11Exception e) {
                        break;
                    }
                }
            }
            finally {
                session.messageSignFinal();
            }
            byte[][] byArrayArray = signatures;
            return byArrayArray;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean[] verifyMessages(Mechanism mechanism, long keyHandle, VerifyMessageBytesEntry[] entries) throws TokenException {
        boolean[] verifyResults = new boolean[entries.length];
        ConcurrentBagEntry<Session> session0 = this.borrowSession();
        Session session = session0.value();
        try {
            session.messageVerifyInit(mechanism, keyHandle);
            try {
                for (int i = 0; i < entries.length; ++i) {
                    VerifyMessageBytesEntry entry = entries[i];
                    byte[] data = entry.data();
                    int len = data.length;
                    try {
                        if (len <= this.maxMessageSize) {
                            session.verifyMessage(entry.params(), entry.data(), entry.signature());
                        } else {
                            session.verifyMessageBegin(entry.params());
                            for (int ofs = 0; ofs < len; ofs += this.maxMessageSize) {
                                boolean lastBlock = ofs + this.maxMessageSize >= len;
                                session.verifyMessageNext(entry.params(), PKCS11Token.copyOfLen(data, ofs, Math.min(this.maxMessageSize, len - ofs)), lastBlock ? entry.signature() : null);
                            }
                        }
                        verifyResults[i] = true;
                        continue;
                    }
                    catch (PKCS11Exception e) {
                        verifyResults[i] = false;
                    }
                }
            }
            finally {
                session.messageVerifyFinal();
            }
            boolean[] blArray = verifyResults;
            return blArray;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean[] verifyMessages(Mechanism mechanism, long keyHandle, VerifyMessageStreamEntry[] entries) throws TokenException, IOException {
        boolean[] verifyResults = new boolean[entries.length];
        ConcurrentBagEntry<Session> session0 = this.borrowSession();
        Session session = session0.value();
        try {
            session.messageVerifyInit(mechanism, keyHandle);
            try {
                for (int i = 0; i < entries.length; ++i) {
                    VerifyMessageStreamEntry entry = entries[i];
                    byte[] buffer = new byte[this.maxMessageSize];
                    InputStream data = entry.data();
                    CkParams params = entry.params();
                    try {
                        int readed;
                        session.verifyMessageBegin(params);
                        while ((readed = data.read(buffer)) != -1) {
                            if (readed <= 0) continue;
                            session.verifyMessageNext(params, PKCS11Token.copyOfLen(buffer, readed), null);
                        }
                        session.verifyMessageNext(params, new byte[0], entry.signature());
                        verifyResults[i] = true;
                        continue;
                    }
                    catch (PKCS11Exception e) {
                        verifyResults[i] = false;
                    }
                }
            }
            finally {
                session.messageVerifyFinal();
            }
            boolean[] blArray = verifyResults;
            return blArray;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    public String toString() {
        return "User type: " + PKCS11Constants.codeToName(PKCS11Constants.Category.CKU, this.userType) + "\nUser name: " + (this.userName == null ? "null" : new String(this.userName)) + "\nMaximal session count: " + this.maxSessionCount + "\nRead only: " + this.readOnly + "\nToken: " + this.token;
    }

    public AttributeVector getAttrValues(long objectHandle, long ... attributeTypes) throws TokenException {
        ArrayList<Long> typeList = new ArrayList<Long>(attributeTypes.length);
        for (long attrType : attributeTypes) {
            typeList.add(attrType);
        }
        return this.getAttrValues(objectHandle, typeList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeVector getAttrValues(long objectHandle, List<Long> attributeTypes) throws TokenException {
        ConcurrentBagEntry<Session> session0 = this.borrowSession();
        try {
            AttributeVector attributeVector = session0.value().getAttrValues(objectHandle, attributeTypes);
            return attributeVector;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeVector getDefaultAttrValues(long objectHandle) throws TokenException {
        ConcurrentBagEntry<Session> session0 = this.borrowSession();
        try {
            AttributeVector attributeVector = session0.value().getDefaultAttrValues(objectHandle);
            return attributeVector;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    private Session openSession() throws PKCS11Exception {
        Session session = this.token.openSession(!this.readOnly);
        this.countSessions.incrementAndGet();
        return session;
    }

    private ConcurrentBagEntry<Session> borrowSession() throws TokenException {
        return this.borrowSession(true, 0, 0L);
    }

    private ConcurrentBagEntry<Session> borrowNoLoginSession() throws TokenException {
        return this.borrowSession(false, 0, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConcurrentBagEntry<Session> borrowSession(boolean login, int retries, long maxTimeMs) throws TokenException {
        if (maxTimeMs == 0L) {
            maxTimeMs = clock.millis() + this.timeOutWaitNewSessionMs;
        }
        ConcurrentBagEntry<Session> session = null;
        ConcurrentBag<ConcurrentBagEntry<Session>> concurrentBag = this.sessions;
        synchronized (concurrentBag) {
            if (this.countSessions.get() < (long)this.maxSessionCount) {
                try {
                    session = this.sessions.borrow(1L, TimeUnit.NANOSECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (session == null) {
                    this.sessions.add(new ConcurrentBagEntry<Session>(this.openSession()));
                }
            }
        }
        if (session == null) {
            long timeOutMs = maxTimeMs - clock.millis();
            try {
                session = this.sessions.borrow(Math.max(1L, timeOutMs), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (session == null) {
            throw new TokenException("no idle session");
        }
        boolean requiteSession = true;
        try {
            long deviceError;
            boolean sessionActive = true;
            SessionInfo sessionInfo = null;
            try {
                sessionInfo = session.value().getSessionInfo();
            }
            catch (PKCS11Exception ex) {
                long ckr = ex.getErrorCode();
                if (ckr == 176L || ckr == 179L) {
                    sessionActive = false;
                }
                StaticLogger.warn("error getSessionInfo: {}", PKCS11Constants.ckrCodeToName(ckr));
            }
            if (sessionActive && sessionInfo != null && (deviceError = sessionInfo.getDeviceError()) != 0L) {
                sessionActive = false;
                StaticLogger.error("device has error {}", deviceError);
            }
            if (!sessionActive) {
                requiteSession = false;
                this.sessions.remove(session);
                this.countSessions.decrementAndGet();
                if (retries < this.maxSessionCount) {
                    ConcurrentBagEntry<Session> session2 = this.borrowSession(login, retries + 1, maxTimeMs);
                    StaticLogger.info("borrowed session after " + (retries + 1) + " tries.", new Object[0]);
                    ConcurrentBagEntry<Session> ckr = session2;
                    return ckr;
                }
                throw new TokenException("could not borrow session after " + (retries + 1) + " tries.");
            }
            if (login) {
                boolean loggedIn = false;
                if (sessionInfo != null) {
                    long state = sessionInfo.getState();
                    boolean bl = loggedIn = state == 4L || state == 3L || state == 1L;
                }
                if (!loggedIn) {
                    this.login(session.value());
                }
            }
            requiteSession = false;
            ConcurrentBagEntry<Session> concurrentBagEntry = session;
            return concurrentBagEntry;
        }
        finally {
            if (requiteSession) {
                this.sessions.requite(session);
            }
        }
    }

    private void login(Session session) throws TokenException {
        this.login(session, this.userType, this.userName, this.pins);
    }

    private void login(Session session, long userType, char[] userName, List<char[]> pins) throws TokenException {
        StaticLogger.info("verify on PKCS11Module with " + (pins == null || pins.isEmpty() ? "NULL pin" : "pin"), new Object[0]);
        String userText = "user ";
        if (userName != null) {
            userText = userText + new String(userName) + " ";
        }
        userText = userText + "of type " + PKCS11Constants.codeToName(PKCS11Constants.Category.CKU, userType);
        try {
            if (userName == null) {
                if (this.isProtectedAuthenticationPath || pins == null || pins.isEmpty()) {
                    session.login(userType, new char[0]);
                    StaticLogger.info("login successful as " + userText + " with NULL PIN", new Object[0]);
                } else {
                    for (char[] pin : pins) {
                        session.login(userType, pin == null ? new char[]{} : pin);
                    }
                    StaticLogger.info("login successful as " + userText + " with PIN", new Object[0]);
                }
            } else if (this.isProtectedAuthenticationPath || pins == null || pins.isEmpty()) {
                session.loginUser(userType, userName, new char[0]);
                StaticLogger.info("loginUser successful as " + userText + " with NULL PIN", new Object[0]);
            } else {
                for (char[] pin : pins) {
                    session.loginUser(userType, userName, pin == null ? new char[]{} : pin);
                }
                StaticLogger.info("loginUser successful as " + userText + " with PIN", new Object[0]);
            }
        }
        catch (PKCS11Exception ex) {
            long ckr = ex.getErrorCode();
            if (ckr == 256L) {
                StaticLogger.info("user already logged in", new Object[0]);
            }
            StaticLogger.warn("login failed as {}: {}", userText, PKCS11Constants.ckrCodeToName(ckr));
            throw ex;
        }
    }

    private static byte[] copyOfLen(byte[] bytes, int len) {
        return bytes.length == len ? bytes : Arrays.copyOf(bytes, len);
    }

    private static byte[] copyOfLen(byte[] bytes, int offset, int len) {
        return offset == 0 && bytes.length == len ? bytes : Arrays.copyOfRange(bytes, offset, offset + len);
    }

    private static int readBytes(InputStream stream, byte[] buffer, int numBytes) throws IOException {
        int readed;
        int ofs = 0;
        while ((readed = stream.read(buffer, ofs, numBytes - ofs)) != -1 && (ofs += readed) < numBytes) {
        }
        return ofs;
    }

    private static boolean isMacMechanism(long mechanism) {
        return mechanism == 4234L || mechanism == 4238L || mechanism == 545L || mechanism == 598L || mechanism == 593L || mechanism == 609L || mechanism == 625L || mechanism == 694L || mechanism == 689L || mechanism == 705L || mechanism == 721L || mechanism == 599L || mechanism == 594L || mechanism == 610L || mechanism == 626L || mechanism == 695L || mechanism == 690L || mechanism == 706L || mechanism == 722L;
    }

    private static void addCkaTypes(List<Long> list, long ... types) {
        for (long type : types) {
            list.add(type);
        }
    }
}

