/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.pkcs11.wrapper;

import iaik.pkcs.pkcs11.wrapper.CK_C_INITIALIZE_ARGS;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Implementation;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.xipki.pkcs11.wrapper.Functions;
import org.xipki.pkcs11.wrapper.ModuleInfo;
import org.xipki.pkcs11.wrapper.PKCS11Constants;
import org.xipki.pkcs11.wrapper.PKCS11Exception;
import org.xipki.pkcs11.wrapper.Slot;
import org.xipki.pkcs11.wrapper.StaticLogger;
import org.xipki.pkcs11.wrapper.Version;

public class PKCS11Module {
    static final int BEHAVIOUR_ECDSA_SIGNATURE_X962 = 1;
    static final int BEHAVIOUR_SM2_SIGNATURE_X962 = 2;
    static final int BEHAVIOUR_EC_PRIVATEKEY_ECPOINT = 3;
    static final int BEHAVIOUR_SM2_PRIVATEKEY_ECPOINT = 4;
    private final PKCS11Implementation pkcs11;
    private static boolean linkedAndInitialized;
    private Boolean ecPointFixNeeded;
    private Boolean ecdsaSignatureFixNeeded;
    private Boolean sm2SignatureFixNeeded;
    private Map<PKCS11Constants.Category, VendorMap> vendorMaps;
    private final Set<Integer> vendorBehaviours = new HashSet<Integer>();
    private static final AtomicBoolean licensePrinted;

    protected PKCS11Module(PKCS11Implementation pkcs11) {
        this.pkcs11 = Functions.requireNonNull("pkcs11", pkcs11);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PKCS11Module getInstance(String pkcs11ModulePath) throws IOException {
        AtomicBoolean atomicBoolean = licensePrinted;
        synchronized (atomicBoolean) {
            if (!licensePrinted.get()) {
                StaticLogger.info("This product (ipkcs11wrapper) includes software (IAIK PKCS#11 wrapper version 1.6.8)\ndeveloped by Stiftung SIC which is licensed under \"IAIK PKCS#11 Wrapper License\"- \nA copy of this license is downloadable under \nhttps://jce.iaik.tugraz.at/products/core-crypto-toolkits/pkcs11-wrapper/#License.\nAll other parts are licensed under Apache License, version 2.", new Object[0]);
                licensePrinted.set(true);
            }
        }
        PKCS11Module.ensureLinkedAndInitialized();
        StaticLogger.info("PKCS11Module.getInstance: pkcs11ModulePath={}", pkcs11ModulePath);
        return new PKCS11Module(new PKCS11Implementation(Functions.requireNonNull("pkcs11ModulePath", pkcs11ModulePath)));
    }

    private static synchronized void ensureLinkedAndInitialized() {
        if (!linkedAndInitialized) {
            try {
                System.loadLibrary("pkcs11wrapper");
            }
            catch (UnsatisfiedLinkError e) {
                try {
                    PKCS11Module.loadWrapperFromJar();
                }
                catch (IOException ioe) {
                    throw new UnsatisfiedLinkError("no pkcs11wrapper in library path or jar file. " + ioe.getMessage());
                }
            }
            PKCS11Implementation.initializeLibrary();
            linkedAndInitialized = true;
        }
    }

    Boolean getEcPointFixNeeded() {
        return this.ecPointFixNeeded;
    }

    void setEcPointFixNeeded(Boolean ecPointFixNeeded) {
        this.ecPointFixNeeded = ecPointFixNeeded;
    }

    Boolean getEcdsaSignatureFixNeeded() {
        return this.ecdsaSignatureFixNeeded;
    }

    void setEcdsaSignatureFixNeeded(Boolean ecdsaSignatureFixNeeded) {
        this.ecdsaSignatureFixNeeded = ecdsaSignatureFixNeeded;
    }

    Boolean getSm2SignatureFixNeeded() {
        return this.sm2SignatureFixNeeded;
    }

    void setSm2SignatureFixNeeded(Boolean sm2SignatureFixNeeded) {
        this.sm2SignatureFixNeeded = sm2SignatureFixNeeded;
    }

    public ModuleInfo getInfo() throws PKCS11Exception {
        try {
            return new ModuleInfo(this.pkcs11.C_GetInfo());
        }
        catch (iaik.pkcs.pkcs11.wrapper.PKCS11Exception e) {
            throw this.convertException(e);
        }
    }

    public void initialize() throws PKCS11Exception {
        CK_C_INITIALIZE_ARGS wrapperInitArgs = new CK_C_INITIALIZE_ARGS();
        wrapperInitArgs.flags |= 2L;
        StaticLogger.info("C_Initialize: flags=0x{}", Functions.toFullHex(wrapperInitArgs.flags));
        try {
            this.pkcs11.C_Initialize(wrapperInitArgs, true);
        }
        catch (iaik.pkcs.pkcs11.wrapper.PKCS11Exception e) {
            throw this.convertException(e);
        }
        this.initVendor();
    }

    public void finalize(Object args) throws PKCS11Exception {
        try {
            this.pkcs11.C_Finalize(args);
        }
        catch (iaik.pkcs.pkcs11.wrapper.PKCS11Exception e) {
            throw this.convertException(e);
        }
    }

    public Slot[] getSlotList(boolean tokenPresent) throws PKCS11Exception {
        long[] slotIDs;
        try {
            slotIDs = this.pkcs11.C_GetSlotList(tokenPresent);
        }
        catch (iaik.pkcs.pkcs11.wrapper.PKCS11Exception e) {
            throw this.convertException(e);
        }
        Slot[] slots = new Slot[slotIDs.length];
        for (int i = 0; i < slots.length; ++i) {
            slots[i] = new Slot(this, slotIDs[i]);
        }
        return slots;
    }

    public Slot waitForSlotEvent(boolean dontBlock) throws PKCS11Exception {
        long slotId;
        try {
            slotId = this.pkcs11.C_WaitForSlotEvent(dontBlock ? 1L : 0L, null);
        }
        catch (iaik.pkcs.pkcs11.wrapper.PKCS11Exception e) {
            throw this.convertException(e);
        }
        return new Slot(this, slotId);
    }

    public PKCS11 getPKCS11Module() {
        return this.pkcs11;
    }

    boolean hasVendorBehaviour(int vendorBehavior) {
        return this.vendorBehaviours.contains(vendorBehavior);
    }

    public long genericToVendorCode(PKCS11Constants.Category category, long genericCode) {
        if (this.vendorMaps != null) {
            VendorMap map = this.vendorMaps.get((Object)category);
            return map != null ? map.genericToVendor(genericCode) : genericCode;
        }
        return genericCode;
    }

    public long vendorToGenericCode(PKCS11Constants.Category category, long vendorCode) {
        if (this.vendorMaps != null) {
            VendorMap map = this.vendorMaps.get((Object)category);
            return map != null ? map.vendorToGeneric(vendorCode) : vendorCode;
        }
        return vendorCode;
    }

    public String codeToName(PKCS11Constants.Category category, long code) {
        if ((code & 0x80000000L) != 0L && this.vendorMaps != null) {
            VendorMap map = this.vendorMaps.get((Object)category);
            return map != null ? map.codeToName(code) : PKCS11Constants.codeToName(category, code);
        }
        return PKCS11Constants.codeToName(category, code);
    }

    public Long nameToCode(PKCS11Constants.Category category, String name) {
        if (this.vendorMaps != null) {
            VendorMap map = this.vendorMaps.get((Object)category);
            return map != null ? map.nameToCode(name) : PKCS11Constants.nameToCode(category, name);
        }
        return PKCS11Constants.nameToCode(category, name);
    }

    public String toString() {
        return this.pkcs11 != null ? this.pkcs11.toString() : "null";
    }

    public PKCS11Exception convertException(iaik.pkcs.pkcs11.wrapper.PKCS11Exception e) {
        String name = this.codeToName(PKCS11Constants.Category.CKR, e.getErrorCode());
        return new PKCS11Exception(e.getErrorCode(), name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void loadWrapperFromJar() throws IOException {
        ClassLoader classLoader;
        String PKCS11_TEMP_DIR = "PKCS11_TEMP_DIR";
        boolean LINUX_INDEX = false;
        boolean WIN_INDEX = true;
        int MAC_INDEX = 2;
        String[] WRAPPER_OS_PATH = new String[]{"unix/linux-", "windows/win-", "unix/macosx_universal/"};
        String[] WRAPPER_FILE_SUFFIX = new String[]{".so", ".dll", ".jnilib"};
        String[] WRAPPER_FILE_PREFIX = new String[]{"lib", "", "lib", "lib"};
        boolean X64_INDEX = false;
        boolean X86_INDEX = true;
        int ARM_INDEX = 2;
        int AARCH64_INDEX = 3;
        String[] WRAPPER_ARCH_PATH = new String[]{"x86_64/", "x86/", "arm/", "aarch64/"};
        int trialCounter = 0;
        String osName = System.getProperty("os.name");
        int osIndex = (osName = osName.toLowerCase(Locale.ROOT)).contains("win") ? 1 : (osName.contains("linux") ? 0 : (osName.contains("mac") ? 2 : 0));
        String archName = System.getProperty("os.arch").toLowerCase(Locale.ROOT);
        int archIndex = archName.contains("aarch64") ? 3 : (archName.contains("arm") ? 2 : (archName.contains("64") ? 0 : (archName.contains("32") || archName.contains("86") ? 1 : -1)));
        if (archIndex == -1) {
            archIndex = 0;
            ++trialCounter;
        }
        boolean isRelease = null != (classLoader = PKCS11Module.class.getClassLoader()).getResource("natives/unix/linux-x86/release/libpkcs11wrapper.so");
        String releaseOrDebugDir = isRelease ? "release/" : "debug/";
        String system = "natives/" + WRAPPER_OS_PATH[osIndex];
        String architecture = osIndex == 2 ? "" : WRAPPER_ARCH_PATH[archIndex];
        String libName = WRAPPER_FILE_PREFIX[osIndex] + "pkcs11wrapper";
        String osFileEnding = WRAPPER_FILE_SUFFIX[osIndex];
        boolean success = false;
        do {
            String jarFilePath;
            InputStream wrapperLibrary;
            if ((wrapperLibrary = classLoader.getResourceAsStream(jarFilePath = system + architecture + releaseOrDebugDir + libName + osFileEnding)) == null) {
                if (trialCounter >= WRAPPER_ARCH_PATH.length) throw new IOException("No suitable wrapper native library for " + osName + " " + archName + " found in jar file.");
                archIndex = trialCounter++;
                architecture = WRAPPER_ARCH_PATH[archIndex];
                continue;
            }
            File tempWrapperFile = null;
            try {
                String directory = System.getProperty("PKCS11_TEMP_DIR", null);
                if (directory != null && !directory.isEmpty()) {
                    File tempWrapperDirectory = new File(directory);
                    if (!tempWrapperDirectory.exists()) throw new IOException("Specified local temp directory '" + directory + "' does not exist!");
                    tempWrapperFile = File.createTempFile(libName, osFileEnding, tempWrapperDirectory);
                } else {
                    tempWrapperFile = File.createTempFile(libName, osFileEnding);
                }
                if (!tempWrapperFile.canWrite()) {
                    throw new IOException("Can't copy wrapper native library to local temporary directory - no write permission in " + tempWrapperFile.getAbsolutePath());
                }
                tempWrapperFile.deleteOnExit();
                StaticLogger.info("PKCS11oModule.loadWrapperFromJar: copy file {} to {}", jarFilePath, tempWrapperFile.getAbsolutePath());
                try {
                    Files.copy(wrapperLibrary, tempWrapperFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                finally {
                    wrapperLibrary.close();
                }
            }
            catch (IOException e) {
                if (tempWrapperFile == null) throw new IOException("Can't copy wrapper native library to local temporary directory. " + e.getMessage());
                tempWrapperFile.delete();
                throw new IOException("Can't copy wrapper native library to local temporary directory. " + e.getMessage());
            }
            catch (RuntimeException e) {
                if (tempWrapperFile == null) throw e;
                tempWrapperFile.delete();
                throw e;
            }
            try {
                System.load(tempWrapperFile.getAbsolutePath());
                return;
            }
            catch (UnsatisfiedLinkError e) {
                tempWrapperFile.delete();
                if (trialCounter >= WRAPPER_ARCH_PATH.length) throw new IOException("No suitable wrapper native library found in jar file. " + osName + " " + archName + " not supported.");
                archIndex = trialCounter++;
                architecture = WRAPPER_ARCH_PATH[archIndex];
            }
        } while (!success);
    }

    private static VendorConfBlock readVendorBlock(BufferedReader reader) throws IOException {
        String line;
        boolean inBlock = false;
        VendorConfBlock block = null;
        while ((line = reader.readLine()) != null) {
            String value;
            int idx;
            if ((line = line.trim()).isEmpty() || line.charAt(0) == '#') continue;
            if (line.startsWith("<vendor>")) {
                block = new VendorConfBlock();
                inBlock = true;
                continue;
            }
            if (line.startsWith("</vendor>")) {
                if (block != null) {
                    block.validate();
                }
                return block;
            }
            if (!inBlock) continue;
            if (line.startsWith("module.")) {
                idx = line.indexOf(32);
                if (idx == -1 || (value = line.substring(idx + 1).trim()).isEmpty()) continue;
                String name = line.substring(0, idx).trim();
                List<String> textList = Arrays.asList(value.toLowerCase(Locale.ROOT).split(":"));
                if (name.equalsIgnoreCase("module.path")) {
                    block.modulePaths = textList;
                    continue;
                }
                if (name.equalsIgnoreCase("module.mid")) {
                    block.manufacturerIDs = textList;
                    continue;
                }
                if (name.equalsIgnoreCase("module.description")) {
                    block.descriptions = textList;
                    continue;
                }
                if (!name.equalsIgnoreCase("module.version")) continue;
                block.versions = textList;
                continue;
            }
            if (line.startsWith("CKD_") || line.startsWith("CKG_") || line.startsWith("CKK_") || line.startsWith("CKM_") || line.startsWith("CKR_")) {
                idx = line.indexOf(32);
                if (idx == -1) continue;
                block.nameToCodeMap.put(line.substring(0, idx).trim(), line.substring(idx + 1).trim());
                continue;
            }
            if (line.startsWith("VENDOR_BEHAVIORS ")) {
                idx = line.indexOf(32);
                value = line.substring(idx + 1).trim();
                if (value.isEmpty()) continue;
                block.vendorBehaviours = value;
                continue;
            }
            StaticLogger.warn("vendor.conf: ignore line " + line, new Object[0]);
        }
        return block;
    }

    private void initVendor() {
        block18: {
            try {
                InputStream in;
                String modulePath = this.pkcs11.getPkcs11ModulePath();
                ModuleInfo moduleInfo = this.getInfo();
                String manufacturerID = moduleInfo.getManufacturerID();
                String libraryDescription = moduleInfo.getLibraryDescription();
                Version libraryVersion = moduleInfo.getLibraryVersion();
                String confPath = System.getProperty("org.xipki.pkcs11.vendor.conf");
                InputStream inputStream = in = confPath != null ? Files.newInputStream(Paths.get(confPath, new String[0]), new OpenOption[0]) : PKCS11Module.class.getClassLoader().getResourceAsStream("org/xipki/pkcs11/wrapper/vendor.conf");
                if (in == null) {
                    throw new IOException("found no file org/xipki/pkcs11/wrapper/vendor.conf");
                }
                try (BufferedReader br = new BufferedReader(new InputStreamReader(in));){
                    VendorConfBlock block;
                    do {
                        if ((block = PKCS11Module.readVendorBlock(br)) != null) continue;
                        break block18;
                    } while (!block.matches(modulePath, manufacturerID, libraryDescription, libraryVersion));
                    StaticLogger.info("found <vendor> configuration: {}", block);
                    if (block.vendorBehaviours != null) {
                        StringTokenizer tokenizer = new StringTokenizer(block.vendorBehaviours, ":, \t");
                        while (tokenizer.hasMoreTokens()) {
                            String token = tokenizer.nextToken();
                            if ("SM2_SIGNATURE_X962".equalsIgnoreCase(token)) {
                                this.vendorBehaviours.add(2);
                                continue;
                            }
                            if ("ECDSA_SIGNATURE_X962".equalsIgnoreCase(token)) {
                                this.vendorBehaviours.add(1);
                                continue;
                            }
                            if ("SM2_PRIVATEKEY_ECPOINT".equalsIgnoreCase(token)) {
                                this.vendorBehaviours.add(4);
                                continue;
                            }
                            if ("EC_PRIVATEKEY_ECPOINT".equalsIgnoreCase(token)) {
                                this.vendorBehaviours.add(3);
                                continue;
                            }
                            StaticLogger.warn("Ignored unknown vendor behaviour '" + token + "'.", new Object[0]);
                        }
                    }
                    PKCS11Constants.Category[] categories = new PKCS11Constants.Category[]{PKCS11Constants.Category.CKD, PKCS11Constants.Category.CKG_MGF, PKCS11Constants.Category.CKK, PKCS11Constants.Category.CKM, PKCS11Constants.Category.CKP_PRF, PKCS11Constants.Category.CKR, PKCS11Constants.Category.CKU};
                    for (PKCS11Constants.Category category : categories) {
                        this.vendorMaps.put(category, new VendorMap(category));
                    }
                    for (Map.Entry entry : block.nameToCodeMap.entrySet()) {
                        PKCS11Constants.Category category;
                        String name = ((String)entry.getKey()).toUpperCase(Locale.ROOT);
                        PKCS11Constants.Category category2 = name.startsWith("CKD_") ? PKCS11Constants.Category.CKD : (name.startsWith("CKG_") ? PKCS11Constants.Category.CKG_MGF : (name.startsWith("CKK_") ? PKCS11Constants.Category.CKK : (name.startsWith("CKM_") ? PKCS11Constants.Category.CKM : (name.startsWith("CKP_") ? PKCS11Constants.Category.CKP_PRF : (name.startsWith("CKR_") ? PKCS11Constants.Category.CKR : (category = name.startsWith("CKU_") ? PKCS11Constants.Category.CKU : null))))));
                        if (category == null) {
                            throw new IllegalStateException("Unknown name in vendor block: " + name);
                        }
                        this.vendorMaps.get((Object)category).addNameCode(name, ((String)entry.getValue()).toUpperCase(Locale.ROOT));
                    }
                }
            }
            catch (Exception e) {
                StaticLogger.warn("error reading VENDOR code mapping, ignore it.", new Object[0]);
            }
        }
    }

    private static long parseCode(String str) {
        boolean hex = str.startsWith("0X");
        return hex ? Long.parseLong(str.substring(2), 16) : Long.parseLong(str);
    }

    static {
        licensePrinted = new AtomicBoolean(false);
    }

    private static final class VendorConfBlock {
        private List<String> modulePaths;
        private List<String> manufacturerIDs;
        private List<String> descriptions;
        private List<String> versions;
        private String vendorBehaviours;
        private final Map<String, String> nameToCodeMap = new HashMap<String, String>();

        private VendorConfBlock() {
        }

        void validate() throws IOException {
            if (VendorConfBlock.isEmpty(this.modulePaths) && VendorConfBlock.isEmpty(this.manufacturerIDs) && VendorConfBlock.isEmpty(this.descriptions)) {
                throw new IOException("invalid <vendor>-block");
            }
        }

        boolean matches(String modulePath, String manufacturerID, String libraryDescription, Version libraryVersion) {
            if (!VendorConfBlock.isEmpty(this.modulePaths) && VendorConfBlock.notContains(this.modulePaths, Paths.get(modulePath, new String[0]).getFileName().toString()) || !VendorConfBlock.isEmpty(this.manufacturerIDs) && VendorConfBlock.notContains(this.manufacturerIDs, manufacturerID) || !VendorConfBlock.isEmpty(this.descriptions) && VendorConfBlock.notContains(this.descriptions, libraryDescription)) {
                return false;
            }
            if (VendorConfBlock.isEmpty(this.versions)) {
                return true;
            }
            int iVersion = ((0xFF & libraryVersion.getMajor()) << 8) + (0xFF & libraryVersion.getMinor());
            boolean match = false;
            for (String t : this.versions) {
                int to;
                int idx = t.indexOf("-");
                int from = idx == -1 ? VendorConfBlock.toIntVersion(t) : VendorConfBlock.toIntVersion(t.substring(0, idx));
                int n = to = idx == -1 ? from : VendorConfBlock.toIntVersion(t.substring(idx + 1));
                if (iVersion < from || iVersion > to) continue;
                match = true;
                break;
            }
            return match;
        }

        private static int toIntVersion(String version) {
            StringTokenizer st = new StringTokenizer(version, ".");
            return (Integer.parseInt(st.nextToken()) << 8) + Integer.parseInt(st.nextToken());
        }

        private static boolean isEmpty(Collection<?> c) {
            return c == null || c.isEmpty();
        }

        private static boolean notContains(List<String> list, String str) {
            str = str.toLowerCase(Locale.ROOT);
            for (String s : list) {
                if (!str.contains(s)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return "VendorConfBlock\n  modulePaths:      " + this.modulePaths + "\n  manufacturerIDs:  " + this.manufacturerIDs + "\n  descriptions:     " + this.descriptions + "\n  versions:         " + this.versions + "\n  vendorBehaviours: " + this.vendorBehaviours + "\n  nameToCodeMap:    " + this.nameToCodeMap;
        }
    }

    private static final class VendorMap {
        private final Map<Long, Long> genericToVendorMap = new HashMap<Long, Long>();
        private final Map<Long, Long> vendorToGenericMap = new HashMap<Long, Long>();
        private final Map<Long, String> codeNameMap = new HashMap<Long, String>();
        private final Map<String, Long> nameCodeMap = new HashMap<String, Long>();
        private final PKCS11Constants.Category category;

        VendorMap(PKCS11Constants.Category category) {
            this.category = category;
        }

        void addNameCode(String name, String code) {
            long lCode = PKCS11Module.parseCode(code);
            Long genericCode = PKCS11Constants.nameToCode(this.category, name);
            if (genericCode != null) {
                if ((genericCode & 0x80000000L) != 0L && genericCode != lCode) {
                    this.genericToVendorMap.put(genericCode, lCode);
                    this.vendorToGenericMap.put(lCode, genericCode);
                }
            } else {
                this.codeNameMap.put(lCode, name);
                this.nameCodeMap.put(name, lCode);
            }
        }

        boolean isEmpty() {
            return this.codeNameMap.isEmpty();
        }

        long genericToVendor(long genericCode) {
            return this.genericToVendorMap.getOrDefault(genericCode, genericCode);
        }

        long vendorToGeneric(long vendorCode) {
            return this.vendorToGenericMap.getOrDefault(vendorCode, vendorCode);
        }

        public String codeToName(long code) {
            String name = this.codeNameMap.get(code);
            if (name == null) {
                name = PKCS11Constants.codeToName(this.category, code);
            }
            return name;
        }

        public Long nameToCode(String name) {
            Long code = this.nameCodeMap.get(name);
            if (code == null) {
                code = PKCS11Constants.nameToCode(this.category, name);
            }
            return code;
        }
    }
}

